/*
 * Decompiled with CFR 0.152.
 */
package org.jmol.io2;

import java.io.BufferedInputStream;
import java.io.BufferedReader;
import java.io.InputStream;
import java.util.Map;
import java.util.zip.ZipInputStream;
import javajs.util.PT;
import org.jmol.api.Interface;
import org.jmol.api.JmolAdapter;
import org.jmol.api.JmolDocument;
import org.jmol.api.JmolFilesReaderInterface;
import org.jmol.io.DataReader;
import org.jmol.io.JmolBinary;
import org.jmol.util.Logger;
import org.jmol.viewer.FileManager;
import org.jmol.viewer.Viewer;

public class FilesReader
implements JmolFilesReaderInterface {
    private FileManager fm;
    private Viewer viewer;
    private String[] fullPathNamesIn;
    private String[] namesAsGivenIn;
    private String[] fileTypesIn;
    private Object atomSetCollection;
    private DataReader[] dataReaders;
    private Map<String, Object> htParams;
    private boolean isAppend;

    public void set(FileManager fileManager, Viewer viewer, String[] stringArray, String[] stringArray2, String[] stringArray3, DataReader[] dataReaderArray, Map<String, Object> map, boolean bl) {
        this.fm = fileManager;
        this.viewer = viewer;
        this.fullPathNamesIn = stringArray;
        this.namesAsGivenIn = stringArray2;
        this.fileTypesIn = stringArray3;
        this.dataReaders = dataReaderArray;
        this.htParams = map;
        this.isAppend = bl;
    }

    public void run() {
        if (!this.isAppend && this.viewer.displayLoadErrors) {
            this.viewer.zap(false, true, false);
        }
        boolean bl = !this.viewer.displayLoadErrors;
        this.atomSetCollection = this.viewer.getModelAdapter().getAtomSetCollectionReaders((JmolFilesReaderInterface)this, this.fullPathNamesIn, this.fileTypesIn, this.htParams, bl);
        this.dataReaders = null;
        if (bl && !(this.atomSetCollection instanceof String)) {
            this.atomSetCollection = this.viewer.getModelAdapter().getAtomSetCollectionFromSet(this.atomSetCollection, null, this.htParams);
        }
        if (this.atomSetCollection instanceof String) {
            Logger.error((String)("file ERROR: " + this.atomSetCollection));
            return;
        }
        if (!this.isAppend && !this.viewer.displayLoadErrors) {
            this.viewer.zap(false, true, false);
        }
        this.fm.nameAsGiven = this.dataReaders == null ? "file[]" : "String[]";
        this.fm.fileName = this.fm.nameAsGiven;
        this.fm.fullPathName = this.fm.nameAsGiven;
    }

    public Object getBufferedReaderOrBinaryDocument(int n, boolean bl) {
        String[] stringArray;
        Object object;
        if (this.dataReaders != null) {
            return bl ? null : this.dataReaders[n].getBufferedReader();
        }
        String string = this.fullPathNamesIn[n];
        String[] stringArray2 = null;
        this.htParams.remove("subFileList");
        if (string.indexOf("|") >= 0) {
            stringArray2 = PT.split((String)string, (String)"|");
            string = stringArray2[0];
        }
        if ((object = this.fm.getUnzippedReaderOrStreamFromName(string, null, true, bl, false, true, this.htParams)) instanceof ZipInputStream) {
            if (stringArray2 != null) {
                this.htParams.put("subFileList", stringArray2);
            }
            stringArray = this.fm.getZipDirectory(string, true);
            object = this.fm.getBufferedInputStreamOrErrorMessageFromName(string, this.fullPathNamesIn[n], false, false, null, false);
            object = JmolBinary.getAtomSetCollectionOrBufferedReaderFromZip((JmolAdapter)this.viewer.getModelAdapter(), (InputStream)((BufferedInputStream)object), (String)string, (String[])stringArray, this.htParams, (boolean)true);
        }
        if (object instanceof BufferedInputStream) {
            stringArray = (String[])Interface.getOptionInterface((String)"io2.BinaryDocument");
            stringArray.setStream((BufferedInputStream)object, true);
            return stringArray;
        }
        return object instanceof BufferedReader || object instanceof JmolDocument ? object : (object == null ? "error opening:" + this.namesAsGivenIn[n] : (String)object);
    }

    public Object getAtomSetCollection() {
        return this.atomSetCollection;
    }
}

