/*
 * Decompiled with CFR 0.152.
 */
package org.jmol.renderspecial;

import javajs.util.P3;
import javajs.util.P3i;
import javajs.util.T3;
import javajs.util.V3;
import org.jmol.render.ShapeRenderer;
import org.jmol.shapespecial.Dipole;
import org.jmol.shapespecial.Dipoles;
import org.jmol.util.C;

public class DipolesRenderer
extends ShapeRenderer {
    private float dipoleVectorScale;
    private final V3 offset = new V3();
    private final P3i[] screens = new P3i[6];
    private final P3[] points = new P3[6];
    private P3 cross0;
    private P3 cross1;
    private static final int cylinderBase = 0;
    private static final int cross = 1;
    private static final int crossEnd = 2;
    private static final int center = 3;
    private static final int arrowHeadBase = 4;
    private static final int arrowHeadTip = 5;
    private int diameter;
    private int headWidthPixels;
    private int crossWidthPixels;
    private static final float arrowHeadOffset = 0.9f;
    private static final float arrowHeadWidthFactor = 2.0f;
    private static final float crossOffset = 0.1f;
    private static final float crossWidth = 0.04f;

    public DipolesRenderer() {
        for (int i = 0; i < 6; ++i) {
            this.screens[i] = new P3i();
            this.points[i] = new P3();
        }
        this.cross0 = new P3();
        this.cross1 = new P3();
    }

    protected boolean render() {
        Dipoles dipoles = (Dipoles)this.shape;
        this.dipoleVectorScale = this.viewer.getFloat(0x2200000B);
        boolean bl = false;
        int n = dipoles.dipoleCount;
        while (--n >= 0) {
            Dipole dipole = dipoles.dipoles[n];
            if (dipole.visibilityFlags == 0 || !this.transform(dipole) || !this.renderDipoleVector(dipole)) continue;
            bl = true;
        }
        return bl;
    }

    private boolean transform(Dipole dipole) {
        int n;
        V3 v3 = dipole.vector;
        this.offset.setT((T3)v3);
        if (dipole.center == null) {
            this.offset.scale(dipole.offsetAngstroms / dipole.dipoleValue);
            if (this.dipoleVectorScale < 0.0f) {
                this.offset.add((T3)v3);
            }
            this.points[0].setT((T3)dipole.origin);
            this.points[0].add((T3)this.offset);
        } else {
            this.offset.scale(-0.5f * this.dipoleVectorScale);
            this.points[0].setT((T3)dipole.center);
            this.points[0].add((T3)this.offset);
            if (dipole.offsetAngstroms != 0.0f) {
                this.offset.setT((T3)v3);
                this.offset.scale(dipole.offsetAngstroms / dipole.dipoleValue);
                this.points[0].add((T3)this.offset);
            }
        }
        this.points[1].scaleAdd2(this.dipoleVectorScale * 0.1f, (T3)v3, (T3)this.points[0]);
        this.points[2].scaleAdd2(this.dipoleVectorScale * 0.14f, (T3)v3, (T3)this.points[0]);
        this.points[3].scaleAdd2(this.dipoleVectorScale / 2.0f, (T3)v3, (T3)this.points[0]);
        this.points[4].scaleAdd2(this.dipoleVectorScale * 0.9f, (T3)v3, (T3)this.points[0]);
        this.points[5].scaleAdd2(this.dipoleVectorScale, (T3)v3, (T3)this.points[0]);
        if (dipole.atoms[0] != null && this.modelSet.isAtomHidden(dipole.atoms[0].getIndex())) {
            return false;
        }
        this.offset.setT((T3)this.points[3]);
        this.offset.cross(this.offset, v3);
        if (this.offset.length() == 0.0f) {
            this.offset.set(this.points[3].x + 0.2345f, this.points[3].y + 0.1234f, this.points[3].z + 0.4321f);
            this.offset.cross(this.offset, v3);
        }
        this.offset.scale(dipole.offsetSide / this.offset.length());
        for (n = 0; n < 6; ++n) {
            this.points[n].add((T3)this.offset);
        }
        for (n = 0; n < 6; ++n) {
            this.viewer.transformPtScr(this.points[n], this.screens[n]);
        }
        this.viewer.transformPt3f(this.points[1], this.cross0);
        this.viewer.transformPt3f(this.points[2], this.cross1);
        this.mad = dipole.mad;
        float f = this.viewer.scaleToScreen(this.screens[3].z, (int)this.mad);
        this.diameter = (int)f;
        this.headWidthPixels = (int)Math.floor(f * 2.0f);
        if (this.headWidthPixels < this.diameter + 5) {
            this.headWidthPixels = this.diameter + 5;
        }
        this.crossWidthPixels = this.headWidthPixels;
        return true;
    }

    private boolean renderDipoleVector(Dipole dipole) {
        short s;
        short s2;
        short s3 = s2 = dipole.bond == null ? dipole.colix : C.getColixInherited((short)dipole.colix, (short)dipole.bond.colix);
        if (dipole.atoms[0] != null) {
            s2 = C.getColixInherited((short)s2, (short)dipole.atoms[0].getColix());
            s3 = C.getColixInherited((short)s3, (short)dipole.atoms[1].getColix());
        }
        if (!s2) {
            s2 = 5;
        }
        if (!s3) {
            s3 = 5;
        }
        if (this.dipoleVectorScale < 0.0f) {
            s = s2;
            s2 = s3;
            s3 = s;
        }
        this.colix = s2;
        if (this.colix == s3) {
            if (!this.g3d.setColix(this.colix)) {
                return true;
            }
            this.g3d.fillCylinder((byte)1, this.diameter, this.screens[0], this.screens[4]);
            if (!dipole.noCross) {
                this.g3d.fillCylinderBits((byte)2, this.crossWidthPixels, this.cross0, this.cross1);
            }
            this.g3d.fillConeScreen((byte)2, this.headWidthPixels, this.screens[4], this.screens[5], false);
            return false;
        }
        s = 0;
        if (this.g3d.setColix(this.colix)) {
            this.g3d.fillCylinder((byte)1, this.diameter, this.screens[0], this.screens[3]);
            if (!dipole.noCross) {
                this.g3d.fillCylinderBits((byte)2, this.crossWidthPixels, this.cross0, this.cross1);
            }
        } else {
            s = 1;
        }
        this.colix = s3;
        if (this.g3d.setColix(this.colix)) {
            this.g3d.fillCylinder((byte)4, this.diameter, this.screens[3], this.screens[4]);
            this.g3d.fillConeScreen((byte)2, this.headWidthPixels, this.screens[4], this.screens[5], false);
        } else {
            s = 1;
        }
        return s;
    }
}

