/*
 * Decompiled with CFR 0.152.
 */
package org.jmol.jvxl.readers;

import java.io.BufferedReader;
import javajs.util.SB;
import org.jmol.jvxl.readers.MapFileReader;
import org.jmol.jvxl.readers.SurfaceGenerator;
import org.jmol.util.Logger;

class MrcBinaryReader
extends MapFileReader {
    protected String[] labels;
    private static byte[] b8 = new byte[8];

    MrcBinaryReader() {
    }

    @Override
    void init2(SurfaceGenerator surfaceGenerator, BufferedReader bufferedReader) {
        String string = (String)((Object[])surfaceGenerator.getReaderData())[0];
        this.init2MFR(surfaceGenerator, this.br);
        this.binarydoc = this.newBinaryDocument();
        this.binarydoc.setStream(surfaceGenerator.getAtomDataServer().getBufferedInputStream(string), true);
        this.nSurfaces = 1;
        if (this.params.thePlane == null) {
            this.params.insideOut = !this.params.insideOut;
        }
        this.allowSigma = true;
    }

    @Override
    protected void readParameters() throws Exception {
        int n;
        byte[] byArray = new byte[100];
        byte[] byArray2 = new byte[4];
        byte[] byArray3 = new byte[4];
        this.nx = this.binarydoc.readInt();
        if (this.nx < 0 || this.nx > 256) {
            this.binarydoc.setStream(null, false);
            this.nx = this.binarydoc.swapBytesI(this.nx);
            if (this.params.thePlane == null) {
                boolean bl = this.params.insideOut = !this.params.insideOut;
            }
            if (this.nx < 0 || this.nx > 1000) {
                Logger.info("nx=" + this.nx + " not displayable as MRC file");
                throw new Exception("MRC file type not readable");
            }
            Logger.info("reading nonstandard little-endian MRC file");
        }
        this.ny = this.binarydoc.readInt();
        this.nz = this.binarydoc.readInt();
        this.mode = this.binarydoc.readInt();
        if (this.mode < 0 || this.mode > 6) {
            this.binarydoc.setStream(null, false);
            this.nx = this.binarydoc.swapBytesI(this.nx);
            this.ny = this.binarydoc.swapBytesI(this.ny);
            this.nz = this.binarydoc.swapBytesI(this.nz);
            this.mode = this.binarydoc.swapBytesI(this.mode);
        }
        Logger.info("MRC header: mode: " + this.mode);
        Logger.info("MRC header: nx ny nz: " + this.nx + " " + this.ny + " " + this.nz);
        this.nxyzStart[0] = this.binarydoc.readInt();
        this.nxyzStart[1] = this.binarydoc.readInt();
        this.nxyzStart[2] = this.binarydoc.readInt();
        Logger.info("MRC header: nxyzStart: " + this.nxyzStart[0] + " " + this.nxyzStart[1] + " " + this.nxyzStart[2]);
        this.na = this.binarydoc.readInt();
        this.nb = this.binarydoc.readInt();
        this.nc = this.binarydoc.readInt();
        if (this.na == 0) {
            this.na = this.nx - 1;
        }
        if (this.nb == 0) {
            this.nb = this.ny - 1;
        }
        if (this.nc == 0) {
            this.nc = this.nz - 1;
        }
        Logger.info("MRC header: na nb nc: " + this.na + " " + this.nb + " " + this.nc);
        this.a = this.binarydoc.readFloat();
        this.b = this.binarydoc.readFloat();
        this.c = this.binarydoc.readFloat();
        this.alpha = this.binarydoc.readFloat();
        this.beta = this.binarydoc.readFloat();
        this.gamma = this.binarydoc.readFloat();
        this.mapc = this.binarydoc.readInt();
        this.mapr = this.binarydoc.readInt();
        this.maps = this.binarydoc.readInt();
        Logger.info("MRC header: mapc mapr maps: " + this.mapc + " " + this.mapr + " " + this.maps);
        if (this.mapc != 1 && this.params.thePlane == null) {
            this.params.dataXYReversed = true;
        }
        this.dmin = this.binarydoc.readFloat();
        this.dmax = this.binarydoc.readFloat();
        this.dmean = this.binarydoc.readFloat();
        Logger.info("MRC header: dmin,dmax,dmean: " + this.dmin + "," + this.dmax + "," + this.dmean);
        int n2 = this.binarydoc.readInt();
        int n3 = this.binarydoc.readInt();
        Logger.info("MRC header: ispg,nsymbt: " + n2 + "," + n3);
        this.binarydoc.readByteArray(byArray, 0, byArray.length);
        this.origin.x = this.binarydoc.readFloat();
        this.origin.y = this.binarydoc.readFloat();
        this.origin.z = this.binarydoc.readFloat();
        Logger.info("MRC header: origin: " + this.origin);
        this.binarydoc.readByteArray(byArray2, 0, byArray2.length);
        this.binarydoc.readByteArray(byArray3, 0, byArray3.length);
        float f = this.binarydoc.readFloat();
        Logger.info("MRC header: rms: " + f);
        int n4 = this.binarydoc.readInt();
        Logger.info("MRC header: labels: " + n4);
        this.labels = new String[n4];
        if (n4 > 0) {
            this.labels[0] = "Jmol MrcBinaryReader";
        }
        for (n = 0; n < 10; ++n) {
            String string = this.binarydoc.readString(80).trim();
            if (n >= n4) continue;
            this.labels[n] = string;
            Logger.info(this.labels[n]);
        }
        for (n = 0; n < n3; n += 80) {
            long l = this.binarydoc.getPosition();
            String string = this.binarydoc.readString(80).trim();
            if (string.indexOf(0) != string.lastIndexOf(0)) {
                Logger.error("File indicates " + n3 + " symmetry lines, but " + n + " found!");
                this.binarydoc.seek(l);
                break;
            }
            Logger.info("MRC file symmetry information: " + string);
        }
        Logger.info("MRC header: bytes read: " + this.binarydoc.getPosition() + "\n");
        this.getVectorsAndOrigin();
        if (this.params.thePlane == null && (this.params.cutoffAutomatic || !Float.isNaN(this.params.sigma))) {
            float f2 = this.params.sigma < 0.0f || Float.isNaN(this.params.sigma) ? 1.0f : this.params.sigma;
            this.params.cutoff = f * f2 + this.dmean;
            Logger.info("Cutoff set to (mean + rmsDeviation*" + f2 + " = " + this.params.cutoff + ")\n");
        }
        this.jvxlFileHeaderBuffer = new SB();
        this.jvxlFileHeaderBuffer.append("MRC DATA ").append(n4 > 0 ? this.labels[0] : "").append("\n");
        this.jvxlFileHeaderBuffer.append("see http://ami.scripps.edu/software/mrctools/mrc_specification.php\n");
    }

    @Override
    protected float nextVoxel() throws Exception {
        float f;
        switch (this.mode) {
            case 0: {
                f = this.binarydoc.readByte();
                break;
            }
            case 1: {
                f = this.binarydoc.readShort();
                break;
            }
            default: {
                f = this.binarydoc.readFloat();
                break;
            }
            case 3: {
                f = this.binarydoc.readShort();
                this.binarydoc.readShort();
                break;
            }
            case 4: {
                f = this.binarydoc.readFloat();
                this.binarydoc.readFloat();
                break;
            }
            case 6: {
                f = this.binarydoc.readUnsignedShort();
            }
        }
        this.nBytes = this.binarydoc.getPosition();
        return f;
    }

    @Override
    protected void skipData(int n) throws Exception {
        block5: for (int i = 0; i < n; ++i) {
            switch (this.mode) {
                case 0: {
                    this.binarydoc.readByte();
                    continue block5;
                }
                case 1: 
                case 6: {
                    this.binarydoc.readByteArray(b8, 0, 2);
                    continue block5;
                }
                default: {
                    this.binarydoc.readByteArray(b8, 0, 4);
                    continue block5;
                }
                case 4: {
                    this.binarydoc.readByteArray(b8, 0, 8);
                }
            }
        }
    }
}

