/*
 * Decompiled with CFR 0.152.
 */
package org.jmol.jvxl.readers;

import java.io.BufferedReader;
import javajs.util.PT;
import org.jmol.io.JmolBinary;
import org.jmol.jvxl.readers.PmeshReader;
import org.jmol.jvxl.readers.SurfaceGenerator;
import org.jmol.util.Logger;

class MsmsReader
extends PmeshReader {
    private String fileName;

    MsmsReader() {
    }

    @Override
    void init2(SurfaceGenerator surfaceGenerator, BufferedReader bufferedReader) {
        this.init2PFR(surfaceGenerator, bufferedReader);
        this.fileName = (String)((Object[])surfaceGenerator.getReaderData())[0];
        if (this.fileName == null) {
            return;
        }
        this.type = "msms";
        this.onePerLine = true;
        this.fixedCount = 3;
        this.vertexBase = 1;
        this.setHeader();
    }

    @Override
    protected boolean readVertices() throws Exception {
        this.skipHeader();
        return this.readVerticesPM();
    }

    @Override
    protected boolean readPolygons() throws Exception {
        this.br.close();
        this.fileName = PT.simpleReplace(this.fileName, ".vert", ".face");
        Logger.info("reading from file " + this.fileName);
        try {
            this.br = JmolBinary.getBufferedReader(this.sg.getAtomDataServer().getBufferedInputStream(this.fileName), null);
        }
        catch (Exception exception) {
            Logger.info("Note: file " + this.fileName + " was not found");
            this.br = null;
            return true;
        }
        this.sg.addRequiredFile(this.fileName);
        this.skipHeader();
        return this.readPolygonsPM();
    }

    private void skipHeader() throws Exception {
        while (this.readLine() != null && this.line.indexOf("#") >= 0) {
        }
        this.tokens = this.getTokens();
        this.iToken = 0;
    }
}

