/*
 * Decompiled with CFR 0.152.
 */
package org.jmol.renderbio;

import javajs.util.A4;
import javajs.util.M3;
import javajs.util.P3;
import javajs.util.P3i;
import javajs.util.V3;
import org.jmol.constant.EnumStructure;
import org.jmol.java.BS;
import org.jmol.modelset.Atom;
import org.jmol.modelsetbio.CarbohydratePolymer;
import org.jmol.modelsetbio.Monomer;
import org.jmol.modelsetbio.NucleicPolymer;
import org.jmol.render.MeshRenderer;
import org.jmol.renderbio.TraceRenderer;
import org.jmol.shape.Mesh;
import org.jmol.shapebio.BioShape;
import org.jmol.shapebio.BioShapeCollection;
import org.jmol.util.C;
import org.jmol.util.Hermite;
import org.jmol.util.Logger;
import org.jmol.util.Normix;

abstract class BioShapeRenderer
extends MeshRenderer {
    private boolean invalidateMesh;
    private boolean invalidateSheets;
    private boolean isHighRes;
    private boolean isTraceAlpha;
    private boolean ribbonBorder = false;
    private boolean haveControlPointScreens;
    private float aspectRatio;
    private int hermiteLevel;
    private float sheetSmoothing;
    protected boolean cartoonsFancy;
    private Mesh[] meshes;
    private boolean[] meshReady;
    private BS bsRenderMesh;
    protected int monomerCount;
    protected Monomer[] monomers;
    protected boolean isNucleic;
    protected boolean isCarbohydrate;
    protected BS bsVisible = new BS();
    protected P3i[] ribbonTopScreens;
    protected P3i[] ribbonBottomScreens;
    protected P3[] controlPoints;
    protected P3i[] controlPointScreens;
    protected int[] leadAtomIndices;
    protected V3[] wingVectors;
    protected short[] mads;
    protected short[] colixes;
    protected short[] colixesBack;
    protected EnumStructure[] structureTypes;
    protected boolean isPass2;
    protected boolean wireframeOnly;
    private final P3 pointT = new P3();
    private int iPrev;
    private int iNext;
    private int iNext2;
    private int iNext3;
    private int diameterBeg;
    private int diameterMid;
    private int diameterEnd;
    private boolean doCap0;
    private boolean doCap1;
    protected short colixBack;
    private BS reversed;
    private final P3i screenArrowTop = new P3i();
    private final P3i screenArrowTopPrev = new P3i();
    private final P3i screenArrowBot = new P3i();
    private final P3i screenArrowBotPrev = new P3i();
    private static final int ABSOLUTE_MIN_MESH_SIZE = 3;
    private static final int MIN_MESH_RENDER_SIZE = 8;
    private P3[] controlHermites;
    private V3[] wingHermites;
    private P3[] radiusHermites;
    private V3 norm = new V3();
    private final V3 wing = new V3();
    private final V3 wing1 = new V3();
    private final V3 wingT = new V3();
    private final A4 aa = new A4();
    private final P3 pt = new P3();
    private final P3 pt1 = new P3();
    private final P3 ptPrev = new P3();
    private final P3 ptNext = new P3();
    private final M3 mat = new M3();
    private static final int MODE_TUBE = 0;
    private static final int MODE_FLAT = 1;
    private static final int MODE_ELLIPTICAL = 2;
    private static final int MODE_NONELLIPTICAL = 3;
    private BS bsTemp;
    private final V3 norml = new V3();

    BioShapeRenderer() {
    }

    protected abstract void renderBioShape(BioShape var1);

    @Override
    protected boolean render() {
        if (this.shape == null) {
            return false;
        }
        this.setGlobals();
        this.renderShapes();
        return this.needTranslucent;
    }

    private void setGlobals() {
        int n;
        boolean bl;
        this.isPass2 = this.g3d.isPass2();
        this.invalidateMesh = false;
        this.needTranslucent = false;
        this.g3d.addRenderer(553648147);
        boolean bl2 = bl = !this.isExport && !this.viewer.checkMotionRendering(1113200642);
        if (bl != this.wireframeOnly) {
            this.invalidateMesh = true;
        }
        this.wireframeOnly = bl;
        boolean bl3 = bl = this.isExport || !this.wireframeOnly && this.viewer.getBoolean(603979864);
        if (bl != this.isHighRes) {
            this.invalidateMesh = true;
        }
        this.isHighRes = bl;
        boolean bl4 = bl = !this.wireframeOnly && this.viewer.getBoolean(603979819);
        if (this.cartoonsFancy != bl) {
            this.invalidateMesh = true;
            this.cartoonsFancy = bl;
        }
        int n2 = (n = this.viewer.getHermiteLevel()) <= 0 ? -n : (n = this.viewer.getInMotion(true) ? 0 : n);
        if (this.cartoonsFancy && !this.wireframeOnly) {
            n = Math.max(n, 3);
        }
        if (n != this.hermiteLevel) {
            this.invalidateMesh = true;
        }
        this.hermiteLevel = Math.min(n, 8);
        int n3 = this.viewer.getInt(553648166);
        n3 = Math.min(Math.max(0, n3), 20);
        if (this.cartoonsFancy && n3 >= 16) {
            n3 = 4;
        }
        if (this.wireframeOnly || this.hermiteLevel == 0) {
            n3 = 0;
        }
        if ((float)n3 != this.aspectRatio && n3 != 0 && n != 0) {
            this.invalidateMesh = true;
        }
        this.aspectRatio = n3;
        bl = this.viewer.getBoolean(603979966);
        if (bl != this.isTraceAlpha) {
            this.invalidateMesh = true;
        }
        this.isTraceAlpha = bl;
        this.invalidateSheets = false;
        float f = this.viewer.getFloat(0x22000030);
        if (f != this.sheetSmoothing && this.isTraceAlpha) {
            this.sheetSmoothing = f;
            this.invalidateMesh = true;
            this.invalidateSheets = true;
        }
    }

    private void renderShapes() {
        BioShapeCollection bioShapeCollection = (BioShapeCollection)this.shape;
        int n = bioShapeCollection.bioShapes.length;
        while (--n >= 0) {
            BioShape bioShape = bioShapeCollection.getBioShape(n);
            if ((bioShape.modelVisibilityFlags & this.myVisibilityFlag) == 0 || bioShape.monomerCount < 2 || !this.initializePolymer(bioShape)) continue;
            this.bsRenderMesh.clearAll();
            this.renderBioShape(bioShape);
            this.renderMeshes();
            this.freeTempArrays();
        }
    }

    protected boolean setBioColix(short s) {
        if (this.g3d.setColix(s)) {
            return true;
        }
        this.needTranslucent = true;
        return false;
    }

    private void freeTempArrays() {
        if (this.haveControlPointScreens) {
            this.viewer.freeTempScreens(this.controlPointScreens);
        }
        this.viewer.freeTempEnum(this.structureTypes);
    }

    private boolean initializePolymer(BioShape bioShape) {
        BS bS = this.viewer.getDeletedAtoms();
        this.controlPoints = this.viewer.isJmolDataFrameForModel(bioShape.modelIndex) ? bioShape.bioPolymer.getControlPoints(true, 0.0f, false) : bioShape.bioPolymer.getControlPoints(this.isTraceAlpha, this.sheetSmoothing, this.invalidateSheets);
        this.monomerCount = bioShape.monomerCount;
        this.bsRenderMesh = BS.newN(this.monomerCount);
        this.monomers = bioShape.monomers;
        this.reversed = bioShape.bioPolymer.reversed;
        this.leadAtomIndices = bioShape.bioPolymer.getLeadAtomIndices();
        this.bsVisible.clearAll();
        boolean bl = false;
        if (this.invalidateMesh) {
            bioShape.falsifyMesh();
        }
        int n = this.monomerCount;
        while (--n >= 0) {
            if ((this.monomers[n].shapeVisibilityFlags & this.myVisibilityFlag) == 0 || this.modelSet.isAtomHidden(this.leadAtomIndices[n]) || bS != null && bS.get(this.leadAtomIndices[n])) continue;
            Atom atom = this.modelSet.atoms[this.leadAtomIndices[n]];
            if (!this.g3d.isInDisplayRange(atom.screenX, atom.screenY)) continue;
            this.bsVisible.set(n);
            bl = true;
        }
        if (!bl) {
            return false;
        }
        this.ribbonBorder = this.viewer.getBoolean(603979898);
        this.isNucleic = bioShape.bioPolymer instanceof NucleicPolymer;
        this.isCarbohydrate = bioShape.bioPolymer instanceof CarbohydratePolymer;
        this.haveControlPointScreens = false;
        this.wingVectors = bioShape.wingVectors;
        this.meshReady = bioShape.meshReady;
        this.meshes = bioShape.meshes;
        this.mads = bioShape.mads;
        this.colixes = bioShape.colixes;
        this.colixesBack = bioShape.colixesBack;
        this.setStructureTypes();
        return true;
    }

    private void setStructureTypes() {
        this.structureTypes = this.viewer.allocTempEnum(this.monomerCount + 1);
        int n = this.monomerCount;
        while (--n >= 0) {
            this.structureTypes[n] = this.monomers[n].getProteinStructureType();
            if (this.structureTypes[n] != EnumStructure.TURN) continue;
            this.structureTypes[n] = EnumStructure.NONE;
        }
        this.structureTypes[this.monomerCount] = this.structureTypes[this.monomerCount - 1];
    }

    protected boolean isHelix(int n) {
        return this.structureTypes[n] == EnumStructure.HELIX;
    }

    protected void getScreenControlPoints() {
        this.calcScreenControlPoints(this.controlPoints);
    }

    protected void calcScreenControlPoints(P3[] p3Array) {
        int n = this.monomerCount + 1;
        this.controlPointScreens = this.viewer.allocTempScreens(n);
        int n2 = n;
        while (--n2 >= 0) {
            this.viewer.transformPtScr(p3Array[n2], this.controlPointScreens[n2]);
        }
        this.haveControlPointScreens = true;
    }

    protected P3i[] calcScreens(float f) {
        int n = this.controlPoints.length;
        P3i[] p3iArray = this.viewer.allocTempScreens(n);
        if (f == 0.0f) {
            int n2 = n;
            while (--n2 >= 0) {
                this.viewer.transformPtScr(this.controlPoints[n2], p3iArray[n2]);
            }
        } else {
            float f2 = f / 1000.0f;
            int n3 = n;
            while (--n3 >= 0) {
                this.calc1Screen(this.controlPoints[n3], this.wingVectors[n3], this.mads[n3] == 0 && n3 > 0 ? this.mads[n3 - 1] : this.mads[n3], f2, p3iArray[n3]);
            }
        }
        return p3iArray;
    }

    private void calc1Screen(P3 p3, V3 v3, short s, float f, P3i p3i) {
        this.pointT.setT(v3);
        float f2 = (float)s * f;
        this.pointT.scaleAdd(f2, p3);
        this.viewer.transformPtScr(this.pointT, p3i);
    }

    protected short getLeadColix(int n) {
        return C.getColixInherited(this.colixes[n], this.monomers[n].getLeadAtom().getColix());
    }

    protected short getLeadColixBack(int n) {
        return this.colixesBack == null || this.colixesBack.length <= n ? (short)0 : this.colixesBack[n];
    }

    private void setNeighbors(int n) {
        this.iPrev = Math.max(n - 1, 0);
        this.iNext = Math.min(n + 1, this.monomerCount);
        this.iNext2 = Math.min(n + 2, this.monomerCount);
        this.iNext3 = Math.min(n + 3, this.monomerCount);
    }

    private boolean setMads(int n, boolean bl) {
        this.madBeg = this.madEnd = this.mads[n];
        this.madMid = this.madEnd;
        if (this.isTraceAlpha) {
            if (!bl || this.structureTypes[n] == this.structureTypes[this.iNext]) {
                this.madEnd = this.mads[this.iNext];
                if (this.madEnd == 0) {
                    this.madEnd = this instanceof TraceRenderer ? this.madBeg : this.madBeg;
                }
                this.madMid = (short)(this.madBeg + this.madEnd >> 1);
            }
        } else {
            if (!bl || this.structureTypes[n] == this.structureTypes[this.iPrev]) {
                this.madBeg = (short)((this.mads[this.iPrev] == 0 ? this.madMid : this.mads[this.iPrev]) + this.madMid >> 1);
            }
            if (!bl || this.structureTypes[n] == this.structureTypes[this.iNext]) {
                this.madEnd = (short)((this.mads[this.iNext] == 0 ? this.madMid : this.mads[this.iNext]) + this.madMid >> 1);
            }
        }
        this.diameterBeg = (int)this.viewer.scaleToScreen(this.controlPointScreens[n].z, this.madBeg);
        this.diameterMid = (int)this.viewer.scaleToScreen(this.monomers[n].getLeadAtom().screenZ, this.madMid);
        this.diameterEnd = (int)this.viewer.scaleToScreen(this.controlPointScreens[this.iNext].z, this.madEnd);
        this.doCap0 = n == this.iPrev || bl && this.structureTypes[n] != this.structureTypes[this.iPrev];
        this.doCap1 = this.iNext == this.iNext2 || bl && this.structureTypes[n] != this.structureTypes[this.iNext];
        return this.aspectRatio > 0.0f && (this.exportType == 1 || this.checkDiameter(this.diameterBeg) || this.checkDiameter(this.diameterMid) || this.checkDiameter(this.diameterEnd));
    }

    private boolean checkDiameter(int n) {
        return this.isHighRes & n > 3 || n >= 8;
    }

    protected void renderHermiteCylinder(P3i[] p3iArray, int n) {
        this.colix = this.getLeadColix(n);
        if (!this.setBioColix(this.colix)) {
            return;
        }
        this.setNeighbors(n);
        this.g3d.drawHermite4(this.isNucleic ? 4 : 7, p3iArray[this.iPrev], p3iArray[n], p3iArray[this.iNext], p3iArray[this.iNext2]);
    }

    protected void renderHermiteConic(int n, boolean bl) {
        this.setNeighbors(n);
        this.colix = this.getLeadColix(n);
        if (!this.setBioColix(this.colix)) {
            return;
        }
        if (this.setMads(n, bl) || this.isExport) {
            try {
                if (!(this.meshes[n] != null && this.meshReady[n] || this.createMesh(n, this.madBeg, this.madMid, this.madEnd, 1.0f))) {
                    return;
                }
                this.meshes[n].setColix(this.colix);
                this.bsRenderMesh.set(n);
                return;
            }
            catch (Exception exception) {
                this.bsRenderMesh.clear(n);
                this.meshes[n] = null;
                Logger.error("render mesh error hermiteConic: " + exception.toString());
            }
        }
        if (this.diameterBeg == 0 && this.diameterEnd == 0 || this.wireframeOnly) {
            this.g3d.drawLineAB(this.controlPointScreens[n], this.controlPointScreens[this.iNext]);
        } else {
            this.g3d.fillHermite(this.isNucleic ? 4 : 7, this.diameterBeg, this.diameterMid, this.diameterEnd, this.controlPointScreens[this.iPrev], this.controlPointScreens[n], this.controlPointScreens[this.iNext], this.controlPointScreens[this.iNext2]);
        }
    }

    protected void renderHermiteRibbon(boolean bl, int n, boolean bl2) {
        this.setNeighbors(n);
        this.colix = this.getLeadColix(n);
        if (!this.setBioColix(this.colix)) {
            return;
        }
        this.colixBack = this.getLeadColixBack(n);
        if (bl && (this.aspectRatio != 0.0f || this.isExport) && (this.setMads(n, bl2) || this.isExport)) {
            try {
                if (!(this.meshes[n] != null && this.meshReady[n] || this.createMesh(n, this.madBeg, this.madMid, this.madEnd, this.aspectRatio))) {
                    return;
                }
                this.meshes[n].setColix(this.colix);
                this.meshes[n].setColixBack(this.colixBack);
                this.bsRenderMesh.set(n);
                return;
            }
            catch (Exception exception) {
                this.bsRenderMesh.clear(n);
                this.meshes[n] = null;
                Logger.error("render mesh error hermiteRibbon: " + exception.toString());
            }
        }
        this.g3d.drawHermite7(bl, this.ribbonBorder, (this.reversed.get(n) ? -1 : 1) * (this.isNucleic ? 4 : 7), this.ribbonTopScreens[this.iPrev], this.ribbonTopScreens[n], this.ribbonTopScreens[this.iNext], this.ribbonTopScreens[this.iNext2], this.ribbonBottomScreens[this.iPrev], this.ribbonBottomScreens[n], this.ribbonBottomScreens[this.iNext], this.ribbonBottomScreens[this.iNext2], (int)this.aspectRatio, this.colixBack);
    }

    protected void renderHermiteArrowHead(int n) {
        this.colix = this.getLeadColix(n);
        if (!this.setBioColix(this.colix)) {
            return;
        }
        this.colixBack = this.getLeadColixBack(n);
        this.setNeighbors(n);
        if (this.setMads(n, false) || this.isExport) {
            try {
                this.doCap0 = true;
                this.doCap1 = false;
                if (!(this.meshes[n] != null && this.meshReady[n] || this.createMesh(n, (int)Math.floor((double)this.madBeg * 1.2), (int)Math.floor((double)this.madBeg * 0.6), 0, this.aspectRatio == 1.0f ? this.aspectRatio : this.aspectRatio / 2.0f))) {
                    return;
                }
                this.meshes[n].setColix(this.colix);
                this.bsRenderMesh.set(n);
                return;
            }
            catch (Exception exception) {
                this.bsRenderMesh.clear(n);
                this.meshes[n] = null;
                Logger.error("render mesh error hermiteArrowHead: " + exception.toString());
            }
        }
        this.calc1Screen(this.controlPoints[n], this.wingVectors[n], this.madBeg, 7.0E-4f, this.screenArrowTop);
        this.calc1Screen(this.controlPoints[n], this.wingVectors[n], this.madBeg, -7.0E-4f, this.screenArrowBot);
        this.calc1Screen(this.controlPoints[n], this.wingVectors[n], this.madBeg, 0.001f, this.screenArrowTopPrev);
        this.calc1Screen(this.controlPoints[n], this.wingVectors[n], this.madBeg, -0.001f, this.screenArrowBotPrev);
        this.g3d.drawHermite7(true, this.ribbonBorder, this.isNucleic ? 4 : 7, this.screenArrowTopPrev, this.screenArrowTop, this.controlPointScreens[this.iNext], this.controlPointScreens[this.iNext2], this.screenArrowBotPrev, this.screenArrowBot, this.controlPointScreens[this.iNext], this.controlPointScreens[this.iNext2], (int)this.aspectRatio, this.colixBack);
        if (this.ribbonBorder && this.aspectRatio == 0.0f) {
            this.g3d.fillCylinderXYZ(this.colix, this.colix, (byte)3, this.exportType == 1 ? 50 : 3, this.screenArrowTop.x, this.screenArrowTop.y, this.screenArrowTop.z, this.screenArrowBot.x, this.screenArrowBot.y, this.screenArrowBot.z);
        }
    }

    private boolean createMesh(int n, int n2, int n3, int n4, float f) {
        int n5;
        boolean bl;
        this.setNeighbors(n);
        if (this.controlPoints[n].distance(this.controlPoints[this.iNext]) == 0.0f) {
            return false;
        }
        boolean bl2 = f != 1.0f && this.wingVectors != null;
        boolean bl3 = f == 0.0f;
        boolean bl4 = this.cartoonsFancy || this.hermiteLevel >= 6;
        int n6 = (this.hermiteLevel + 1) * 2 + 1;
        int n7 = bl3 ? 4 : (this.hermiteLevel + 1) * 4 - 2;
        float f2 = (float)(bl3 ? Math.PI / (double)(n7 - 1) : Math.PI * 2 / (double)n7);
        Mesh mesh = this.meshes[n] = new Mesh().mesh1("mesh_" + this.shapeID + "_" + n, (short)0, n);
        boolean bl5 = bl = n2 != n3 || n3 != n4;
        if (this.controlHermites == null || this.controlHermites.length < n6 + 1) {
            this.controlHermites = new P3[n6 + 1];
        }
        Hermite.getHermiteList(this.isNucleic ? 4 : 7, this.controlPoints[this.iPrev], this.controlPoints[n], this.controlPoints[this.iNext], this.controlPoints[this.iNext2], this.controlPoints[this.iNext3], this.controlHermites, 0, n6, true);
        if (this.wingHermites == null || this.wingHermites.length < n6 + 1) {
            this.wingHermites = new V3[n6 + 1];
        }
        this.wing.setT(this.wingVectors[this.iPrev]);
        if (n4 == 0) {
            this.wing.scale(2.0f);
        }
        Hermite.getHermiteList(this.isNucleic ? 4 : 7, this.wing, this.wingVectors[n], this.wingVectors[this.iNext], this.wingVectors[this.iNext2], this.wingVectors[this.iNext3], this.wingHermites, 0, n6, false);
        float f3 = (float)n2 / 2000.0f;
        float f4 = (float)n3 / 2000.0f;
        float f5 = (float)n4 / 2000.0f;
        if (bl) {
            if (this.radiusHermites == null || this.radiusHermites.length < (n6 + 1 >> 1) + 1) {
                this.radiusHermites = new P3[(n6 + 1 >> 1) + 1];
            }
            this.ptPrev.set(f3, f3, 0.0f);
            this.pt.set(f3, f4, 0.0f);
            this.pt1.set(f4, f5, 0.0f);
            this.ptNext.set(f5, f5, 0.0f);
            Hermite.getHermiteList(4, this.ptPrev, this.pt, this.pt1, this.ptNext, this.ptNext, this.radiusHermites, 0, n6 + 1 >> 1, true);
        }
        int n8 = 0;
        int n9 = n6 >> 1;
        int n10 = (n7 + 2) / 4;
        int n11 = (3 * n7 + 2) / 4;
        int n12 = !bl2 ? 0 : (bl3 ? 1 : (bl4 ? 2 : 3));
        boolean bl6 = n12 == 0 || n12 == 3;
        for (n5 = 0; n5 < n6; ++n5) {
            this.norm.sub2(this.controlHermites[n5 + 1], this.controlHermites[n5]);
            float f6 = !bl ? f3 : (n5 < n9 ? this.radiusHermites[n5].x : this.radiusHermites[n5 - n9].y);
            this.wing.setT(this.wingHermites[n5]);
            this.wing1.setT(this.wing);
            switch (n12) {
                case 1: {
                    break;
                }
                case 2: {
                    this.wing1.cross(this.norm, this.wing);
                    this.wing1.normalize();
                    this.wing1.scale(this.wing.length() / f);
                    break;
                }
                case 3: {
                    this.wing.scale(2.0f / f);
                    this.wing1.sub(this.wing);
                    break;
                }
                case 0: {
                    this.wing.cross(this.wing, this.norm);
                    this.wing.normalize();
                }
            }
            this.wing.scale(f6);
            this.wing1.scale(f6);
            if (bl6) {
                this.aa.setVA(this.norm, f2);
                this.mat.setAA(this.aa);
            }
            this.pt1.setT(this.controlHermites[n5]);
            float f7 = bl3 ? 0.0f : f2;
            int n13 = 0;
            while (n13 < n7) {
                if (bl6 && n13 > 0) {
                    this.mat.transform(this.wing);
                }
                switch (n12) {
                    case 1: {
                        this.wingT.setT(this.wing1);
                        this.wingT.scale((float)Math.cos(f7));
                        break;
                    }
                    case 2: {
                        this.wingT.setT(this.wing1);
                        this.wingT.scale((float)Math.sin(f7));
                        this.wingT.scaleAdd2((float)Math.cos(f7), this.wing, this.wingT);
                        break;
                    }
                    case 3: {
                        this.wingT.setT(this.wing);
                        if (n13 == n10 || n13 == n11) {
                            this.wing1.scale(-1.0f);
                        }
                        this.wingT.add(this.wing1);
                        break;
                    }
                    case 0: {
                        this.wingT.setT(this.wing);
                    }
                }
                this.pt.add2(this.pt1, this.wingT);
                mesh.addV(this.pt);
                ++n13;
                f7 += f2;
            }
            if (n5 > 0) {
                n13 = bl3 ? n7 - 1 : n7;
                for (int i = 0; i < n13; ++i) {
                    int n14 = n8 - n7 + i;
                    int n15 = n8 - n7 + (i + 1) % n7;
                    int n16 = n8 + (i + 1) % n7;
                    int n17 = n8 + i;
                    if (i < n13 / 2) {
                        mesh.addQuad(n14, n15, n16, n17);
                        continue;
                    }
                    mesh.addQuad(n15, n16, n17, n14);
                }
            }
            n8 += n7;
        }
        if (!bl3) {
            n5 = n8;
            if (this.doCap0) {
                int n18;
                for (n18 = 0; n18 < n7; ++n18) {
                    mesh.addV(mesh.vertices[n18]);
                }
                n8 += n7;
                n18 = this.hermiteLevel * 2;
                while (--n18 >= 0) {
                    mesh.addQuad(n8 - n7 + n18 + 2, n8 - n7 + n18 + 1, n8 - n7 + (n7 - n18) % n7, n8 - n18 - 1);
                }
            }
            if (this.doCap1) {
                int n19;
                for (n19 = 0; n19 < n7; ++n19) {
                    mesh.addV(mesh.vertices[n5 - n7 + n19]);
                }
                n8 += n7;
                n19 = this.hermiteLevel * 2;
                while (--n19 >= 0) {
                    mesh.addQuad(n8 - n19 - 1, n8 - n7 + (n7 - n19) % n7, n8 - n7 + n19 + 1, n8 - n7 + n19 + 2);
                }
            }
        }
        this.meshReady[n] = true;
        this.adjustCartoonSeamNormals(n, n7);
        mesh.setVisibilityFlags(1);
        return true;
    }

    void adjustCartoonSeamNormals(int n, int n2) {
        if (this.bsTemp == null) {
            this.bsTemp = Normix.newVertexBitSet();
        }
        if (n == this.iNext - 1 && this.iNext < this.monomerCount && this.monomers[n].getStrucNo() == this.monomers[this.iNext].getStrucNo() && this.meshReady[n] && this.meshReady[this.iNext]) {
            try {
                V3[] v3Array = this.meshes[this.iNext].getNormalsTemp();
                V3[] v3Array2 = this.meshes[n].getNormalsTemp();
                int n3 = v3Array2.length;
                if (this.doCap0) {
                    n3 -= n2;
                }
                for (int i = 1; i <= n2; ++i) {
                    this.norml.add2(v3Array2[n3 - i], v3Array[n2 - i]);
                    this.norml.normalize();
                    this.meshes[n].normalsTemp[n3 - i].setT(this.norml);
                    this.meshes[this.iNext].normalsTemp[n2 - i].setT(this.norml);
                }
            }
            catch (Exception exception) {
                // empty catch block
            }
        }
    }

    private void renderMeshes() {
        int n = this.bsRenderMesh.nextSetBit(0);
        while (n >= 0) {
            if (this.meshes[n].normalsTemp != null) {
                this.meshes[n].setNormixes(this.meshes[n].normalsTemp);
                this.meshes[n].normalsTemp = null;
            } else if (this.meshes[n].normixes == null) {
                this.meshes[n].initialize(1073741958, null, null);
            }
            this.renderMesh(this.meshes[n]);
            n = this.bsRenderMesh.nextSetBit(n + 1);
        }
    }
}

