/*
 * Decompiled with CFR 0.152.
 */
package org.jmol.renderspecial;

import javajs.util.P3i;
import org.jmol.java.BS;
import org.jmol.renderspecial.DotsRenderer;
import org.jmol.shapespecial.GeoSurface;
import org.jmol.util.Geodesic;

public class GeoSurfaceRenderer
extends DotsRenderer {
    private P3i facePt1 = new P3i();
    private P3i facePt2 = new P3i();
    private P3i facePt3 = new P3i();

    @Override
    protected boolean render() {
        GeoSurface geoSurface = (GeoSurface)this.shape;
        boolean bl = this.iShowSolid = this.viewer.checkMotionRendering(1113198597) || geoSurface.ec.getDotsConvexMax() <= 100;
        if (!this.iShowSolid) {
            return false;
        }
        if (!this.g3d.setColix((short)4)) {
            return true;
        }
        this.g3d.addRenderer(1073742182);
        if (this.iShowSolid && this.faceMap == null) {
            this.faceMap = new int[this.screenDotCount];
        }
        this.render1(geoSurface);
        return false;
    }

    @Override
    protected void renderConvex(short s, BS bS, int n) {
        this.colix = s;
        if (this.iShowSolid) {
            if (this.g3d.setColix(s)) {
                this.renderSurface(bS);
            }
            return;
        }
        this.renderDots(n);
    }

    private void renderSurface(BS bS) {
        if (this.faceMap == null) {
            return;
        }
        short[] sArray = Geodesic.getFaceVertexes(this.screenLevel);
        int[] nArray = this.screenCoordinates;
        int n = bS.size();
        if (this.screenDotCount < n) {
            n = this.screenDotCount;
        }
        int n2 = 0;
        while (n2 < sArray.length) {
            short s = sArray[n2++];
            short s2 = sArray[n2++];
            short s3 = sArray[n2++];
            if (s >= n || s2 >= n || s3 >= n || !bS.get(s) || !bS.get(s2) || !bS.get(s3)) continue;
            this.facePt1.set(nArray[this.faceMap[s]], nArray[this.faceMap[s] + 1], nArray[this.faceMap[s] + 2]);
            this.facePt2.set(nArray[this.faceMap[s2]], nArray[this.faceMap[s2] + 1], nArray[this.faceMap[s2] + 2]);
            this.facePt3.set(nArray[this.faceMap[s3]], nArray[this.faceMap[s3] + 1], nArray[this.faceMap[s3] + 2]);
            this.g3d.fillTriangle3CN(this.facePt1, this.colix, s, this.facePt2, this.colix, s2, this.facePt3, this.colix, s3);
        }
    }
}

