/*
 * Decompiled with CFR 0.152.
 */
package org.jmol.viewer;

import java.util.Hashtable;
import java.util.Map;
import javajs.util.List;
import javajs.util.M4;
import javajs.util.P3;
import javajs.util.P3i;
import javajs.util.SB;
import javajs.util.T3;
import org.jmol.atomdata.RadiusData;
import org.jmol.constant.EnumPalette;
import org.jmol.constant.EnumVdw;
import org.jmol.java.BS;
import org.jmol.modelset.Atom;
import org.jmol.modelset.Group;
import org.jmol.modelset.ModelSet;
import org.jmol.shape.Shape;
import org.jmol.util.BSUtil;
import org.jmol.util.GData;
import org.jmol.util.JmolMolecule;
import org.jmol.util.Logger;
import org.jmol.util.Vibration;
import org.jmol.viewer.JC;
import org.jmol.viewer.Viewer;

public class ShapeManager {
    private GData gdata;
    private ModelSet modelSet;
    Shape[] shapes;
    public Viewer viewer;
    private static final int[] hoverable = new int[]{30, 25, 24, 22, 35};
    private static int clickableMax = hoverable.length - 1;
    private final BS bsRenderableAtoms = new BS();
    private final int[] navigationCrossHairMinMax = new int[4];

    public ShapeManager(Viewer viewer, ModelSet modelSet) {
        this(viewer);
        this.resetShapes();
        this.loadDefaultShapes(modelSet);
    }

    ShapeManager(Viewer viewer) {
        this.viewer = viewer;
        this.gdata = viewer.getGraphicsData();
    }

    public void findNearestShapeAtomIndex(int n, int n2, Atom[] atomArray, BS bS) {
        if (this.shapes != null) {
            for (int i = 0; i < this.shapes.length && atomArray[0] == null; ++i) {
                if (this.shapes[i] == null) continue;
                this.shapes[i].findNearestAtomIndex(n, n2, atomArray, bS);
            }
        }
    }

    public Shape[] getShapes() {
        return this.shapes;
    }

    public Object getShapePropertyIndex(int n, String string, int n2) {
        if (this.shapes == null || this.shapes[n] == null) {
            return null;
        }
        this.viewer.setShapeErrorState(n, "get " + string);
        Object object = this.shapes[n].getProperty(string, n2);
        this.viewer.setShapeErrorState(-1, null);
        return object;
    }

    public boolean getShapePropertyData(int n, String string, Object[] objectArray) {
        if (this.shapes == null || this.shapes[n] == null) {
            return false;
        }
        this.viewer.setShapeErrorState(n, "get " + string);
        boolean bl = this.shapes[n].getPropertyData(string, objectArray);
        this.viewer.setShapeErrorState(-1, null);
        return bl;
    }

    public int getShapeIdFromObjectName(String string) {
        if (this.shapes != null) {
            for (int i = 16; i < 29; ++i) {
                if (this.shapes[i] == null || this.shapes[i].getIndexFromName(string) < 0) continue;
                return i;
            }
        }
        return -1;
    }

    public void loadDefaultShapes(ModelSet modelSet) {
        this.modelSet = modelSet;
        if (this.shapes != null) {
            for (int i = 0; i < this.shapes.length; ++i) {
                if (this.shapes[i] == null) continue;
                this.shapes[i].setModelSet(modelSet);
            }
        }
        this.loadShape(0);
        this.loadShape(1);
    }

    public Shape loadShape(int n) {
        if (this.shapes == null) {
            return null;
        }
        if (this.shapes[n] != null) {
            return this.shapes[n];
        }
        if (n == 2 || n == 3 || n == 4) {
            return null;
        }
        String string = JC.getShapeClassName(n, false);
        try {
            Class<?> clazz = Class.forName(string);
            Shape shape = (Shape)clazz.newInstance();
            this.viewer.setShapeErrorState(n, "allocate");
            shape.initializeShape(this.viewer, this.gdata, this.modelSet, n);
            this.viewer.setShapeErrorState(-1, null);
            this.shapes[n] = shape;
            return this.shapes[n];
        }
        catch (Exception exception) {
            Logger.errorEx("Could not instantiate shape:" + string, exception);
            return null;
        }
    }

    public void refreshShapeTrajectories(int n, BS bS, M4 m4) {
        Integer n2 = n;
        BS bS2 = this.viewer.getModelUndeletedAtomsBitSet(n);
        for (int i = 0; i < 36; ++i) {
            if (this.shapes[i] == null) continue;
            this.setShapePropertyBs(i, "refreshTrajectories", new Object[]{n2, bS, m4}, bS2);
        }
    }

    public void releaseShape(int n) {
        if (this.shapes != null) {
            this.shapes[n] = null;
        }
    }

    public void resetShapes() {
        if (!this.viewer.noGraphicsAllowed()) {
            this.shapes = new Shape[36];
        }
    }

    public void setShapeSizeBs(int n, int n2, RadiusData radiusData, BS bS) {
        if (this.shapes == null) {
            return;
        }
        if (bS == null && (n != 1 || n2 != Integer.MAX_VALUE)) {
            bS = this.viewer.getSelectionSet(false);
        }
        if (radiusData != null && radiusData.value != 0.0f && radiusData.vdwType == EnumVdw.TEMP) {
            this.modelSet.getBfactor100Lo();
        }
        this.viewer.setShapeErrorState(n, "set size");
        if (radiusData == null ? n2 != 0 : radiusData.value != 0.0f) {
            this.loadShape(n);
        }
        if (this.shapes[n] != null) {
            this.shapes[n].setShapeSizeRD(n2, radiusData, bS);
        }
        this.viewer.setShapeErrorState(-1, null);
    }

    public void setLabel(String string, BS bS) {
        if (string == null) {
            if (this.shapes[5] == null) {
                return;
            }
        } else {
            this.loadShape(5);
            this.setShapeSizeBs(5, 0, null, bS);
        }
        this.setShapePropertyBs(5, "label", string, bS);
    }

    public void setShapePropertyBs(int n, String string, Object object, BS bS) {
        if (this.shapes == null || this.shapes[n] == null) {
            return;
        }
        if (bS == null) {
            bS = this.viewer.getSelectionSet(false);
        }
        this.viewer.setShapeErrorState(n, "set " + string);
        this.shapes[n].setProperty(string.intern(), object, bS);
        this.viewer.setShapeErrorState(-1, null);
    }

    boolean checkFrankclicked(int n, int n2) {
        Shape shape = this.shapes[35];
        return shape != null && shape.wasClicked(n, n2);
    }

    Map<String, Object> checkObjectClicked(int n, int n2, int n3, BS bS, boolean bl) {
        Map<String, Object> map = null;
        if (n3 != 0 && this.viewer.getBondPicking() && (map = this.shapes[1].checkObjectClicked(n, n2, n3, bS, bl)) != null) {
            return map;
        }
        for (int i = 0; i < clickableMax; ++i) {
            Shape shape = this.shapes[hoverable[i]];
            if (shape == null || (map = shape.checkObjectClicked(n, n2, n3, bS, bl)) == null) continue;
            return map;
        }
        return null;
    }

    boolean checkObjectDragged(int n, int n2, int n3, int n4, int n5, BS bS, int n6) {
        boolean bl = false;
        int n7 = n6 > 0 ? n6 + 1 : 36;
        for (int i = n6; !bl && i < n7; ++i) {
            if (this.shapes[i] == null) continue;
            bl = this.shapes[i].checkObjectDragged(n, n2, n3, n4, n5, bS);
        }
        return bl;
    }

    boolean checkObjectHovered(int n, int n2, BS bS, boolean bl) {
        Shape shape = this.shapes[1];
        if (bl && shape != null && shape.checkObjectHovered(n, n2, bS)) {
            return true;
        }
        for (int i = 0; i < hoverable.length; ++i) {
            shape = this.shapes[hoverable[i]];
            if (shape == null || !shape.checkObjectHovered(n, n2, bS)) continue;
            return true;
        }
        return false;
    }

    void deleteShapeAtoms(Object[] objectArray, BS bS) {
        if (this.shapes != null) {
            for (int i = 0; i < 36; ++i) {
                if (this.shapes[i] == null) continue;
                this.setShapePropertyBs(i, "deleteModelAtoms", objectArray, bS);
            }
        }
    }

    void deleteVdwDependentShapes(BS bS) {
        if (bS == null) {
            bS = this.viewer.getSelectionSet(false);
        }
        if (this.shapes[24] != null) {
            this.shapes[24].setProperty("deleteVdw", null, bS);
        }
        if (this.shapes[25] != null) {
            this.shapes[25].setProperty("deleteVdw", null, bS);
        }
    }

    float getAtomShapeValue(int n, Group group, int n2) {
        int n3 = JC.shapeTokenIndex(n);
        if (n3 < 0 || this.shapes[n3] == null) {
            return 0.0f;
        }
        int n4 = this.shapes[n3].getSize(n2);
        if (n4 == 0) {
            if ((group.shapeVisibilityFlags & this.shapes[n3].myVisibilityFlag) == 0) {
                return 0.0f;
            }
            n4 = this.shapes[n3].getSizeG(group);
        }
        return (float)n4 / 2000.0f;
    }

    void getObjectMap(Map<String, ?> map, boolean bl) {
        if (this.shapes == null) {
            return;
        }
        Boolean bl2 = bl;
        for (int i = 16; i < 29; ++i) {
            this.getShapePropertyData(i, "getNames", new Object[]{map, bl2});
        }
    }

    Object getProperty(Object object) {
        if (object.equals("getShapes")) {
            return this.shapes;
        }
        return null;
    }

    BS getRenderableBitSet() {
        return this.bsRenderableAtoms;
    }

    public Shape getShape(int n) {
        return this.shapes == null ? null : this.shapes[n];
    }

    Map<String, Object> getShapeInfo() {
        Hashtable<String, Object> hashtable = new Hashtable<String, Object>();
        SB sB = new SB();
        if (this.shapes != null) {
            for (int i = 0; i < 36; ++i) {
                Shape shape = this.shapes[i];
                if (shape == null) continue;
                String string = JC.shapeClassBases[i];
                List<Map<String, Object>> list = shape.getShapeDetail();
                if (list == null) continue;
                hashtable.put(string, list);
            }
        }
        if (sB.length() > 0) {
            hashtable.put("shapeCommands", sB.toString());
        }
        return hashtable;
    }

    void mergeShapes(Shape[] shapeArray) {
        if (shapeArray == null) {
            return;
        }
        if (this.shapes == null) {
            this.shapes = shapeArray;
        } else {
            for (int i = 0; i < shapeArray.length; ++i) {
                if (shapeArray[i] == null) continue;
                if (this.shapes[i] == null) {
                    this.loadShape(i);
                }
                this.shapes[i].merge(shapeArray[i]);
            }
        }
    }

    void resetBioshapes(BS bS) {
        if (this.shapes == null) {
            return;
        }
        for (int i = 0; i < this.shapes.length; ++i) {
            if (this.shapes[i] == null || !this.shapes[i].isBioShape) continue;
            this.shapes[i].setModelSet(this.modelSet);
            this.shapes[i].setShapeSizeRD(0, null, bS);
            this.shapes[i].setProperty("color", (Object)EnumPalette.NONE, bS);
        }
    }

    void setAtomLabel(String string, int n) {
        if (this.shapes == null) {
            return;
        }
        this.loadShape(5);
        this.shapes[5].setProperty("label:" + string, n, null);
    }

    void setModelVisibility() {
        int n;
        if (this.shapes == null || this.shapes[0] == null) {
            return;
        }
        BS bS = this.viewer.getVisibleFramesBitSet();
        for (n = 1; n < 36; ++n) {
            if (this.shapes[n] == null) continue;
            this.shapes[n].setVisibilityFlags(bS);
        }
        this.shapes[0].setVisibilityFlags(bS);
        for (n = 0; n < 36; ++n) {
            Shape shape = this.shapes[n];
            if (shape == null) continue;
            shape.setModelClickability();
        }
    }

    public void finalizeAtoms(BS bS, P3 p3) {
        Atom[] atomArray;
        if (bS != null) {
            atomArray = this.viewer.getAtomSetCenter(bS);
            P3 p32 = new P3();
            this.viewer.transformPt3f((P3)atomArray, p32);
            p32.add(p3);
            this.viewer.unTransformPoint(p32, p32);
            p32.sub((T3)atomArray);
            this.viewer.setAtomCoordsRelative(p32, bS);
            p3.set(0.0f, 0.0f, 0.0f);
        }
        this.bsRenderableAtoms.clearAll();
        atomArray = this.modelSet.atoms;
        int n = this.modelSet.getAtomCount();
        while (--n >= 0) {
            Atom atom = atomArray[n];
            if ((atom.getShapeVisibilityFlags() & 1) == 0) continue;
            this.bsRenderableAtoms.set(n);
        }
    }

    public int[] transformAtoms() {
        int n;
        int n2;
        Vibration[] vibrationArray = this.modelSet.vibrations;
        Atom[] atomArray = this.modelSet.atoms;
        int n3 = this.bsRenderableAtoms.nextSetBit(0);
        while (n3 >= 0) {
            Atom atom = atomArray[n3];
            P3i p3i = vibrationArray != null && atom.hasVibration() ? this.viewer.transformPtVib(atom, vibrationArray[n3]) : this.viewer.transformPt(atom);
            atom.screenX = p3i.x;
            atom.screenY = p3i.y;
            atom.screenZ = p3i.z;
            n2 = Math.abs(atom.madAtom);
            if (n2 == Atom.MAD_GLOBAL) {
                n2 = (int)(this.viewer.getFloat(0x44100001) * 2000.0f);
            }
            atom.screenDiameter = (short)this.viewer.scaleToScreen(p3i.z, n2);
            n3 = this.bsRenderableAtoms.nextSetBit(n3 + 1);
        }
        if (this.viewer.getSlabEnabled()) {
            int n4;
            n3 = this.viewer.getBoolean(603979940) ? 1 : 0;
            boolean bl = this.viewer.getBoolean(603979938);
            int n5 = this.gdata.getSlab();
            n2 = this.gdata.getDepth();
            if (n3 != 0) {
                JmolMolecule[] jmolMoleculeArray = this.modelSet.getMolecules();
                int n6 = this.modelSet.getMoleculeCountInModel(-1);
                for (n4 = 0; n4 < n6; ++n4) {
                    JmolMolecule jmolMolecule = jmolMoleculeArray[n4];
                    int n7 = 0;
                    int n8 = jmolMolecule.firstAtomIndex;
                    if (!this.bsRenderableAtoms.get(n8)) continue;
                    while (n7 < jmolMolecule.atomCount && !this.gdata.isClippedZ(atomArray[n8].screenZ - (atomArray[n8].screenDiameter >> 1))) {
                        ++n7;
                        ++n8;
                    }
                    if (n7 == jmolMolecule.atomCount) continue;
                    n8 = jmolMolecule.firstAtomIndex;
                    for (int i = 0; i < jmolMolecule.atomCount; ++i) {
                        this.bsRenderableAtoms.clear(n8);
                        atomArray[n8++].screenZ = 0;
                    }
                }
            }
            n = this.bsRenderableAtoms.nextSetBit(0);
            while (n >= 0) {
                Atom atom = atomArray[n];
                if (this.gdata.isClippedZ(atom.screenZ - (bl ? atomArray[n].screenDiameter >> 1 : 0))) {
                    atom.setClickable(0);
                    n4 = (bl ? -1 : 1) * atom.screenDiameter / 2;
                    if (atom.screenZ + n4 < n5 || atom.screenZ - n4 > n2 || !this.gdata.isInDisplayRange(atom.screenX, atom.screenY)) {
                        this.bsRenderableAtoms.clear(n);
                    }
                }
                n = this.bsRenderableAtoms.nextSetBit(n + 1);
            }
        }
        if (this.modelSet.getAtomCount() == 0 || !this.viewer.getShowNavigationPoint()) {
            return null;
        }
        n3 = Integer.MAX_VALUE;
        int n9 = Integer.MIN_VALUE;
        int n10 = Integer.MAX_VALUE;
        n2 = Integer.MIN_VALUE;
        n = this.bsRenderableAtoms.nextSetBit(0);
        while (n >= 0) {
            Atom atom = atomArray[n];
            if (atom.screenX < n3) {
                n3 = atom.screenX;
            }
            if (atom.screenX > n9) {
                n9 = atom.screenX;
            }
            if (atom.screenY < n10) {
                n10 = atom.screenY;
            }
            if (atom.screenY > n2) {
                n2 = atom.screenY;
            }
            n = this.bsRenderableAtoms.nextSetBit(n + 1);
        }
        this.navigationCrossHairMinMax[0] = n3;
        this.navigationCrossHairMinMax[1] = n9;
        this.navigationCrossHairMinMax[2] = n10;
        this.navigationCrossHairMinMax[3] = n2;
        return this.navigationCrossHairMinMax;
    }

    public void setModelSet(ModelSet modelSet) {
        this.modelSet = this.viewer.modelSet = modelSet;
    }

    public void checkInheritedShapes() {
        if (this.shapes[24] == null) {
            return;
        }
        this.setShapePropertyBs(24, "remapInherited", null, null);
    }

    public void restrictSelected(boolean bl, boolean bl2) {
        BS bS = BSUtil.copy(this.viewer.getSelectionSet(true));
        if (bl2) {
            this.viewer.invertSelection();
            BS bS2 = this.viewer.getSelectionSubset();
            if (bS2 != null) {
                bS = BSUtil.copy(this.viewer.getSelectionSet(true));
                bS.and(bS2);
                this.viewer.select(bS, false, 0, true);
                BSUtil.invertInPlace(bS, this.viewer.getAtomCount());
                bS.and(bS2);
            }
        }
        BSUtil.andNot(bS, this.viewer.getDeletedAtoms());
        boolean bl3 = this.viewer.getBoolean(0x24000024);
        if (!bl) {
            this.viewer.setBooleanProperty("bondModeOr", true);
        }
        this.setShapeSizeBs(1, 0, null, null);
        this.setShapePropertyBs(1, "type", 32768, null);
        this.setShapeSizeBs(1, 0, null, null);
        this.setShapePropertyBs(1, "type", 1023, null);
        BS bS3 = this.viewer.getSelectionSet(false);
        int n = 21;
        while (--n >= 0) {
            if (n == 6 || this.getShape(n) == null) continue;
            this.setShapeSizeBs(n, 0, null, bS3);
        }
        if (this.getShape(21) != null) {
            this.setShapePropertyBs(21, "delete", bS3, null);
        }
        this.setLabel(null, bS3);
        if (!bl) {
            this.viewer.setBooleanProperty("bondModeOr", bl3);
        }
        this.viewer.select(bS, false, 0, true);
    }
}

