/*
 * Decompiled with CFR 0.152.
 */
package org.jmol.smiles;

import javajs.util.List;
import javajs.util.P3;
import javajs.util.T3;
import javajs.util.V3;
import org.jmol.java.BS;
import org.jmol.util.JmolEdge;
import org.jmol.util.JmolNode;

public class SmilesAromatic {
    public static final boolean isFlatSp2Ring(JmolNode[] jmolNodeArray, BS bS, BS bS2, float f) {
        V3 v3;
        JmolNode jmolNode;
        int n = bS2.nextSetBit(0);
        while (n >= 0) {
            jmolNode = jmolNodeArray[n];
            v3 = jmolNode.getEdges();
            if (((JmolEdge[])v3).length >= 3 && ((JmolEdge[])v3).length > 3) {
                return false;
            }
            n = bS2.nextSetBit(n + 1);
        }
        if (f == Float.MAX_VALUE) {
            return true;
        }
        if (f <= 0.0f) {
            f = 0.01f;
        }
        V3 v32 = new V3();
        jmolNode = new V3();
        v3 = new V3();
        V3 v33 = null;
        int n2 = bS2.cardinality();
        V3[] v3Array = new V3[n2 * 2];
        int n3 = 0;
        float f2 = 1.0f - f * 5.0f;
        int n4 = bS2.nextSetBit(0);
        while (n4 >= 0) {
            JmolNode jmolNode2 = jmolNodeArray[n4];
            JmolEdge[] jmolEdgeArray = jmolNode2.getEdges();
            int n5 = -1;
            int n6 = -1;
            int n7 = -1;
            int n8 = jmolEdgeArray.length;
            while (--n8 >= 0) {
                int n9 = jmolNode2.getBondedAtomIndex(n8);
                if (!bS.get(n9)) continue;
                if (!bS2.get(n9)) {
                    n5 = n9;
                    continue;
                }
                if (n6 < 0) {
                    n6 = n9;
                    continue;
                }
                n7 = n9;
            }
            SmilesAromatic.getNormalThroughPoints(jmolNodeArray[n6], jmolNodeArray[n4], jmolNodeArray[n7], v32, (V3)jmolNode, v3);
            if (v33 == null) {
                v33 = new V3();
            }
            if (!SmilesAromatic.addNormal(v32, v33, f2)) {
                return false;
            }
            v3Array[n3++] = V3.newV((T3)v32);
            if (n5 >= 0) {
                SmilesAromatic.getNormalThroughPoints(jmolNodeArray[n6], jmolNodeArray[n5], jmolNodeArray[n7], v32, (V3)jmolNode, v3);
                if (!SmilesAromatic.addNormal(v32, v33, f2)) {
                    return false;
                }
                v3Array[n3++] = V3.newV((T3)v32);
            }
            n4 = bS2.nextSetBit(n4 + 1);
        }
        n4 = SmilesAromatic.checkStandardDeviation(v3Array, v33, n3, f) ? 1 : 0;
        return n4 != 0;
    }

    private static final boolean addNormal(V3 v3, V3 v32, float f) {
        float f2 = v32.dot((T3)v3);
        if (f2 != 0.0f && Math.abs(f2) < f) {
            return false;
        }
        if (f2 < 0.0f) {
            v3.scale(-1.0f);
        }
        v32.add((T3)v3);
        v32.normalize();
        return true;
    }

    private static final boolean checkStandardDeviation(V3[] v3Array, V3 v3, int n, float f) {
        double d = 0.0;
        double d2 = 0.0;
        for (int i = 0; i < n; ++i) {
            float f2 = v3Array[i].dot((T3)v3);
            d += (double)f2;
            d2 += (double)f2 * (double)f2;
        }
        return (d = Math.sqrt((d2 - d * d / (double)n) / (double)(n - 1))) < (double)f;
    }

    static float getNormalThroughPoints(JmolNode jmolNode, JmolNode jmolNode2, JmolNode jmolNode3, V3 v3, V3 v32, V3 v33) {
        v32.sub2((T3)((P3)jmolNode2), (T3)((P3)jmolNode));
        v33.sub2((T3)((P3)jmolNode3), (T3)((P3)jmolNode));
        v3.cross(v32, v33);
        v3.normalize();
        v32.setT((T3)((P3)jmolNode));
        return -v32.dot((T3)v3);
    }

    static BS checkAromaticDefined(JmolNode[] jmolNodeArray, BS bS) {
        BS bS2 = new BS();
        int n = bS.nextSetBit(0);
        while (n >= 0) {
            JmolEdge[] jmolEdgeArray = jmolNodeArray[n].getEdges();
            for (int i = 0; i < jmolEdgeArray.length; ++i) {
                switch (jmolEdgeArray[i].order) {
                    case 513: 
                    case 514: 
                    case 515: {
                        bS2.set(jmolEdgeArray[i].getAtomIndex1());
                        bS2.set(jmolEdgeArray[i].getAtomIndex2());
                    }
                }
            }
            n = bS.nextSetBit(n + 1);
        }
        return bS2;
    }

    static void checkAromaticStrict(JmolNode[] jmolNodeArray, BS bS, List<Object> list, List<Object> list2) {
        BS bS2;
        BS bS3 = new BS();
        BS bS4 = new BS();
        int n = list.size();
        while (--n >= 0) {
            bS2 = (BS)list.get(n);
            if (!SmilesAromatic.isAromaticRing(bS, bS4, bS2, 5)) continue;
            SmilesAromatic.checkAromaticStrict2(jmolNodeArray, bS3, list, list2, bS2, true);
        }
        n = list2.size();
        while (--n >= 0) {
            bS2 = (BS)list2.get(n);
            if (!SmilesAromatic.isAromaticRing(bS, bS4, bS2, 6)) continue;
            SmilesAromatic.checkAromaticStrict2(jmolNodeArray, bS3, list, list2, bS2, false);
        }
        bS.clearAll();
        bS.or(bS3);
    }

    private static boolean isAromaticRing(BS bS, BS bS2, BS bS3, int n) {
        bS2.clearAll();
        bS2.or(bS3);
        bS2.and(bS);
        return bS2.cardinality() == n;
    }

    private static void checkAromaticStrict2(JmolNode[] jmolNodeArray, BS bS, List<Object> list, List<Object> list2, BS bS2, boolean bl) {
        int n = SmilesAromatic.countInternalPairs(jmolNodeArray, bS2, bl) << 1;
        switch (n) {
            case -3: {
                break;
            }
            default: {
                int n2 = bS2.nextSetBit(0);
                while (n2 >= 0) {
                    JmolEdge[] jmolEdgeArray = jmolNodeArray[n2].getEdges();
                    for (int i = 0; i < jmolEdgeArray.length; ++i) {
                        BS bS3;
                        int n3;
                        if (jmolEdgeArray[i].order != 2 || bS2.get(n3 = jmolEdgeArray[i].getOtherAtomNode(jmolNodeArray[n2]).getIndex())) continue;
                        boolean bl2 = false;
                        int n4 = list.size();
                        while (--n4 >= 0 && !bl2) {
                            bS3 = (BS)list.get(n4);
                            if (!bS3.get(n3) || !bS.get(n3) && Math.abs(SmilesAromatic.countInternalPairs(jmolNodeArray, bS3, true)) != 3) continue;
                            bl2 = true;
                        }
                        n4 = list2.size();
                        while (--n4 >= 0 && !bl2) {
                            bS3 = (BS)list2.get(n4);
                            if (!bS3.get(n3) || !bS.get(n3) && Math.abs(SmilesAromatic.countInternalPairs(jmolNodeArray, bS3, false)) != 3) continue;
                            bl2 = true;
                        }
                        if (!bl2) {
                            return;
                        }
                        ++n;
                    }
                    n2 = bS2.nextSetBit(n2 + 1);
                }
                break block0;
            }
        }
        if (n == 6) {
            bS.or(bS2);
        }
    }

    private static int countInternalPairs(JmolNode[] jmolNodeArray, BS bS, boolean bl) {
        int n = 0;
        int n2 = 0;
        int n3 = 0;
        int n4 = bS.nextSetBit(0);
        while (n4 >= 0) {
            JmolNode jmolNode = jmolNodeArray[n4];
            JmolEdge[] jmolEdgeArray = jmolNode.getEdges();
            boolean bl2 = false;
            block8: for (int i = 0; i < jmolEdgeArray.length; ++i) {
                int n5 = jmolEdgeArray[i].getOtherAtomNode(jmolNode).getIndex();
                if (!bS.get(n5)) continue;
                switch (jmolEdgeArray[i].order) {
                    case 513: 
                    case 514: 
                    case 515: {
                        ++n2;
                        continue block8;
                    }
                    case 2: {
                        ++n;
                        bl2 = true;
                    }
                }
            }
            if (bl && n2 == 0) {
                switch (jmolNode.getElementNumber()) {
                    case 7: 
                    case 8: 
                    case 16: {
                        if (bl2) break;
                        ++n3;
                    }
                }
            }
            n4 = bS.nextSetBit(n4 + 1);
        }
        return n2 == 0 ? n / 2 + n3 : (n2 == (bl ? 5 : 6) ? -3 : 0);
    }
}

