/*
 * Decompiled with CFR 0.152.
 */
package org.jmol.smiles;

import javajs.util.AU;
import javajs.util.List;
import javajs.util.PT;
import org.jmol.api.SmilesMatcherInterface;
import org.jmol.java.BS;
import org.jmol.smiles.InvalidSmilesException;
import org.jmol.smiles.SmilesGenerator;
import org.jmol.smiles.SmilesParser;
import org.jmol.smiles.SmilesSearch;
import org.jmol.util.BSUtil;
import org.jmol.util.JmolNode;

public class SmilesMatcher
implements SmilesMatcherInterface {
    private static final int MODE_BITSET = 1;
    private static final int MODE_ARRAY = 2;
    private static final int MODE_MAP = 3;

    public String getLastException() {
        return InvalidSmilesException.getLastError();
    }

    public String getMolecularFormula(String string, boolean bl) {
        InvalidSmilesException.setLastError(null);
        try {
            SmilesSearch smilesSearch = SmilesParser.getMolecule(string, bl);
            smilesSearch.createTopoMap(null);
            smilesSearch.nodes = smilesSearch.jmolAtoms;
            return smilesSearch.getMolecularFormula(!bl);
        }
        catch (InvalidSmilesException invalidSmilesException) {
            if (InvalidSmilesException.getLastError() == null) {
                InvalidSmilesException.setLastError(invalidSmilesException.toString());
            }
            return null;
        }
    }

    public String getSmiles(JmolNode[] jmolNodeArray, int n, BS bS, boolean bl, boolean bl2, boolean bl3, String string) {
        InvalidSmilesException.setLastError(null);
        try {
            if (bl) {
                return new SmilesGenerator().getBioSmiles(jmolNodeArray, n, bS, bl2, bl3, string);
            }
            return new SmilesGenerator().getSmiles(jmolNodeArray, n, bS);
        }
        catch (InvalidSmilesException invalidSmilesException) {
            if (InvalidSmilesException.getLastError() == null) {
                InvalidSmilesException.setLastError(invalidSmilesException.toString());
            }
            return null;
        }
    }

    public int areEqual(String string, String string2) {
        BS[] bSArray = this.find(string, string2, false, false);
        return bSArray == null ? -1 : bSArray.length;
    }

    public boolean areEqual(String string, SmilesSearch smilesSearch) {
        BS[] bSArray = this.find(string, smilesSearch, false, true, true);
        return bSArray != null && bSArray.length == 1;
    }

    public BS[] find(String string, String string2, boolean bl, boolean bl2) {
        InvalidSmilesException.setLastError(null);
        try {
            SmilesSearch smilesSearch = SmilesParser.getMolecule(string2, false);
            return this.find(string, smilesSearch, bl, !bl, bl2);
        }
        catch (Exception exception) {
            if (InvalidSmilesException.getLastError() == null) {
                InvalidSmilesException.setLastError(exception.toString());
            }
            System.out.println(exception.toString());
            return null;
        }
    }

    public String getRelationship(String string, String string2) {
        int n;
        boolean bl;
        String string3;
        if (string == null || string2 == null || string.length() == 0 || string2.length() == 0) {
            return "";
        }
        String string4 = this.getMolecularFormula(string, false);
        if (!string4.equals(string3 = this.getMolecularFormula(string2, false))) {
            return "none";
        }
        int n2 = this.countStereo(string);
        boolean bl2 = bl = n2 == (n = this.countStereo(string2)) && this.areEqual(string2, string) > 0;
        if (!bl) {
            String string5 = string + string2;
            if (string5.indexOf("/") >= 0 || string5.indexOf("\\") >= 0 || string5.indexOf("@") >= 0) {
                if (n2 == n && n2 > 0) {
                    boolean bl3 = bl = this.areEqual(string = this.reverseChirality(string), string2) > 0;
                    if (bl) {
                        return "enantiomers";
                    }
                }
                boolean bl4 = bl = this.areEqual("/nostereo/" + string2, string) > 0;
                if (bl) {
                    return n2 == n ? "diastereomers" : "ambiguous stereochemistry!";
                }
            }
            return "constitutional isomers";
        }
        return "identical";
    }

    public String reverseChirality(String string) {
        string = PT.simpleReplace((String)string, (String)"@@", (String)"!@");
        string = PT.simpleReplace((String)string, (String)"@", (String)"@@");
        string = PT.simpleReplace((String)string, (String)"!@@", (String)"@");
        string = PT.simpleReplace((String)string, (String)"@@SP", (String)"@SP");
        string = PT.simpleReplace((String)string, (String)"@@OH", (String)"@OH");
        string = PT.simpleReplace((String)string, (String)"@@TB", (String)"@TB");
        return string;
    }

    public BS getSubstructureSet(String string, JmolNode[] jmolNodeArray, int n, BS bS, boolean bl, boolean bl2) {
        return (BS)this.match(string, jmolNodeArray, n, bS, null, bl, false, bl2, 1);
    }

    public void getSubstructureSets(String[] stringArray, JmolNode[] jmolNodeArray, int n, int n2, BS bS, List<BS> list, List<BS>[] listArray) {
        InvalidSmilesException.setLastError(null);
        SmilesParser smilesParser = new SmilesParser(true);
        SmilesSearch smilesSearch = null;
        try {
            smilesSearch = smilesParser.parse("");
            smilesSearch.firstMatchOnly = false;
            smilesSearch.matchAllAtoms = false;
            smilesSearch.jmolAtoms = jmolNodeArray;
            smilesSearch.jmolAtomCount = Math.abs(n);
            smilesSearch.setSelected(bS);
            smilesSearch.getRingData(true, n2, listArray);
            smilesSearch.asVector = false;
            smilesSearch.subSearches = new SmilesSearch[1];
            smilesSearch.getSelections();
        }
        catch (InvalidSmilesException invalidSmilesException) {
            // empty catch block
        }
        BS bS2 = new BS();
        for (int i = 0; i < stringArray.length; ++i) {
            if (stringArray[i] == null || stringArray[i].length() == 0 || stringArray[i].startsWith("#")) {
                list.addLast(null);
                continue;
            }
            try {
                SmilesSearch smilesSearch2;
                smilesSearch.clear();
                smilesSearch.subSearches[0] = smilesSearch2 = smilesParser.getSearch(smilesSearch, SmilesParser.cleanPattern(stringArray[i]), n2);
                BS bS3 = BSUtil.copy((BS)((BS)smilesSearch.search(false)));
                list.addLast((Object)bS3);
                bS2.or(bS3);
                if (bS2.cardinality() != n) continue;
                return;
            }
            catch (Exception exception) {
                if (InvalidSmilesException.getLastError() == null) {
                    InvalidSmilesException.setLastError(exception.toString());
                }
                System.out.println(exception.toString());
            }
        }
    }

    public BS[] getSubstructureSetArray(String string, JmolNode[] jmolNodeArray, int n, BS bS, BS bS2, boolean bl, boolean bl2) {
        return (BS[])this.match(string, jmolNodeArray, n, bS, bS2, bl, false, bl2, 2);
    }

    public int[][] getCorrelationMaps(String string, JmolNode[] jmolNodeArray, int n, BS bS, boolean bl, boolean bl2) {
        return (int[][])this.match(string, jmolNodeArray, n, bS, null, bl, false, bl2, 3);
    }

    private BS[] find(String string, SmilesSearch smilesSearch, boolean bl, boolean bl2, boolean bl3) {
        BS bS = new BS();
        smilesSearch.createTopoMap(bS);
        return (BS[])this.match(string, smilesSearch.jmolAtoms, -smilesSearch.jmolAtoms.length, null, bS, bl, bl2, bl3, 2);
    }

    private Object match(String string, JmolNode[] jmolNodeArray, int n, BS bS, BS bS2, boolean bl, boolean bl2, boolean bl3, int n2) {
        InvalidSmilesException.setLastError(null);
        try {
            SmilesSearch smilesSearch = SmilesParser.getMolecule(string, bl);
            smilesSearch.jmolAtoms = jmolNodeArray;
            smilesSearch.jmolAtomCount = Math.abs(n);
            if (n < 0) {
                smilesSearch.isSmilesFind = true;
            }
            smilesSearch.setSelected(bS);
            smilesSearch.getSelections();
            smilesSearch.bsRequired = null;
            smilesSearch.setRingData(bS2);
            smilesSearch.firstMatchOnly = bl3;
            smilesSearch.matchAllAtoms = bl2;
            switch (n2) {
                case 1: {
                    smilesSearch.asVector = false;
                    return smilesSearch.search(false);
                }
                case 2: {
                    smilesSearch.asVector = true;
                    List list = (List)smilesSearch.search(false);
                    return list.toArray((Object[])new BS[list.size()]);
                }
                case 3: {
                    smilesSearch.getMaps = true;
                    List list = (List)smilesSearch.search(false);
                    return list.toArray((Object[])AU.newInt2((int)list.size()));
                }
            }
        }
        catch (Exception exception) {
            if (InvalidSmilesException.getLastError() == null) {
                InvalidSmilesException.setLastError(exception.toString());
            }
            System.out.println(exception.toString());
        }
        return null;
    }

    private int countStereo(String string) {
        string = PT.simpleReplace((String)string, (String)"@@", (String)"@");
        int n = string.lastIndexOf(64) + 1;
        int n2 = 0;
        while (--n >= 0) {
            if (string.charAt(n) != '@') continue;
            ++n2;
        }
        return n2;
    }
}

