/*
 * Decompiled with CFR 0.152.
 */
package org.jmol.modelsetbio;

import javajs.util.T3;
import org.jmol.constant.EnumStructure;
import org.jmol.modelset.Atom;
import org.jmol.modelset.Chain;
import org.jmol.modelsetbio.Monomer;

public class CarbohydrateMonomer
extends Monomer {
    static final byte[] alphaOffsets = new byte[]{0};

    private CarbohydrateMonomer() {
    }

    static Monomer validateAndAllocate(Chain chain, String string, int n, int n2, int n3) {
        return new CarbohydrateMonomer().set2(chain, string, n, n2, n3, alphaOffsets);
    }

    public boolean isCarbohydrate() {
        return true;
    }

    @Override
    public EnumStructure getProteinStructureType() {
        return EnumStructure.CARBOHYDRATE;
    }

    @Override
    boolean isConnectedAfter(Monomer monomer) {
        if (monomer == null) {
            return true;
        }
        for (int i = this.firstAtomIndex; i <= this.lastAtomIndex; ++i) {
            for (int j = monomer.firstAtomIndex; j <= monomer.lastAtomIndex; ++j) {
                Atom atom = this.chain.getAtom(i);
                Atom atom2 = this.chain.getAtom(j);
                if (atom.getElementNumber() + atom2.getElementNumber() != 14 || !((double)atom.distanceSquared((T3)atom2) < 3.24)) continue;
                return true;
            }
        }
        return false;
    }

    @Override
    void findNearestAtomIndex(int n, int n2, Atom[] atomArray, short s, short s2) {
        Atom atom = atomArray[0];
        Atom atom2 = this.getLeadAtom();
        int n3 = s / 2;
        if (n3 < 1200) {
            n3 = 1200;
        }
        if (atom2.screenZ == 0) {
            return;
        }
        int n4 = (int)this.scaleToScreen(atom2.screenZ, n3);
        if (n4 < 4) {
            n4 = 4;
        }
        if (this.isCursorOnTopOf(atom2, n, n2, n4, atom)) {
            atomArray[0] = atom2;
        }
    }

    @Override
    public boolean isConnectedPrevious() {
        if (this.monomerIndex <= 0) {
            return false;
        }
        for (int i = this.firstAtomIndex; i <= this.lastAtomIndex; ++i) {
            if (!this.getCrossLink(i, null)) continue;
            return true;
        }
        return false;
    }
}

