/*
 * Decompiled with CFR 0.152.
 */
package org.jmol.modelsetbio;

import javajs.util.List;
import javajs.util.OC;
import javajs.util.P3;
import javajs.util.P4;
import javajs.util.SB;
import javajs.util.T3;
import javajs.util.V3;
import org.jmol.java.BS;
import org.jmol.modelset.Atom;
import org.jmol.modelset.Bond;
import org.jmol.modelset.HBond;
import org.jmol.modelset.LabelToken;
import org.jmol.modelsetbio.BioPolymer;
import org.jmol.modelsetbio.Monomer;
import org.jmol.modelsetbio.NucleicMonomer;
import org.jmol.util.Measure;
import org.jmol.viewer.Viewer;

public class NucleicPolymer
extends BioPolymer {
    NucleicPolymer(Monomer[] monomerArray) {
        super(monomerArray);
        this.type = 2;
        this.hasWingPoints = true;
    }

    Atom getNucleicPhosphorusAtom(int n) {
        return this.monomers[n].getLeadAtom();
    }

    @Override
    protected boolean calcEtaThetaAngles() {
        float f = Float.NaN;
        for (int i = 0; i < this.monomerCount - 2; ++i) {
            NucleicMonomer nucleicMonomer = (NucleicMonomer)this.monomers[i];
            NucleicMonomer nucleicMonomer2 = (NucleicMonomer)this.monomers[i + 1];
            Atom atom = nucleicMonomer.getP();
            Atom atom2 = nucleicMonomer.getC4P();
            Atom atom3 = nucleicMonomer2.getP();
            Atom atom4 = nucleicMonomer2.getC4P();
            if (i > 0) {
                NucleicMonomer nucleicMonomer3 = (NucleicMonomer)this.monomers[i - 1];
                Atom atom5 = nucleicMonomer3.getC4P();
                f = Measure.computeTorsion((T3)atom5, (T3)atom, (T3)atom2, (T3)atom3, (boolean)true);
            }
            float f2 = Measure.computeTorsion((T3)atom, (T3)atom2, (T3)atom3, (T3)atom4, (boolean)true);
            if (f < 0.0f) {
                f += 360.0f;
            }
            if (f2 < 0.0f) {
                f2 += 360.0f;
            }
            nucleicMonomer.setGroupParameter(1112539141, f);
            nucleicMonomer.setGroupParameter(1112539152, f2);
        }
        return true;
    }

    @Override
    public void calcRasmolHydrogenBonds(BioPolymer bioPolymer, BS bS, BS bS2, List<Bond> list, int n, int[][][] nArray, boolean bl, boolean bl2) {
        NucleicPolymer nucleicPolymer = (NucleicPolymer)bioPolymer;
        V3 v3 = new V3();
        V3 v32 = new V3();
        V3 v33 = new V3();
        int n2 = this.monomerCount;
        while (--n2 >= 0) {
            NucleicMonomer nucleicMonomer = (NucleicMonomer)this.monomers[n2];
            if (!nucleicMonomer.isPurine()) continue;
            Atom atom = nucleicMonomer.getN3();
            boolean bl3 = bS.get(atom.index);
            if (!bl3 && !bS2.get(atom.index)) continue;
            Atom atom2 = nucleicMonomer.getN1();
            Atom atom3 = nucleicMonomer.getN0();
            P4 p4 = new P4();
            Measure.getPlaneThroughPoints((P3)atom, (P3)atom2, (P3)atom3, (V3)v3, (V3)v32, (V3)v33, (P4)p4);
            Atom atom4 = null;
            float f = 25.0f;
            NucleicMonomer nucleicMonomer2 = null;
            int n3 = nucleicPolymer.monomerCount;
            while (--n3 >= 0) {
                NucleicMonomer nucleicMonomer3 = (NucleicMonomer)nucleicPolymer.monomers[n3];
                if (!nucleicMonomer3.isPyrimidine()) continue;
                Atom atom5 = nucleicMonomer3.getN3();
                if (bl3 ? !bS2.get(atom5.index) : !bS.get(atom5.index)) continue;
                Atom atom6 = nucleicMonomer3.getN0();
                float f2 = atom2.distanceSquared((T3)atom5);
                if (!(f2 < f) || !(atom3.distanceSquared((T3)atom6) > 50.0f) || !(Math.abs(Measure.distanceToPlane((P4)p4, (P3)atom5)) < 1.0f)) continue;
                nucleicMonomer2 = nucleicMonomer3;
                atom4 = atom5;
                f = f2;
            }
            n3 = 0;
            if (atom4 == null || (n3 += NucleicPolymer.addHydrogenBond(list, atom2, atom4)) >= n) continue;
            if (nucleicMonomer.isGuanine()) {
                if ((n3 += NucleicPolymer.addHydrogenBond(list, nucleicMonomer.getN2(), nucleicMonomer2.getO2())) >= n || (n3 += NucleicPolymer.addHydrogenBond(list, nucleicMonomer.getO6(), nucleicMonomer2.getN4())) < n) continue;
                continue;
            }
            n3 += NucleicPolymer.addHydrogenBond(list, nucleicMonomer.getN6(), nucleicMonomer2.getO4());
        }
    }

    protected static int addHydrogenBond(List<Bond> list, Atom atom, Atom atom2) {
        if (atom == null || atom2 == null) {
            return 0;
        }
        list.addLast((Object)new HBond(atom, atom2, 18432, 1, 0, 0.0f));
        return 1;
    }

    @Override
    public void getPdbData(Viewer viewer, char c, char c2, int n, int n2, BS bS, BS bS2, boolean bl, boolean bl2, boolean bl3, LabelToken[] labelTokenArray, OC oC, SB sB, BS bS3) {
        NucleicPolymer.getPdbData(viewer, this, c, c2, n, n2, bS, bS2, bl, bl2, bl3, labelTokenArray, oC, sB, bS3);
    }
}

