/*
 * Decompiled with CFR 0.152.
 */
package org.jmol.render;

import javajs.util.A4;
import javajs.util.M3;
import javajs.util.P3;
import javajs.util.P3i;
import org.jmol.modelset.Measurement;
import org.jmol.modelset.MeasurementPending;
import org.jmol.render.LabelsRenderer;
import org.jmol.shape.Measures;
import org.jmol.util.Point3fi;

public class MeasuresRenderer
extends LabelsRenderer {
    private Measurement measurement;
    private boolean doJustify;
    private short mad0;
    private A4 aaT = new A4();
    private M3 matrixT = new M3();

    @Override
    protected boolean render() {
        if (!this.g3d.checkTranslucent(false)) {
            return false;
        }
        if (this.atomPt == null) {
            this.atomPt = new Point3fi();
        }
        Measures measures = (Measures)this.shape;
        this.doJustify = this.viewer.getBoolean(603979872);
        this.imageFontScaling = this.viewer.getImageFontScaling();
        this.mad0 = measures.mad;
        this.font3d = this.g3d.getFont3DScaled(measures.font3d, this.imageFontScaling);
        this.renderPendingMeasurement(measures.measurementPending);
        if (!this.viewer.getBoolean(603979926)) {
            return false;
        }
        boolean bl = this.viewer.getBoolean(603979879);
        boolean bl2 = this.viewer.getBoolean(603979835);
        measures.setVisibilityInfo();
        int n = measures.measurementCount;
        while (--n >= 0) {
            Measurement measurement = (Measurement)measures.measurements.get(n);
            if (bl2 || measurement.isDynamic) {
                measurement.refresh();
            }
            if (!measurement.isVisible || !measurement.isValid) continue;
            this.colix = measurement.colix;
            if (this.colix == 0) {
                this.colix = measures.colix;
            }
            if (this.colix == 0) {
                this.colix = this.viewer.getColixBackgroundContrast();
            }
            this.labelColix = measurement.labelColix;
            if (this.labelColix == 0) {
                this.labelColix = this.viewer.getColixBackgroundContrast();
            } else if (this.labelColix == -1) {
                this.labelColix = this.colix;
            }
            this.g3d.setColix(this.colix);
            this.colixA = this.colixB = this.colix;
            this.renderMeasurement(measurement.getCount(), measurement, bl);
        }
        return false;
    }

    private Point3fi getAtom(int n) {
        Point3fi point3fi = this.measurement.getAtom(n);
        if (point3fi.screenDiameter < 0) {
            this.viewer.transformPtScr(point3fi, this.pt0i);
            point3fi.screenX = this.pt0i.x;
            point3fi.screenY = this.pt0i.y;
            point3fi.screenZ = this.pt0i.z;
        }
        return point3fi;
    }

    private void renderMeasurement(int n, Measurement measurement, boolean bl) {
        String string;
        this.measurement = measurement;
        String string2 = string = bl ? measurement.getString() : null;
        if (string != null && string.length() == 0) {
            string = null;
        }
        if (string != null && measurement.text != null) {
            measurement.text.setText(string);
            measurement.text.setColix(this.labelColix);
        }
        if (measurement.mad == 0) {
            this.dotsOrDashes = false;
            this.mad = this.mad0;
        } else {
            this.mad = (short)measurement.mad;
            this.dotsOrDashes = true;
            this.dashDots = this.mad < 0 ? null : ndots;
        }
        switch (n) {
            case 1: {
                if (measurement.traceX == Integer.MIN_VALUE) break;
                this.atomA = this.getAtom(1);
                this.drawLine(this.atomA.screenX, this.atomA.screenY, this.atomA.screenZ, measurement.traceX, measurement.traceY, this.atomA.screenZ, this.mad);
                break;
            }
            case 2: {
                this.atomA = this.getAtom(1);
                this.atomB = this.getAtom(2);
                this.renderDistance(string);
                break;
            }
            case 3: {
                this.atomA = this.getAtom(1);
                this.atomB = this.getAtom(2);
                this.atomC = this.getAtom(3);
                this.renderAngle(string);
                break;
            }
            case 4: {
                this.atomA = this.getAtom(1);
                this.atomB = this.getAtom(2);
                this.atomC = this.getAtom(3);
                this.atomD = this.getAtom(4);
                this.renderTorsion(string);
            }
        }
        this.atomD = null;
        this.atomC = null;
        this.atomB = null;
        this.atomA = null;
    }

    void renderDistance(String string) {
        int n;
        this.tickInfo = this.measurement.tickInfo;
        if (this.tickInfo != null) {
            this.drawLine(this.atomA.screenX, this.atomA.screenY, this.atomA.screenZ, this.atomB.screenX, this.atomB.screenY, this.atomB.screenZ, this.mad);
            this.drawTicks(this.atomA, this.atomB, this.mad, string != null);
            return;
        }
        int n2 = this.atomA.screenZ - this.atomA.screenDiameter - 10;
        int n3 = this.atomB.screenZ - this.atomB.screenDiameter - 10;
        int n4 = this.drawLine(this.atomA.screenX, this.atomA.screenY, n2, this.atomB.screenX, this.atomB.screenY, n3, this.mad);
        if (string == null) {
            return;
        }
        if (this.mad > 0) {
            n4 <<= 1;
        }
        if ((n = (n2 + n3) / 2) < 1) {
            n = 1;
        }
        int n5 = (this.atomA.screenX + this.atomB.screenX) / 2;
        int n6 = (this.atomA.screenY + this.atomB.screenY) / 2;
        if (this.measurement.text == null) {
            this.g3d.setColix(this.labelColix);
            this.drawString(n5, n6, n, n4, this.doJustify && (n5 - this.atomA.screenX) * (n6 - this.atomA.screenY) > 0, false, false, this.doJustify ? 0 : Integer.MAX_VALUE, string);
        } else {
            this.atomPt.add2(this.atomA, this.atomB);
            this.atomPt.scale(0.5f);
            this.atomPt.screenX = (this.atomA.screenX + this.atomB.screenX) / 2;
            this.atomPt.screenY = (this.atomA.screenY + this.atomB.screenY) / 2;
            this.renderLabelOrMeasure(this.measurement.text, string);
        }
    }

    private void renderAngle(String string) {
        int n = this.atomB.screenDiameter + 10;
        int n2 = this.atomA.screenZ - this.atomA.screenDiameter - 10;
        int n3 = this.atomB.screenZ - n;
        int n4 = this.atomC.screenZ - this.atomC.screenDiameter - 10;
        int n5 = this.drawLine(this.atomA.screenX, this.atomA.screenY, n2, this.atomB.screenX, this.atomB.screenY, n3, this.mad);
        n5 += this.drawLine(this.atomB.screenX, this.atomB.screenY, n3, this.atomC.screenX, this.atomC.screenY, n4, this.mad);
        if (string == null) {
            return;
        }
        n5 = (n5 + 1) / 2;
        A4 a4 = this.measurement.getAxisAngle();
        if (a4 == null) {
            if (this.measurement.text == null) {
                int n6 = (int)Math.floor(5.0f * this.imageFontScaling);
                this.g3d.setColix(this.labelColix);
                this.drawString(this.atomB.screenX + n6, this.atomB.screenY - n6, n3, n5, false, false, false, this.doJustify ? 0 : Integer.MAX_VALUE, string);
            } else {
                this.atomPt.setT(this.atomB);
                this.renderLabelOrMeasure(this.measurement.text, string);
            }
            return;
        }
        int n7 = (int)Math.floor((double)a4.angle / (Math.PI * 2) * 64.0);
        float f = a4.angle / (float)n7;
        this.aaT.setAA(a4);
        int n8 = n7 / 2;
        P3 p3 = this.measurement.getPointArc();
        int n9 = n7;
        while (--n9 >= 0) {
            this.aaT.angle = (float)n9 * f;
            this.matrixT.setAA(this.aaT);
            this.pointT.setT(p3);
            this.matrixT.transform(this.pointT);
            this.pointT.add(this.atomB);
            P3i p3i = this.viewer.transformPt(this.pointT);
            int n10 = p3i.z - n;
            if (n10 < 0) {
                n10 = 0;
            }
            this.g3d.drawPixel(p3i.x, p3i.y, n10);
            if (n9 != n8) continue;
            this.pointT.setT(p3);
            this.pointT.scale(1.1f);
            this.matrixT.transform(this.pointT);
            this.pointT.add(this.atomB);
            this.viewer.transformPt(this.pointT);
            int n11 = p3i.z - n;
            if (this.measurement.text == null) {
                this.g3d.setColix(this.labelColix);
                this.drawString(p3i.x, p3i.y, n11, n5, p3i.x < this.atomB.screenX, false, false, this.doJustify ? this.atomB.screenY : Integer.MAX_VALUE, string);
                continue;
            }
            this.atomPt.setT(this.pointT);
            this.renderLabelOrMeasure(this.measurement.text, string);
        }
    }

    private void renderTorsion(String string) {
        int n = this.atomA.screenZ - this.atomA.screenDiameter - 10;
        int n2 = this.atomB.screenZ - this.atomB.screenDiameter - 10;
        int n3 = this.atomC.screenZ - this.atomC.screenDiameter - 10;
        int n4 = this.atomD.screenZ - this.atomD.screenDiameter - 10;
        int n5 = this.drawLine(this.atomA.screenX, this.atomA.screenY, n, this.atomB.screenX, this.atomB.screenY, n2, this.mad);
        n5 += this.drawLine(this.atomB.screenX, this.atomB.screenY, n2, this.atomC.screenX, this.atomC.screenY, n3, this.mad);
        n5 += this.drawLine(this.atomC.screenX, this.atomC.screenY, n3, this.atomD.screenX, this.atomD.screenY, n4, this.mad);
        if (string == null) {
            return;
        }
        n5 /= 3;
        if (this.measurement.text == null) {
            this.g3d.setColix(this.labelColix);
            this.drawString((this.atomA.screenX + this.atomB.screenX + this.atomC.screenX + this.atomD.screenX) / 4, (this.atomA.screenY + this.atomB.screenY + this.atomC.screenY + this.atomD.screenY) / 4, (n + n2 + n3 + n4) / 4, n5, false, false, false, this.doJustify ? 0 : Integer.MAX_VALUE, string);
        } else {
            this.atomPt.add2(this.atomA, this.atomB);
            this.atomPt.add(this.atomC);
            this.atomPt.add(this.atomD);
            this.atomPt.scale(0.25f);
            this.renderLabelOrMeasure(this.measurement.text, string);
        }
    }

    private void renderPendingMeasurement(MeasurementPending measurementPending) {
        if (this.isExport || measurementPending == null) {
            return;
        }
        int n = measurementPending.getCount();
        if (n == 0) {
            return;
        }
        short s = measurementPending.traceX == Integer.MIN_VALUE ? this.viewer.getColixRubberband() : (n == 2 ? (short)20 : 23);
        this.labelColix = s;
        this.g3d.setColix(s);
        measurementPending.refresh();
        if (measurementPending.haveTarget()) {
            this.renderMeasurement(n, measurementPending, measurementPending.traceX == Integer.MIN_VALUE);
        } else {
            this.renderPendingWithCursor(n, measurementPending);
        }
    }

    private void renderPendingWithCursor(int n, MeasurementPending measurementPending) {
        if (n > 1) {
            this.renderMeasurement(n, measurementPending, false);
        }
        this.measurement = measurementPending;
        Point3fi point3fi = this.getAtom(n);
        int n2 = point3fi.screenZ - point3fi.screenDiameter - 10;
        int n3 = this.viewer.getCursorX();
        int n4 = this.viewer.getCursorY();
        if (this.g3d.isAntialiased()) {
            n3 <<= 1;
            n4 <<= 1;
        }
        this.drawLine(point3fi.screenX, point3fi.screenY, n2, n3, n4, 0, this.mad);
    }

    @Override
    protected int drawLine(int n, int n2, int n3, int n4, int n5, int n6, int n7) {
        int n8 = (int)(n7 >= 20 && this.exportType != 1 ? this.viewer.scaleToScreen((n3 + n6) / 2, n7) : (float)n7);
        if (this.dotsOrDashes && (this.dashDots == null || this.dashDots == ndots)) {
            this.width = n8;
        }
        return this.drawLine2(n, n2, n3, n4, n5, n6, n8);
    }
}

