/*
 * Decompiled with CFR 0.152.
 */
package org.jmol.adapter.readers.quantum;

import java.util.Hashtable;
import java.util.Map;
import javajs.util.AU;
import javajs.util.List;
import org.jmol.adapter.readers.quantum.MopacSlaterReader;
import org.jmol.adapter.smarter.Atom;
import org.jmol.adapter.smarter.AtomSetCollectionReader;

public class MopacGraphfReader
extends MopacSlaterReader {
    private int atomCount;
    private int nCoefficients;
    private float[][] invMatrix;
    private boolean isNewFormat;
    private List<float[]> orbitalData;
    private List<String> orbitalInfo;

    protected void initializeReader() {
        this.alphaBeta = "alpha";
    }

    protected boolean checkLine() throws Exception {
        this.readAtoms();
        if (this.doReadMolecularOrbitals) {
            this.readSlaterBasis();
            this.readMolecularOrbitals(false);
            if (this.readKeywords()) {
                this.readMolecularOrbitals(true);
            }
        }
        this.continuing = false;
        return false;
    }

    private void readAtoms() throws Exception {
        this.atomSetCollection.newAtomSet();
        this.atomCount = this.parseIntStr(this.line);
        this.atomicNumbers = new int[this.atomCount];
        for (int i = 0; i < this.atomCount; ++i) {
            this.readLine();
            this.atomicNumbers[i] = this.parseIntRange(this.line, 0, 4);
            Atom atom = this.atomSetCollection.addNewAtom();
            this.setAtomCoordXYZ(atom, this.parseFloatRange(this.line, 4, 17), this.parseFloatRange(this.line, 17, 29), this.parseFloatRange(this.line, 29, 41));
            if (this.line.length() > 41) {
                atom.partialCharge = this.parseFloatStr(this.line.substring(41));
            }
            atom.elementSymbol = AtomSetCollectionReader.getElementSymbol((int)this.atomicNumbers[i]);
        }
    }

    private void readSlaterBasis() throws Exception {
        this.nCoefficients = 0;
        float[] fArray = new float[3];
        for (int i = 0; i < this.atomCount; ++i) {
            MopacGraphfReader.getTokensFloat((String)this.readLine(), (float[])fArray, (int)3);
            int n = this.atomicNumbers[i];
            float f = fArray[0];
            if (f != 0.0f) {
                this.createSphericalSlaterByType(i, n, "S", f, 1.0f);
            }
            if ((f = fArray[1]) != 0.0f) {
                this.createSphericalSlaterByType(i, n, "Px", f, 1.0f);
                this.createSphericalSlaterByType(i, n, "Py", f, 1.0f);
                this.createSphericalSlaterByType(i, n, "Pz", f, 1.0f);
            }
            if ((f = fArray[2]) == 0.0f) continue;
            this.createSphericalSlaterByType(i, n, "Dx2-y2", f, 1.0f);
            this.createSphericalSlaterByType(i, n, "Dxz", f, 1.0f);
            this.createSphericalSlaterByType(i, n, "Dz2", f, 1.0f);
            this.createSphericalSlaterByType(i, n, "Dyz", f, 1.0f);
            this.createSphericalSlaterByType(i, n, "Dxy", f, 1.0f);
        }
        this.nCoefficients = this.slaters.size();
        this.setSlaters(true, false);
    }

    private void readMolecularOrbitals(boolean bl) throws Exception {
        int n;
        int n2;
        if (bl) {
            this.alphaBeta = "beta";
        }
        float[][] fArray = null;
        if (this.readLine() == null) {
            return;
        }
        boolean bl2 = this.isNewFormat = this.line.indexOf("ORBITAL") >= 0;
        if (this.isNewFormat) {
            this.orbitalData = new List();
            if (this.line.length() > 10) {
                this.orbitalInfo = new List();
            }
        } else {
            fArray = new float[this.nCoefficients][this.nCoefficients];
        }
        for (n2 = 0; n2 < this.nCoefficients; ++n2) {
            float[] fArray2;
            if (n2 != 0) {
                this.readLine();
            }
            if (this.isNewFormat) {
                if (this.line == null || this.line.indexOf("ORBITAL") < 0 || this.line.indexOf("ORBITAL_LIST") >= 0) break;
                fArray2 = new float[this.nCoefficients];
                this.orbitalData.addLast((Object)fArray2);
                if (this.orbitalInfo != null) {
                    this.orbitalInfo.addLast((Object)this.line);
                }
                this.readLine();
            } else {
                fArray2 = fArray[n2];
            }
            this.fillFloatArray(this.line, 15, fArray2);
        }
        if (this.invMatrix == null) {
            if (this.isNewFormat && this.line.indexOf("MATRIX") < 0) {
                this.readLine();
            }
            this.invMatrix = AU.newFloat2((int)this.nCoefficients);
            for (n2 = 0; n2 < this.nCoefficients; ++n2) {
                this.invMatrix[n2] = new float[n2 + 1];
                this.fillFloatArray(null, 15, this.invMatrix[n2]);
            }
        }
        int n3 = this.nOrbitals = this.orbitalData == null ? this.nCoefficients : this.orbitalData.size();
        if (this.orbitalData != null) {
            fArray = AU.newFloat2((int)this.nOrbitals);
            n2 = this.nOrbitals;
            while (--n2 >= 0) {
                fArray[n2] = (float[])this.orbitalData.get(n2);
            }
        }
        float[][] fArray3 = new float[this.nOrbitals][this.nCoefficients];
        for (int i = 0; i < this.nOrbitals; ++i) {
            for (n = 0; n < this.nCoefficients; ++n) {
                for (int j = 0; j < this.nCoefficients; ++j) {
                    float[] fArray4 = fArray3[i];
                    int n4 = n;
                    fArray4[n4] = fArray4[n4] + fArray[i][j] * (j >= n ? this.invMatrix[j][n] : this.invMatrix[n][j]);
                }
                if (!(Math.abs(fArray3[i][n]) < 1.0E-4f)) continue;
                fArray3[i][n] = 0.0f;
            }
        }
        if (this.isNewFormat && this.orbitalInfo == null && this.line != null && this.line.indexOf("ORBITAL_LIST") < 0) {
            this.readLine();
        }
        float[] fArray5 = new float[2];
        for (n = 0; n < this.nOrbitals; ++n) {
            Hashtable<String, Object> hashtable = new Hashtable<String, Object>();
            if (this.orbitalInfo != null) {
                this.line = (String)this.orbitalInfo.get(n);
                String[] stringArray = this.getTokens();
                hashtable.put("energy", Float.valueOf(this.parseFloatStr(stringArray[3])));
                hashtable.put("occupancy", Float.valueOf(this.parseFloatStr(stringArray[1])));
            } else if (this.readLine() != null) {
                MopacGraphfReader.getTokensFloat((String)this.line, (float[])fArray5, (int)2);
                hashtable.put("energy", Float.valueOf(fArray5[0]));
                hashtable.put("occupancy", Float.valueOf(fArray5[1]));
            }
            hashtable.put("coefficients", fArray3[n]);
            if (bl) {
                hashtable.put("type", "beta");
            }
            this.line = "\n";
            if (!this.filterMO()) continue;
            this.setMO(hashtable);
        }
        this.setMOs("eV");
    }

    private boolean readKeywords() throws Exception {
        boolean bl;
        if (this.readLine() == null || this.line.indexOf(" Keywords:") < 0) {
            return false;
        }
        this.calculationType = this.line.substring(11).trim();
        this.moData.put("calculationType", this.calculationType);
        boolean bl2 = bl = this.line.indexOf("UHF") >= 0;
        if (bl) {
            int n = this.orbitals.size();
            while (--n >= 0) {
                ((Map)this.orbitals.get(n)).put("type", "alpha");
            }
        }
        return bl;
    }
}

