/*
 * Decompiled with CFR 0.152.
 */
package jspecview.common;

import java.io.BufferedInputStream;
import java.io.BufferedReader;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.StringReader;
import java.io.UnsupportedEncodingException;
import java.net.MalformedURLException;
import java.net.URL;
import java.util.Hashtable;
import java.util.Map;
import javajs.util.AU;
import javajs.util.Encoding;
import javajs.util.OC;
import javajs.util.PT;
import javajs.util.SB;
import jspecview.api.JSVZipInterface;
import jspecview.common.JSVersion;
import jspecview.common.JSViewer;
import jspecview.util.JSVEscape;
import org.jmol.util.Logger;

public class JSVFileManager {
    public static final String SIMULATION_PROTOCOL = "http://SIMULATION/";
    public static URL appletDocumentBase;
    private static JSViewer viewer;
    public static String jsDocumentBase;
    private static final String[] urlPrefixes;
    public static final int URL_LOCAL = 4;
    private static String nciResolver;
    private static String nmrdbServer;
    private static Map<String, String> htSimulate;
    private static int stringCount;

    public boolean isApplet() {
        return appletDocumentBase != null;
    }

    public static String getFileAsString(String string) {
        if (string == null) {
            return null;
        }
        SB sB = new SB();
        try {
            String string2;
            BufferedReader bufferedReader = JSVFileManager.getBufferedReaderFromName(string, null);
            while ((string2 = bufferedReader.readLine()) != null) {
                sB.append(string2);
                sB.appendC('\n');
            }
            bufferedReader.close();
        }
        catch (Exception exception) {
            return null;
        }
        return sB.toString();
    }

    public static BufferedReader getBufferedReaderForInputStream(InputStream inputStream) {
        try {
            return new BufferedReader(new InputStreamReader(inputStream, "UTF-8"));
        }
        catch (UnsupportedEncodingException unsupportedEncodingException) {
            return null;
        }
    }

    public static BufferedReader getBufferedReaderForString(String string) {
        return string == null ? null : new BufferedReader(new StringReader(string));
    }

    public static BufferedReader getBufferedReaderFromName(String string, String string2) throws MalformedURLException, IOException {
        if (string == null) {
            throw new IOException("Cannot find " + string);
        }
        Logger.info("JSVFileManager getBufferedReaderFromName " + string);
        String string3 = JSVFileManager.getFullPathName(string);
        Logger.info("JSVFileManager getBufferedReaderFromName " + string3);
        return JSVFileManager.getUnzippedBufferedReaderFromName(string3, string2);
    }

    public static String getFullPathName(String string) throws MalformedURLException {
        if (appletDocumentBase == null) {
            if (JSVFileManager.isURL(string)) {
                URL uRL = new URL((URL)null, string, null);
                return uRL.toString();
            }
            return JSVFileManager.viewer.apiPlatform.newFile(string).getFullPath();
        }
        if (string.indexOf(":\\") == 1 || string.indexOf(":/") == 1) {
            string = "file:///" + string;
        }
        URL uRL = new URL(appletDocumentBase, string, null);
        return uRL.toString();
    }

    public static boolean isURL(String string) {
        int n = urlPrefixes.length;
        while (--n >= 0) {
            if (!string.startsWith(urlPrefixes[n])) continue;
            return true;
        }
        return false;
    }

    public static int urlTypeIndex(String string) {
        for (int i = 0; i < urlPrefixes.length; ++i) {
            if (!string.startsWith(urlPrefixes[i])) continue;
            return i;
        }
        return -1;
    }

    public static boolean isLocal(String string) {
        if (string == null) {
            return false;
        }
        int n = JSVFileManager.urlTypeIndex(string);
        return n < 0 || n == 4;
    }

    private static BufferedReader getUnzippedBufferedReaderFromName(String string, String string2) throws IOException {
        String[] stringArray = null;
        if (string.indexOf("|") >= 0 && (stringArray = PT.split(string, "|")) != null && stringArray.length > 0) {
            string = stringArray[0];
        }
        if (string.startsWith(SIMULATION_PROTOCOL)) {
            return JSVFileManager.getBufferedReaderForString(JSVFileManager.getSimulationJCampDX(string.substring(SIMULATION_PROTOCOL.length())));
        }
        if (JSVFileManager.viewer.isApplet) {
            Object object = JSVFileManager.viewer.apiPlatform.getBufferedURLInputStream(new URL((URL)null, string, null), null, null);
            if (object instanceof SB || object instanceof String) {
                return new BufferedReader(new StringReader(object.toString()));
            }
            if (JSVFileManager.isAB(object)) {
                return new BufferedReader(new StringReader(new String((byte[])object)));
            }
            return new BufferedReader(new InputStreamReader((InputStream)object, "UTF-8"));
        }
        InputStream inputStream = JSVFileManager.getInputStream(string, true, null);
        BufferedInputStream bufferedInputStream = new BufferedInputStream(inputStream);
        inputStream = bufferedInputStream;
        if (JSVFileManager.isZipFile(bufferedInputStream)) {
            return ((JSVZipInterface)JSViewer.getInterface("jspecview.util.JSVZipUtil")).newJSVZipFileSequentialReader(inputStream, stringArray, string2);
        }
        if (JSVFileManager.isGzip(bufferedInputStream)) {
            inputStream = ((JSVZipInterface)JSViewer.getInterface("jspecview.util.JSVZipUtil")).newGZIPInputStream(inputStream);
        }
        return new BufferedReader(new InputStreamReader(inputStream, "UTF-8"));
    }

    public static boolean isAB(Object object) {
        return object instanceof byte[];
    }

    public static boolean isZipFile(InputStream inputStream) throws IOException {
        byte[] byArray = new byte[4];
        inputStream.mark(5);
        int n = inputStream.read(byArray, 0, 4);
        inputStream.reset();
        return n == 4 && byArray[0] == 80 && byArray[1] == 75 && byArray[2] == 3 && byArray[3] == 4;
    }

    private static boolean isGzip(InputStream inputStream) throws IOException {
        byte[] byArray = new byte[4];
        inputStream.mark(5);
        int n = inputStream.read(byArray, 0, 4);
        inputStream.reset();
        return n == 4 && byArray[0] == 31 && byArray[1] == -117;
    }

    public static Object getStreamAsBytes(BufferedInputStream bufferedInputStream, OC oC) throws IOException {
        byte[] byArray = new byte[1024];
        byte[] byArray2 = oC == null ? new byte[4096] : null;
        int n = 0;
        int n2 = 0;
        while ((n = bufferedInputStream.read(byArray, 0, 1024)) > 0) {
            n2 += n;
            if (oC == null) {
                if (n2 >= byArray2.length) {
                    byArray2 = AU.ensureLengthByte(byArray2, n2 * 2);
                }
                System.arraycopy(byArray, 0, byArray2, n2 - n, n);
                continue;
            }
            oC.write(byArray, 0, n);
        }
        bufferedInputStream.close();
        if (oC == null) {
            return AU.arrayCopyByte(byArray2, n2);
        }
        return n2 + " bytes";
    }

    public static String postByteArray(String string, byte[] byArray) {
        Object object = null;
        try {
            object = JSVFileManager.getInputStream(string, false, byArray);
        }
        catch (Exception exception) {
            return exception.toString();
        }
        if (object instanceof String) {
            return (String)object;
        }
        try {
            object = JSVFileManager.getStreamAsBytes((BufferedInputStream)object, null);
        }
        catch (IOException iOException) {
            try {
                ((BufferedInputStream)object).close();
            }
            catch (IOException iOException2) {
                // empty catch block
            }
        }
        return object == null ? "" : JSVFileManager.fixUTF((byte[])object);
    }

    private static Encoding getUTFEncoding(byte[] byArray) {
        if (byArray.length >= 3 && byArray[0] == -17 && byArray[1] == -69 && byArray[2] == -65) {
            return Encoding.UTF8;
        }
        if (byArray.length >= 4 && byArray[0] == 0 && byArray[1] == 0 && byArray[2] == -2 && byArray[3] == -1) {
            return Encoding.UTF_32BE;
        }
        if (byArray.length >= 4 && byArray[0] == -1 && byArray[1] == -2 && byArray[2] == 0 && byArray[3] == 0) {
            return Encoding.UTF_32LE;
        }
        if (byArray.length >= 2 && byArray[0] == -1 && byArray[1] == -2) {
            return Encoding.UTF_16LE;
        }
        if (byArray.length >= 2 && byArray[0] == -2 && byArray[1] == -1) {
            return Encoding.UTF_16BE;
        }
        return Encoding.NONE;
    }

    public static String fixUTF(byte[] byArray) {
        Encoding encoding = JSVFileManager.getUTFEncoding(byArray);
        if (encoding != Encoding.NONE) {
            try {
                String string = new String(byArray, encoding.name().replace('_', '-'));
                switch (encoding) {
                    case UTF8: 
                    case UTF_16BE: 
                    case UTF_16LE: {
                        string = string.substring(1);
                        break;
                    }
                }
                return string;
            }
            catch (UnsupportedEncodingException unsupportedEncodingException) {
                System.out.println(unsupportedEncodingException);
            }
        }
        return new String(byArray);
    }

    public static InputStream getInputStream(String string, boolean bl, byte[] byArray) throws IOException, MalformedURLException {
        int n;
        boolean bl2 = JSVFileManager.isURL(string);
        boolean bl3 = appletDocumentBase != null;
        Object object = null;
        String string2 = null;
        if (bl2 && (n = string.indexOf("?POST?")) >= 0) {
            string2 = string.substring(n + 6);
            string = string.substring(0, n);
        }
        if (bl3 || bl2) {
            URL uRL = new URL(appletDocumentBase, string, null);
            Logger.info("JSVFileManager opening URL " + uRL + (string2 == null ? "" : " with POST of " + string2.length() + " bytes"));
            object = JSVFileManager.viewer.apiPlatform.getBufferedURLInputStream(uRL, byArray, string2);
            if (object instanceof String) {
                Logger.info("JSVFileManager could not get this URL:" + object);
                return null;
            }
        } else {
            if (bl) {
                Logger.info("JSVFileManager opening file " + string);
            }
            object = JSVFileManager.viewer.apiPlatform.getBufferedFileInputStream(string);
        }
        return (InputStream)object;
    }

    private static String getSimulationJCampDX(String string) {
        String string2;
        String string3;
        if (htSimulate == null) {
            htSimulate = new Hashtable<String, String>();
        }
        if ((string3 = htSimulate.get(string2 = "" + string.substring(string.indexOf("V2000") + 1).hashCode())) == null) {
            System.out.println("creating " + string);
            boolean bl = string.startsWith("MOL=");
            String string4 = bl ? PT.simpleReplace(string.substring(4), "\\n", "\n") : PT.simpleReplace(nciResolver, "%FILE", PT.escapeUrl(string.substring(1)));
            Logger.info("JSVFileManager using \n" + string4);
            string4 = JSVFileManager.getFileAsString(string4);
            if (string4 == null) {
                Logger.info("no data returned");
            }
            int n = string4.indexOf("\n");
            string4 = "/JSpecView " + JSVersion.VERSION + string4.substring(n);
            string4 = PT.simpleReplace(string4, "?", "_");
            String string5 = JSVFileManager.getFileAsString(nmrdbServer + string4);
            System.out.println(string5);
            string5 = PT.simpleReplace(string5, "\\r\\n", "\n");
            string5 = PT.simpleReplace(string5, "\\t", "\t");
            string5 = PT.simpleReplace(string5, "\\n", "\n");
            string4 = JSVFileManager.getQuotedJSONAttribute(string5, "molfile", null);
            String string6 = JSVFileManager.getQuotedJSONAttribute(string5, "xml", null);
            string6 = PT.simpleReplace(string6, "</", "\n</");
            string6 = PT.simpleReplace(string6, "><", ">\n<");
            string6 = PT.simpleReplace(string6, "\\\"", "\"");
            string3 = JSVFileManager.getQuotedJSONAttribute(string5, "jcamp", null);
            string3 = "##TITLE=" + (bl ? "JMOL SIMULATION" : string) + "\n" + string3.substring(string3.indexOf("\n##") + 1);
            Logger.info(string3.substring(0, string3.indexOf("##XYDATA") + 40) + "...");
            n = 0;
            n = string3.indexOf("##.");
            String string7 = string;
            int n2 = string7.indexOf("id='");
            if (bl && n2 > 0) {
                string7 = string7.substring(n2 + 4, (string7 + "'").indexOf("'", n2 + 4));
            }
            string3 = string3.substring(0, n) + "##$MODELS=\n<Models>\n" + "<ModelData id=" + JSVEscape.eS(string7) + "\n type=\"MOL\">\n" + string4 + "</ModelData>\n</Models>\n" + "##$SIGNALS=\n" + string6 + "\n" + string3.substring(n);
            htSimulate.put(string2, string3);
        }
        return string3;
    }

    private static URL getResource(Object object, String string, String[] stringArray) {
        URL uRL = null;
        try {
            uRL = object.getClass().getResource(string);
            if (uRL == null) {
                stringArray[0] = "Couldn't find file: " + string;
            }
        }
        catch (Exception exception) {
            stringArray[0] = "Exception " + exception.getMessage() + " in getResource " + string;
        }
        return uRL;
    }

    public static String getResourceString(Object object, String string, String[] stringArray) {
        URL uRL = JSVFileManager.getResource(object, string, stringArray);
        if (uRL == null) {
            stringArray[0] = "Error loading resource " + string;
            return null;
        }
        if (uRL instanceof String) {
            return JSVFileManager.getFileAsString((String)((Object)uRL));
        }
        SB sB = new SB();
        try {
            String string2;
            BufferedReader bufferedReader = new BufferedReader(new InputStreamReader((InputStream)uRL.getContent(), "UTF-8"));
            while ((string2 = bufferedReader.readLine()) != null) {
                sB.append(string2).append("\n");
            }
            bufferedReader.close();
        }
        catch (Exception exception) {
            stringArray[0] = exception.getMessage();
        }
        return sB.toString();
    }

    public static String getJmolFilePath(String string) {
        try {
            string = JSVFileManager.getFullPathName(string);
        }
        catch (MalformedURLException malformedURLException) {
            return null;
        }
        return appletDocumentBase == null ? string.replace('\\', '/') : string;
    }

    public static String getName(String string) {
        if (string == null) {
            return "String" + ++stringCount;
        }
        if (JSVFileManager.isURL(string)) {
            try {
                if (string.startsWith(SIMULATION_PROTOCOL) && string.length() > 100) {
                    return string.substring(0, Math.min(string.length(), 30)) + "...";
                }
                String string2 = new URL((URL)null, string, null).getFile();
                return string2.substring(string2.lastIndexOf(47) + 1);
            }
            catch (MalformedURLException malformedURLException) {
                return null;
            }
        }
        return JSVFileManager.viewer.apiPlatform.newFile(string).getName();
    }

    public static String getQuotedJSONAttribute(String string, String string2, String string3) {
        if (string3 == null) {
            string3 = string2;
        }
        string2 = "\"" + string2 + "\":";
        string3 = "\"" + string3 + "\":";
        int n = string.indexOf(string2);
        int n2 = string.indexOf(string3, n);
        return n < 0 || n2 < 0 ? null : PT.getQuotedStringAt(string, n2 + string3.length());
    }

    public static void setDocumentBase(JSViewer jSViewer, URL uRL) {
        viewer = jSViewer;
        appletDocumentBase = uRL;
    }

    static {
        jsDocumentBase = "";
        urlPrefixes = new String[]{"http:", "https:", "ftp:", SIMULATION_PROTOCOL, "file:"};
        nciResolver = "http://cactus.nci.nih.gov/chemical/structure/%FILE/file?format=sdf&get3d=True";
        nmrdbServer = "http://www.nmrdb.org/tools/jmol/predict.php?POST?molfile=";
    }
}

