/*
 * Decompiled with CFR 0.152.
 */
package jspecview.export;

import java.io.BufferedReader;
import javajs.api.GenericFileInterface;
import javajs.util.Base64;
import javajs.util.List;
import javajs.util.OC;
import javajs.util.PT;
import jspecview.api.ExportInterface;
import jspecview.api.JSVExporter;
import jspecview.api.JSVFileHelper;
import jspecview.api.JSVPanel;
import jspecview.common.Annotation;
import jspecview.common.ExportType;
import jspecview.common.JDXSpectrum;
import jspecview.common.JSVFileManager;
import jspecview.common.JSViewer;
import jspecview.common.PanelData;
import jspecview.common.PrintLayout;
import jspecview.util.JSVTxt;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class Exporter
implements ExportInterface {
    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    @Override
    public String write(JSViewer viewer, List<String> tokens, boolean forInkscape) {
        if (tokens == null) {
            return this.printPDF(viewer, null);
        }
        String type = null;
        String fileName = null;
        JSVPanel jsvp = viewer.selectedPanel;
        try {
            switch (tokens.size()) {
                default: {
                    return "WRITE what?";
                }
                case 1: {
                    int index;
                    fileName = PT.trimQuotes((String)tokens.get(0));
                    if (fileName.indexOf(".") >= 0) {
                        type = "XY";
                    }
                    if (jsvp == null) {
                        return null;
                    }
                    ExportType eType = ExportType.getType(fileName);
                    switch (eType) {
                        case PNG: 
                        case JPG: 
                        case PDF: {
                            return this.exportTheSpectrum(viewer, eType, null, null, -1, -1, null);
                        }
                    }
                    viewer.fileHelper.setFileChooser(eType);
                    String[] items = this.getExportableItems(viewer, eType.equals((Object)ExportType.SOURCE));
                    int n = index = items == null ? -1 : viewer.getOptionFromDialog(items, "Export", "Choose a spectrum to export");
                    if (index == Integer.MIN_VALUE) {
                        return null;
                    }
                    GenericFileInterface file = viewer.fileHelper.getFile(this.getSuggestedFileName(viewer, eType), jsvp, true);
                    if (file == null) {
                        return null;
                    }
                    OC out = viewer.getOutputChannel(file.getFullPath(), false);
                    String msg = this.exportSpectrumOrImage(viewer, eType, index, out);
                    boolean isOK = msg.startsWith("OK");
                    if (isOK) {
                        viewer.si.siUpdateRecentMenus(file.getFullPath());
                    }
                    return msg;
                }
                case 2: 
            }
            type = ((String)tokens.get(0)).toUpperCase();
            fileName = PT.trimQuotes((String)tokens.get(1));
            String ext = fileName.substring(fileName.lastIndexOf(".") + 1).toUpperCase();
            if (ext.equals("JDX")) {
                if (type == null) {
                    type = "XY";
                }
            } else if (ExportType.isExportMode(ext)) {
                type = ext;
            } else if (ExportType.isExportMode(type)) {
                fileName = String.valueOf(fileName) + "." + type;
            }
            ExportType eType = ExportType.getType(type);
            if (forInkscape && eType == ExportType.SVG) {
                eType = ExportType.SVGI;
            }
            OC out = viewer.getOutputChannel(fileName, false);
            return this.exportSpectrumOrImage(viewer, eType, -1, out);
        }
        catch (Exception e) {
            System.out.println(e);
            return null;
        }
    }

    private String exportSpectrumOrImage(JSViewer viewer, ExportType eType, int index, OC out) {
        PanelData pd = viewer.selectedPanel.getPanelData();
        if (index < 0 && (index = pd.getCurrentSpectrumIndex()) < 0) {
            return "Error exporting spectrum: No spectrum selected";
        }
        JDXSpectrum spec = pd.getSpectrumAt(index);
        int startIndex = pd.getStartingPointIndex(index);
        int endIndex = pd.getEndingPointIndex(index);
        String msg = null;
        try {
            msg = this.exportTheSpectrum(viewer, eType, out, spec, startIndex, endIndex, pd);
            if (msg.startsWith("OK")) {
                return "OK - Exported " + eType.name() + ": " + out.getFileName() + msg.substring(2);
            }
        }
        catch (Exception ioe) {
            msg = ioe.toString();
        }
        return "Error exporting " + out.getFileName() + ": " + msg;
    }

    @Override
    public String exportTheSpectrum(JSViewer viewer, ExportType mode, OC out, JDXSpectrum spec, int startIndex, int endIndex, PanelData pd) throws Exception {
        JSVPanel jsvp = viewer.selectedPanel;
        String type = mode.name();
        switch (mode) {
            case SVG: 
            case SVGI: 
            case CML: 
            case AML: {
                break;
            }
            case DIF: 
            case FIX: 
            case SQZ: 
            case PAC: 
            case XY: 
            case DIFDUP: {
                type = "JDX";
                break;
            }
            case PNG: 
            case JPG: {
                if (jsvp == null) {
                    return null;
                }
                viewer.fileHelper.setFileChooser(mode);
                String name = this.getSuggestedFileName(viewer, mode);
                GenericFileInterface file = viewer.fileHelper.getFile(name, jsvp, true);
                if (file == null) {
                    return null;
                }
                if (viewer.isJS) {
                    String fname = file.getName();
                    boolean isPNG = type.equals((Object)ExportType.PNG);
                    String s = isPNG ? "png" : "jpeg";
                    try {
                        out = viewer.getOutputChannel(fname, true);
                        byte[] data = Base64.decodeBase64(s);
                        out.write(data, 0, data.length);
                        out.closeChannel();
                        return "OK " + out.getByteCount() + " bytes";
                    }
                    catch (Exception e) {
                        return e.toString();
                    }
                }
                return jsvp.saveImage(type.toLowerCase(), file);
            }
            case PDF: {
                return this.printPDF(viewer, "PDF");
            }
            case SOURCE: {
                if (jsvp == null) {
                    return null;
                }
                return Exporter.fileCopy(jsvp.getPanelData().getSpectrum().getFilePath(), out);
            }
            case UNK: {
                return null;
            }
        }
        return ((JSVExporter)JSViewer.getInterface("jspecview.export." + type.toUpperCase() + "Exporter")).exportTheSpectrum(viewer, mode, out, spec, startIndex, endIndex, null);
    }

    private String printPDF(JSViewer viewer, String pdfFileName) {
        String printJobTitle;
        OC out;
        String s;
        PrintLayout pl;
        JSVPanel jsvp;
        boolean isBase64;
        block11: {
            if (!viewer.si.isSigned()) {
                return "Error: Applet must be signed for the PRINT command.";
            }
            boolean isJob = pdfFileName == null || pdfFileName.length() == 0;
            isBase64 = !isJob && pdfFileName.toLowerCase().startsWith("base64");
            jsvp = viewer.selectedPanel;
            if (jsvp == null) {
                return null;
            }
            jsvp.getPanelData().closeAllDialogsExcept(Annotation.AType.NONE);
            pl = viewer.getDialogPrint(isJob);
            if (pl == null) {
                return null;
            }
            if (isJob && pl.asPDF) {
                isJob = false;
                pdfFileName = "PDF";
            }
            if (!isBase64 && !isJob) {
                GenericFileInterface file;
                JSVFileHelper helper = viewer.fileHelper;
                helper.setFileChooser(ExportType.PDF);
                if (pdfFileName.equals("?") || pdfFileName.equalsIgnoreCase("PDF")) {
                    pdfFileName = this.getSuggestedFileName(viewer, ExportType.PDF);
                }
                if ((file = helper.getFile(pdfFileName, jsvp, true)) == null) {
                    return null;
                }
                if (!viewer.isJS) {
                    viewer.setProperty("directoryLastExportedFile", helper.setDirLastExported(file.getParentAsFile().getFullPath()));
                }
                pdfFileName = file.getFullPath();
            }
            s = null;
            out = isJob ? null : viewer.getOutputChannel(isBase64 ? null : pdfFileName, true);
            printJobTitle = jsvp.getPanelData().getPrintJobTitle(true);
            if (!pl.showTitle || (printJobTitle = jsvp.getInput("Title?", "Title for Printing", printJobTitle)) != null) break block11;
            return null;
        }
        try {
            jsvp.printPanel(pl, out, printJobTitle);
            s = isBase64 ? Base64.getBase64(out.toByteArray()).toString() : out.toString();
        }
        catch (Exception e) {
            jsvp.showMessage(e.getMessage(), "File Error");
        }
        return s;
    }

    private String[] getExportableItems(JSViewer viewer, boolean isSameType) {
        JSVPanel jsvp = viewer.selectedPanel;
        boolean isView = viewer.currentSource.isView;
        int nSpectra = jsvp.getPanelData().getNumberOfSpectraInCurrentSet();
        if (nSpectra == 1 || !isView && isSameType || jsvp.getPanelData().getCurrentSpectrumIndex() >= 0) {
            return null;
        }
        String[] items = new String[nSpectra];
        int i = 0;
        while (i < nSpectra) {
            items[i] = jsvp.getPanelData().getSpectrumAt(i).getTitle();
            ++i;
        }
        return items;
    }

    private String getSuggestedFileName(JSViewer viewer, ExportType imode) {
        PanelData pd = viewer.selectedPanel.getPanelData();
        String sourcePath = pd.getSpectrum().getFilePath();
        String newName = JSVFileManager.getName(sourcePath);
        int pt = newName.lastIndexOf(".");
        String name = pt < 0 ? newName : newName.substring(0, pt);
        String ext = ".jdx";
        boolean isPrint = false;
        switch (imode) {
            case SOURCE: 
            case DIF: 
            case FIX: 
            case SQZ: 
            case PAC: 
            case XY: 
            case DIFDUP: {
                if (!name.endsWith("_" + (Object)((Object)imode))) {
                    name = String.valueOf(name) + "_" + (Object)((Object)imode);
                }
                ext = ".jdx";
                break;
            }
            case AML: {
                ext = ".xml";
                break;
            }
            case PNG: 
            case JPG: 
            case PDF: {
                isPrint = true;
            }
            default: {
                ext = "." + imode.toString().toLowerCase();
            }
        }
        if (viewer.currentSource.isView) {
            name = pd.getPrintJobTitle(isPrint);
        }
        name = String.valueOf(name) + ext;
        return name;
    }

    private static String fileCopy(String name, OC out) {
        try {
            BufferedReader br = JSVFileManager.getBufferedReaderFromName(name, null);
            String line = null;
            while ((line = br.readLine()) != null) {
                out.append(line);
                out.append(JSVTxt.newLine);
            }
            out.closeChannel();
            return "OK " + out.getByteCount() + " bytes";
        }
        catch (Exception e) {
            return e.toString();
        }
    }
}

