/*
 * Decompiled with CFR 0.152.
 */
package jspecview.java;

import java.awt.Component;
import java.awt.Container;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.ItemEvent;
import java.awt.event.ItemListener;
import java.awt.event.MouseEvent;
import java.awt.event.MouseListener;
import javajs.api.PlatformViewer;
import javajs.util.SB;
import javax.swing.AbstractButton;
import javax.swing.ButtonGroup;
import javax.swing.ImageIcon;
import javax.swing.JCheckBoxMenuItem;
import javax.swing.JComponent;
import javax.swing.JMenu;
import javax.swing.JMenuItem;
import javax.swing.JPopupMenu;
import javax.swing.JRadioButtonMenuItem;
import jspecview.common.JSViewer;
import jspecview.popup.JSVGenericPopup;
import jspecview.popup.JSVPopupResourceBundle;
import org.jmol.util.Logger;

public class AwtPopup
extends JSVGenericPopup {
    private MenuItemListener mil;
    private CheckboxMenuItemListener cmil;
    private MenuMouseListener mfl;

    public void jpiInitialize(PlatformViewer viewer, String menu) {
        JSVPopupResourceBundle bundle = new JSVPopupResourceBundle();
        this.initialize((JSViewer)viewer, bundle, menu);
    }

    public void finalize() {
        System.out.println("SwingPopup Finalize " + this);
    }

    private void updateButton(AbstractButton b, String entry, String script) {
        String[] ret = new String[]{entry};
        ImageIcon icon = (ImageIcon)this.getEntryIcon(ret);
        entry = ret[0];
        if (icon != null) {
            b.setIcon(icon);
        }
        if (entry != null) {
            b.setText(entry);
        }
        if (script != null) {
            b.setActionCommand(script);
        }
    }

    public void updateSpecialMenuItem(Object menuItem) {
    }

    private Object newMenuItem(JMenuItem jmi, Object menu, String entry, String script, String id) {
        this.updateButton(jmi, entry, script);
        if (id != null && id.startsWith("Focus")) {
            jmi.addMouseListener(this.mfl);
            id = String.valueOf(((Component)menu).getName()) + "." + id;
        }
        jmi.setName(id == null ? String.valueOf(((Component)menu).getName()) + "." : id);
        this.menuAddItem(menu, jmi);
        return jmi;
    }

    public void menuAddButtonGroup(Object newMenu) {
        if (this.buttonGroup == null) {
            this.buttonGroup = new ButtonGroup();
        }
        ((ButtonGroup)this.buttonGroup).add((JMenuItem)newMenu);
    }

    public void menuAddItem(Object menu, Object item) {
        if (menu instanceof JPopupMenu) {
            ((JPopupMenu)menu).add((JComponent)item);
        } else if (menu instanceof JMenu) {
            ((JMenu)menu).add((JComponent)item);
        } else {
            Logger.warn("cannot add object to menu: " + menu);
        }
    }

    public void menuAddSeparator(Object menu) {
        if (menu instanceof JPopupMenu) {
            ((JPopupMenu)menu).addSeparator();
        } else {
            ((JMenu)menu).addSeparator();
        }
    }

    public void menuAddSubMenu(Object menu, Object subMenu) {
        this.menuAddItem(menu, subMenu);
    }

    public void menuClearListeners(Object menu) {
        if (menu == null) {
            return;
        }
        Component[] subMenus = menu instanceof JPopupMenu ? ((JPopupMenu)menu).getComponents() : ((JMenu)menu).getPopupMenu().getComponents();
        int i = 0;
        while (i < subMenus.length) {
            Component m = subMenus[i];
            if (m instanceof JMenu) {
                this.menuClearListeners(((JMenu)m).getPopupMenu());
            } else {
                try {
                    m.removeMouseListener(this.mfl);
                    ((AbstractButton)m).removeActionListener(this.mil);
                    ((AbstractButton)m).removeItemListener(this.cmil);
                }
                catch (Exception exception) {
                    // empty catch block
                }
            }
            ++i;
        }
    }

    public Object menuCreateCheckboxItem(Object menu, String entry, String basename, String id, boolean state, boolean isRadio) {
        JMenuItem jmi;
        if (isRadio) {
            JRadioButtonMenuItem jr = new JRadioButtonMenuItem(entry);
            jmi = jr;
            jr.setArmed(state);
        } else {
            JCheckBoxMenuItem jcmi = new JCheckBoxMenuItem(entry);
            jmi = jcmi;
            jcmi.setState(state);
        }
        jmi.setSelected(state);
        jmi.addItemListener(this.cmil);
        return this.newMenuItem(jmi, menu, entry, basename, id);
    }

    public Object menuCreateItem(Object menu, String entry, String script, String id) {
        JMenuItem jmi = new JMenuItem(entry);
        jmi.addActionListener(this.mil);
        return this.newMenuItem(jmi, menu, entry, script, id);
    }

    public Object menuCreatePopup(String title) {
        return new JPopupMenu(title);
    }

    public void menuEnable(Object menu, boolean enable) {
        if (menu instanceof JMenuItem) {
            this.menuEnableItem(menu, enable);
            return;
        }
        try {
            ((JMenu)menu).setEnabled(enable);
        }
        catch (Exception exception) {
            // empty catch block
        }
    }

    public void menuEnableItem(Object item, boolean enable) {
        try {
            ((JMenuItem)item).setEnabled(enable);
        }
        catch (Exception exception) {
            // empty catch block
        }
    }

    public void menuGetAsText(SB sb, int level, Object menu, String menuName) {
        String name = menuName;
        Component[] subMenus = menu instanceof JPopupMenu ? ((JPopupMenu)menu).getComponents() : ((JMenu)menu).getPopupMenu().getComponents();
        int i = 0;
        while (i < subMenus.length) {
            String flags;
            Component m = subMenus[i];
            if (m instanceof JMenu) {
                JMenu jm = (JMenu)m;
                name = jm.getName();
                flags = "enabled:" + jm.isEnabled();
                AwtPopup.addItemText(sb, 'M', level, name, jm.getText(), null, flags);
                this.menuGetAsText(sb, level + 1, ((JMenu)m).getPopupMenu(), name);
            } else if (m instanceof JMenuItem) {
                JMenuItem jmi = (JMenuItem)m;
                flags = "enabled:" + jmi.isEnabled();
                if (m instanceof JCheckBoxMenuItem) {
                    flags = String.valueOf(flags) + ";checked:" + ((JCheckBoxMenuItem)m).getState();
                }
                String script = this.fixScript(jmi.getName(), jmi.getActionCommand());
                AwtPopup.addItemText(sb, 'I', level, jmi.getName(), jmi.getText(), script, flags);
            } else {
                AwtPopup.addItemText(sb, 'S', level, name, null, null, null);
            }
            ++i;
        }
    }

    public boolean menuIsEnabled(Object m) {
        if (m instanceof JMenu) {
            return ((JMenu)m).isEnabled();
        }
        if (m instanceof JMenuItem) {
            return ((JMenuItem)m).isEnabled();
        }
        return false;
    }

    public String menuGetId(Object menu) {
        return ((Component)menu).getName();
    }

    public int menuGetItemCount(Object menu) {
        return ((JMenu)menu).getItemCount();
    }

    public Object menuGetParent(Object menu) {
        return ((JMenu)menu).getParent();
    }

    public int menuGetPosition(Object menu) {
        Object p = this.menuGetParent(menu);
        if (p instanceof JPopupMenu) {
            int i = ((JPopupMenu)p).getComponentCount();
            while (--i >= 0) {
                if (((JPopupMenu)p).getComponent(i) != menu) continue;
                return i;
            }
        } else {
            int i = ((JMenu)p).getItemCount();
            while (--i >= 0) {
                if (((JMenu)p).getItem(i) != menu) continue;
                return i;
            }
        }
        return -1;
    }

    public void menuInsertSubMenu(Object menu, Object subMenu, int index) {
        if (menu instanceof JPopupMenu) {
            ((JPopupMenu)menu).insert((JMenu)subMenu, index);
        } else {
            ((JMenu)menu).insert((JMenu)subMenu, index);
        }
    }

    public Object menuNewSubMenu(String entry, String id) {
        JMenu jm = new JMenu(entry);
        this.updateButton(jm, entry, null);
        jm.setName(id);
        jm.setAutoscrolls(true);
        return jm;
    }

    public void menuRemoveAll(Object menu, int indexFrom) {
        if (indexFrom > 0) {
            int i = this.menuGetItemCount(menu);
            while (--i >= indexFrom) {
                ((JMenu)menu).remove(i);
            }
            return;
        }
        if (menu instanceof JMenu) {
            ((JMenu)menu).removeAll();
        } else {
            ((JPopupMenu)menu).removeAll();
        }
    }

    public void menuSetAutoscrolls(Object menu) {
        ((JMenu)menu).setAutoscrolls(true);
    }

    public void menuSetCheckBoxState(Object item, boolean state) {
        if (item instanceof JCheckBoxMenuItem) {
            ((JCheckBoxMenuItem)item).setState(state);
        } else {
            ((JRadioButtonMenuItem)item).setArmed(state);
        }
        ((JMenuItem)item).setSelected(state);
    }

    public String menuSetCheckBoxOption(Object item, String name, String what) {
        return null;
    }

    public void menuSetCheckBoxValue(Object source) {
        JMenuItem jcmi = (JMenuItem)source;
        this.setCheckBoxValue(jcmi, jcmi.getActionCommand(), jcmi.isSelected());
    }

    public void menuSetLabel(Object menu, String entry) {
        if (menu instanceof JMenuItem) {
            ((JMenuItem)menu).setText(entry);
        } else {
            ((JMenu)menu).setText(entry);
        }
    }

    public void menuSetListeners() {
        this.mil = new MenuItemListener();
        this.cmil = new CheckboxMenuItemListener();
        this.mfl = new MenuMouseListener();
    }

    public void menuShowPopup(Object popup, int x, int y) {
        ((JPopupMenu)popup).show((Container)((Object)this.thisJsvp), x, y);
    }

    private class CheckboxMenuItemListener
    implements ItemListener {
        protected CheckboxMenuItemListener() {
        }

        public void itemStateChanged(ItemEvent e) {
            AwtPopup.this.checkBoxStateChanged(e.getSource());
        }
    }

    private class MenuItemListener
    implements ActionListener {
        protected MenuItemListener() {
        }

        public void actionPerformed(ActionEvent e) {
            AwtPopup.this.checkMenuClick(e.getSource(), e.getActionCommand());
        }
    }

    private class MenuMouseListener
    implements MouseListener {
        protected MenuMouseListener() {
        }

        public void mouseClicked(MouseEvent e) {
        }

        public void mouseEntered(MouseEvent e) {
            if (e.getSource() instanceof JMenuItem) {
                JMenuItem jmi = (JMenuItem)e.getSource();
                AwtPopup.this.checkMenuFocus(jmi.getName(), jmi.getActionCommand(), true);
            }
        }

        public void mouseExited(MouseEvent e) {
            if (e.getSource() instanceof JMenuItem) {
                JMenuItem jmi = (JMenuItem)e.getSource();
                AwtPopup.this.checkMenuFocus(jmi.getName(), jmi.getActionCommand(), false);
            }
        }

        public void mousePressed(MouseEvent e) {
        }

        public void mouseReleased(MouseEvent e) {
        }
    }
}

