/*
 * Decompiled with CFR 0.152.
 */
package jspecview.popup;

import java.util.Hashtable;
import java.util.Map;
import java.util.Properties;
import java.util.StringTokenizer;
import javajs.util.List;
import javajs.util.PT;
import javajs.util.SB;
import jspecview.api.JSVAbstractMenu;
import jspecview.api.JSVPanel;
import jspecview.api.JSVPopupMenu;
import jspecview.common.Annotation;
import jspecview.common.JDXSpectrum;
import jspecview.common.JSVersion;
import jspecview.common.JSViewer;
import jspecview.common.PanelData;
import jspecview.common.PanelNode;
import jspecview.popup.JSVPopupResourceBundle;
import jspecview.popup.PopupResource;
import org.jmol.util.Logger;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public abstract class JSVGenericPopup
implements JSVPopupMenu,
JSVAbstractMenu {
    protected static final boolean dumpList = false;
    protected static final int UPDATE_NEVER = -1;
    private static final int UPDATE_ALL = 0;
    private static final int UPDATE_CONFIG = 1;
    private static final int UPDATE_SHOW = 2;
    protected JSViewer viewer;
    protected Map<String, Object> htCheckbox = new Hashtable<String, Object>();
    protected Properties menuText = new Properties();
    protected Object buttonGroup;
    protected String currentMenuItemId;
    protected String strMenuStructure;
    protected int updateMode;
    protected String menuName;
    private Object popupMenu;
    protected Object thisPopup;
    private Map<String, Object> htMenus = new Hashtable<String, Object>();
    private List<Object> SignedOnly = new List();
    private List<Object> AppletOnly = new List();
    private boolean allowSignedFeatures;
    private boolean isJS;
    private boolean isApplet;
    private boolean isSigned;
    private List<String> cnmrPeaks;
    private List<String> hnmrPeaks;
    private int aboutComputedMenuBaseCount;
    private PanelData pd;
    private int thisX;
    private int thisY;
    protected JSVPanel thisJsvp;

    protected void initialize(JSViewer viewer, PopupResource bundle, String title) {
        this.viewer = viewer;
        this.menuName = title;
        this.thisPopup = this.popupMenu = this.menuCreatePopup(title);
        this.menuSetListeners();
        this.htMenus.put(title, this.popupMenu);
        this.isJS = viewer.isJS;
        this.allowSignedFeatures = !viewer.isApplet || viewer.isSigned;
        this.addMenuItems("", title, this.popupMenu, bundle);
        try {
            this.jpiUpdateComputedMenus();
        }
        catch (NullPointerException e) {
            System.out.println("JSVGenericPopup error " + e);
        }
    }

    @Override
    public void jpiDispose() {
        this.menuClearListeners(this.popupMenu);
        this.thisPopup = null;
        this.popupMenu = null;
    }

    @Override
    public Object jpiGetMenuAsObject() {
        return this.popupMenu;
    }

    @Override
    public String jpiGetMenuAsString(String title) {
        this.updateForShow();
        int pt = title.indexOf("|");
        if (pt >= 0) {
            String type = title.substring(pt);
            title = title.substring(0, pt);
            if (type.indexOf("current") >= 0) {
                SB sb = new SB();
                Object menu = this.htMenus.get(this.menuName);
                this.menuGetAsText(sb, 0, menu, "PopupMenu");
                return sb.toString();
            }
        }
        return new JSVPopupResourceBundle().getMenuAsText(title);
    }

    @Override
    public void jpiShow(int x, int y) {
        this.show(x, y, false);
        this.restorePopupMenu();
        this.menuShowPopup(this.popupMenu, this.thisX, this.thisY);
    }

    @Override
    public void jpiUpdateComputedMenus() {
        if (this.updateMode == -1) {
            return;
        }
        this.updateMode = 0;
        this.getViewerData();
        this.updateFileMenu();
        this.updateFileTypeDependentMenus();
        this.updateMode = 1;
        this.updateAboutSubmenu();
    }

    protected Object getEntryIcon(String[] ret) {
        String entry = ret[0];
        if (!entry.startsWith("<")) {
            return null;
        }
        int pt = entry.indexOf(">");
        ret[0] = entry.substring(pt + 1);
        String fileName = entry.substring(1, pt);
        return this.getImageIcon(fileName);
    }

    protected Object getImageIcon(String fileName) {
        return null;
    }

    public void checkBoxStateChanged(Object source) {
        this.restorePopupMenu();
        this.menuSetCheckBoxValue(source);
        String id = this.menuGetId(source);
        if (id != null) {
            this.currentMenuItemId = id;
        }
    }

    protected static void addItemText(SB sb, char type, int level, String name, String label, String script, String flags) {
        sb.appendC(type).appendI(level).appendC('\t').append(name);
        if (label == null) {
            sb.append(".\n");
            return;
        }
        sb.append("\t").append(label).append("\t").append(script == null || script.length() == 0 ? "-" : script).append("\t").append(flags).append("\n");
    }

    protected String fixScript(String id, String script) {
        return script;
    }

    protected void restorePopupMenu() {
        this.thisPopup = this.popupMenu;
    }

    protected void setCheckBoxValue(Object item, String what, boolean TF) {
        this.checkForCheckBoxScript(item, what, TF);
    }

    private void getViewerData() {
        this.isApplet = this.viewer.isApplet;
        this.isSigned = this.viewer.isSigned;
    }

    private void updateFileTypeDependentMenus() {
        int i = this.SignedOnly.size();
        while (--i >= 0) {
            this.menuEnable(this.SignedOnly.get(i), this.isSigned || !this.isApplet);
        }
        i = this.AppletOnly.size();
        while (--i >= 0) {
            this.menuEnable(this.AppletOnly.get(i), this.isApplet);
        }
    }

    private void addMenuItems(String parentId, String key, Object menu, PopupResource popupResourceBundle) {
        String item;
        String id = String.valueOf(parentId) + "." + key;
        String value = popupResourceBundle.getStructure(key);
        if (Logger.debugging) {
            Logger.debug(String.valueOf(id) + " --- " + value);
        }
        if (value == null) {
            this.menuCreateItem(menu, "#" + key, "", "");
            return;
        }
        StringTokenizer st = new StringTokenizer(value);
        while (value.indexOf("@") >= 0) {
            String s = "";
            while (st.hasMoreTokens()) {
                s = String.valueOf(s) + " " + ((item = st.nextToken()).startsWith("@") ? popupResourceBundle.getStructure(item) : item);
            }
            value = s.substring(1);
            st = new StringTokenizer(value);
        }
        while (st.hasMoreTokens()) {
            item = st.nextToken();
            if (!this.checkKey(item)) continue;
            String label = popupResourceBundle.getWord(item);
            Object newMenu = null;
            String script = "";
            boolean isCB = false;
            if ((label = this.fixLabel(label == null ? item : label)).equals("null")) continue;
            if (item.indexOf("Menu") >= 0) {
                if (item.indexOf("more") < 0) {
                    this.buttonGroup = null;
                }
                Object subMenu = this.menuNewSubMenu(label, String.valueOf(id) + "." + item);
                this.menuAddSubMenu(menu, subMenu);
                this.htMenus.put(item, subMenu);
                if (item.indexOf("Computed") < 0) {
                    this.addMenuItems(id, item, subMenu, popupResourceBundle);
                }
                newMenu = subMenu;
            } else {
                if ("-".equals(item)) {
                    this.menuAddSeparator(menu);
                    continue;
                }
                if (item.contains("CB") || item.contains("RD")) {
                    isCB = true;
                    script = popupResourceBundle.getStructure(item);
                    String basename = label;
                    boolean isRadio = isCB && item.contains("RD");
                    newMenu = this.menuCreateCheckboxItem(menu, label, String.valueOf(basename) + ":" + script, String.valueOf(id) + "." + item, false, isRadio);
                    this.rememberCheckbox(basename, newMenu);
                    if (isRadio) {
                        this.menuAddButtonGroup(newMenu);
                    }
                } else {
                    script = popupResourceBundle.getStructure(item);
                    if (script == null) {
                        script = item;
                    }
                    if (!this.isJS && item.contains("JS")) continue;
                    newMenu = this.menuCreateItem(menu, label, script, String.valueOf(id) + "." + item);
                }
            }
            if (!this.allowSignedFeatures && item.contains("SIGNED")) {
                this.menuEnable(newMenu, false);
            }
            if (item.startsWith("SIGNED")) {
                this.SignedOnly.addLast(newMenu);
            }
            this.htMenus.put(item, newMenu);
        }
    }

    private String fixLabel(String label) {
        if (label.startsWith("_")) {
            label = label.substring(label.indexOf("_", 2) + 1);
        } else if (label.equals("VERSION")) {
            label = JSVersion.VERSION;
        }
        label = PT.simpleReplace(label, "CB", "");
        label = PT.simpleReplace(label, "Menu", "");
        label = PT.simpleReplace(label, "_", " ");
        return label;
    }

    private boolean checkKey(String key) {
        return true;
    }

    private void rememberCheckbox(String key, Object checkboxMenuItem) {
        this.htCheckbox.put(String.valueOf(key) + "::" + this.htCheckbox.size(), checkboxMenuItem);
    }

    private void checkForCheckBoxScript(Object item, String what, boolean TF) {
        if (!this.menuIsEnabled(item)) {
            return;
        }
        if (what.indexOf("##") < 0) {
            int pt = what.indexOf(":");
            if (pt < 0) {
                Logger.error("check box " + item + " IS " + what);
                return;
            }
            String basename = what.substring(0, pt);
            if (basename.endsWith("P!")) {
                if (basename.indexOf("??") >= 0) {
                    what = this.menuSetCheckBoxOption(item, basename, what);
                } else {
                    if (!TF) {
                        return;
                    }
                    what = "set picking " + basename.substring(0, basename.length() - 2);
                }
            } else {
                if ((pt = (what = what.substring(pt + 1)).indexOf("|")) >= 0) {
                    what = (TF ? what.substring(0, pt) : what.substring(pt + 1)).trim();
                }
                what = PT.simpleReplace(what, "T/F", TF ? " TRUE" : " FALSE");
            }
        }
        this.viewer.runScript(what);
    }

    @Override
    public void checkMenuClick(Object source, String script) {
        this.checkMenuClickGP(source, script);
    }

    protected void checkMenuClickGP(Object source, String script) {
        this.restorePopupMenu();
        if (script == null || script.length() == 0) {
            return;
        }
        String id = this.menuGetId(source);
        if (id != null) {
            script = this.fixScript(id, script);
            this.currentMenuItemId = id;
        }
        this.viewer.runScript(script);
    }

    private void updateFileMenu() {
        Object menu = this.htMenus.get("fileMenu");
        if (menu == null) {
            return;
        }
    }

    private void updateSpectraMenu() {
        Object menu;
        Object menuh = this.htMenus.get("hnmrMenu");
        Object menuc = this.htMenus.get("cnmrMenu");
        if (menuh != null) {
            this.menuRemoveAll(menuh, 0);
        }
        if (menuc != null) {
            this.menuRemoveAll(menuc, 0);
        }
        if ((menu = this.htMenus.get("spectraMenu")) == null) {
            return;
        }
        this.menuRemoveAll(menu, 0);
        boolean isOK = this.setSpectraMenu(menuh, this.hnmrPeaks) | this.setSpectraMenu(menuc, this.cnmrPeaks);
        if (isOK) {
            if (menuh != null) {
                this.menuAddSubMenu(menu, menuh);
            }
            if (menuc != null) {
                this.menuAddSubMenu(menu, menuc);
            }
        }
        this.menuEnable(menu, isOK);
    }

    private boolean setSpectraMenu(Object menu, List<String> peaks) {
        int n;
        if (menu == null) {
            return false;
        }
        this.menuEnable(menu, false);
        int n2 = n = peaks == null ? 0 : peaks.size();
        if (n == 0) {
            return false;
        }
        int i = 0;
        while (i < n) {
            String peak = (String)peaks.get(i);
            String title = PT.getQuotedAttribute(peak, "title");
            String atoms = PT.getQuotedAttribute(peak, "atoms");
            if (atoms != null) {
                this.menuCreateItem(menu, title, "select visible & (@" + PT.simpleReplace(atoms, ",", " or @") + ")", "Focus" + i);
            }
            ++i;
        }
        this.menuEnable(menu, true);
        return true;
    }

    private void updateAboutSubmenu() {
        Object menu = this.htMenus.get("aboutComputedMenu");
        if (menu == null) {
            return;
        }
        this.menuRemoveAll(menu, this.aboutComputedMenuBaseCount);
    }

    private void updateForShow() {
        if (this.updateMode == -1) {
            return;
        }
        this.getViewerData();
        this.updateMode = 2;
        this.updateSpectraMenu();
        this.updateAboutSubmenu();
    }

    private void show(int x, int y, boolean doPopup) {
        this.thisJsvp = this.viewer.selectedPanel;
        this.setEnables(this.thisJsvp);
        if (x == Integer.MIN_VALUE) {
            x = this.thisX;
            y = this.thisY;
        } else {
            this.thisX = x;
            this.thisY = y;
        }
        this.updateForShow();
        if (doPopup) {
            this.menuShowPopup(this.popupMenu, this.thisX, this.thisY);
        }
    }

    public void checkMenuFocus(String name, String cmd, boolean isFocus) {
        if (name.indexOf("Focus") < 0) {
            return;
        }
        if (isFocus) {
            this.viewer.runScript(cmd);
        }
    }

    @Override
    public boolean getSelected(String key) {
        return false;
    }

    @Override
    public void setCompoundMenu(List<PanelNode> panelNodes, boolean allowCompoundMenu) {
    }

    @Override
    public void setEnabled(boolean allowMenu, boolean zoomEnabled) {
        if (!allowMenu) {
            this.setItemEnabled("_SIGNED_FileMenu", false);
            this.setItemEnabled("ViewMenu", false);
            this.setItemEnabled("Views", false);
            this.setItemEnabled("Script", false);
            this.setItemEnabled("Print", false);
        }
        this.setItemEnabled("ZoomMenu", zoomEnabled);
    }

    private void setEnables(JSVPanel jsvp) {
        this.pd = jsvp.getPanelData();
        JDXSpectrum spec0 = this.pd.getSpectrum();
        boolean isOverlaid = this.pd.isShowAllStacked();
        boolean isSingle = this.pd.haveSelectedSpectrum();
        this.setItemEnabled("Integration", this.pd.getSpectrum().canIntegrate());
        this.setItemEnabled("Measurements", this.pd.hasCurrentMeasurements(Annotation.AType.Measurements));
        this.setItemEnabled("Peaks", this.pd.getSpectrum().is1D());
        this.setItemEnabled("Predicted_Solution_Colour", isSingle && spec0.canShowSolutionColor());
        this.setItemEnabled("Toggle_Trans/Abs", isSingle && spec0.canConvertTransAbs());
        this.setItemEnabled("Show_Overlay_Key", isOverlaid && this.pd.getNumberOfGraphSets() == 1);
        this.setItemEnabled("Overlay_Offset...", isOverlaid);
        this.setItemEnabled("JDXMenu", spec0.canSaveAsJDX());
        this.setItemEnabled("ExportAsMenu", true);
    }

    private void setItemEnabled(String key, boolean TF) {
        Object item = this.htMenus.get(key);
        if (item == null) {
            return;
        }
        this.menuEnable(item, TF);
    }

    @Override
    public void setSelected(String key, boolean TF) {
        Object item = this.htMenus.get(key);
        if (item == null) {
            return;
        }
        this.menuEnable(item, false);
        this.menuSetCheckBoxState(item, TF);
        this.menuEnable(item, true);
    }
}

