/*
 * Decompiled with CFR 0.152.
 */
package jspecview.source;

import java.io.BufferedReader;
import java.io.IOException;
import java.io.InputStream;
import java.io.StringReader;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Hashtable;
import java.util.Map;
import java.util.NoSuchElementException;
import java.util.StringTokenizer;
import javajs.util.BS;
import javajs.util.List;
import javajs.util.PT;
import javajs.util.SB;
import jspecview.api.JSVZipReader;
import jspecview.api.SourceReader;
import jspecview.common.Coordinate;
import jspecview.common.JDXSpectrum;
import jspecview.common.JSVFileManager;
import jspecview.common.JSViewer;
import jspecview.common.PeakInfo;
import jspecview.exception.JDXSourceException;
import jspecview.exception.JSpecViewException;
import jspecview.source.JDXDataObject;
import jspecview.source.JDXDecompressor;
import jspecview.source.JDXHeader;
import jspecview.source.JDXSource;
import jspecview.source.JDXSourceStreamTokenizer;
import jspecview.util.JSVEscape;
import org.jmol.util.Logger;

public class FileReader {
    public static final String[][] VAR_LIST_TABLE = new String[][]{{"PEAKTABLE", "XYDATA", "XYPOINTS"}, {"(XY..XY)", "(X++(Y..Y))", "(XY..XY)"}};
    static final String ERROR_SEPARATOR = "=====================\n";
    private static final String[] TABULAR_DATA_LABELS = new String[]{"##XYDATA", "##XYPOINTS", "##PEAKTABLE", "##DATATABLE", "##PEAKASSIGNMENTS"};
    private JDXSource source;
    private JDXSourceStreamTokenizer t;
    private SB errorLog;
    private boolean obscure;
    private boolean done;
    private boolean isZipFile;
    private String filePath;
    private boolean loadImaginary = true;
    private int firstSpec = 0;
    private int lastSpec = 0;
    private int nSpec = 0;
    private double blockID;
    private String piUnitsX;
    private String piUnitsY;
    private String thisModelID;
    private int peakIndex;

    private FileReader(String string, boolean bl, boolean bl2, int n, int n2) {
        System.out.println("FileReader filePath=" + string + "<<");
        string = PT.trimQuotes(string);
        this.filePath = string != null && string.startsWith("http://SIMULATION/MOL=") ? "http://SIMULATION/MOL=" + Math.abs(string.hashCode()) : string;
        this.obscure = bl;
        this.firstSpec = n;
        this.lastSpec = n2;
        this.loadImaginary = bl2;
    }

    public static JDXSource createJDXSourceFromStream(InputStream inputStream, boolean bl, boolean bl2) throws Exception {
        return FileReader.createJDXSource(JSVFileManager.getBufferedReaderForInputStream(inputStream), "stream", bl, bl2, -1, -1);
    }

    public static JDXSource createJDXSource(BufferedReader bufferedReader, String string, boolean bl, boolean bl2, int n, int n2) throws Exception {
        try {
            if (bufferedReader == null) {
                bufferedReader = JSVFileManager.getBufferedReaderFromName(string, "##TITLE");
            }
            bufferedReader.mark(400);
            char[] cArray = new char[400];
            bufferedReader.read(cArray, 0, 400);
            bufferedReader.reset();
            String string2 = new String(cArray);
            int n3 = string2.indexOf(35);
            int n4 = string2.indexOf(60);
            if (n3 < 0 || n4 >= 0 && n4 < n3) {
                String string3 = string2.toLowerCase();
                if (string3.contains("404")) {
                    System.out.println(string3);
                }
                string3 = string3.contains("<animl") || string3.contains("<!doctype technique") ? "AnIML" : (string3.contains("xml-cml") ? "CML" : null);
                JDXSource jDXSource = ((SourceReader)JSViewer.getInterface("jspecview.source." + string3 + "Reader")).getSource(string, bufferedReader);
                bufferedReader.close();
                if (jDXSource == null) {
                    throw new JSpecViewException("File type not recognized");
                }
                return jDXSource;
            }
            return new FileReader(string, bl, bl2, n, n2).getJDXSource(bufferedReader);
        }
        catch (JSpecViewException jSpecViewException) {
            bufferedReader.close();
            throw new Exception("Error reading JDX format: " + jSpecViewException);
        }
    }

    private JDXSource getJDXSource(Object object) throws JSpecViewException {
        this.source = new JDXSource(0, this.filePath);
        this.isZipFile = object instanceof JSVZipReader;
        this.t = new JDXSourceStreamTokenizer((BufferedReader)object);
        this.errorLog = new SB();
        String string = null;
        while (!this.done && "##TITLE".equals(this.t.peakLabel())) {
            if (string != null && !this.isZipFile) {
                this.errorLog.append("Warning - file is a concatenation without LINK record -- does not conform to IUPAC standards!\n");
            }
            JDXSpectrum jDXSpectrum = new JDXSpectrum();
            List<String[]> list = new List<String[]>();
            while (!this.done && (string = this.t.getLabel()) != null && !this.isEnd(string)) {
                if (string.equals("##DATATYPE") && this.t.getValue().toUpperCase().equals("LINK")) {
                    this.getBlockSpectra(list);
                    jDXSpectrum = null;
                    continue;
                }
                if (string.equals("##NTUPLES") || string.equals("##VARNAME")) {
                    this.getNTupleSpectra(list, jDXSpectrum, string);
                    jDXSpectrum = null;
                    continue;
                }
                if (Arrays.binarySearch(TABULAR_DATA_LABELS, string) > 0) {
                    this.setTabularDataType(jDXSpectrum, string);
                    if (!this.processTabularData(jDXSpectrum, list)) {
                        throw new JDXSourceException("Unable to read JDX file");
                    }
                    this.addSpectrum(jDXSpectrum, false);
                    jDXSpectrum = null;
                    continue;
                }
                if (jDXSpectrum == null) {
                    jDXSpectrum = new JDXSpectrum();
                }
                if (FileReader.readDataLabel(jDXSpectrum, string, this.t, this.errorLog, this.obscure)) continue;
                String string2 = this.t.getValue();
                FileReader.addHeader(list, this.t.getRawLabel(), string2);
                if (!this.checkCustomTags(jDXSpectrum, string, string2)) continue;
            }
        }
        this.source.setErrorLog(this.errorLog.toString());
        return this.source;
    }

    private boolean isEnd(String string) {
        if (!string.equals("##END")) {
            return false;
        }
        this.t.getValue();
        return true;
    }

    private boolean addSpectrum(JDXSpectrum jDXSpectrum, boolean bl) {
        if (!this.loadImaginary && jDXSpectrum.isImaginary()) {
            Logger.info("FileReader skipping imaginary spectrum -- use LOADIMAGINARY TRUE to load this spectrum.");
            return true;
        }
        ++this.nSpec;
        if (this.firstSpec > 0 && this.nSpec < this.firstSpec) {
            return true;
        }
        if (this.lastSpec > 0 && this.nSpec > this.lastSpec) {
            this.done = true;
            return !true;
        }
        jDXSpectrum.setBlockID(this.blockID);
        this.source.addJDXSpectrum(null, jDXSpectrum, bl);
        return true;
    }

    private JDXSource getBlockSpectra(List<String[]> list) throws JSpecViewException {
        Logger.debug("--JDX block start--");
        String string = "";
        boolean bl = this.source.type == 0;
        boolean bl2 = false;
        while ((string = this.t.getLabel()) != null && !string.equals("##TITLE")) {
            int n;
            if (bl) {
                if (!FileReader.readHeaderLabel(this.source, string, this.t, this.errorLog, this.obscure)) {
                    FileReader.addHeader(list, this.t.getRawLabel(), this.t.getValue());
                }
            } else {
                this.t.getValue();
            }
            if (!string.equals("##BLOCKS") || (n = PT.parseInt(this.t.getValue())) <= 100 || this.firstSpec > 0) continue;
            bl2 = true;
        }
        if (!"##TITLE".equals(string)) {
            throw new JSpecViewException("Unable to read block source");
        }
        if (bl) {
            this.source.setHeaderTable(list);
        }
        this.source.type = 1;
        this.source.isCompoundSource = true;
        JDXSpectrum jDXSpectrum = new JDXSpectrum();
        List<Object> list2 = new List<String[]>();
        FileReader.readDataLabel(jDXSpectrum, string, this.t, this.errorLog, this.obscure);
        try {
            String string2;
            while ((string2 = this.t.getLabel()) != null) {
                if ("##END".equals(string) && this.isEnd(string2)) {
                    Logger.debug("##END= " + this.t.getValue());
                    break;
                }
                string = string2;
                if (Arrays.binarySearch(TABULAR_DATA_LABELS, string) > 0) {
                    this.setTabularDataType(jDXSpectrum, string);
                    if (this.processTabularData(jDXSpectrum, list2)) continue;
                    throw new JDXSourceException("Unable to read Block Source");
                }
                if (string.equals("##DATATYPE") && this.t.getValue().toUpperCase().equals("LINK")) {
                    this.getBlockSpectra(list2);
                    jDXSpectrum = null;
                    string = null;
                } else if (string.equals("##NTUPLES") || string.equals("##VARNAME")) {
                    this.getNTupleSpectra(list2, jDXSpectrum, string);
                    jDXSpectrum = null;
                    string = "";
                } else if (string.equals("##JCAMPCS")) {
                    while (!(string = this.t.getLabel()).equals("##TITLE")) {
                        this.t.getValue();
                    }
                    jDXSpectrum = null;
                } else {
                    this.t.getValue();
                }
                if (this.done) break;
                if (jDXSpectrum == null) {
                    jDXSpectrum = new JDXSpectrum();
                    list2 = new List();
                    if (string == "") continue;
                    if (string == null) {
                        string = "##END";
                        continue;
                    }
                }
                if (FileReader.readDataLabel(jDXSpectrum, string, this.t, this.errorLog, this.obscure)) continue;
                if (this.isEnd(string)) {
                    if (jDXSpectrum.getXYCoords().length > 0 && !this.addSpectrum(jDXSpectrum, bl2)) {
                        return this.source;
                    }
                    jDXSpectrum = new JDXSpectrum();
                    list2 = new List();
                    this.t.getValue();
                    continue;
                }
                String string3 = this.t.getValue();
                FileReader.addHeader(list2, this.t.getRawLabel(), string3);
                if (!this.checkCustomTags(jDXSpectrum, string, string3)) continue;
            }
        }
        catch (NoSuchElementException noSuchElementException) {
            throw new JSpecViewException("Unable to Read Block Source");
        }
        catch (JSpecViewException jSpecViewException) {
            throw jSpecViewException;
        }
        this.addErrorLogSeparator();
        this.source.setErrorLog(this.errorLog.toString());
        Logger.debug("--JDX block end--");
        return this.source;
    }

    private boolean checkCustomTags(JDXSpectrum jDXSpectrum, String string, String string2) {
        int n = "##$MODELS ##$PEAKS  ##$SIGNALS".indexOf(string);
        switch (n) {
            default: {
                return false;
            }
            case 0: {
                this.thisModelID = PT.getQuotedAttribute(string2, "id");
                return true;
            }
            case 10: 
            case 20: 
        }
        this.peakIndex = this.source.peakCount;
        this.source.peakCount = this.source.peakCount + this.readPeaks(jDXSpectrum, string2, n == 20);
        return true;
    }

    private void addErrorLogSeparator() {
        if (this.errorLog.length() > 0 && this.errorLog.lastIndexOf(ERROR_SEPARATOR) != this.errorLog.length() - ERROR_SEPARATOR.length()) {
            this.errorLog.append(ERROR_SEPARATOR);
        }
    }

    private JDXSource getNTupleSpectra(List<String[]> list, JDXDataObject jDXDataObject, String string) throws JSpecViewException {
        Object object;
        Object object2;
        boolean bl;
        boolean bl2;
        double[] dArray = new double[]{Double.MAX_VALUE, Double.MIN_VALUE};
        this.blockID = Math.random();
        boolean bl3 = true;
        if (this.firstSpec > 0) {
            jDXDataObject.numDim = 1;
        }
        if (!(bl2 = string.equals("##VARNAME"))) {
            string = "";
            this.t.getValue();
        }
        Hashtable<String, List<String>> hashtable = new Hashtable<String, List<String>>();
        String[] stringArray = new String[2];
        boolean bl4 = bl = this.source.type == 0;
        if (bl) {
            this.source.type = 2;
            this.source.isCompoundSource = true;
            this.source.setHeaderTable(list);
        }
        while (!(string = bl2 ? string : this.t.getLabel()).equals("##PAGE")) {
            bl2 = false;
            object2 = new StringTokenizer(this.t.getValue(), ",");
            object = new List();
            while (((StringTokenizer)object2).hasMoreTokens()) {
                ((List)object).addLast(((StringTokenizer)object2).nextToken().trim());
            }
            hashtable.put(string, (List<String>)object);
        }
        object2 = (List)hashtable.get("##SYMBOL");
        if (!string.equals("##PAGE")) {
            throw new JSpecViewException("Error Reading NTuple Source");
        }
        object = this.t.getValue();
        JDXSpectrum jDXSpectrum = null;
        boolean bl5 = true;
        while (!this.done) {
            String[] stringArray2;
            int n;
            string = this.t.getLabel();
            if (string.equals("##ENDNTUPLES")) {
                this.t.getValue();
                break;
            }
            if (string.equals("##PAGE")) {
                object = this.t.getValue();
                continue;
            }
            if (jDXSpectrum == null) {
                int n2;
                jDXSpectrum = new JDXSpectrum();
                jDXDataObject.copyTo(jDXSpectrum);
                jDXSpectrum.setTitle(jDXDataObject.getTitle());
                if (!jDXSpectrum.is1D() && (n2 = ((String)object).indexOf(61)) >= 0) {
                    try {
                        jDXSpectrum.setY2D(Double.parseDouble(((String)object).substring(n2 + 1).trim()));
                        String string2 = ((String)object).substring(0, n2).trim();
                        int n3 = ((ArrayList)object2).indexOf(string2);
                        if (n3 >= 0) {
                            jDXSpectrum.setY2DUnits((String)((List)hashtable.get("##UNITS")).get(n3));
                        }
                    }
                    catch (Exception exception) {
                        // empty catch block
                    }
                }
            }
            List<String[]> list2 = new List<String[]>();
            jDXSpectrum.setHeaderTable(list2);
            while (!string.equals("##DATATABLE")) {
                FileReader.addHeader(list2, this.t.getRawLabel(), this.t.getValue());
                string = this.t.getLabel();
            }
            boolean bl6 = true;
            String string3 = this.t.flushLine();
            if (string3.trim().indexOf("PEAKS") > 0) {
                bl6 = false;
            }
            int n4 = string3.indexOf(40);
            int n5 = string3.lastIndexOf(41);
            if (n4 == -1 || n5 == -1) {
                throw new JDXSourceException("Variable List not Found");
            }
            String string4 = string3.substring(n4, n5 + 1);
            int n6 = 0;
            for (n = 0; n < ((ArrayList)object2).size(); ++n) {
                stringArray2 = ((String)((ArrayList)object2).get(n)).trim();
                if (string4.indexOf((String)stringArray2) != -1) {
                    stringArray[n6++] = stringArray2;
                }
                if (n6 == 2) break;
            }
            this.setTabularDataType(jDXSpectrum, "##" + (bl6 ? "XYDATA" : "PEAKTABLE"));
            if (!this.readNTUPLECoords(jDXSpectrum, hashtable, stringArray, dArray)) {
                throw new JDXSourceException("Unable to read Ntuple Source");
            }
            if (!jDXSpectrum.nucleusX.equals("?")) {
                jDXDataObject.nucleusX = jDXSpectrum.nucleusX;
            }
            jDXDataObject.nucleusY = jDXSpectrum.nucleusY;
            jDXDataObject.freq2dX = jDXSpectrum.freq2dX;
            jDXDataObject.freq2dY = jDXSpectrum.freq2dY;
            jDXDataObject.y2DUnits = jDXSpectrum.y2DUnits;
            for (n = 0; n < list.size(); ++n) {
                stringArray2 = (String[])list.get(n);
                String string5 = JDXSourceStreamTokenizer.cleanLabel(stringArray2[0]);
                if (string5.equals("##TITLE") || string5.equals("##DATACLASS") || string5.equals("##NTUPLES")) continue;
                list2.addLast(stringArray2);
            }
            if (bl3) {
                this.addSpectrum(jDXSpectrum, !bl5);
            }
            bl5 = false;
            jDXSpectrum = null;
        }
        this.addErrorLogSeparator();
        this.source.setErrorLog(this.errorLog.toString());
        Logger.info("NTUPLE MIN/MAX Y = " + dArray[0] + " " + dArray[1]);
        return this.source;
    }

    private int readPeaks(JDXSpectrum jDXSpectrum, String string, boolean bl) {
        List<PeakInfo> list = new List<PeakInfo>();
        BufferedReader bufferedReader = new BufferedReader(new StringReader(string));
        try {
            BS bS;
            Object object;
            Object object2;
            int n = bl ? 1 : 0;
            System.out.println("offset is " + n + " isSignals=" + bl);
            String string2 = bl ? "Signals" : "Peaks";
            String string3 = bl ? "<Signal" : "<PeakData";
            String string4 = this.discardUntil(bufferedReader, string2);
            if (string4.indexOf("<" + string2) < 0) {
                string4 = this.discardUntil(bufferedReader, "<" + string2);
            }
            if (string4.indexOf("<" + string2) < 0) {
                return 0;
            }
            String string5 = this.getPeakFilePath();
            String string6 = this.getQuotedAttribute(string4, "model");
            string6 = " model=" + this.escape(string6 == null ? this.thisModelID : string6);
            String string7 = this.getQuotedAttribute(string4, "type");
            if ("HNMR".equals(string7)) {
                string7 = "1HNMR";
            } else if ("CNMR".equals(string7)) {
                string7 = "13CNMR";
            }
            string7 = string7 == null ? "" : " type=" + this.escape(string7);
            this.piUnitsX = this.getQuotedAttribute(string4, "xLabel");
            this.piUnitsY = this.getQuotedAttribute(string4, "yLabel");
            Hashtable<Object[], Object[]> hashtable = new Hashtable<Object[], Object[]>();
            List<Object[]> list2 = new List<Object[]>();
            while ((string4 = bufferedReader.readLine()) != null && !(string4 = string4.trim()).startsWith("</" + string2)) {
                if (!string4.startsWith(string3)) continue;
                this.info(string4);
                String string8 = this.getQuotedAttribute(string4, "title");
                if (string8 == null) {
                    string8 = string7 == "1HNMR" ? "atom%S%: %ATOMS%; integration: %NATOMS%" : "";
                    string8 = " title=" + this.escape(string8);
                } else {
                    string8 = "";
                }
                String string9 = "<PeakData " + string5 + " index=\"%INDEX%\"" + string8 + string7 + (this.getQuotedAttribute(string4, "model") == null ? string6 : "") + " " + string4.substring(string3.length()).trim();
                String string10 = this.getQuotedAttribute(string9, "atoms");
                if (string10 != null) {
                    string9 = this.simpleReplace(string9, "atoms=\"" + string10 + "\"", "atoms=\"%ATOMS%\"");
                }
                if ((object2 = (Object[])hashtable.get(object = (int)(this.parseFloatStr(this.getQuotedAttribute(string4, "xMin")) * 100.0f) + "_" + (int)(this.parseFloatStr(this.getQuotedAttribute(string4, "xMax")) * 100.0f))) == null) {
                    object2 = new Object[]{string9, string10 == null ? null : new BS()};
                    hashtable.put((Object[])object, (Object[])object2);
                    list2.addLast((Object[])object2);
                }
                bS = (BS)object2[1];
                if (string10 == null || bS == null) continue;
                string10 = string10.replace(',', ' ');
                bS.or(this.unescapeBitSet("({" + string10 + "})"));
                System.out.println("bs is  " + bS);
            }
            int n2 = 0;
            int n3 = list2.size();
            for (int i = 0; i < n3; ++i) {
                object = (Object[])list2.get(i);
                object2 = (Object[])object[0];
                object2 = this.simpleReplace((String)object2, "%INDEX%", "" + this.getPeakIndex());
                bS = (BS)object[1];
                if (bS != null) {
                    System.out.println("bs " + i + " is " + bS);
                    String string11 = "";
                    int n4 = bS.nextSetBit(0);
                    while (n4 >= 0) {
                        string11 = string11 + "," + (n4 + n);
                        n4 = bS.nextSetBit(n4 + 1);
                    }
                    n4 = bS.cardinality();
                    n2 += n4;
                    object2 = this.simpleReplace((String)object2, "%ATOMS%", string11.substring(1));
                    object2 = this.simpleReplace((String)object2, "%S%", n4 == 1 ? "" : "s");
                    object2 = this.simpleReplace((String)object2, "%NATOMS%", "" + n4);
                }
                this.info("JSpecView using " + (String)object2);
                this.add(list, (String)object2);
            }
            this.setSpectrumPeaks(jDXSpectrum, list, n2);
            return n3;
        }
        catch (Exception exception) {
            return 0;
        }
    }

    private void add(List<PeakInfo> list, String string) {
        list.addLast(new PeakInfo(string));
    }

    private void info(String string) {
        Logger.info(string);
    }

    private BS unescapeBitSet(String string) {
        char c;
        int n;
        if (string == null || (n = (string = string.trim()).length()) < 4 || string.equalsIgnoreCase("({null})") || (c = string.charAt(0)) != '(' && c != '[' || string.charAt(n - 1) != (c == '(' ? (char)')' : ']') || string.charAt(1) != '{' || string.indexOf(125) != n - 2) {
            return null;
        }
        int n2 = n -= 2;
        while (--n2 >= 2) {
            c = string.charAt(n2);
            if (Character.isDigit(c) || c == ' ' || c == '\t' || c == ':') continue;
            return null;
        }
        n2 = n;
        while (Character.isDigit(string.charAt(--n2))) {
        }
        if (++n2 == n) {
            n2 = 0;
        } else {
            try {
                n2 = Integer.parseInt(string.substring(n2, n));
            }
            catch (NumberFormatException numberFormatException) {
                return null;
            }
        }
        BS bS = BS.newN(n2);
        n2 = -1;
        int n3 = -1;
        int n4 = -2;
        block8: for (int i = 2; i <= n; ++i) {
            c = string.charAt(i);
            switch (c) {
                case '\t': 
                case ' ': 
                case '}': {
                    if (n4 < 0) continue block8;
                    if (n4 < n2) {
                        return null;
                    }
                    n2 = n4;
                    if (n3 < 0) {
                        n3 = n4;
                    }
                    bS.setBits(n3, n4 + 1);
                    n3 = -1;
                    n4 = -2;
                    continue block8;
                }
                case ':': {
                    n3 = n2 = n4;
                    n4 = -2;
                    continue block8;
                }
                default: {
                    if (!Character.isDigit(c)) continue block8;
                    if (n4 < 0) {
                        n4 = 0;
                    }
                    n4 = n4 * 10 + (c - 48);
                }
            }
        }
        return n3 >= 0 ? null : bS;
    }

    private float parseFloatStr(String string) {
        return PT.parseFloat(string);
    }

    private String simpleReplace(String string, String string2, String string3) {
        return PT.simpleReplace(string, string2, string3);
    }

    private String escape(String string) {
        return JSVEscape.eS(string);
    }

    private String getQuotedAttribute(String string, String string2) {
        return PT.getQuotedAttribute(string, string2);
    }

    private String getPeakFilePath() {
        return " file=" + JSVEscape.eS(PT.trimQuotes(this.filePath).replace('\\', '/'));
    }

    private void setSpectrumPeaks(JDXSpectrum jDXSpectrum, List<PeakInfo> list, int n) {
        jDXSpectrum.setPeakList(list, this.piUnitsX, this.piUnitsY);
        jDXSpectrum.setNHydrogens(n);
    }

    private String discardUntil(BufferedReader bufferedReader, String string) throws Exception {
        String string2;
        while ((string2 = bufferedReader.readLine()) != null && string2.indexOf("<" + string) < 0 && string2.indexOf("##") < 0) {
        }
        return string2;
    }

    private int getPeakIndex() {
        return ++this.peakIndex;
    }

    private static boolean readDataLabel(JDXDataObject jDXDataObject, String string, JDXSourceStreamTokenizer jDXSourceStreamTokenizer, SB sB, boolean bl) {
        if (FileReader.readHeaderLabel(jDXDataObject, string, jDXSourceStreamTokenizer, sB, bl)) {
            return true;
        }
        if (string.equals("##MINX") || string.equals("##MINY") || string.equals("##MAXX") || string.equals("##MAXY") || string.equals("##FIRSTY") || string.equals("##DELTAX") || string.equals("##DATACLASS")) {
            jDXSourceStreamTokenizer.getValue();
            return true;
        }
        if (string.equals("##FIRSTX")) {
            jDXDataObject.fileFirstX = Double.parseDouble(jDXSourceStreamTokenizer.getValue());
            return true;
        }
        if (string.equals("##LASTX")) {
            jDXDataObject.fileLastX = Double.parseDouble(jDXSourceStreamTokenizer.getValue());
            return true;
        }
        if (string.equals("##NPOINTS")) {
            jDXDataObject.nPointsFile = Integer.parseInt(jDXSourceStreamTokenizer.getValue());
            return true;
        }
        if (string.equals("##XFACTOR")) {
            jDXDataObject.xFactor = Double.parseDouble(jDXSourceStreamTokenizer.getValue());
            return true;
        }
        if (string.equals("##YFACTOR")) {
            jDXDataObject.yFactor = Double.parseDouble(jDXSourceStreamTokenizer.getValue());
            return true;
        }
        if (string.equals("##XUNITS")) {
            jDXDataObject.setXUnits(jDXSourceStreamTokenizer.getValue());
            return true;
        }
        if (string.equals("##YUNITS")) {
            jDXDataObject.setYUnits(jDXSourceStreamTokenizer.getValue());
            return true;
        }
        if (string.equals("##XLABEL")) {
            jDXDataObject.setXLabel(jDXSourceStreamTokenizer.getValue());
            return false;
        }
        if (string.equals("##YLABEL")) {
            jDXDataObject.setYLabel(jDXSourceStreamTokenizer.getValue());
            return false;
        }
        if (string.equals("##NUMDIM")) {
            jDXDataObject.numDim = Integer.parseInt(jDXSourceStreamTokenizer.getValue());
            return true;
        }
        if (string.equals("##.OBSERVEFREQUENCY")) {
            jDXDataObject.observedFreq = Double.parseDouble(jDXSourceStreamTokenizer.getValue());
            return true;
        }
        if (string.equals("##.OBSERVENUCLEUS")) {
            jDXDataObject.setObservedNucleus(jDXSourceStreamTokenizer.getValue());
            return true;
        }
        if (string.equals("##$OFFSET") && jDXDataObject.shiftRefType != 0) {
            if (jDXDataObject.offset == Double.MAX_VALUE) {
                jDXDataObject.offset = Double.parseDouble(jDXSourceStreamTokenizer.getValue());
            }
            jDXDataObject.dataPointNum = 1;
            jDXDataObject.shiftRefType = 1;
            return false;
        }
        if (string.equals("##$REFERENCEPOINT") && jDXDataObject.shiftRefType != 0) {
            jDXDataObject.offset = Double.parseDouble(jDXSourceStreamTokenizer.getValue());
            jDXDataObject.dataPointNum = 1;
            jDXDataObject.shiftRefType = 2;
            return false;
        }
        if (string.equals("##.SHIFTREFERENCE")) {
            String string2 = jDXSourceStreamTokenizer.getValue();
            if (!jDXDataObject.dataType.toUpperCase().contains("SPECTRUM")) {
                return true;
            }
            StringTokenizer stringTokenizer = new StringTokenizer(string2, ",");
            if (stringTokenizer.countTokens() != 4) {
                return true;
            }
            try {
                stringTokenizer.nextToken();
                stringTokenizer.nextToken();
                jDXDataObject.dataPointNum = Integer.parseInt(stringTokenizer.nextToken().trim());
                jDXDataObject.offset = Double.parseDouble(stringTokenizer.nextToken().trim());
            }
            catch (NumberFormatException numberFormatException) {
                return true;
            }
            catch (NoSuchElementException noSuchElementException) {
                return true;
            }
            if (jDXDataObject.dataPointNum <= 0) {
                jDXDataObject.dataPointNum = 1;
            }
            jDXDataObject.shiftRefType = 0;
            return true;
        }
        return false;
    }

    private static boolean readHeaderLabel(JDXHeader jDXHeader, String string, JDXSourceStreamTokenizer jDXSourceStreamTokenizer, SB sB, boolean bl) {
        if (string.equals("##TITLE")) {
            String string2 = jDXSourceStreamTokenizer.getValue();
            jDXHeader.setTitle(bl || string2 == null || string2.equals("") ? "Unknown" : string2);
            return true;
        }
        if (string.equals("##JCAMPDX")) {
            String string3;
            jDXHeader.jcampdx = string3 = jDXSourceStreamTokenizer.getValue();
            float f = PT.parseFloat(string3);
            if (((double)f >= 6.0 || Float.isNaN(f)) && sB != null) {
                sB.append("Warning: JCAMP-DX version may not be fully supported: " + string3 + "\n");
            }
            return true;
        }
        if (string.equals("##ORIGIN")) {
            String string4 = jDXSourceStreamTokenizer.getValue();
            jDXHeader.origin = string4 != null && !string4.equals("") ? string4 : "Unknown";
            return true;
        }
        if (string.equals("##OWNER")) {
            String string5 = jDXSourceStreamTokenizer.getValue();
            jDXHeader.owner = string5 != null && !string5.equals("") ? string5 : "Unknown";
            return true;
        }
        if (string.equals("##DATATYPE")) {
            jDXHeader.dataType = jDXSourceStreamTokenizer.getValue();
            return true;
        }
        if (string.equals("##LONGDATE")) {
            jDXHeader.longDate = jDXSourceStreamTokenizer.getValue();
            return true;
        }
        if (string.equals("##DATE")) {
            jDXHeader.date = jDXSourceStreamTokenizer.getValue();
            return true;
        }
        if (string.equals("##TIME")) {
            jDXHeader.time = jDXSourceStreamTokenizer.getValue();
            return true;
        }
        return false;
    }

    private void setTabularDataType(JDXDataObject jDXDataObject, String string) {
        if (string.equals("##PEAKASSIGNMENTS")) {
            jDXDataObject.setDataClass("PEAKASSIGNMENTS");
        } else if (string.equals("##PEAKTABLE")) {
            jDXDataObject.setDataClass("PEAKTABLE");
        } else if (string.equals("##XYDATA")) {
            jDXDataObject.setDataClass("XYDATA");
        } else if (string.equals("##XYPOINTS")) {
            jDXDataObject.setDataClass("XYPOINTS");
        }
    }

    private boolean processTabularData(JDXDataObject jDXDataObject, List<String[]> list) throws JSpecViewException {
        if (jDXDataObject.dataClass.equals("PEAKASSIGNMENTS")) {
            return true;
        }
        jDXDataObject.setHeaderTable(list);
        if (jDXDataObject.dataClass.equals("XYDATA")) {
            jDXDataObject.checkRequiredTokens();
            this.decompressData(jDXDataObject, null);
            return true;
        }
        if (jDXDataObject.dataClass.equals("PEAKTABLE") || jDXDataObject.dataClass.equals("XYPOINTS")) {
            jDXDataObject.setContinuous(jDXDataObject.dataClass.equals("XYPOINTS"));
            try {
                this.t.readLineTrimmed();
            }
            catch (IOException iOException) {
                iOException.printStackTrace();
            }
            Coordinate[] coordinateArray = jDXDataObject.xFactor != Double.MAX_VALUE && jDXDataObject.yFactor != Double.MAX_VALUE ? Coordinate.parseDSV(this.t.getValue(), jDXDataObject.xFactor, jDXDataObject.yFactor) : Coordinate.parseDSV(this.t.getValue(), 1.0, 1.0);
            jDXDataObject.setXYCoords(coordinateArray);
            double d = Coordinate.deltaX(coordinateArray[coordinateArray.length - 1].getXVal(), coordinateArray[0].getXVal(), coordinateArray.length);
            jDXDataObject.setIncreasing(d > 0.0);
            return true;
        }
        return false;
    }

    private boolean readNTUPLECoords(JDXDataObject jDXDataObject, Map<String, List<String>> map, String[] stringArray, double[] dArray) {
        if (jDXDataObject.dataClass.equals("XYDATA")) {
            List<String> list = map.get("##SYMBOL");
            int n = list.indexOf(stringArray[0]);
            int n2 = list.indexOf(stringArray[1]);
            list = map.get("##VARNAME");
            jDXDataObject.varName = ((String)list.get(n2)).toUpperCase();
            list = map.get("##FACTOR");
            jDXDataObject.xFactor = Double.parseDouble((String)list.get(n));
            jDXDataObject.yFactor = Double.parseDouble((String)list.get(n2));
            list = map.get("##LAST");
            jDXDataObject.fileLastX = Double.parseDouble((String)list.get(n));
            list = map.get("##FIRST");
            jDXDataObject.fileFirstX = Double.parseDouble((String)list.get(n));
            list = map.get("##VARDIM");
            jDXDataObject.nPointsFile = Integer.parseInt((String)list.get(n));
            list = map.get("##UNITS");
            jDXDataObject.setXUnits((String)list.get(n));
            jDXDataObject.setYUnits((String)list.get(n2));
            if (jDXDataObject.nucleusX == null && (list = map.get("##.NUCLEUS")) != null) {
                jDXDataObject.setNucleus((String)list.get(0), false);
                jDXDataObject.setNucleus((String)list.get(n), true);
            } else if (jDXDataObject.nucleusX == null) {
                jDXDataObject.nucleusX = "?";
            }
            this.decompressData(jDXDataObject, dArray);
            return true;
        }
        if (jDXDataObject.dataClass.equals("PEAKTABLE") || jDXDataObject.dataClass.equals("XYPOINTS")) {
            jDXDataObject.setContinuous(jDXDataObject.dataClass.equals("XYPOINTS"));
            List<String> list = map.get("##SYMBOL");
            int n = list.indexOf(stringArray[0]);
            int n3 = list.indexOf(stringArray[1]);
            list = map.get("##UNITS");
            jDXDataObject.setXUnits((String)list.get(n));
            jDXDataObject.setYUnits((String)list.get(n3));
            jDXDataObject.setXYCoords(Coordinate.parseDSV(this.t.getValue(), jDXDataObject.xFactor, jDXDataObject.yFactor));
            return true;
        }
        return false;
    }

    private void decompressData(JDXDataObject jDXDataObject, double[] dArray) {
        double d;
        int n = this.errorLog.length();
        double d2 = Coordinate.deltaX(jDXDataObject.fileLastX, jDXDataObject.fileFirstX, jDXDataObject.nPointsFile);
        jDXDataObject.setIncreasing(d2 > 0.0);
        jDXDataObject.setContinuous(true);
        JDXDecompressor jDXDecompressor = new JDXDecompressor(this.t, jDXDataObject.fileFirstX, jDXDataObject.xFactor, jDXDataObject.yFactor, d2, jDXDataObject.nPointsFile);
        double[] dArray2 = new double[2];
        long l = System.currentTimeMillis();
        Coordinate[] coordinateArray = jDXDecompressor.decompressData(this.errorLog, dArray2);
        System.out.println("decompression time = " + (System.currentTimeMillis() - l) + " ms");
        jDXDataObject.setXYCoords(coordinateArray);
        double d3 = jDXDecompressor.getMinY();
        if (dArray != null) {
            if (d3 < dArray[0]) {
                dArray[0] = d3;
            }
            if ((d3 = jDXDecompressor.getMaxY()) > dArray[1]) {
                dArray[1] = d3;
            }
        }
        double d4 = d = Double.isNaN(jDXDataObject.freq2dX) ? jDXDataObject.observedFreq : jDXDataObject.freq2dX;
        if (jDXDataObject.offset != Double.MAX_VALUE && d != Double.MAX_VALUE && jDXDataObject.dataType.toUpperCase().contains("SPECTRUM")) {
            Coordinate.applyShiftReference(coordinateArray, jDXDataObject.dataPointNum, jDXDataObject.fileFirstX, jDXDataObject.fileLastX, jDXDataObject.offset, d, jDXDataObject.shiftRefType);
        }
        if (d != Double.MAX_VALUE && jDXDataObject.getXUnits().toUpperCase().equals("HZ")) {
            double d5 = d;
            Coordinate.applyScale(coordinateArray, 1.0 / d5, 1.0);
            jDXDataObject.setXUnits("PPM");
            jDXDataObject.setHZtoPPM(true);
        }
        if (this.errorLog.length() != n) {
            this.errorLog.append(jDXDataObject.getTitle()).append("\n");
            this.errorLog.append("firstX: " + jDXDataObject.fileFirstX + " Found " + dArray2[0] + "\n");
            this.errorLog.append("lastX from Header " + jDXDataObject.fileLastX + " Found " + dArray2[1] + "\n");
            this.errorLog.append("deltaX from Header " + d2 + "\n");
            this.errorLog.append("Number of points in Header " + jDXDataObject.nPointsFile + " Found " + coordinateArray.length + "\n");
        }
        if (Logger.debugging) {
            System.err.println(this.errorLog.toString());
        }
    }

    public static void addHeader(List<String[]> list, String string, String string2) {
        for (int i = 0; i < list.size(); ++i) {
            String[] stringArray = (String[])list.get(i);
            if (!stringArray[0].equals(string)) continue;
            stringArray[1] = string2;
            return;
        }
        list.addLast(new String[]{string, string2, JDXSourceStreamTokenizer.cleanLabel(string)});
    }

    static {
        Arrays.sort(TABULAR_DATA_LABELS);
    }
}

