/*
 * Decompiled with CFR 0.152.
 */
package jspecview.source;

import javajs.util.List;

public class JDXHeader {
    public String title = "";
    public String jcampdx = "5.01";
    public String dataType = "";
    public String dataClass = "";
    public String origin = "";
    public String owner = "PUBLIC DOMAIN";
    public String longDate = "";
    public String date = "";
    public String time = "";
    static final String[] typeNames = new String[]{"ND NMR SPECTRUM   NMR", "NMR SPECTRUM      NMR", "INFRARED SPECTRUM IR", "MASS SPECTRUM     MS", "RAMAN SPECTRUM    RAMAN", "GAS CHROMATOGRAM  GC", "UV/VIS SPECTRUM   UV/VIS"};
    private String qualifiedType;
    protected List<String[]> headerTable = new List();

    public void setTitle(String string) {
        this.title = string;
    }

    public void setJcampdx(String string) {
        this.jcampdx = string;
    }

    public void setDataType(String string) {
        this.dataType = string;
    }

    public void setDataClass(String string) {
        this.dataClass = string;
    }

    public void setOrigin(String string) {
        this.origin = string;
    }

    public void setOwner(String string) {
        this.owner = string;
    }

    public void setLongDate(String string) {
        this.longDate = string;
    }

    public void setDate(String string) {
        this.date = string;
    }

    public void setTime(String string) {
        this.time = string;
    }

    public String getTitle() {
        return this.title;
    }

    static String getTypeName(String string) {
        string = string.toUpperCase();
        for (int i = 0; i < typeNames.length; ++i) {
            if (!typeNames[i].startsWith(string)) continue;
            return typeNames[i].substring(18);
        }
        return string;
    }

    public String getQualifiedDataType() {
        return this.qualifiedType == null ? (this.qualifiedType = JDXHeader.getTypeName(this.dataType)) : this.qualifiedType;
    }

    public String getJcampdx() {
        return this.jcampdx;
    }

    public String getDataType() {
        return this.dataType;
    }

    public String getOrigin() {
        return this.origin;
    }

    public String getOwner() {
        return this.owner;
    }

    public String getLongDate() {
        return this.longDate;
    }

    public String getDate() {
        return this.date;
    }

    public String getTime() {
        return this.time;
    }

    public String getDataClass() {
        return this.dataClass;
    }

    public void setHeaderTable(List<String[]> list) {
        this.headerTable = list;
    }

    public List<String[]> getHeaderTable() {
        return this.headerTable;
    }

    public String[][] getHeaderRowDataAsArray(boolean bl, int n) {
        String[][] stringArray = new String[(bl ? 6 : 5) + this.headerTable.size() + n][];
        int n2 = 0;
        stringArray[n2++] = new String[]{"##TITLE", this.title};
        stringArray[n2++] = new String[]{"##JCAMP-DX", this.jcampdx};
        stringArray[n2++] = new String[]{"##DATA TYPE", this.dataType};
        if (bl) {
            stringArray[n2++] = new String[]{"##DATA CLASS", this.dataClass};
        }
        stringArray[n2++] = new String[]{"##ORIGIN", this.origin};
        stringArray[n2++] = new String[]{"##OWNER", this.owner};
        for (int i = 0; i < this.headerTable.size(); ++i) {
            stringArray[n2++] = (String[])this.headerTable.get(i);
        }
        return stringArray;
    }
}

