/*
 * Decompiled with CFR 0.152.
 */
package jspecview.source;

import java.io.BufferedReader;
import java.io.IOException;
import java.io.InputStream;
import java.io.StringReader;
import java.util.zip.ZipEntry;
import java.util.zip.ZipInputStream;
import javajs.util.SB;
import jspecview.api.JSVZipReader;
import org.jmol.util.Logger;

public class JSVZipFileSequentialReader
extends BufferedReader
implements JSVZipReader {
    private String[] subFileList;
    private ZipInputStream zis;
    private ZipEntry ze;
    private int ptMark;
    private String data;
    private String startCode;
    private int lineCount;
    private byte[] buf = new byte[1024];
    private int len;
    private int pt;
    private char cr = '\u0000';

    public JSVZipFileSequentialReader() {
        super(new StringReader(""));
    }

    @Override
    public JSVZipFileSequentialReader set(InputStream inputStream, String[] stringArray, String string) {
        this.subFileList = stringArray;
        this.zis = new ZipInputStream(inputStream);
        this.startCode = string;
        this.nextEntry();
        return this;
    }

    @Override
    public void close() {
        try {
            this.close();
            this.zis.close();
        }
        catch (IOException iOException) {
            iOException.printStackTrace();
        }
    }

    @Override
    public void mark(int n) {
        this.ptMark = this.pt;
        if (this.len == 0) {
            this.readLine();
            this.pt = this.ptMark;
        }
    }

    @Override
    public void reset() {
        this.pt = this.ptMark;
    }

    @Override
    public int read(char[] cArray, int n, int n2) {
        int n3 = Math.min(this.len - this.pt, n2);
        this.data.getChars(0, n3, cArray, n);
        return n3;
    }

    @Override
    public String readLine() {
        while (this.ze != null) {
            try {
                String string = this.getEntryLine();
                if (string != null) {
                    return string;
                }
            }
            catch (IOException iOException) {
                break;
            }
            this.nextEntry();
        }
        return null;
    }

    private void nextEntry() {
        this.pt = 0;
        this.len = 0;
        this.cr = '\u0000';
        this.lineCount = 0;
        try {
            while ((this.ze = this.zis.getNextEntry()) != null) {
                if (!this.isEntryOK(this.ze.getName())) continue;
                return;
            }
        }
        catch (Exception exception) {
            this.ze = null;
        }
    }

    private boolean isEntryOK(String string) {
        if (this.subFileList == null || this.subFileList.length == 1) {
            return true;
        }
        int n = this.subFileList.length;
        while (--n >= 0) {
            if (!this.subFileList[n].equals(string)) continue;
            Logger.info("...reading zip entry " + string);
            return true;
        }
        Logger.info("...skipping zip entry " + string);
        return false;
    }

    private String getEntryLine() throws IOException {
        SB sB = null;
        while (this.len >= 0 && (this.pt < this.len || this.zis.available() == 1)) {
            int n = this.pt;
            char c = ' ';
            while (this.pt < this.len && c != this.cr) {
                c = this.data.charAt(this.pt++);
                switch (c) {
                    case '\n': {
                        if (this.cr == '\r') {
                            n = this.pt;
                            break;
                        }
                        this.cr = (char)10;
                        break;
                    }
                    case '\r': {
                        if (this.cr == '\n') break;
                        this.cr = (char)13;
                    }
                }
            }
            if (sB == null) {
                sB = new SB();
            }
            if (this.pt != n) {
                sB.append(this.data.substring(n, this.pt + (c == this.cr ? -1 : 0)));
            }
            if (c == this.cr || this.zis.available() != 1 || (this.len = this.zis.read(this.buf, 0, 1024)) < 0) {
                if (this.lineCount++ == 0 && this.startCode != null && sB.indexOf(this.startCode) < 0) {
                    return null;
                }
                return sB.toString();
            }
            this.pt = 0;
            this.data = new String(this.buf, 0, this.len);
            if (this.data.indexOf(0) < 0) continue;
            return null;
        }
        return sB == null ? null : sB.toString();
    }
}

