/*
 * Decompiled with CFR 0.152.
 */
package jspecview.source;

import java.io.BufferedInputStream;
import java.io.BufferedReader;
import java.io.ByteArrayInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.util.zip.GZIPInputStream;
import java.util.zip.ZipEntry;
import java.util.zip.ZipInputStream;
import javajs.util.AU;
import javajs.util.List;
import javajs.util.SB;
import jspecview.api.JSVZipInterface;
import jspecview.api.JSVZipReader;
import jspecview.common.JSViewer;
import org.jmol.util.Logger;

public class JSVZipUtil
implements JSVZipInterface {
    @Override
    public InputStream newGZIPInputStream(InputStream inputStream) throws IOException {
        return new GZIPInputStream(inputStream, 512);
    }

    @Override
    public BufferedReader newJSVZipFileSequentialReader(InputStream inputStream, String[] stringArray, String string) {
        return ((JSVZipReader)JSViewer.getInterface("jspecview.source.JSVZipFileSequentialReader")).set(inputStream, stringArray, string);
    }

    public static boolean isZipFile(byte[] byArray) throws Exception {
        return byArray.length > 4 && byArray[0] == 80 && byArray[1] == 75 && byArray[2] == 3 && byArray[3] == 4;
    }

    public static Object getZipFileContents(InputStream inputStream, String[] stringArray, int n) {
        SB sB = new SB();
        if (stringArray == null || n >= stringArray.length) {
            return JSVZipUtil.getZipDirectoryAsStringAndClose(inputStream);
        }
        String string = stringArray[n];
        ZipInputStream zipInputStream = new ZipInputStream(inputStream);
        try {
            ZipEntry zipEntry;
            boolean bl = string.equals(".");
            if (bl || string.lastIndexOf("/") == string.length() - 1) {
                ZipEntry zipEntry2;
                while ((zipEntry2 = zipInputStream.getNextEntry()) != null) {
                    String string2 = zipEntry2.getName();
                    if (!bl && !string2.startsWith(string)) continue;
                    sB.append(string2).appendC('\n');
                }
                return sB.toString();
            }
            while ((zipEntry = zipInputStream.getNextEntry()) != null) {
                if (!string.equals(zipEntry.getName())) continue;
                byte[] byArray = JSVZipUtil.getZipEntryAsBytes(zipInputStream);
                if (JSVZipUtil.isZipFile(byArray)) {
                    return JSVZipUtil.getZipFileContents(new BufferedInputStream(new ByteArrayInputStream(byArray)), stringArray, ++n);
                }
                return new String(byArray);
            }
        }
        catch (Exception exception) {
            // empty catch block
        }
        return "";
    }

    public static byte[] getZipFileContentsAsBytes(InputStream inputStream, String[] stringArray, int n) {
        byte[] byArray = new byte[]{};
        String string = stringArray[n];
        if (string.lastIndexOf("/") == string.length() - 1) {
            return byArray;
        }
        ZipInputStream zipInputStream = new ZipInputStream(inputStream);
        try {
            ZipEntry zipEntry;
            while ((zipEntry = zipInputStream.getNextEntry()) != null) {
                if (!string.equals(zipEntry.getName())) continue;
                byte[] byArray2 = JSVZipUtil.getZipEntryAsBytes(zipInputStream);
                if (JSVZipUtil.isZipFile(byArray2) && ++n < stringArray.length) {
                    return JSVZipUtil.getZipFileContentsAsBytes(new BufferedInputStream(new ByteArrayInputStream(byArray2)), stringArray, n);
                }
                return byArray2;
            }
        }
        catch (Exception exception) {
            // empty catch block
        }
        return byArray;
    }

    public static String getZipDirectoryAsStringAndClose(InputStream inputStream) {
        SB sB = new SB();
        String[] stringArray = new String[]{};
        try {
            stringArray = JSVZipUtil.getZipDirectoryOrErrorAndClose(inputStream, false);
            inputStream.close();
        }
        catch (Exception exception) {
            Logger.error(exception.getMessage());
        }
        for (int i = 0; i < stringArray.length; ++i) {
            sB.append(stringArray[i]).appendC('\n');
        }
        return sB.toString();
    }

    public static String[] getZipDirectoryAndClose(InputStream inputStream, boolean bl) {
        String[] stringArray = new String[]{};
        try {
            stringArray = JSVZipUtil.getZipDirectoryOrErrorAndClose(inputStream, bl);
            inputStream.close();
        }
        catch (Exception exception) {
            Logger.error(exception.getMessage());
        }
        return stringArray;
    }

    private static String[] getZipDirectoryOrErrorAndClose(InputStream inputStream, boolean bl) throws IOException {
        ZipEntry zipEntry;
        List<String> list = new List<String>();
        ZipInputStream zipInputStream = new ZipInputStream(inputStream);
        String string = null;
        while ((zipEntry = zipInputStream.getNextEntry()) != null) {
            String string2 = zipEntry.getName();
            if (bl && string2.equals("JmolManifest")) {
                string = JSVZipUtil.getZipEntryAsString(zipInputStream);
                continue;
            }
            list.addLast(string2);
        }
        zipInputStream.close();
        if (bl) {
            list.add(0, string == null ? "" : string + "\n############\n");
        }
        int n = list.size();
        String[] stringArray = new String[n];
        for (int i = 0; i < n; ++i) {
            stringArray[i] = (String)list.get(i);
        }
        return stringArray;
    }

    public static String getZipEntryAsString(ZipInputStream zipInputStream) throws IOException {
        int n;
        SB sB = new SB();
        byte[] byArray = new byte[1024];
        while (zipInputStream.available() == 1 && (n = zipInputStream.read(byArray, 0, 1024)) > 0) {
            sB.append(new String(byArray, 0, n));
        }
        return sB.toString();
    }

    public static byte[] getZipEntryAsBytes(ZipInputStream zipInputStream) throws IOException {
        byte[] byArray = new byte[1024];
        byte[] byArray2 = new byte[4096];
        int n = 0;
        int n2 = 0;
        while (zipInputStream.available() == 1 && (n = zipInputStream.read(byArray, 0, 1024)) > 0) {
            if ((n2 += n) >= byArray2.length) {
                byArray2 = AU.ensureLengthByte(byArray2, n2 * 2);
            }
            System.arraycopy(byArray, 0, byArray2, n2 - n, n);
        }
        byArray = new byte[n2];
        System.arraycopy(byArray2, 0, byArray, 0, n2);
        return byArray;
    }

    public static byte[] getStreamAsBytes(BufferedInputStream bufferedInputStream) throws IOException {
        byte[] byArray = new byte[1024];
        byte[] byArray2 = new byte[4096];
        int n = 0;
        int n2 = 0;
        while ((n = bufferedInputStream.read(byArray, 0, 1024)) > 0) {
            if ((n2 += n) >= byArray2.length) {
                byArray2 = AU.ensureLengthByte(byArray2, n2 * 2);
            }
            System.arraycopy(byArray, 0, byArray2, n2 - n, n);
        }
        byArray = new byte[n2];
        System.arraycopy(byArray2, 0, byArray, 0, n2);
        return byArray;
    }
}

