/*
 * Decompiled with CFR 0.152.
 */
package org.jmol.adapter.readers.xml;

import java.util.Hashtable;
import java.util.Map;
import javajs.util.List;
import org.jmol.adapter.readers.xml.XmlReader;
import org.jmol.adapter.smarter.Atom;
import org.jmol.api.Interface;
import org.jmol.api.VolumeDataInterface;
import org.jmol.util.Logger;

public class XmlChem3dReader
extends XmlReader {
    private List<Map<String, Object>> orbitals = new List();
    private Map<String, Object> moData;

    XmlChem3dReader() {
    }

    @Override
    protected String[] getDOMAttributes() {
        return new String[]{"id", "symbol", "cartCoords", "bondAtom1", "bondAtom2", "bondOrder", "gridDatXDim", "gridDatYDim", "gridDatZDim", "gridDatXSize", "gridDatYSize", "gridDatZSize", "gridDatOrigin", "gridDatData", "calcPartialCharges", "calcAtoms"};
    }

    @Override
    protected void processXml(XmlReader xmlReader, Object object) throws Exception {
        this.PX(xmlReader, object);
        this.finalizeMOData(this.moData);
    }

    @Override
    public void processStartElement(String string) {
        int n;
        String[] stringArray;
        if ("model".equals(string)) {
            this.atomSetCollection.newAtomSet();
            return;
        }
        if ("atom".equals(string)) {
            this.atom = new Atom();
            this.atom.atomName = (String)this.atts.get("id");
            this.atom.elementSymbol = (String)this.atts.get("symbol");
            if (this.atts.containsKey("cartCoords")) {
                String string2 = (String)this.atts.get("cartCoords");
                String[] stringArray2 = XmlChem3dReader.getTokensStr((String)string2);
                this.atom.set(this.parseFloatStr(stringArray2[0]), this.parseFloatStr(stringArray2[1]), this.parseFloatStr(stringArray2[2]));
            }
            return;
        }
        if ("bond".equals(string)) {
            String string3 = (String)this.atts.get("bondAtom1");
            String string4 = (String)this.atts.get("bondAtom2");
            int n2 = 1;
            if (this.atts.containsKey("bondOrder")) {
                n2 = this.parseIntStr((String)this.atts.get("bondOrder"));
            }
            this.atomSetCollection.addNewBondFromNames(string3, string4, n2);
            return;
        }
        if ("electronicStructureCalculation".equalsIgnoreCase(string)) {
            stringArray = XmlChem3dReader.getTokensStr((String)((String)this.atts.get("calcPartialCharges")));
            String[] stringArray3 = XmlChem3dReader.getTokensStr((String)((String)this.atts.get("calcAtoms")));
            n = this.parseIntStr(stringArray[0]);
            while (--n >= 0) {
                this.atomSetCollection.mapPartialCharge(stringArray3[n + 1], this.parseFloatStr(stringArray[n + 1]));
            }
        }
        if ("gridData".equalsIgnoreCase(string)) {
            int n3;
            int n4;
            int n5;
            int n6 = this.parseIntStr((String)this.atts.get("gridDatXDim"));
            n = this.parseIntStr((String)this.atts.get("gridDatYDim"));
            int n7 = this.parseIntStr((String)this.atts.get("gridDatZDim"));
            float f = this.parseFloatStr((String)this.atts.get("gridDatXSize")) / (float)n6;
            float f2 = this.parseFloatStr((String)this.atts.get("gridDatYSize")) / (float)n;
            float f3 = this.parseFloatStr((String)this.atts.get("gridDatZSize")) / (float)n7;
            stringArray = XmlChem3dReader.getTokensStr((String)((String)this.atts.get("gridDatOrigin")));
            float f4 = this.parseFloatStr(stringArray[0]);
            float f5 = this.parseFloatStr(stringArray[1]);
            float f6 = this.parseFloatStr(stringArray[2]);
            stringArray = XmlChem3dReader.getTokensStr((String)((String)this.atts.get("gridDatData")));
            int n8 = 1;
            float[][][] fArray = new float[n6][n][n7];
            float f7 = 0.0f;
            for (n5 = 0; n5 < n7; ++n5) {
                for (n4 = 0; n4 < n; ++n4) {
                    for (n3 = 0; n3 < n6; ++n3) {
                        float f8;
                        fArray[n3][n4][n5] = f8 = this.parseFloatStr(stringArray[n8++]);
                        f7 += f8 * f8;
                    }
                }
            }
            f7 = (float)(1.0 / Math.sqrt(f7));
            for (n5 = 0; n5 < n7; ++n5) {
                for (n4 = 0; n4 < n; ++n4) {
                    for (n3 = 0; n3 < n6; ++n3) {
                        float[] fArray2 = fArray[n3][n4];
                        int n9 = n5;
                        fArray2[n9] = fArray2[n9] * f7;
                    }
                }
            }
            VolumeDataInterface volumeDataInterface = (VolumeDataInterface)Interface.getOptionInterface((String)"jvxl.data.VolumeData");
            volumeDataInterface.setVoxelCounts(n6, n, n7);
            volumeDataInterface.setVolumetricVector(0, f, 0.0f, 0.0f);
            volumeDataInterface.setVolumetricVector(1, 0.0f, f2, 0.0f);
            volumeDataInterface.setVolumetricVector(2, 0.0f, 0.0f, f3);
            volumeDataInterface.setVolumetricOrigin(f4, f5, f6);
            volumeDataInterface.setVoxelDataAsArray(fArray);
            if (this.moData == null) {
                this.moData = new Hashtable<String, Object>();
                this.moData.put("defaultCutoff", Float.valueOf(0.01f));
                this.moData.put("haveVolumeData", Boolean.TRUE);
                this.moData.put("calculationType", "Chem3D");
                this.orbitals = new List();
                this.moData.put("mos", this.orbitals);
            }
            Hashtable<String, VolumeDataInterface> hashtable = new Hashtable<String, VolumeDataInterface>();
            hashtable.put("volumeData", volumeDataInterface);
            this.orbitals.addLast(hashtable);
            Logger.info((String)("Chem3D molecular orbital data displayable using ISOSURFACE MO " + this.orbitals.size()));
            return;
        }
    }

    @Override
    void processEndElement(String string) {
        if ("atom".equals(string)) {
            if (this.atom.elementSymbol != null && !Float.isNaN(this.atom.z)) {
                this.parent.setAtomCoord(this.atom);
                this.atomSetCollection.addAtomWithMappedName(this.atom);
            }
            this.atom = null;
            return;
        }
        this.keepChars = false;
        this.chars = null;
    }
}

