/*
 * Decompiled with CFR 0.152.
 */
package javajs.export;

import java.io.IOException;
import java.io.OutputStream;
import java.util.Hashtable;
import java.util.Map;
import javajs.export.PDFObject;
import javajs.util.List;
import javajs.util.SB;

public class PDFCreator {
    private OutputStream os;
    private List<PDFObject> indirectObjects;
    private PDFObject root;
    private PDFObject graphics;
    private int pt;
    private int xrefPt;
    private int count;
    private int height;
    private int width;
    private Map<String, PDFObject> fonts;
    private Map<Object, PDFObject> images;

    public void setOutputStream(OutputStream outputStream) {
        this.os = outputStream;
    }

    public void newDocument(int n, int n2, boolean bl) {
        this.width = bl ? n2 : n;
        this.height = bl ? n : n2;
        System.out.println("Creating PDF with width=" + this.width + " and height=" + this.height);
        this.fonts = new Hashtable<String, PDFObject>();
        this.indirectObjects = new List();
        this.root = this.newObject("Catalog");
        PDFObject pDFObject = this.newObject("Pages");
        PDFObject pDFObject2 = this.newObject("Page");
        PDFObject pDFObject3 = this.newObject(null);
        this.graphics = this.newObject("XObject");
        this.root.addDef("Pages", pDFObject.getRef());
        pDFObject.addDef("Count", "1");
        pDFObject.addDef("Kids", "[ " + pDFObject2.getRef() + " ]");
        pDFObject2.addDef("Parent", pDFObject.getRef());
        pDFObject2.addDef("MediaBox", "[ 0 0 " + n + " " + n2 + " ]");
        if (bl) {
            pDFObject2.addDef("Rotate", "90");
        }
        pDFObject3.addDef("Length", "?");
        pDFObject3.append((bl ? "q 0 1 1 0 0 0 " : "q 1 0 0 -1 0 " + n2) + " cm /" + this.graphics.getID() + " Do Q");
        pDFObject2.addDef("Contents", pDFObject3.getRef());
        this.addProcSet(pDFObject2);
        this.addProcSet(this.graphics);
        this.graphics.addDef("Subtype", "/Form");
        this.graphics.addDef("FormType", "1");
        this.graphics.addDef("BBox", "[0 0 " + this.width + " " + this.height + "]");
        this.graphics.addDef("Matrix", "[1 0 0 1 0 0]");
        this.graphics.addDef("Length", "?");
        pDFObject2.addResource("XObject", this.graphics.getID(), this.graphics.getRef());
        this.g("q 1 w 1 J 1 j 10 M []0 d q ");
        this.clip(0, 0, this.width, this.height);
    }

    private void addProcSet(PDFObject pDFObject) {
        pDFObject.addResource(null, "ProcSet", "[/PDF /Text /ImageB /ImageC /ImageI]");
    }

    private void clip(int n, int n2, int n3, int n4) {
        this.moveto(n, n2);
        this.lineto(n3, n2);
        this.lineto(n3, n4);
        this.lineto(n, n4);
        this.g("h W n");
    }

    public void moveto(int n, int n2) {
        this.g(n + " " + n2 + " m");
    }

    public void lineto(int n, int n2) {
        this.g(n + " " + n2 + " l");
    }

    private PDFObject newObject(String string) {
        PDFObject pDFObject = new PDFObject(++this.count);
        if (string != null) {
            pDFObject.addDef("Type", "/" + string);
        }
        this.indirectObjects.addLast(pDFObject);
        return pDFObject;
    }

    public void addInfo(Map<String, String> map) {
        Hashtable<String, String> hashtable = new Hashtable<String, String>();
        for (Map.Entry<String, String> entry : map.entrySet()) {
            String string = "(" + entry.getValue().replace(')', '_').replace('(', '_') + ")";
            hashtable.put(entry.getKey(), string);
        }
        this.root.addDef("Info", hashtable);
    }

    private PDFObject addFontResource(String string) {
        PDFObject pDFObject = this.newObject("Font");
        this.fonts.put(string, pDFObject);
        pDFObject.addDef("BaseFont", string);
        pDFObject.addDef("Encoding", "/WinAnsiEncoding");
        pDFObject.addDef("Subtype", "/Type1");
        this.graphics.addResource("Font", pDFObject.getID(), pDFObject.getRef());
        return pDFObject;
    }

    public void addImageResource(Object object, int n, int n2, int[] nArray, boolean bl) {
        PDFObject pDFObject = this.newObject("XObject");
        if (this.images == null) {
            this.images = new Hashtable<Object, PDFObject>();
        }
        this.images.put(object, pDFObject);
        pDFObject.addDef("Subtype", "/Image");
        pDFObject.addDef("Length", "?");
        pDFObject.addDef("ColorSpace", bl ? "/DeviceRGB" : "/DeviceGray");
        pDFObject.addDef("BitsPerComponent", "8");
        pDFObject.addDef("Width", "" + n);
        pDFObject.addDef("Height", "" + n2);
        this.graphics.addResource("XObject", pDFObject.getID(), pDFObject.getRef());
        int n3 = nArray.length;
        byte[] byArray = new byte[n3 * (bl ? 3 : 1)];
        if (bl) {
            int n4 = 0;
            for (int i = 0; i < n3; ++i) {
                byArray[n4++] = (byte)(nArray[i] >> 16 & 0xFF);
                byArray[n4++] = (byte)(nArray[i] >> 8 & 0xFF);
                byArray[n4++] = (byte)(nArray[i] & 0xFF);
            }
        } else {
            for (int i = 0; i < n3; ++i) {
                byArray[i] = (byte)nArray[i];
            }
        }
        pDFObject.setStream(byArray);
        this.graphics.addResource("XObject", pDFObject.getID(), pDFObject.getRef());
    }

    public void g(String string) {
        this.graphics.append(string).appendC('\n');
    }

    private void output(String string) throws IOException {
        byte[] byArray = string.getBytes();
        this.os.write(byArray, 0, byArray.length);
        this.pt += byArray.length;
    }

    public void closeDocument() throws IOException {
        this.g("Q Q");
        this.outputHeader();
        this.writeObjects();
        this.writeXRefTable();
        this.writeTrailer();
        this.os.flush();
        this.os.close();
    }

    private void outputHeader() throws IOException {
        this.output("%PDF-1.3\n%");
        byte[] byArray = new byte[]{-1, -1, -1, -1};
        this.os.write(byArray, 0, byArray.length);
        this.pt += 4;
        this.output("\n");
    }

    private void writeTrailer() throws IOException {
        PDFObject pDFObject = new PDFObject(-2);
        this.output("trailer");
        pDFObject.addDef("Size", "" + this.indirectObjects.size());
        pDFObject.addDef("Root", this.root.getRef());
        pDFObject.output(this.os);
        this.output("startxref\n");
        this.output("" + this.xrefPt + "\n");
        this.output("%%EOF\n");
    }

    private void writeObjects() throws IOException {
        PDFObject pDFObject;
        int n;
        int n2 = this.indirectObjects.size();
        for (n = 0; n < n2; ++n) {
            pDFObject = (PDFObject)this.indirectObjects.get(n);
            if (!pDFObject.isFont()) continue;
            pDFObject.pt = this.pt;
            this.pt += pDFObject.output(this.os);
        }
        for (n = 0; n < n2; ++n) {
            pDFObject = (PDFObject)this.indirectObjects.get(n);
            if (pDFObject.isFont()) continue;
            pDFObject.pt = this.pt;
            this.pt += pDFObject.output(this.os);
        }
    }

    private void writeXRefTable() throws IOException {
        this.xrefPt = this.pt;
        int n = this.indirectObjects.size();
        SB sB = new SB();
        sB.append("xref\n0 " + (n + 1) + "\n0000000000 65535 f\r\n");
        for (int i = 0; i < n; ++i) {
            PDFObject pDFObject = (PDFObject)this.indirectObjects.get(i);
            String string = "0000000000" + pDFObject.pt;
            sB.append(string.substring(string.length() - 10));
            sB.append(" 00000 n\r\n");
        }
        this.output(sB.toString());
    }

    public boolean canDoLineTo() {
        return true;
    }

    public void fill() {
        this.g("f");
    }

    public void stroke() {
        this.g("S");
    }

    public void doCircle(int n, int n2, int n3, boolean bl) {
        double d = (double)(n3 * 4) * (Math.sqrt(2.0) - 1.0) / 3.0;
        double d2 = n;
        double d3 = n2;
        this.g(d2 + (double)n3 + " " + d3 + " m");
        this.g(d2 + (double)n3 + " " + (d3 + d) + " " + (d2 + d) + " " + (d3 + (double)n3) + " " + d2 + " " + (d3 + (double)n3) + " " + " c");
        this.g(d2 - d + " " + (d3 + (double)n3) + " " + (d2 - (double)n3) + " " + (d3 + d) + " " + (d2 - (double)n3) + " " + d3 + " c");
        this.g(d2 - (double)n3 + " " + (d3 - d) + " " + (d2 - d) + " " + (d3 - (double)n3) + " " + d2 + " " + (d3 - (double)n3) + " c");
        this.g(d2 + d + " " + (d3 - (double)n3) + " " + (d2 + (double)n3) + " " + (d3 - d) + " " + (d2 + (double)n3) + " " + d3 + " c");
        this.g(bl ? "f" : "s");
    }

    public void doPolygon(int[] nArray, int[] nArray2, int n, boolean bl) {
        this.moveto(nArray[0], nArray2[0]);
        for (int i = 1; i < n; ++i) {
            this.lineto(nArray[i], nArray2[i]);
        }
        this.g(bl ? "f" : "s");
    }

    public void doRect(int n, int n2, int n3, int n4, boolean bl) {
        this.g(n + " " + n2 + " " + n3 + " " + n4 + " re " + (bl ? "f" : "s"));
    }

    public void drawImage(Object object, int n, int n2, int n3, int n4, int n5, int n6, int n7, int n8) {
        PDFObject pDFObject = this.images.get(object);
        if (pDFObject == null) {
            return;
        }
        this.g("q");
        this.clip(n, n2, n3, n4);
        double d = Double.parseDouble((String)pDFObject.getDef("Width"));
        double d2 = Double.parseDouble((String)pDFObject.getDef("Height"));
        double d3 = n3 - n + 1;
        double d4 = n4 - n2 + 1;
        double d5 = n7 - n5 + 1;
        double d6 = n8 - n6 + 1;
        double d7 = d3 / d5;
        double d8 = d4 / d6;
        double d9 = (double)n - (double)n5 * d7;
        double d10 = (double)n2 + (d2 - (double)n6) * d8;
        this.g(d7 * d + " 0 0 " + -d8 * d2 + " " + d9 + " " + d10 + " cm");
        this.g("/" + pDFObject.getID() + " Do");
        this.g("Q");
    }

    public void drawStringRotated(String string, int n, int n2, int n3) {
        this.g("q " + this.getRotation(n3) + " " + n + " " + n2 + " cm BT(" + string + ")Tj ET Q");
    }

    public String getRotation(int n) {
        float f = 0.0f;
        float f2 = 0.0f;
        switch (n) {
            case 0: {
                f = 1.0f;
                break;
            }
            case 90: {
                f2 = 1.0f;
                break;
            }
            case -90: {
                f2 = -1.0f;
                break;
            }
            case 180: {
                f = -1.0f;
                break;
            }
            default: {
                float f3 = (float)((double)n / 180.0 * Math.PI);
                f = (float)Math.cos(f3);
                f2 = (float)Math.sin(f3);
                if ((double)Math.abs(f) < 1.0E-4) {
                    f = 0.0f;
                }
                if (!((double)Math.abs(f2) < 1.0E-4)) break;
                f2 = 0.0f;
            }
        }
        return f + " " + f2 + " " + f2 + " " + -f;
    }

    public void setColor(float[] fArray, boolean bl) {
        this.g(fArray[0] + " " + fArray[1] + " " + fArray[2] + (bl ? " rg" : " RG"));
    }

    public void setFont(String string, float f) {
        PDFObject pDFObject = this.fonts.get(string);
        if (pDFObject == null) {
            pDFObject = this.addFontResource(string);
        }
        this.g("/" + pDFObject.getID() + " " + f + " Tf");
    }

    public void setLineWidth(float f) {
        this.g(f + " w");
    }

    public void translateScale(float f, float f2, float f3) {
        this.g(f3 + " 0 0 " + f3 + " " + f + " " + f2 + " cm");
    }
}

