/*
 * Decompiled with CFR 0.152.
 */
package jspecview.common;

import jspecview.common.Annotation;
import jspecview.common.Coordinate;
import jspecview.common.JDXSpectrum;

public class Measurement
extends Annotation {
    private Coordinate pt2 = new Coordinate();
    protected double value;

    public Measurement setM1(double d, double d2, JDXSpectrum jDXSpectrum) {
        this.setA(d, d2, jDXSpectrum, "", false, false, 0, 6);
        this.setPt2(this.getXVal(), this.getYVal());
        return this;
    }

    public Measurement copyM() {
        Measurement measurement = new Measurement();
        measurement.setA(this.getXVal(), this.getYVal(), this.spec, this.text, false, false, this.offsetX, this.offsetY);
        measurement.setPt2(this.pt2.getXVal(), this.pt2.getYVal());
        return measurement;
    }

    public Measurement setPt2(JDXSpectrum jDXSpectrum, boolean bl) {
        this.spec = jDXSpectrum;
        if (bl) {
            this.setPt2(this.getXVal(), this.getYVal());
        }
        return this;
    }

    public void setPt2(double d, double d2) {
        this.pt2.setXVal(d);
        this.pt2.setYVal(d2);
        this.value = Math.abs(d - this.getXVal());
        this.text = this.spec.setMeasurementText(this);
    }

    public JDXSpectrum getSpectrum() {
        return this.spec;
    }

    public void setValue(double d) {
        this.value = d;
        this.text = this.spec.setMeasurementText(this);
    }

    public double getValue() {
        return this.value;
    }

    public double getXVal2() {
        return this.pt2.getXVal();
    }

    public double getYVal2() {
        return this.pt2.getYVal();
    }

    @Override
    public void addSpecShift(double d) {
        this.setXVal(this.getXVal() + d);
        this.pt2.setXVal(this.pt2.getXVal() + d);
    }

    public void setYVal2(double d) {
        this.pt2.setYVal(d);
    }

    public boolean overlaps(double d, double d2) {
        return Math.min(this.getXVal(), this.getXVal2()) < Math.max(d, d2) && Math.max(this.getXVal(), this.getXVal2()) > Math.min(d, d2);
    }

    @Override
    public String toString() {
        return "[" + this.getXVal() + "," + this.pt2.getXVal() + "]";
    }
}

