/*
 * Decompiled with CFR 0.152.
 */
package jspecview.common;

import java.util.Hashtable;
import java.util.Map;
import javajs.util.List;
import javajs.util.SB;
import jspecview.common.ScriptTokenizer;

public enum ScriptToken {
    UNKNOWN,
    APPLETID,
    APPLETREADYCALLBACKFUNCTIONNAME,
    AUTOINTEGRATE("TF"),
    BACKGROUNDCOLOR("C"),
    CLOSE("spectrumId or fileName or ALL"),
    COMPOUNDMENUON("TF"),
    COORDCALLBACKFUNCTIONNAME,
    COORDINATESCOLOR("C"),
    COORDINATESON("T"),
    DEBUG("TF"),
    DISPLAYFONTNAME("fontName"),
    DISPLAY1D("T"),
    DISPLAY2D("T"),
    ENABLEZOOM("T"),
    ENDINDEX,
    FINDX("x-value"),
    GETPROPERTY("[ALL] [propertyName]"),
    GETSOLUTIONCOLOR,
    GRIDCOLOR("C"),
    GRIDON("T"),
    HIDDEN("TF"),
    HIGHLIGHTCOLOR("C"),
    INTEGRALOFFSET("percent"),
    INTEGRALRANGE("percent"),
    INTEGRATE,
    INTEGRATION("ON/OFF/AUTO/TOGGLE/MIN value/MARK ppm1-ppm2:norm,ppm3-ppm4,... (start with 0-0 to clear)"),
    INTEGRALPLOTCOLOR,
    INTEGRATIONRATIOS,
    INTERFACE,
    IRMODE("A or T or TOGGLE"),
    JMOL("...Jmol command..."),
    JSV,
    LABEL("x y [color and/or \"text\"]"),
    LINK("AB or ABC or NONE or ALL"),
    LOAD("[APPEND] \"fileName\" [first] [last]; use \"\" to reload current file"),
    LOADFILECALLBACKFUNCTIONNAME,
    LOADIMAGINARY("T/F - default is to NOT load imaginary spectra"),
    MENUON,
    OBSCURE,
    OVERLAY,
    OVERLAYSTACKED("TF"),
    PEAK("<type(IR,CNMR,HNMR,MS, etc)> id=xxx or \"match\" [ALL], for example: PEAK HNMR id=3"),
    PEAKCALLBACKFUNCTIONNAME,
    PEAKLIST(" Example: PEAKLIST threshold=20 [%, or include=10] skip=0 interpolate=parabolic [or NONE]"),
    PEAKTABCOLOR("C"),
    PLOTAREACOLOR("C"),
    PLOTCOLOR("C"),
    PLOTCOLORS("color,color,color,..."),
    PRINT,
    REVERSEPLOT("T"),
    SCALEBY("factor"),
    SCALECOLOR("C"),
    SCRIPT("filename.jsv"),
    SELECT("spectrumID, spectrumID,..."),
    SETPEAK("x (ppm) or NONE does peak search, unlike SETX -- NMR only"),
    SETX("x (ppm) does no peak search, unlike SETPEAK -- NMR only"),
    SHIFTX("dx (ppm) or NONE -- NMR only"),
    SHOWERRORS,
    SHOWINTEGRATION("T"),
    SHOWKEY("T"),
    SHOWMEASUREMENTS("T"),
    SHOWMENU,
    SHOWPEAKLIST("T"),
    SHOWPROPERTIES,
    SHOWSOURCE,
    SPECTRUM("spectrumID"),
    SPECTRUMNUMBER,
    STACKOFFSETY("percent"),
    STARTINDEX,
    SYNCCALLBACKFUNCTIONNAME,
    SYNCID,
    TEST,
    TITLEON("T"),
    TITLEBOLDON("T"),
    TITLECOLOR("C"),
    TITLEFONTNAME("fontName"),
    UNITSCOLOR("C"),
    VERSION,
    VIEW("spectrumID, spectrumID, ... Example: VIEW 3.1, 3.2  or  VIEW \"acetophenone\""),
    XSCALEON("T"),
    XUNITSON("T"),
    YSCALE("[ALL] lowValue highValue"),
    YSCALEON("T"),
    YUNITSON("T"),
    WINDOW,
    WRITE("[XY,DIF,DIFDUP,PAC,FIX,SQZ,AML,CML,JPG,PDF,PNG,SVG] \"filename\""),
    ZOOM("OUT or x1,x2 or x1,y1 x2,y2"),
    ZOOMBOXCOLOR,
    ZOOMBOXCOLOR2;

    private String tip;
    public static Map<String, ScriptToken> htParams;

    public String getTip() {
        return "  " + (this.tip == "T" ? "TRUE/FALSE/TOGGLE" : (this.tip == "TF" ? "TRUE or FALSE" : (this.tip == "C" ? "<color>" : this.tip)));
    }

    private ScriptToken() {
    }

    private ScriptToken(String string2) {
        this.tip = string2;
    }

    public static ScriptToken getScriptToken(String string) {
        Object object;
        if (htParams == null) {
            htParams = new Hashtable<String, ScriptToken>();
            object = ScriptToken.values();
            int n = ((ScriptToken[])object).length;
            for (int i = 0; i < n; ++i) {
                ScriptToken scriptToken = object[i];
                htParams.put(scriptToken.name(), scriptToken);
            }
        }
        return (object = htParams.get(string.toUpperCase())) == null ? UNKNOWN : object;
    }

    public static List<ScriptToken> getScriptTokenList(String string, boolean bl) {
        string = string.toUpperCase();
        List<ScriptToken> list = new List<ScriptToken>();
        ScriptToken scriptToken = ScriptToken.getScriptToken(string);
        if (bl) {
            if (scriptToken != null) {
                list.addLast(scriptToken);
            }
        } else {
            for (Map.Entry<String, ScriptToken> entry : htParams.entrySet()) {
                if (!entry.getKey().startsWith(string) || entry.getValue().tip == null) continue;
                list.addLast(entry.getValue());
            }
        }
        return list;
    }

    public static String getValue(ScriptToken scriptToken, ScriptTokenizer scriptTokenizer, String string) {
        if (!scriptTokenizer.hasMoreTokens()) {
            return "";
        }
        switch (scriptToken) {
            default: {
                return ScriptTokenizer.nextStringToken(scriptTokenizer, true);
            }
            case CLOSE: 
            case GETPROPERTY: 
            case INTEGRATION: 
            case INTEGRATE: 
            case JMOL: 
            case LABEL: 
            case LOAD: 
            case PEAK: 
            case PLOTCOLORS: 
            case YSCALE: 
            case WRITE: {
                return ScriptToken.removeCommandName(string);
            }
            case SELECT: 
            case OVERLAY: 
            case VIEW: 
            case ZOOM: 
        }
        return ScriptToken.removeCommandName(string).replace(',', ' ').trim();
    }

    private static String removeCommandName(String string) {
        int n = string.indexOf(" ");
        if (n < 0) {
            return "";
        }
        return string.substring(n).trim();
    }

    public static String getKey(ScriptTokenizer scriptTokenizer) {
        String string = scriptTokenizer.nextToken();
        if (string.startsWith("#") || string.startsWith("//")) {
            return null;
        }
        if (string.equalsIgnoreCase("SET")) {
            string = scriptTokenizer.nextToken();
        }
        return string.toUpperCase();
    }

    public static List<String> getTokens(String string) {
        String string2;
        List<String> list = new List<String>();
        ScriptTokenizer scriptTokenizer = new ScriptTokenizer(string, false);
        while (scriptTokenizer.hasMoreTokens() && !(string2 = ScriptTokenizer.nextStringToken(scriptTokenizer, false)).startsWith("//") && !string2.startsWith("#")) {
            list.addLast(string2);
        }
        return list;
    }

    public static String getNameList(List<ScriptToken> list) {
        if (list.size() == 0) {
            return "";
        }
        SB sB = new SB();
        for (int i = 0; i < list.size(); ++i) {
            sB.append(",").append(((ScriptToken)((Object)list.get(i))).toString());
        }
        return sB.toString().substring(1);
    }
}

