/*
 * Decompiled with CFR 0.152.
 */
package jspecview.export;

import java.io.IOException;
import javajs.util.List;
import javajs.util.OC;
import jspecview.common.Coordinate;
import jspecview.common.JDXSpectrum;
import jspecview.common.JSViewer;
import jspecview.export.FormExporter;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
abstract class XMLExporter
extends FormExporter {
    protected boolean continuous;
    protected String title;
    protected String ident;
    protected String state;
    protected String xUnits;
    protected String yUnits;
    protected String xUnitFactor = "";
    protected String xUnitExponent = "1";
    protected String xUnitLabel;
    protected String yUnitLabel;
    protected String datatype;
    protected String owner;
    protected String origin;
    protected String spectypeInitials = "";
    protected String longdate;
    protected String date;
    protected String time;
    protected String vendor = "";
    protected String model = "";
    protected String resolution = "";
    protected String pathlength = "";
    protected String molform = "";
    protected String bp = "";
    protected String mp = "";
    protected String casRN = "";
    protected String casName = "";
    protected String obNucleus = "";
    protected double obFreq;
    protected double firstX;
    protected double lastX;
    protected double deltaX;
    protected String solvRef = "";
    protected String solvName = "";
    protected int startIndex;
    protected int endIndex;
    protected Coordinate[] xyCoords;
    protected int npoints;
    protected List<Coordinate> newXYCoords = new List();
    private static final String[] params = new String[]{"##STATE", "##RESOLUTION", "##SPECTROMETER", "##$MANUFACTURER", "##MOLFORM", "##CASREGISTRYNO", "##CASNAME", "##MP", "##BP", "##.OBSERVENUCLEUS", "##.SOLVENTNAME", "##.SOLVENTREFERENCE"};
    private static final int PARAM_STATE = 0;
    private static final int PARAM_RESOLUTION = 1;
    private static final int PARAM_SPECTROMETER = 2;
    private static final int PARAM_MANUFACTURER = 3;
    private static final int PARAM_MOLFORM = 4;
    private static final int PARAM_CASREGISTRYNO = 5;
    private static final int PARAM_CASNAME = 6;
    private static final int PARAM_MP = 7;
    private static final int PARAM_BP = 8;
    private static final int PARAM_OBSERVENUCLEUS = 9;
    private static final int PARAM_SOLVENTNAME = 10;
    private static final int PARAM_SOLVENTREFERENCE = 11;

    XMLExporter() {
    }

    protected boolean setup(JSViewer viewer, JDXSpectrum spec, OC out, int startIndex, int endIndex) {
        this.startIndex = startIndex;
        this.endIndex = endIndex;
        this.initForm(viewer, out);
        return this.setParameters(spec);
    }

    protected boolean setParameters(JDXSpectrum spec) {
        this.continuous = spec.isContinuous();
        if (!this.continuous) {
            return false;
        }
        this.xyCoords = spec.getXYCoords();
        this.npoints = this.endIndex - this.startIndex + 1;
        int i = this.startIndex;
        while (i <= this.endIndex) {
            this.newXYCoords.addLast(this.xyCoords[i]);
            ++i;
        }
        this.title = spec.getTitle();
        this.xUnits = spec.getXUnits().toUpperCase();
        this.yUnits = spec.getYUnits().toUpperCase();
        if (this.xUnits.equals("1/CM")) {
            this.xUnitLabel = "1/cm";
            this.xUnitFactor = "0.01";
            this.xUnitExponent = "-1";
        } else if (this.xUnits.equals("UM") || this.xUnits.equals("MICROMETERS")) {
            this.xUnitLabel = "um";
            this.xUnitFactor = "0.000001";
        } else if (this.xUnits.equals("NM") || this.xUnits.equals("NANOMETERS") || this.xUnits.equals("WAVELENGTH")) {
            this.xUnitLabel = "nm";
            this.xUnitFactor = "0.000000001";
        } else if (this.xUnits.equals("PM") || this.xUnits.equals("PICOMETERS")) {
            this.xUnitLabel = "pm";
            this.xUnitFactor = "0.000000000001";
        } else {
            this.xUnitLabel = "Arb. Units";
            this.xUnitFactor = "";
        }
        this.yUnitLabel = this.yUnits.equals("A") || this.yUnits.equals("ABS") || this.yUnits.equals("ABSORBANCE") || this.yUnits.equals("AU") || this.yUnits.equals("AUFS") || this.yUnits.equals("OPTICAL DENSITY") ? "Absorbance" : (this.yUnits.equals("T") || this.yUnits.equals("TRANSMITTANCE") ? "Transmittance" : (this.yUnits.equals("COUNTS") || this.yUnits.equals("CTS") ? "Counts" : "Arb. Units"));
        this.owner = spec.getOwner();
        this.origin = spec.getOrigin();
        this.time = spec.getTime();
        this.longdate = spec.getLongDate();
        this.date = spec.getDate();
        if (this.longdate.equals("") || this.date.equals("")) {
            this.longdate = this.currentTime;
        }
        if (this.date.length() == 8 && this.date.charAt(0) < '5') {
            this.longdate = "20" + this.date + " " + this.time;
        }
        if (this.date.length() == 8 && this.date.charAt(0) > '5') {
            this.longdate = "19" + this.date + " " + this.time;
        }
        this.obFreq = spec.getObservedFreq();
        this.firstX = this.xyCoords[this.startIndex].getXVal();
        this.lastX = this.xyCoords[this.endIndex].getXVal();
        this.deltaX = spec.getDeltaX();
        this.datatype = spec.getDataType();
        if (this.datatype.contains("NMR")) {
            this.firstX *= this.obFreq;
            this.lastX *= this.obFreq;
            this.deltaX *= this.obFreq;
        }
        this.setParams(spec.getHeaderTable());
        return true;
    }

    private static int getParamIndex(String label) {
        int i = 0;
        while (i < params.length) {
            if (params[i].equalsIgnoreCase(label)) {
                return i;
            }
            ++i;
        }
        return -1;
    }

    private void setParams(List<String[]> table) {
        int i = 0;
        while (i < table.size()) {
            String[] entry = (String[])table.get(i);
            String val = entry[1];
            switch (XMLExporter.getParamIndex(entry[0])) {
                case 0: {
                    this.state = val;
                    break;
                }
                case 1: {
                    this.resolution = val;
                    break;
                }
                case 2: {
                    this.model = val;
                    break;
                }
                case 3: {
                    this.vendor = val;
                    break;
                }
                case 4: {
                    this.molform = val;
                    break;
                }
                case 5: {
                    this.casRN = val;
                    break;
                }
                case 6: {
                    this.casName = val;
                    break;
                }
                case 7: {
                    this.mp = val;
                    break;
                }
                case 8: {
                    this.bp = val;
                    break;
                }
                case 9: {
                    this.obNucleus = val;
                    break;
                }
                case 10: {
                    this.solvName = val;
                    break;
                }
                case 11: {
                    this.solvRef = val;
                }
            }
            ++i;
        }
    }

    protected void setContext() {
        this.context.put("continuous", this.continuous);
        this.context.put("file", String.valueOf(this.out.getFileName()));
        this.context.put("title", this.title);
        this.context.put("ident", this.ident);
        this.context.put("state", this.state);
        this.context.put("firstX", new Double(this.firstX));
        this.context.put("lastX", new Double(this.lastX));
        this.context.put("xyCoords", this.newXYCoords);
        this.context.put("xdata_type", "Float32");
        this.context.put("ydata_type", "Float32");
        this.context.put("npoints", this.npoints);
        this.context.put("xencode", "avs");
        this.context.put("yencode", "ivs");
        this.context.put("xUnits", this.xUnits);
        this.context.put("yUnits", this.yUnits);
        this.context.put("xUnitLabel", this.xUnitLabel);
        this.context.put("yUnitLabel", this.yUnitLabel);
        this.context.put("specinits", this.spectypeInitials);
        this.context.put("deltaX", new Double(this.deltaX));
        this.context.put("owner", this.owner);
        this.context.put("origin", this.origin);
        this.context.put("timestamp", this.longdate);
        this.context.put("DataType", this.datatype);
        this.context.put("currenttime", this.currentTime);
        this.context.put("resolution", this.resolution);
        this.context.put("pathlength", this.pathlength);
        this.context.put("molform", this.molform);
        this.context.put("CASrn", this.casRN);
        this.context.put("CASn", this.casName);
        this.context.put("mp", this.mp);
        this.context.put("bp", this.bp);
        this.context.put("ObFreq", new Double(this.obFreq));
        this.context.put("ObNucleus", this.obNucleus);
        this.context.put("SolvName", this.solvName);
        this.context.put("SolvRef", this.solvRef);
        this.context.put("vendor", this.vendor);
        this.context.put("model", this.model);
    }

    String writeFormType(String type) throws IOException {
        return this.writeForm(String.valueOf(type) + (this.datatype.contains("NMR") ? "_nmr" : "_tmp") + ".vm");
    }
}

