/*
 * Decompiled with CFR 0.152.
 */
package jspecview.java;

import java.awt.Component;
import java.awt.event.KeyEvent;
import java.awt.event.KeyListener;
import java.awt.event.MouseEvent;
import java.awt.event.MouseListener;
import java.awt.event.MouseMotionListener;
import java.awt.event.MouseWheelEvent;
import java.awt.event.MouseWheelListener;
import javajs.api.EventManager;
import javajs.api.GenericMouseInterface;
import jspecview.api.JSVPanel;
import org.jmol.util.Logger;

class Mouse
implements MouseWheelListener,
MouseListener,
MouseMotionListener,
KeyListener,
GenericMouseInterface {
    private JSVPanel viewer;
    private EventManager pd;
    private boolean isMouseDown;
    private int xWhenPressed;
    private int yWhenPressed;
    private int modifiersWhenPressed10;

    Mouse(JSVPanel jsvp) {
        this.viewer = jsvp;
        this.pd = jsvp.getPanelData();
        Component display = (Component)((Object)jsvp);
        display.addKeyListener(this);
        display.addMouseListener(this);
        display.addMouseMotionListener(this);
        display.addMouseWheelListener(this);
    }

    public void clear() {
    }

    public void dispose() {
        Component display = (Component)((Object)this.viewer);
        display.removeMouseListener(this);
        display.removeMouseMotionListener(this);
        display.removeMouseWheelListener(this);
        display.removeKeyListener(this);
    }

    public boolean processEvent(int id, int x, int y, int modifiers, long time) {
        modifiers = Mouse.applyLeftMouse(modifiers);
        switch (id) {
            case 501: {
                this.xWhenPressed = x;
                this.yWhenPressed = y;
                this.modifiersWhenPressed10 = modifiers;
                this.mousePressed(time, x, y, modifiers, false);
                break;
            }
            case 506: {
                this.mouseDragged(time, x, y, modifiers);
                break;
            }
            case 504: {
                this.mouseEntered(time, x, y);
                break;
            }
            case 505: {
                this.mouseExited(time, x, y);
                break;
            }
            case 503: {
                this.mouseMoved(time, x, y, modifiers);
                break;
            }
            case 502: {
                this.mouseReleased(time, x, y, modifiers);
                if (x != this.xWhenPressed || y != this.yWhenPressed || modifiers != this.modifiersWhenPressed10) break;
                this.mouseClicked(time, x, y, modifiers, 1);
                break;
            }
            default: {
                return false;
            }
        }
        return true;
    }

    public void mouseClicked(MouseEvent e) {
        this.mouseClicked(e.getWhen(), e.getX(), e.getY(), e.getModifiers(), e.getClickCount());
    }

    public void mouseEntered(MouseEvent e) {
        this.mouseEntered(e.getWhen(), e.getX(), e.getY());
    }

    public void mouseExited(MouseEvent e) {
        this.mouseExited(e.getWhen(), e.getX(), e.getY());
    }

    public void mousePressed(MouseEvent e) {
        this.mousePressed(e.getWhen(), e.getX(), e.getY(), e.getModifiers(), e.isPopupTrigger());
    }

    public void mouseReleased(MouseEvent e) {
        this.mouseReleased(e.getWhen(), e.getX(), e.getY(), e.getModifiers());
    }

    public void mouseDragged(MouseEvent e) {
        int modifiers = e.getModifiers();
        if ((modifiers & 0x1C) == 0) {
            modifiers |= 0x10;
        }
        this.mouseDragged(e.getWhen(), e.getX(), e.getY(), modifiers);
    }

    public void mouseMoved(MouseEvent e) {
        this.mouseMoved(e.getWhen(), e.getX(), e.getY(), e.getModifiers());
    }

    public void mouseWheelMoved(MouseWheelEvent e) {
        e.consume();
        this.mouseWheel(e.getWhen(), e.getWheelRotation(), e.getModifiers() | 0x20);
    }

    public void keyTyped(KeyEvent ke) {
        char ch = ke.getKeyChar();
        int modifiers = ke.getModifiers();
        if (Logger.debuggingHigh) {
            Logger.info("MouseManager keyTyped: " + ch + " " + ('\u0000' + ch) + " " + modifiers);
        }
        if (this.pd.keyTyped(ch, modifiers)) {
            ke.consume();
        }
    }

    public void keyPressed(KeyEvent ke) {
        if (this.pd.keyPressed(ke.getKeyCode(), ke.getModifiers())) {
            ke.consume();
        }
    }

    public void keyReleased(KeyEvent ke) {
        this.pd.keyReleased(ke.getKeyCode());
    }

    private void mouseEntered(long time, int x, int y) {
        this.pd.mouseEnterExit(time, x, y, false);
    }

    private void mouseExited(long time, int x, int y) {
        this.pd.mouseEnterExit(time, x, y, true);
    }

    private void mouseClicked(long time, int x, int y, int modifiers, int clickCount) {
        this.pd.mouseAction(2, time, x, y, 1, modifiers);
    }

    private void mouseMoved(long time, int x, int y, int modifiers) {
        if (this.isMouseDown) {
            this.pd.mouseAction(1, time, x, y, 0, Mouse.applyLeftMouse(modifiers));
        } else {
            this.pd.mouseAction(0, time, x, y, 0, modifiers);
        }
    }

    private void mouseWheel(long time, int rotation, int modifiers) {
        this.pd.mouseAction(3, time, 0, rotation, 0, modifiers);
    }

    private void mousePressed(long time, int x, int y, int modifiers, boolean isPopupTrigger) {
        this.isMouseDown = true;
        this.pd.mouseAction(4, time, x, y, 0, modifiers);
    }

    private void mouseReleased(long time, int x, int y, int modifiers) {
        this.isMouseDown = false;
        this.pd.mouseAction(5, time, x, y, 0, modifiers);
    }

    private void mouseDragged(long time, int x, int y, int modifiers) {
        if ((modifiers & 0x14) == 20) {
            modifiers = modifiers & 0xFFFFFFFB | 2;
        }
        this.pd.mouseAction(1, time, x, y, 0, modifiers);
    }

    private static int applyLeftMouse(int modifiers) {
        return (modifiers & 0x1C) == 0 ? modifiers | 0x10 : modifiers;
    }

    public void processTwoPointGesture(float[][][] touches) {
    }
}

