/*
 * Decompiled with CFR 0.152.
 */
package jspecview.source;

import java.io.BufferedReader;
import java.io.IOException;
import javajs.util.BC;
import javajs.util.Base64;
import jspecview.source.JDXSource;
import jspecview.source.XMLReader;

public class AnIMLReader
extends XMLReader {
    private boolean inResult;

    @Override
    protected JDXSource getXML(BufferedReader bufferedReader) {
        try {
            this.source = new JDXSource(0, this.filePath);
            this.getSimpleXmlReader(bufferedReader);
            this.reader.nextEvent();
            this.processXML(0, 3);
            if (!this.checkPointCount()) {
                return null;
            }
            this.xFactor = 1.0;
            this.yFactor = 1.0;
            this.populateVariables();
        }
        catch (Exception exception) {
            System.err.println("That file may be empty...");
            this.errorLog.append("That file may be empty... \n");
        }
        this.processErrors("anIML");
        try {
            bufferedReader.close();
        }
        catch (IOException iOException) {
            // empty catch block
        }
        return this.source;
    }

    @Override
    protected boolean processTag(int n) throws Exception {
        switch (n) {
            case 0: {
                this.processAuditTrail();
                return true;
            }
            case 1: {
                this.processExperimentStepSet();
                return true;
            }
            case 2: {
                this.processSampleSet();
                return true;
            }
            case 11: {
                this.processAuthor();
                return true;
            }
            case 3: {
                this.inResult = true;
                return true;
            }
        }
        System.out.println("AnIMLSource not processing tag " + tagNames[n] + "!");
        return false;
    }

    @Override
    protected void processEndTag(int n) throws Exception {
        switch (n) {
            case 1: 
            case 3: {
                this.inResult = false;
            }
        }
    }

    private void processAuditTrail() throws Exception {
        if (this.tagName.equals("user")) {
            this.reader.qualifiedValue();
        } else if (this.tagName.equals("timestamp")) {
            this.reader.qualifiedValue();
        }
    }

    private void processSampleSet() throws Exception {
        if (this.tagName.equals("sample")) {
            ++this.samplenum;
        } else if (this.tagName.equals("parameter")) {
            this.attrList = this.reader.getAttrValueLC("name");
            if (this.attrList.equals("name")) {
                this.reader.qualifiedValue();
            } else if (this.attrList.equals("owner")) {
                this.reader.qualifiedValue();
            } else if (this.attrList.equals("molecular formula")) {
                this.molForm = this.reader.qualifiedValue();
            } else if (this.attrList.equals("cas registry number")) {
                this.casRN = this.reader.qualifiedValue();
            }
        }
    }

    private void processExperimentStepSet() throws Exception {
        System.out.println("AnIML experiment " + this.tagName);
        if (this.tagName.equals("result")) {
            this.inResult = true;
        } else if (this.tagName.equals("sampleref")) {
            if (this.reader.getAttrValueLC("role").contains("samplemeasurement")) {
                this.sampleID = this.reader.getAttrValue("sampleID");
            }
        } else if (this.tagName.equals("author")) {
            this.process(11, true);
        } else if (this.tagName.equals("timestamp")) {
            this.LongDate = this.reader.thisValue();
        } else if (this.tagName.equals("technique")) {
            this.techname = this.reader.getAttrValue("name").toUpperCase() + " SPECTRUM";
        } else if (this.tagName.equals("vectorset") || this.tagName.equals("seriesset") && this.inResult) {
            this.npoints = Integer.parseInt(this.reader.getAttrValue("length"));
            System.out.println("AnIML No. of points= " + this.npoints);
            this.xaxisData = new double[this.npoints];
            this.yaxisData = new double[this.npoints];
        } else if (this.tagName.equals("vector") || this.tagName.equals("series") && this.inResult) {
            String string = this.reader.getAttrValue("name");
            String string2 = this.reader.getAttrValueLC("dependency");
            if (string2.equals("independent")) {
                this.xUnits = string;
                this.getXValues();
            } else if (string2.equals("dependent")) {
                this.yUnits = string;
                this.getYValues();
            }
        } else if (this.tagName.equals("parameter")) {
            this.attrList = this.reader.getAttrValueLC("name");
            if (this.attrList.equals("identifier")) {
                this.title = this.reader.qualifiedValue();
            } else if (this.attrList.equals("nucleus")) {
                this.obNucleus = this.reader.qualifiedValue();
            } else if (this.attrList.equals("observefrequency")) {
                this.StrObFreq = this.reader.qualifiedValue();
                this.obFreq = Double.parseDouble(this.StrObFreq);
            } else if (this.attrList.equals("referencepoint")) {
                this.refPoint = Double.parseDouble(this.reader.qualifiedValue());
            } else if (this.attrList.equals("sample path length")) {
                this.pathlength = this.reader.qualifiedValue();
            } else if (this.attrList.equals("scanmode")) {
                this.reader.thisValue();
            } else if (this.attrList.equals("manufacturer")) {
                this.vendor = this.reader.thisValue();
            } else if (this.attrList.equals("model name")) {
                this.modelType = this.reader.thisValue();
            } else if (this.attrList.equals("resolution")) {
                this.resolution = this.reader.qualifiedValue();
            }
        }
    }

    private void getXValues() throws Exception {
        this.reader.nextTag();
        if (this.reader.getTagName().equals("autoincrementedvalueset")) {
            this.reader.nextTag();
            if (this.reader.getTagName().equals("startvalue")) {
                this.firstX = Double.parseDouble(this.reader.qualifiedValue());
            }
            this.nextStartTag();
            if (this.reader.getTagName().equals("increment")) {
                this.deltaX = Double.parseDouble(this.reader.qualifiedValue());
            }
        }
        if (!this.inResult) {
            this.nextStartTag();
            this.xUnits = this.reader.getAttrValue("label");
        }
        this.increasing = this.deltaX > 0.0;
        this.continuous = true;
        for (int i = 0; i < this.npoints; ++i) {
            this.xaxisData[i] = this.firstX + this.deltaX * (double)i;
        }
        this.lastX = this.xaxisData[this.npoints - 1];
    }

    private void nextStartTag() throws Exception {
        this.reader.nextStartTag();
        while (this.reader.getTagType() == 6) {
            this.reader.nextStartTag();
        }
    }

    private void getYValues() throws Exception {
        BC bC = new BC();
        String string = this.reader.getAttrValueLC("type");
        if (string.length() == 0) {
            string = this.reader.getAttrValueLC("vectorType");
        }
        this.reader.nextTag();
        this.tagName = this.reader.getTagName();
        if (this.tagName.equals("individualvalueset")) {
            for (int i = 0; i < this.npoints; ++i) {
                this.yaxisData[i] = Double.parseDouble(this.reader.qualifiedValue());
            }
            System.out.println(this.npoints + " individual Y values now read");
        } else if (this.tagName.equals("encodedvalueset")) {
            this.attrList = this.reader.getCharacters();
            byte[] byArray = Base64.decodeBase64(this.attrList);
            if (byArray.length != 0) {
                if (string.equals("float64")) {
                    int n = 0;
                    int n2 = 0;
                    while (n < this.npoints) {
                        this.yaxisData[n] = bC.bytesToDoubleToFloat(byArray, n2, false);
                        ++n;
                        n2 += 8;
                    }
                } else {
                    int n = 0;
                    int n3 = 0;
                    while (n < this.npoints) {
                        this.yaxisData[n] = bC.bytesToFloat(byArray, n3, false);
                        ++n;
                        n3 += 4;
                    }
                }
            }
        }
        this.reader.nextStartTag();
        this.tagName = this.reader.getTagName();
        this.yUnits = this.reader.getAttrValue("label");
        this.firstY = this.yaxisData[0];
    }

    private void processAuthor() throws Exception {
        if (this.tagName.equals("name")) {
            this.owner = this.reader.thisValue();
        } else if (this.tagName.contains("location")) {
            this.origin = this.reader.thisValue();
        }
    }
}

