/*
 * Decompiled with CFR 0.152.
 */
package jspecview.source;

import java.io.BufferedReader;
import java.io.IOException;
import javajs.util.SB;
import org.jmol.util.Logger;

public class JDXSourceStreamTokenizer {
    private BufferedReader br;
    private String label;
    private String value;
    private int labelLineNo = 0;
    private String line;
    private int lineNo;

    JDXSourceStreamTokenizer(BufferedReader bufferedReader) {
        this.br = bufferedReader;
    }

    String peakLabel() {
        return this.nextLabel(false);
    }

    String getLabel() {
        return this.nextLabel(true);
    }

    private String nextLabel(boolean bl) {
        int n;
        this.label = null;
        this.value = null;
        while (this.line == null) {
            try {
                this.readLine();
                if (this.line == null) {
                    this.line = "";
                    return null;
                }
                this.line = this.line.trim();
            }
            catch (IOException iOException) {
                this.line = "";
                return null;
            }
            if (this.line.startsWith("##")) break;
            this.line = null;
        }
        if ((n = this.line.indexOf("=")) < 0) {
            if (bl) {
                Logger.info("BAD JDX LINE -- no '=' (line " + this.lineNo + "): " + this.line);
            }
            this.label = this.line;
            if (!bl) {
                this.line = "";
            }
        } else {
            this.label = this.line.substring(0, n).trim();
            if (bl) {
                this.line = this.line.substring(n + 1);
            }
        }
        this.labelLineNo = this.lineNo;
        if (Logger.debugging) {
            Logger.info(this.label);
        }
        return JDXSourceStreamTokenizer.cleanLabel(this.label);
    }

    public static String cleanLabel(String string) {
        if (string == null) {
            return null;
        }
        SB sB = new SB();
        block3: for (int i = 0; i < string.length(); ++i) {
            switch (string.charAt(i)) {
                case ' ': 
                case '-': 
                case '/': 
                case '\\': 
                case '_': {
                    continue block3;
                }
                default: {
                    sB.appendC(string.charAt(i));
                }
            }
        }
        return sB.toString().toUpperCase();
    }

    String getRawLabel() {
        return this.label;
    }

    int getLabelLineNo() {
        return this.labelLineNo;
    }

    public String getValue() {
        if (this.value != null) {
            return this.value;
        }
        SB sB = new SB().append(this.line);
        if (sB.length() > 0) {
            sB.appendC('\n');
        }
        try {
            while (!(this.readLine() == null || this.line.indexOf("##") >= 0 && this.line.trim().startsWith("##"))) {
                sB.append(this.line).appendC('\n');
            }
        }
        catch (IOException iOException) {
            iOException.printStackTrace();
        }
        this.value = JDXSourceStreamTokenizer.trimLines(sB);
        if (Logger.debugging) {
            Logger.info(this.value);
        }
        return this.value;
    }

    public String readLineTrimmed() throws IOException {
        this.readLine();
        if (this.line == null) {
            return null;
        }
        if (this.line.indexOf("$$") < 0) {
            return this.line.trim();
        }
        SB sB = new SB().append(this.line);
        return JDXSourceStreamTokenizer.trimLines(sB);
    }

    String flushLine() {
        SB sB = new SB().append(this.line);
        this.line = null;
        return JDXSourceStreamTokenizer.trimLines(sB);
    }

    private String readLine() throws IOException {
        this.line = this.br.readLine();
        ++this.lineNo;
        return this.line;
    }

    /*
     * Enabled aggressive block sorting
     */
    private static String trimLines(SB sB) {
        int n = sB.length();
        int n2 = n - 1;
        int n3 = JDXSourceStreamTokenizer.ptNonWhite(sB, 0, n);
        if (n3 >= n) {
            return "";
        }
        if (sB.charAt(n3) == '<') {
            n = sB.lastIndexOf(">") + 1;
            if (n == 0) {
                n = sB.length();
            }
            return sB.toString().substring(n3, n);
        }
        char[] cArray = new char[n - n3];
        int n4 = 0;
        while (n3 < n) {
            block14: {
                int n5 = sB.charAt(n3);
                switch (n5) {
                    case 13: {
                        if (n3 >= n2 || sB.charAt(n3 + 1) != '\n') {
                            n5 = 10;
                            break;
                        }
                        break block14;
                    }
                    case 10: {
                        if (n4 > 0 && cArray[n4 - 1] != '\n') {
                            n4 -= n3 - JDXSourceStreamTokenizer.ptNonSpaceRev(sB, n3) - 1;
                        }
                        ++n3;
                        n3 = JDXSourceStreamTokenizer.ptNonSpace(sB, n3, n) - 1;
                        break;
                    }
                    case 36: {
                        if (n3 >= n2 || sB.charAt(n3 + 1) != '$') break;
                        ++n3;
                        while (++n3 < n && "\n\r".indexOf(sB.charAt(n3)) < 0) {
                        }
                        break block14;
                    }
                }
                if (n5 != 10 || n4 <= 0 || cArray[n4 - 1] != '\n') {
                    cArray[n4++] = n5;
                }
            }
            ++n3;
        }
        if (n4 > 0 && cArray[n4 - 1] == '\n') {
            --n4;
        }
        return new String(cArray).substring(0, n4).trim();
    }

    private static int ptNonWhite(SB sB, int n, int n2) {
        while (n < n2 && Character.isWhitespace(sB.charAt(n))) {
            ++n;
        }
        return n;
    }

    private static int ptNonSpace(SB sB, int n, int n2) {
        while (n < n2 && (sB.charAt(n) == ' ' || sB.charAt(n) == '\t')) {
            ++n;
        }
        return n;
    }

    private static int ptNonSpaceRev(SB sB, int n) {
        while (--n >= 0 && (sB.charAt(n) == ' ' || sB.charAt(n) == '\t')) {
        }
        return n;
    }
}

