/*
 * Decompiled with CFR 0.152.
 */
package org.jmol.modelsetbio;

import javajs.util.List;
import javajs.util.OC;
import javajs.util.P3;
import javajs.util.SB;
import javajs.util.T3;
import javajs.util.V3;
import org.jmol.constant.EnumStructure;
import org.jmol.java.BS;
import org.jmol.modelset.Atom;
import org.jmol.modelset.LabelToken;
import org.jmol.modelset.ModelSet;
import org.jmol.modelsetbio.BioPolymer;
import org.jmol.modelsetbio.Helix;
import org.jmol.modelsetbio.Monomer;
import org.jmol.modelsetbio.ProteinStructure;
import org.jmol.modelsetbio.Sheet;
import org.jmol.modelsetbio.Turn;
import org.jmol.util.Logger;
import org.jmol.util.Measure;
import org.jmol.viewer.Viewer;

public class AlphaPolymer
extends BioPolymer {
    AlphaPolymer(Monomer[] monomerArray) {
        super(monomerArray);
    }

    @Override
    protected P3 getControlPoint(int n, V3 v3) {
        if (!this.monomers[n].isSheet()) {
            return this.leadPoints[n];
        }
        v3.sub2((T3)this.leadMidpoints[n], (T3)this.leadPoints[n]);
        v3.scale(this.sheetSmoothing);
        P3 p3 = P3.newP((T3)this.leadPoints[n]);
        p3.add((T3)v3);
        return p3;
    }

    @Override
    public void getPdbData(Viewer viewer, char c, char c2, int n, int n2, BS bS, BS bS2, boolean bl, boolean bl2, boolean bl3, LabelToken[] labelTokenArray, OC oC, SB sB, BS bS3) {
        AlphaPolymer.getPdbData(viewer, this, c, c2, n, n2, bS, bS2, bl, bl2, bl3, labelTokenArray, oC, sB, bS3);
    }

    public void addStructure(EnumStructure enumStructure, String string, int n, int n2, int n3, int n4, int n5, int n6, int n7, int n8, BS bS) {
        int n9;
        int n10;
        int n11;
        int n12 = -1;
        int n13 = -1;
        if (n7 < n8) {
            if (this.monomers[0].firstAtomIndex > n8 || this.monomers[this.monomerCount - 1].lastAtomIndex < n7) {
                return;
            }
            n12 = n7;
            n13 = n8;
        }
        if ((n11 = this.getIndex(n3, n4, n12, n13)) == -1 || (n10 = this.getIndex(n5, n6, n12, n13)) == -1) {
            return;
        }
        if (n7 >= 0 && bS != null && (n9 = bS.nextSetBit(this.monomers[n11].firstAtomIndex)) >= 0 && n9 < this.monomers[n10].lastAtomIndex) {
            return;
        }
        this.addStructureProtected(enumStructure, string, n, n2, n11, n10);
        if (n7 >= 0) {
            bS.setBits(n7, n8 + 1);
        }
    }

    public void addStructureProtected(EnumStructure enumStructure, String string, int n, int n2, int n3, int n4) {
        if (n4 < n3) {
            Logger.error((String)("AlphaPolymer:addSecondaryStructure error:  indexStart:" + n3 + " indexEnd:" + n4));
            return;
        }
        int n5 = n4 - n3 + 1;
        ProteinStructure proteinStructure = null;
        switch (enumStructure) {
            case HELIX: 
            case HELIXALPHA: 
            case HELIX310: 
            case HELIXPI: {
                proteinStructure = new Helix(this, n3, n5, enumStructure);
                break;
            }
            case SHEET: {
                proteinStructure = new Sheet(this, n3, n5, enumStructure);
                break;
            }
            case TURN: {
                proteinStructure = new Turn(this, n3, n5);
                break;
            }
            default: {
                Logger.error((String)"unrecognized secondary structure type");
                return;
            }
        }
        proteinStructure.structureID = string;
        proteinStructure.serialID = n;
        proteinStructure.strandCount = n2;
        for (int i = n3; i <= n4; ++i) {
            this.monomers[i].setStructure(proteinStructure);
        }
    }

    @Override
    public List<Atom[]> calculateStruts(ModelSet modelSet, BS bS, BS bS2, List<Atom> list, float f, int n, boolean bl) {
        return this.calculateStrutsStatic(modelSet, bS, bS2, list, f, n, bl);
    }

    private List<Atom[]> calculateStrutsStatic(ModelSet modelSet, BS bS, BS bS2, List<Atom> list, float f, int n, boolean bl) {
        float f2;
        int n2;
        int n3;
        int n4;
        int n5;
        int n6;
        int n7;
        int n8;
        List list2 = new List();
        float f3 = f * f;
        int n9 = list.size();
        int n10 = 3;
        BS bS3 = new BS();
        BS bS4 = new BS();
        BS bS5 = new BS();
        Atom atom = (Atom)list.get(0);
        int n11 = modelSet.getBioPolymerCountInModel((int)atom.modelIndex);
        int[][] nArray = new int[n11][n10 * 2];
        for (int i = 0; i < n9; ++i) {
            atom = (Atom)list.get(i);
            n8 = atom.getPolymerIndexInModel();
            n7 = atom.getMonomerIndex();
            n6 = n7;
            if (n6 < n10) {
                nArray[n8][n6] = i + 1;
            }
            if ((n6 = ((Monomer)atom.getGroup()).getBioPolymerLength() - n7 - 1) >= n10) continue;
            nArray[n8][n10 + n6] = i + 1;
        }
        float[] fArray = new float[n9 * (n9 - 1) / 2];
        for (n8 = 0; n8 < n9; ++n8) {
            atom = (Atom)list.get(n8);
            for (n7 = n8 + 1; n7 < n9; ++n7) {
                n6 = AlphaPolymer.strutPoint(n8, n7, n9);
                Atom atom2 = (Atom)list.get(n7);
                n5 = atom.getResno();
                n4 = atom.getPolymerIndexInModel();
                n3 = atom2.getResno();
                n2 = atom2.getPolymerIndexInModel();
                if (n4 == n2 && Math.abs(n3 - n5) < n) {
                    bS5.set(n6);
                }
                if (!((f2 = (fArray[n6] = atom.distanceSquared((T3)atom2))) >= f3)) continue;
                bS4.set(n6);
            }
        }
        n8 = 5;
        while (--n8 >= 0) {
            f3 = (f - (float)n8) * (f - (float)n8);
            for (n7 = 0; n7 < n9; ++n7) {
                if (!bl && bS3.get(n7)) continue;
                for (n6 = n7 + 1; n6 < n9; ++n6) {
                    n5 = AlphaPolymer.strutPoint(n7, n6, n9);
                    if (bS4.get(n5) || bS5.get(n5) || !bl && bS3.get(n6) || !(fArray[n5] <= f3)) continue;
                    AlphaPolymer.setStrut(n7, n6, n9, list, bS, bS2, (List<Atom[]>)list2, bS3, bS4, bS5, n);
                }
            }
        }
        for (n8 = 0; n8 < n11; ++n8) {
            for (n7 = 0; n7 < n10 * 2; ++n7) {
                n6 = nArray[n8][n7] - 1;
                if (n6 < 0 || !bS3.get(n6)) continue;
                for (n5 = 0; n5 < n10; ++n5) {
                    n4 = n7 / n10 * n10 + n5;
                    n6 = nArray[n8][n4] - 1;
                    if (n6 >= 0) {
                        bS3.set(n6);
                    }
                    nArray[n8][n4] = -1;
                }
            }
            if (nArray[n8][0] == -1 && nArray[n8][n10] == -1) continue;
            n7 = 0;
            n6 = 0;
            n5 = 0;
            n4 = 0;
            n3 = 0;
            n2 = 0;
            f2 = Float.MAX_VALUE;
            float f4 = Float.MAX_VALUE;
            for (int i = 0; i < n9; ++i) {
                for (int j = 0; j < n10 * 2; ++j) {
                    int n12;
                    int n13 = nArray[n8][j] - 1;
                    if (n13 == -2) {
                        j = (j / n10 + 1) * n10 - 1;
                        continue;
                    }
                    if (i == n13 || n13 == -1 || bS5.get(n12 = AlphaPolymer.strutPoint(n13, i, n9)) || fArray[n12] > (j < n10 ? f2 : f4)) continue;
                    if (j < n10) {
                        if (bS4.get(n12)) {
                            n7 = 1;
                        }
                        n4 = i;
                        n5 = n13;
                        f2 = fArray[n12];
                        continue;
                    }
                    if (bS4.get(n12)) {
                        n6 = 1;
                    }
                    n2 = i;
                    n3 = n13;
                    f4 = fArray[n12];
                }
            }
            if (n7 != 0) {
                AlphaPolymer.setStrut(n5, n4, n9, list, bS, bS2, (List<Atom[]>)list2, bS3, bS4, bS5, n);
            }
            if (n6 == 0) continue;
            AlphaPolymer.setStrut(n3, n2, n9, list, bS, bS2, (List<Atom[]>)list2, bS3, bS4, bS5, n);
        }
        return list2;
    }

    private static int strutPoint(int n, int n2, int n3) {
        return n2 < n ? n2 * (2 * n3 - n2 - 1) / 2 + n - n2 - 1 : n * (2 * n3 - n - 1) / 2 + n2 - n - 1;
    }

    private static void setStrut(int n, int n2, int n3, List<Atom> list, BS bS, BS bS2, List<Atom[]> list2, BS bS3, BS bS4, BS bS5, int n4) {
        Atom atom = (Atom)list.get(n);
        Atom atom2 = (Atom)list.get(n2);
        if (!bS.get(atom.index) || !bS2.get(atom2.index)) {
            return;
        }
        list2.addLast((Object)new Atom[]{atom, atom2});
        bS3.set(n);
        bS3.set(n2);
        for (int i = Math.max(0, n - n4); i <= n + n4 && i < n3; ++i) {
            for (int j = Math.max(0, n2 - n4); j <= n2 + n4 && j < n3; ++j) {
                int n5;
                if (i == j || bS5.get(n5 = AlphaPolymer.strutPoint(i, j, n3))) continue;
                bS4.set(n5);
            }
        }
    }

    public void calculateStructures(boolean bl) {
        if (this.monomerCount < 4) {
            return;
        }
        float[] fArray = this.calculateAnglesInDegrees();
        Code[] codeArray = this.calculateCodes(fArray);
        this.checkBetaSheetAlphaHelixOverlap(codeArray, fArray);
        EnumStructure[] enumStructureArray = this.calculateRunsFourOrMore(codeArray);
        this.extendRuns(enumStructureArray);
        this.searchForTurns(codeArray, fArray, enumStructureArray);
        this.addStructuresFromTags(enumStructureArray);
    }

    private float[] calculateAnglesInDegrees() {
        float[] fArray = new float[this.monomerCount];
        int n = this.monomerCount - 1;
        while (--n >= 2) {
            fArray[n] = Measure.computeTorsion((T3)this.monomers[n - 2].getLeadAtom(), (T3)this.monomers[n - 1].getLeadAtom(), (T3)this.monomers[n].getLeadAtom(), (T3)this.monomers[n + 1].getLeadAtom(), (boolean)true);
        }
        return fArray;
    }

    private Code[] calculateCodes(float[] fArray) {
        Code[] codeArray = new Code[this.monomerCount];
        int n = this.monomerCount - 1;
        while (--n >= 2) {
            float f = fArray[n];
            codeArray[n] = f >= 10.0f && f < 120.0f ? Code.RIGHT_HELIX : (f >= 120.0f || f < -90.0f ? Code.BETA_SHEET : (f >= -90.0f && f < 0.0f ? Code.LEFT_HELIX : Code.NADA));
        }
        return codeArray;
    }

    private void checkBetaSheetAlphaHelixOverlap(Code[] codeArray, float[] fArray) {
        int n = this.monomerCount - 2;
        while (--n >= 2) {
            if (codeArray[n] != Code.BETA_SHEET || !(fArray[n] <= 140.0f) || codeArray[n - 2] != Code.RIGHT_HELIX || codeArray[n - 1] != Code.RIGHT_HELIX || codeArray[n + 1] != Code.RIGHT_HELIX || codeArray[n + 2] != Code.RIGHT_HELIX) continue;
            codeArray[n] = Code.RIGHT_HELIX;
        }
    }

    private EnumStructure[] calculateRunsFourOrMore(Code[] codeArray) {
        EnumStructure[] enumStructureArray = new EnumStructure[this.monomerCount];
        EnumStructure enumStructure = EnumStructure.NONE;
        Code code = Code.NADA;
        int n = 0;
        for (int i = 0; i < this.monomerCount; ++i) {
            if (codeArray[i] == code && code != Code.NADA && code != Code.BETA_SHEET) {
                if (++n == 4) {
                    enumStructure = code == Code.BETA_SHEET ? EnumStructure.SHEET : EnumStructure.HELIX;
                    int n2 = 4;
                    while (--n2 >= 0) {
                        enumStructureArray[i - n2] = enumStructure;
                    }
                    continue;
                }
                if (n <= 4) continue;
                enumStructureArray[i] = enumStructure;
                continue;
            }
            n = 1;
            code = codeArray[i];
        }
        return enumStructureArray;
    }

    private void extendRuns(EnumStructure[] enumStructureArray) {
        for (int i = 1; i < this.monomerCount - 4; ++i) {
            if (enumStructureArray[i] != EnumStructure.NONE || enumStructureArray[i + 1] == EnumStructure.NONE) continue;
            enumStructureArray[i] = enumStructureArray[i + 1];
        }
        enumStructureArray[0] = enumStructureArray[1];
        enumStructureArray[this.monomerCount - 1] = enumStructureArray[this.monomerCount - 2];
    }

    private void searchForTurns(Code[] codeArray, float[] fArray, EnumStructure[] enumStructureArray) {
        int n = this.monomerCount - 1;
        while (--n >= 2) {
            codeArray[n] = Code.NADA;
            if (enumStructureArray[n] != null && enumStructureArray[n] != EnumStructure.NONE) continue;
            float f = fArray[n];
            if (f >= -90.0f && f < 0.0f) {
                codeArray[n] = Code.LEFT_TURN;
                continue;
            }
            if (!(f >= 0.0f) || !(f < 90.0f)) continue;
            codeArray[n] = Code.RIGHT_TURN;
        }
        n = this.monomerCount - 1;
        while (--n >= 0) {
            if (codeArray[n] == Code.NADA || codeArray[n + 1] != codeArray[n] || enumStructureArray[n] != EnumStructure.NONE) continue;
            enumStructureArray[n] = EnumStructure.TURN;
        }
    }

    private void addStructuresFromTags(EnumStructure[] enumStructureArray) {
        int n = 0;
        while (n < this.monomerCount) {
            int n2;
            EnumStructure enumStructure = enumStructureArray[n];
            if (enumStructure == null || enumStructure == EnumStructure.NONE) {
                ++n;
                continue;
            }
            for (n2 = n + 1; n2 < this.monomerCount && enumStructureArray[n2] == enumStructure; ++n2) {
            }
            this.addStructureProtected(enumStructure, null, 0, 0, n, n2 - 1);
            n = n2;
        }
    }

    private static enum Code {
        NADA,
        RIGHT_HELIX,
        BETA_SHEET,
        LEFT_HELIX,
        LEFT_TURN,
        RIGHT_TURN;

    }
}

