/*
 * Decompiled with CFR 0.152.
 */
package org.jmol.modelsetbio;

import java.util.Map;
import javajs.util.List;
import javajs.util.P3;
import javajs.util.V3;
import org.jmol.constant.EnumStructure;
import org.jmol.java.BS;
import org.jmol.modelset.Atom;
import org.jmol.modelset.Bond;
import org.jmol.modelset.Chain;
import org.jmol.modelset.Group;
import org.jmol.modelsetbio.BioPolymer;
import org.jmol.modelsetbio.ProteinStructure;
import org.jmol.util.Logger;
import org.jmol.util.Measure;
import org.jmol.util.Quaternion;
import org.jmol.viewer.JC;

public abstract class Monomer
extends Group {
    BioPolymer bioPolymer;
    protected byte[] offsets;
    int monomerIndex;

    protected static boolean have(byte[] byArray, byte by) {
        return (byArray[by] & 0xFF) != 255;
    }

    protected Monomer set2(Chain chain, String string, int n, int n2, int n3, byte[] byArray) {
        this.setGroup(chain, string, n, n2, n3);
        this.offsets = byArray;
        int n4 = this.offsets[0] & 0xFF;
        if (n4 != 255) {
            this.leadAtomIndex = n2 + n4;
        }
        return this;
    }

    public Group[] getGroups() {
        return this.bioPolymer.getGroups();
    }

    void setBioPolymer(BioPolymer bioPolymer, int n) {
        this.bioPolymer = bioPolymer;
        this.monomerIndex = n;
    }

    public int getSelectedMonomerCount() {
        return this.bioPolymer.getSelectedMonomerCount();
    }

    public int getSelectedMonomerIndex() {
        return this.monomerIndex >= 0 && this.bioPolymer.isMonomerSelected(this.monomerIndex) ? this.monomerIndex : -1;
    }

    public BioPolymer getBioPolymer() {
        return this.bioPolymer;
    }

    public int getBioPolymerLength() {
        return this.bioPolymer == null ? 0 : this.bioPolymer.monomerCount;
    }

    public int getMonomerIndex() {
        return this.monomerIndex;
    }

    public int getBioPolymerIndexInModel() {
        return this.bioPolymer == null ? -1 : this.bioPolymer.bioPolymerIndexInModel;
    }

    protected static byte[] scanForOffsets(int n, int[] nArray, byte[] byArray) {
        int n2 = byArray.length;
        byte[] byArray2 = new byte[n2];
        int n3 = n2;
        while (--n3 >= 0) {
            int n4;
            int n5;
            byte by = byArray[n3];
            if (by < 0) {
                n5 = nArray[~by];
            } else {
                n5 = nArray[by];
                if (n5 < 0) {
                    return null;
                }
            }
            if (n5 < 0) {
                n4 = 255;
            } else {
                n4 = n5 - n;
                if (n4 < 0 || n4 > 254) {
                    Logger.warn((String)("Monomer.scanForOffsets i=" + n3 + " atomID=" + by + " atomIndex:" + n5 + " firstAtomIndex:" + n + " offset out of 0-254 range. Groups aren't organized correctly. Is this really a protein?: " + n4));
                    if (by < 0) {
                        n4 = 255;
                    }
                }
            }
            byArray2[n3] = (byte)n4;
        }
        return byArray2;
    }

    void setStructure(ProteinStructure proteinStructure) {
    }

    public ProteinStructure getProteinStructure() {
        return null;
    }

    public EnumStructure getProteinStructureType() {
        return EnumStructure.NONE;
    }

    public boolean isHelix() {
        return false;
    }

    public boolean isSheet() {
        return false;
    }

    public void setStrucNo(int n) {
    }

    protected final Atom getAtomFromOffsetIndex(int n) {
        if (n > this.offsets.length) {
            return null;
        }
        int n2 = this.offsets[n] & 0xFF;
        if (n2 == 255) {
            return null;
        }
        return this.chain.getAtom(this.firstAtomIndex + n2);
    }

    protected final Atom getSpecialAtom(byte[] byArray, byte by) {
        int n = byArray.length;
        while (--n >= 0) {
            byte by2 = byArray[n];
            if (by2 < 0) {
                by2 = -by2;
            }
            if (by != by2) continue;
            int n2 = this.offsets[n] & 0xFF;
            if (n2 == 255) {
                return null;
            }
            return this.chain.getAtom(this.firstAtomIndex + n2);
        }
        return null;
    }

    protected final P3 getSpecialAtomPoint(byte[] byArray, byte by) {
        int n = byArray.length;
        while (--n >= 0) {
            byte by2 = byArray[n];
            if (by2 < 0) {
                by2 = -by2;
            }
            if (by != by2) continue;
            int n2 = this.offsets[n] & 0xFF;
            if (n2 == 255) {
                return null;
            }
            return this.chain.getAtom(this.firstAtomIndex + n2);
        }
        return null;
    }

    public boolean isLeadAtom(int n) {
        return n == this.leadAtomIndex;
    }

    public final Atom getLeadAtom() {
        return this.getAtomFromOffsetIndex(0);
    }

    public final Atom getWingAtom() {
        return this.getAtomFromOffsetIndex(1);
    }

    Atom getInitiatorAtom() {
        return this.getLeadAtom();
    }

    Atom getTerminatorAtom() {
        return this.getLeadAtom();
    }

    abstract boolean isConnectedAfter(Monomer var1);

    void findNearestAtomIndex(int n, int n2, Atom[] atomArray, short s, short s2) {
    }

    protected boolean calcBioParameters() {
        return this.bioPolymer.calcParameters();
    }

    public boolean haveParameters() {
        return this.bioPolymer.haveParameters;
    }

    public Map<String, Object> getMyInfo() {
        ProteinStructure proteinStructure;
        float f;
        char c;
        Map map = this.getGroupInfo(this.groupIndex);
        map.put("chain", this.chain.getIDStr());
        int n = this.getResno();
        if (n > 0) {
            map.put("sequenceNumber", n);
        }
        if ((c = this.getInsertionCode()) != '\u0000') {
            map.put("insertionCode", "" + c);
        }
        if (!Float.isNaN(f = this.getGroupParameter(1112539145))) {
            map.put("phi", Float.valueOf(f));
        }
        if (!Float.isNaN(f = this.getGroupParameter(1112539146))) {
            map.put("psi", Float.valueOf(f));
        }
        if (!Float.isNaN(f = this.getGroupParameter(1112539141))) {
            map.put("mu", Float.valueOf(f));
        }
        if (!Float.isNaN(f = this.getGroupParameter(1112539152))) {
            map.put("theta", Float.valueOf(f));
        }
        if ((proteinStructure = this.getProteinStructure()) != null) {
            map.put("structureId", proteinStructure.strucNo);
            map.put("structureType", proteinStructure.type.getBioStructureTypeName(false));
        }
        map.put("shapeVisibilityFlags", this.shapeVisibilityFlags);
        return map;
    }

    public String getStructureId() {
        ProteinStructure proteinStructure = this.getProteinStructure();
        return proteinStructure == null ? "" : proteinStructure.type.getBioStructureTypeName(false);
    }

    void getConformation(Atom[] atomArray, BS bS, int n) {
        char c = '\u0000';
        for (int i = this.firstAtomIndex; i <= this.lastAtomIndex; ++i) {
            Atom atom = atomArray[i];
            char c2 = atom.getAlternateLocationID();
            if (c2 == '\u0000') continue;
            if (n >= 0 && c2 != c) {
                c = c2;
                --n;
            }
            if (n >= 0 || c2 == c) continue;
            bS.clear(i);
        }
    }

    final void updateOffsetsForAlternativeLocations(Atom[] atomArray, BS bS) {
        int n = this.offsets.length;
        block0: while (--n >= 0) {
            int n2 = this.offsets[n] & 0xFF;
            if (n2 == 255) continue;
            int n3 = this.firstAtomIndex + n2;
            Atom atom = atomArray[n3];
            byte by = atom.getAtomID();
            if (atom.getAlternateLocationID() == '\u0000') continue;
            int n4 = this.lastAtomIndex - this.firstAtomIndex;
            for (int i = 1; i <= n4; ++i) {
                byte by2;
                int n5;
                int n6 = n3 + i;
                if (n6 > this.lastAtomIndex) {
                    n6 -= n4 + 1;
                }
                if ((n5 = n6 - this.firstAtomIndex) < 0 || n5 > 255 || n6 == n3 || !bS.get(n6) || (by2 = atomArray[n6].getAtomID()) != by || by2 == 0 && !atomArray[n6].getAtomName().equals(atom.getAtomName())) continue;
                if (Logger.debugging) {
                    Logger.debug((String)("Chain.udateOffsetsForAlternativeLocation " + atomArray[n6] + " was " + atom));
                }
                this.offsets[n] = (byte)n5;
                continue block0;
            }
        }
    }

    final void getMonomerSequenceAtoms(BS bS, BS bS2) {
        this.selectAtoms(bS2);
        bS2.and(bS);
    }

    protected static final boolean checkOptional(byte[] byArray, byte by, int n, int n2) {
        if (Monomer.have(byArray, by)) {
            return true;
        }
        if (n2 < 0) {
            return false;
        }
        byArray[by] = (byte)(n2 - n);
        return true;
    }

    P3 getQuaternionFrameCenter(char c) {
        return null;
    }

    protected Object getHelixData2(int n, char c, int n2) {
        Quaternion quaternion;
        int n3 = this.monomerIndex - n2;
        Monomer monomer = n2 < 1 || this.monomerIndex <= 0 ? null : this.bioPolymer.monomers[n3];
        Quaternion quaternion2 = this.getQuaternion(c);
        Quaternion quaternion3 = n2 < 1 ? Quaternion.getQuaternionFrameV((V3)JC.axisX, (V3)JC.axisY, (V3)JC.axisZ, (boolean)false) : (quaternion = monomer == null ? null : monomer.getQuaternion(c));
        if (quaternion == null || quaternion2 == null) {
            return this.getHelixData(n, c, n2);
        }
        P3 p3 = n2 < 1 ? P3.new3((float)0.0f, (float)0.0f, (float)0.0f) : monomer.getQuaternionFrameCenter(c);
        P3 p32 = this.getQuaternionFrameCenter(c);
        if (p3 == null || p32 == null) {
            return this.getHelixData(n, c, n2);
        }
        return Measure.computeHelicalAxis(n == 135176 ? "helixaxis" + this.getUniqueID() : null, (int)n, (P3)p3, (P3)p32, (Quaternion)quaternion2.div(quaternion));
    }

    public String getUniqueID() {
        char c;
        int n = this.getChainID();
        Atom atom = this.getLeadAtom();
        String string = (atom == null ? "" : "_" + atom.getModelIndex()) + "_" + this.getResno() + (n == 0 ? "" : "_" + n);
        char c2 = c = atom == null ? (char)'\u0000' : this.getLeadAtom().getAlternateLocationID();
        if (c != '\u0000') {
            string = string + "_" + c;
        }
        return string;
    }

    public boolean isCrossLinked(Group group) {
        for (int i = this.firstAtomIndex; i <= this.lastAtomIndex; ++i) {
            if (!this.getCrossLinkGroup(i, null, group)) continue;
            return true;
        }
        return false;
    }

    public boolean getCrossLinkLead(List<Integer> list) {
        for (int i = this.firstAtomIndex; i <= this.lastAtomIndex; ++i) {
            if (!this.getCrossLink(i, list) || list != null) continue;
            return true;
        }
        return false;
    }

    protected boolean getCrossLink(int n, List<Integer> list) {
        return this.getCrossLinkGroup(n, list, null);
    }

    private boolean getCrossLinkGroup(int n, List<Integer> list, Group group) {
        Atom atom = this.chain.getAtom(n);
        Bond[] bondArray = atom.getBonds();
        int n2 = this.getBioPolymerIndexInModel();
        if (n2 < 0 || bondArray == null) {
            return false;
        }
        boolean bl = false;
        boolean bl2 = list == null && group == null;
        for (int i = 0; i < bondArray.length; ++i) {
            Atom atom2 = bondArray[i].getOtherAtom(atom);
            Group group2 = atom2.getGroup();
            if (group != null && group2 != group) continue;
            int n3 = group2.getBioPolymerIndexInModel();
            int n4 = group2.getMonomerIndex();
            if (bl2) {
                if (n3 != n2 || n4 != this.monomerIndex - 1) continue;
                return true;
            }
            if (n3 < 0 || n4 < 0 || n3 == n2 && n4 >= this.monomerIndex - 1 && n4 <= this.monomerIndex + 1) continue;
            bl = true;
            if (group != null) break;
            list.addLast((Object)group2.leadAtomIndex);
        }
        return bl;
    }

    public boolean isConnectedPrevious() {
        return true;
    }
}

