/*
 * Decompiled with CFR 0.152.
 */
package com.sparshui.server;

import com.sparshui.GestureType;
import com.sparshui.common.ClientProtocol;
import com.sparshui.common.Event;
import com.sparshui.common.utils.Converter;
import com.sparshui.server.TouchPoint;
import java.io.ByteArrayOutputStream;
import java.io.DataOutputStream;
import java.io.IOException;
import java.net.Socket;
import javajs.util.List;

public class ServerToClientProtocol
extends ClientProtocol {
    private DataOutputStream _bufferOut;
    private ByteArrayOutputStream _buffer = new ByteArrayOutputStream();

    public ServerToClientProtocol(Socket socket) throws IOException {
        super(socket);
        this._bufferOut = new DataOutputStream(this._buffer);
    }

    public List<GestureType> getGestures(int n) throws IOException {
        List<GestureType> list = new List<GestureType>();
        this._bufferOut.writeInt(n);
        this.sendBuffer(2);
        for (int i = this._in.readInt(); i > 0; i -= 4) {
            int n2 = this._in.readInt();
            if (n2 < 0) {
                byte[] byArray = new byte[-n2];
                this._in.read(byArray);
                list.addLast(new GestureType(Converter.byteArrayToString(byArray)));
                i -= byArray.length;
                continue;
            }
            list.addLast(new GestureType(n2));
        }
        return list;
    }

    public int getGroupID(TouchPoint touchPoint) throws IOException {
        byte[] byArray = new byte[4];
        Converter.floatToByteArray(byArray, 0, touchPoint.getLocation().getX());
        this._bufferOut.write(byArray);
        Converter.floatToByteArray(byArray, 0, touchPoint.getLocation().getY());
        this._bufferOut.write(byArray);
        this.sendBuffer(1);
        int n = this._in.readInt();
        return n;
    }

    public void processEvents(int n, List<Event> list) throws IOException {
        for (int i = 0; i < list.size(); ++i) {
            this._bufferOut.writeInt(n);
            this._bufferOut.write(((Event)list.get(i)).serialize());
            this.sendBuffer(0);
        }
    }

    public void processError(int n) throws IOException {
        this._bufferOut.writeInt(-1);
        this._bufferOut.writeInt(n);
        this.sendBuffer(0);
    }

    private void sendBuffer(int n) throws IOException {
        this._out.writeByte((byte)n);
        this._out.writeInt(this._buffer.size());
        this._out.write(this._buffer.toByteArray());
        this._buffer.reset();
    }
}

