/*
 * Decompiled with CFR 0.152.
 */
package org.jmol.export;

import java.awt.Point;
import java.awt.image.BufferedImage;
import java.io.File;
import java.io.IOException;
import java.util.HashSet;
import java.util.Hashtable;
import java.util.Map;
import java.util.Set;
import javajs.util.A4;
import javajs.util.AU;
import javajs.util.CU;
import javajs.util.List;
import javajs.util.M4;
import javajs.util.OC;
import javajs.util.P3;
import javajs.util.PT;
import javajs.util.SB;
import javajs.util.T3;
import javajs.util.V3;
import org.jmol.export.MeshData;
import org.jmol.export.__CartesianExporter;
import org.jmol.java.BS;
import org.jmol.modelset.Atom;
import org.jmol.util.C;
import org.jmol.util.Escape;
import org.jmol.util.GData;
import org.jmol.util.Logger;
import org.jmol.util.MeshSurface;
import org.jmol.util.Quaternion;
import org.jmol.viewer.Viewer;

public class _ObjExporter
extends __CartesianExporter {
    private static final boolean debug = false;
    private boolean surfacesOnly = false;
    private boolean normalizeUV = true;
    private OC mtlout;
    String objFileRootName;
    File mtlFile;
    private int nMtlBytes;
    Set<Short> textures = new HashSet<Short>();
    List<String> textureFiles;
    private int sphereNum = 1;
    private int cylinderNum = 1;
    private int ellipseNum = 1;
    private int circleNum = 1;
    private int ellipsoidNum = 1;
    private int coneNum = 1;
    private int triangleNum = 1;
    private int surfaceNum = 1;
    private int currentVertexOrigin = 1;
    private int currentNormalOrigin = 1;
    private int currentTextureOrigin = 1;
    private float pixelSize;
    private final P3 ptTemp = new P3();

    public _ObjExporter() {
        this.debugPrint("_WavefrontObjExporter CTOR");
        this.commentChar = "# ";
    }

    protected void debugPrint(String string) {
    }

    @Override
    protected void outputFace(int[] nArray, int[] nArray2, int n) {
    }

    @Override
    protected void outputCircle(P3 p3, P3 p32, float f, short s, boolean bl) {
        this.debugPrint("outputCircle");
        if (this.surfacesOnly) {
            this.debugPrint("  Not done owing to surfacesOnly");
            return;
        }
        if (bl) {
            this.outputCircle1(p3, p32, s, f);
        }
    }

    @Override
    protected void outputCone(P3 p3, P3 p32, float f, short s) {
        this.debugPrint("outputCone");
        if (this.surfacesOnly) {
            this.debugPrint("  Not done owing to surfacesOnly");
            return;
        }
        this.outputCone1(p3, p32, f, s);
    }

    @Override
    protected boolean outputCylinder(P3 p3, P3 p32, P3 p33, short s, byte by, float f, P3 p34, P3 p35, boolean bl) {
        if (this.surfacesOnly) {
            this.debugPrint("  Not done owing to surfacesOnly");
            return true;
        }
        if (p34 != null) {
            if (by == 2) {
                this.outputEllipse1(p3, p32, p34, p35, s);
                this.tempP3.setT(p3);
                this.tempP3.sub(p34);
                this.tempP3.add(p3);
                this.outputEllipse1(p3, p33, this.tempP3, p35, s);
            }
        } else if (by == 3) {
            this.outputSphere(p32, f * 1.01f, s, true);
            this.outputSphere(p33, f * 1.01f, s, true);
        } else if (by == 2) {
            this.outputCircle1(p32, p33, s, f);
            this.outputCircle1(p33, p32, s, f);
        }
        this.outputCylinder1(p3, p32, p33, s, by, f, p34, p35);
        return true;
    }

    @Override
    protected void outputEllipsoid(P3 p3, P3[] p3Array, short s) {
        if (this.surfacesOnly) {
            this.debugPrint("  Not done owing to surfacesOnly");
            return;
        }
        A4 a4 = Quaternion.getQuaternionFrame(p3, p3Array[1], p3Array[3]).toAxisAngle4f();
        float f = p3Array[1].distance(p3);
        float f2 = p3Array[3].distance(p3);
        float f3 = p3Array[5].distance(p3);
        this.outputEllipsoid1(p3, f, f2, f3, a4, s);
    }

    @Override
    protected void outputSphere(P3 p3, float f, short s, boolean bl) {
        if (this.surfacesOnly) {
            this.debugPrint("  Not done owing to surfacesOnly");
            return;
        }
        this.outputEllipsoid1(p3, f, f, f, null, s);
    }

    @Override
    protected void outputTextPixel(P3 p3, int n) {
        this.debugPrint("outputTextPixel");
        if (this.surfacesOnly) {
            this.debugPrint("  Not done owing to surfacesOnly");
            return;
        }
        short s = C.getColix(n);
        this.outputSphere(p3, this.pixelSize, s, true);
    }

    @Override
    protected void outputTriangle(P3 p3, P3 p32, P3 p33, short s) {
        this.debugPrint("outputTriangle");
        if (this.surfacesOnly) {
            this.debugPrint("  Not done owing to surfacesOnly");
            return;
        }
        this.outputTriangle1(p3, p32, p33, s);
    }

    @Override
    protected void outputHeader() {
        this.debugPrint("outputHeader");
        this.output("# Created by Jmol " + Viewer.getJmolVersion() + "\n");
    }

    @Override
    protected void output(T3 t3) {
        this.debugPrint("output");
    }

    @Override
    protected void drawSurface(MeshSurface meshSurface, short s) {
        int n;
        if (Logger.debugging) {
            this.debugPrint("outputSurface");
            this.debugPrint("  nVertices=" + meshSurface.vertexCount);
            if (meshSurface.normals == null) {
                this.debugPrint("  no vertex normals");
            } else {
                this.debugPrint("  nNormals=" + meshSurface.vertexCount);
            }
            if (meshSurface.polygonColixes == null) {
                this.debugPrint("  no vertex colors");
            } else {
                this.debugPrint("  nColixes=" + meshSurface.vertexCount);
            }
            this.debugPrint("  number of triangles or quads=" + meshSurface.polygonCount);
            if (meshSurface.polygonColixes == null) {
                this.debugPrint("  no face colors");
            } else {
                this.debugPrint("  nPolygonColixes=" + meshSurface.polygonCount);
            }
            if (meshSurface.bsPolygons == null) {
                this.debugPrint("  all polygons used");
            } else {
                this.debugPrint("  number of polygons used=" + meshSurface.bsPolygons.cardinality());
            }
            this.debugPrint("  solid color=" + this.g3d.getColorArgbOrGray(s));
        }
        BS bS = meshSurface.bsPolygons;
        int n2 = meshSurface.polygonCount;
        if (meshSurface.normals != null) {
            meshSurface.normalCount = meshSurface.vertexCount;
        }
        boolean bl = bS == null;
        int[][] nArray = AU.newInt2(bl ? n2 : bS.cardinality());
        int n3 = n = bl ? n2 - 1 : bS.nextSetBit(0);
        int n4 = 0;
        while (n3 >= 0) {
            int[] nArray2;
            int[] nArray3 = meshSurface.polygonIndexes[n3];
            int n5 = n4++;
            if (meshSurface.haveQuads) {
                nArray2 = nArray3;
            } else {
                int[] nArray4 = new int[3];
                nArray4[0] = nArray3[0];
                nArray4[1] = nArray3[1];
                nArray2 = nArray4;
                nArray4[2] = nArray3[2];
            }
            nArray[n5] = nArray2;
            n3 = bl ? n3 - 1 : bS.nextSetBit(n3 + 1);
        }
        MeshSurface meshSurface2 = MeshSurface.newMesh(false, meshSurface.vertices, meshSurface.vertexCount, nArray, meshSurface.normals, 0);
        meshSurface2.vertexColixes = meshSurface.vertexColixes;
        String string = "Surface" + this.surfaceNum++;
        boolean bl2 = s != 0;
        this.addTexture(s, bl2 ? null : string);
        Point point = null;
        if (bl2) {
            this.debugPrint("outputSurface: coloring solid");
            this.debugPrint("  Omitting texture map");
        } else {
            int n6 = nArray.length;
            int n7 = (int)Math.ceil(Math.sqrt(n6));
            int n8 = n6 / n7;
            if (n6 % n7 != 0) {
                ++n8;
            }
            point = new Point(n7, n8);
            this.debugPrint("  width=" + n7 + " height=" + n8 + " size = " + n7 * n8);
            File file = this.createTextureFile(string, meshSurface2, point);
            if (file == null) {
                System.out.println("Error creating texture file: " + string);
                this.textureFiles.addLast("Error creating texture file: " + string);
                return;
            }
            String string2 = "";
            if (!file.exists()) {
                string2 = " [Does not exist]";
            } else if (file.length() == 0L) {
                string2 = " [Empty]";
            }
            this.textureFiles.addLast(file.length() + " (" + n7 + "x" + n8 + ") " + file.getPath() + string2);
            this.outputMtl(" map_Kd " + file.getName() + "\n");
            this.outputMtl(" map_Ka " + file.getName() + "\n");
        }
        M4 m4 = M4.newM(null);
        m4.setTranslation(V3.newV(meshSurface.offset));
        BS bS2 = new BS();
        this.addMesh(string, meshSurface2, m4, null, s, point, bS2);
    }

    @Override
    boolean initializeOutput(Viewer viewer, double d, GData gData, Map<String, Object> map) {
        this.debugPrint("initializeOutput: + output");
        boolean bl = this.initOutput(viewer, d, gData, map);
        if (!bl) {
            this.debugPrint("End initializeOutput (error in super):");
            return false;
        }
        this.pixelSize = 0.5f / this.scalePixelsPerAngstrom;
        int n = this.fileName.lastIndexOf(".");
        if (n < 0) {
            this.debugPrint("End initializeOutput (Error creating .mtl file):");
            return false;
        }
        this.objFileRootName = this.fileName.substring(0, n);
        try {
            String string = this.objFileRootName + ".mtl";
            this.mtlFile = new File(string);
            this.mtlout = viewer.openExportChannel(d, string, true);
        }
        catch (IOException iOException) {
            this.debugPrint("End initializeOutput (" + iOException.getMessage() + "):");
            return false;
        }
        this.outputMtl("# Created by Jmol " + Viewer.getJmolVersion() + "\n");
        this.output("\nmtllib " + this.mtlFile.getName() + "\n");
        this.textureFiles = new List();
        this.debugPrint("End initializeOutput:");
        return true;
    }

    @Override
    String finalizeOutput() {
        this.debugPrint("finalizeOutput");
        String string = this.finalizeOutput2();
        String string2 = this.mtlout.closeChannel();
        if (string2 != null) {
            Logger.info(string2);
            string2 = "ERROR EXPORTING MTL FILE: " + string2;
            if (string.startsWith("OK")) {
                return string2;
            }
            return string + " and " + string2;
        }
        string = string + ", " + this.nMtlBytes + " " + this.mtlFile.getPath();
        for (String string3 : this.textureFiles) {
            string = string + ", " + string3;
        }
        this.debugPrint(string);
        this.debugPrint("End finalizeOutput:");
        return string;
    }

    private void outputMtl(String string) {
        this.nMtlBytes += string.length();
        this.mtlout.append(string);
    }

    private String getTextureName(short s) {
        return "k" + Escape.getHexColorFromRGB(this.g3d.getColorArgbOrGray(s));
    }

    private void outputCircle1(P3 p3, P3 p32, short s, float f) {
        MeshSurface meshSurface = MeshData.getCircleData();
        M4 m4 = new M4();
        this.addTexture(s, null);
        String string = "Circle" + this.circleNum++;
        m4.setM3(this.getRotationMatrix(p3, p32, f));
        m4.m03 = p3.x;
        m4.m13 = p3.y;
        m4.m23 = p3.z;
        m4.m33 = 1.0f;
        this.addMesh(string, meshSurface, m4, m4, s, null, null);
    }

    private void outputCone1(P3 p3, P3 p32, float f, short s) {
        MeshSurface meshSurface = MeshData.getConeData();
        M4 m4 = new M4();
        this.addTexture(s, null);
        String string = "Cone" + this.coneNum++;
        m4.setM3(this.getRotationMatrix(p3, p32, f));
        m4.m03 = p3.x;
        m4.m13 = p3.y;
        m4.m23 = p3.z;
        m4.m33 = 1.0f;
        this.addMesh(string, meshSurface, m4, m4, s, null, null);
    }

    private boolean outputEllipse1(P3 p3, P3 p32, P3 p33, P3 p34, short s) {
        MeshSurface meshSurface = MeshData.getCircleData();
        M4 m4 = new M4();
        this.addTexture(s, null);
        String string = "Ellipse" + this.ellipseNum++;
        m4.setM3(this.getRotationMatrix(p3, p32, 1.0f, p33, p34));
        m4.m03 = p32.x;
        m4.m13 = p32.y;
        m4.m23 = p32.z;
        m4.m33 = 1.0f;
        this.addMesh(string, meshSurface, m4, m4, s, null, null);
        return true;
    }

    private File createTextureFile(String string, MeshSurface meshSurface, Point point) {
        short[] sArray;
        this.debugPrint("createTextureFile: " + string);
        short[] sArray2 = sArray = meshSurface.polygonColixes == null ? meshSurface.vertexColixes : meshSurface.polygonColixes;
        if (sArray == null || sArray.length == 0) {
            this.debugPrint("createTextureFile: Array problem");
            this.debugPrint("  colixes=" + sArray + " data=" + meshSurface);
            if (sArray != null) {
                this.debugPrint("  colixes.length=" + sArray.length);
            }
            return null;
        }
        int n = meshSurface.polygonIndexes.length;
        if (n <= 0) {
            this.debugPrint("createTextureFile: nFaces = 0");
            return null;
        }
        int n2 = point.x;
        int n3 = point.y;
        String string2 = "png";
        byte[][] byArray = string2.equals("tga") ? new byte[n3 * 3][n2 * 3 * 3] : (byte[][])null;
        BufferedImage bufferedImage = byArray == null ? new BufferedImage(n2 * 3, n3 * 3, 2) : null;
        int n4 = n3 - 1;
        int n5 = 0;
        P3 p3 = new P3();
        for (int i = 0; i < meshSurface.polygonIndexes.length; ++i) {
            int n6;
            if (meshSurface.polygonColixes == null) {
                int[] nArray = meshSurface.polygonIndexes[i];
                p3.set(0.0f, 0.0f, 0.0f);
                for (int n7 : nArray) {
                    p3.add(CU.colorPtFromInt2(this.g3d.getColorArgbOrGray(sArray[n7])));
                }
                p3.scale(1.0f / (float)nArray.length);
                n6 = CU.colorPtToFFRGB(p3);
            } else {
                n6 = this.g3d.getColorArgbOrGray(sArray[i]);
            }
            if (byArray == null) {
                for (int j = 0; j < 3; ++j) {
                    for (int k = 0; k < 3; ++k) {
                        bufferedImage.setRGB(n5 * 3 + j, n4 * 3 + k, n6);
                    }
                }
            }
            if ((n5 = (n5 + 1) % n2) != 0) continue;
            --n4;
        }
        try {
            Hashtable<String, Object> hashtable = new Hashtable<String, Object>();
            String string3 = this.fileName;
            if (bufferedImage != null) {
                hashtable.put("image", bufferedImage);
                hashtable.put("fileName", this.objFileRootName + "_" + string + "." + string2);
                hashtable.put("type", string2);
                hashtable.put("width", n2);
                hashtable.put("height", n3);
                string3 = this.viewer.outputToFile(hashtable);
            }
            this.debugPrint("End createTextureFile: " + string3);
            return new File(string3);
        }
        catch (Exception exception) {
            this.debugPrint("End createTextureFile (" + exception.getMessage() + "):");
            return null;
        }
    }

    private void outputEllipsoid1(P3 p3, float f, float f2, float f3, A4 a4, short s) {
        String string;
        MeshSurface meshSurface = MeshSurface.getSphereData(3);
        this.addTexture(s, null);
        if (p3 instanceof Atom) {
            Atom atom = (Atom)p3;
            string = PT.replaceAllCharacters(atom.getAtomName(), " \t", "") + "_Atom";
        } else {
            string = f == f2 && f == f3 ? "Sphere" + this.sphereNum++ : "Ellipsoid" + this.ellipsoidNum++;
        }
        this.setSphereMatrix(p3, f, f2, f3, a4, this.sphereMatrix);
        this.addMesh(string, meshSurface, this.sphereMatrix, this.sphereMatrix, s, null, null);
    }

    private void outputCylinder1(P3 p3, P3 p32, P3 p33, short s, byte by, float f, P3 p34, P3 p35) {
        MeshSurface meshSurface = MeshData.getCylinderData(false);
        M4 m4 = new M4();
        this.addTexture(s, null);
        String string = "Cylinder" + this.cylinderNum++;
        int n = p34 != null && by == 0 ? 2 : 1;
        for (int i = 0; i < n; ++i) {
            if (p34 == null) {
                m4.setM3(this.getRotationMatrix(p32, p33, f));
            } else {
                m4.setM3(this.getRotationMatrix(p3, p33, f, p34, p35));
            }
            m4.m03 = p32.x;
            m4.m13 = p32.y;
            m4.m23 = p32.z;
            m4.m33 = 1.0f;
        }
        this.addMesh(string, meshSurface, m4, m4, s, null, null);
    }

    private void outputTriangle1(P3 p3, P3 p32, P3 p33, short s) {
        MeshSurface meshSurface = MeshData.getTriangleData(p3, p32, p33);
        this.addTexture(s, null);
        String string = "Triangle" + this.triangleNum++;
        M4 m4 = M4.newM(null);
        this.addMesh(string, meshSurface, m4, m4, s, null, null);
    }

    private void addTexture(short s, String string) {
        Short s2 = s;
        if (string == null && this.textures.contains(s2)) {
            return;
        }
        this.textures.add(s2);
        SB sB = new SB();
        sB.append("\nnewmtl " + (string == null ? this.getTextureName(s) : string) + "\n");
        sB.append(" Ns 163\n");
        sB.append(" Tr " + _ObjExporter.opacityFractionalFromColix(s) + "\n");
        sB.append(" Ni 0.001\n");
        sB.append(" illum 2\n");
        sB.append(" Ka 0.20 0.20 0.20\n");
        sB.append(" Kd " + this.rgbFractionalFromColix(s) + "\n");
        sB.append(" Ks 0.25 0.25 0.25\n");
        this.outputMtl(sB.toString());
    }

    private void addMesh(String string, MeshSurface meshSurface, M4 m4, M4 m42, short s, Point point, BS bS) {
        int n;
        int n2;
        Object object;
        if (this.surfacesOnly && (string == null || !string.startsWith("Surface"))) {
            return;
        }
        this.output("\ng " + string + "\n");
        this.output("usemtl " + (point == null ? this.getTextureName(s) : string) + "\n");
        int[][] nArray = meshSurface.getFaces();
        int n3 = nArray.length;
        if (bS != null) {
            object = nArray;
            n2 = ((int[][])object).length;
            for (int i = 0; i < n2; ++i) {
                int[] nArray2;
                for (int list : nArray2 = object[i]) {
                    bS.set(list);
                }
            }
        }
        object = meshSurface.getVertices();
        n2 = meshSurface.vertexCount;
        int[] nArray3 = new int[n2];
        int n5 = this.getCoordinateMap((T3[])object, nArray3, bS);
        this.output("# Number of vertices: " + n5 + "\n");
        this.outputList((T3[])object, n2, m4, "v ", bS);
        n2 = n5;
        T3[] t3Array = meshSurface.normals;
        int n4 = meshSurface.normalCount;
        int[] nArray2 = null;
        List<String> list = null;
        if (t3Array != null) {
            list = new List<String>();
            nArray2 = this.getNormalMap(t3Array, n4, bS, list);
            n4 = list.size();
            this.output("# Number of normals: " + n4 + "\n");
            for (n = 0; n < n4; ++n) {
                this.output("vn " + (String)list.get(n));
            }
        }
        if (point != null) {
            this.output("# Number of texture coordinates: " + n3 + "\n");
            n = point.x;
            int n6 = point.y;
            int n7 = 0;
            block3: for (int i = 0; i < n6; ++i) {
                float f = (float)i + 0.5f;
                if (this.normalizeUV) {
                    f /= (float)n6;
                }
                for (int j = 0; j < n; ++j) {
                    float f2 = (float)j + 0.5f;
                    if (this.normalizeUV) {
                        f2 /= (float)n;
                    }
                    this.output("vt " + f2 + " " + f + "\n");
                    if (++n7 == n3) continue block3;
                }
            }
            if (!this.normalizeUV) {
                this.output("vt 0.0 0.0\n");
                this.output("vt " + (float)n + " " + (float)n6 + "\n");
            }
        }
        this.output("# Number of faces: " + n3 + "\n");
        for (n = 0; n < n3; ++n) {
            if (point != null) {
                this.outputFace2(nArray[n], n, nArray3, nArray2);
                continue;
            }
            this.outputFace1(nArray[n], nArray3, nArray2);
        }
        if (point != null) {
            this.currentTextureOrigin += n3;
        }
        this.currentVertexOrigin += n2;
        this.currentNormalOrigin += n4;
    }

    private void outputList(T3[] t3Array, int n, M4 m4, String string, BS bS) {
        for (int i = 0; i < n; ++i) {
            if (bS != null && !bS.get(i)) continue;
            this.ptTemp.setT(t3Array[i]);
            if (m4 != null) {
                m4.transform(this.ptTemp);
            }
            this.output(string + this.ptTemp.x + " " + this.ptTemp.y + " " + this.ptTemp.z + "\n");
        }
    }

    private void outputFace1(int[] nArray, int[] nArray2, int[] nArray3) {
        this.output("f");
        for (int n : nArray) {
            this.output(" " + ((nArray2 == null ? n : nArray2[n]) + this.currentVertexOrigin) + "//" + ((nArray3 == null ? n : nArray3[n]) + this.currentNormalOrigin));
        }
        this.output("\n");
    }

    private void outputFace2(int[] nArray, int n, int[] nArray2, int[] nArray3) {
        this.output("f");
        for (int n2 : nArray) {
            this.output(" " + ((nArray2 == null ? n2 : nArray2[n2]) + this.currentVertexOrigin) + "/" + (this.currentTextureOrigin + n) + "/" + ((nArray3 == null ? n2 : nArray3[n2]) + this.currentNormalOrigin));
        }
        this.output("\n");
    }
}

