/*
 * Decompiled with CFR 0.152.
 */
package org.jmol.parallel;

import java.util.concurrent.Executor;
import java.util.concurrent.Executors;
import javajs.util.List;
import org.jmol.api.JmolParallelProcessor;
import org.jmol.parallel.ScriptProcess;
import org.jmol.parallel.ScriptProcessRunnable;
import org.jmol.script.ScriptContext;
import org.jmol.script.ScriptFunction;
import org.jmol.util.Logger;
import org.jmol.viewer.ShapeManager;
import org.jmol.viewer.Viewer;

public class ScriptParallelProcessor
extends ScriptFunction
implements JmolParallelProcessor {
    Viewer viewer;
    public volatile int counter = 0;
    public volatile Error error = null;
    Object lock = new Object();
    private List<ScriptProcess> processes = new List();

    @Override
    public Object getExecutor() {
        return Executors.newCachedThreadPool();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void runAllProcesses(Viewer viewer) {
        if (this.processes.size() == 0) {
            return;
        }
        this.viewer = viewer;
        boolean bl = !viewer.isParallel() && viewer.setParallel(true);
        List<ShapeManager> list = new List<ShapeManager>();
        this.error = null;
        this.counter = 0;
        if (Logger.debugging) {
            Logger.debug("running " + this.processes.size() + " processes on " + Viewer.nProcessors + " processesors inParallel=" + bl);
        }
        this.counter = this.processes.size();
        int n = this.processes.size();
        while (--n >= 0) {
            ShapeManager shapeManager = null;
            if (bl) {
                shapeManager = new ShapeManager(viewer, viewer.getModelSet());
                list.addLast(shapeManager);
            }
            this.runProcess((ScriptProcess)this.processes.remove(0), shapeManager);
        }
        Object object = this.lock;
        synchronized (object) {
            while (this.counter > 0) {
                try {
                    this.lock.wait();
                }
                catch (InterruptedException interruptedException) {
                    // empty catch block
                }
                if (this.error == null) continue;
                throw this.error;
            }
        }
        this.mergeResults(list);
        viewer.setParallel(false);
    }

    void mergeResults(List<ShapeManager> list) {
        try {
            for (int i = 0; i < list.size(); ++i) {
                this.viewer.mergeShapes(((ShapeManager)list.get(i)).getShapes());
            }
        }
        catch (Error error) {
            throw error;
        }
        finally {
            this.counter = -1;
            list = null;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    void clearShapeManager(Error error) {
        ScriptParallelProcessor scriptParallelProcessor = this;
        synchronized (scriptParallelProcessor) {
            this.error = error;
            this.notifyAll();
        }
    }

    @Override
    public void addProcess(String string, ScriptContext scriptContext) {
        this.processes.addLast(new ScriptProcess(string, scriptContext));
    }

    private void runProcess(ScriptProcess scriptProcess, ShapeManager shapeManager) {
        Executor executor;
        ScriptProcessRunnable scriptProcessRunnable = new ScriptProcessRunnable(this, scriptProcess, this.lock, shapeManager);
        Executor executor2 = executor = shapeManager == null ? null : (Executor)this.viewer.getExecutor();
        if (executor != null) {
            executor.execute(scriptProcessRunnable);
        } else {
            scriptProcessRunnable.run();
        }
    }

    void eval(ScriptContext scriptContext, ShapeManager shapeManager) {
        this.viewer.evalParallel(scriptContext, shapeManager);
    }
}

