/*
 * Decompiled with CFR 0.152.
 */
package org.jmol.viewer;

import java.io.Serializable;
import java.util.Arrays;
import java.util.Calendar;
import java.util.Enumeration;
import java.util.Hashtable;
import java.util.Map;
import java.util.Properties;
import javajs.util.Base64;
import javajs.util.List;
import javajs.util.M3;
import javajs.util.P3;
import javajs.util.PT;
import javajs.util.SB;
import javajs.util.V3;
import org.jmol.api.JmolPropertyManager;
import org.jmol.api.SymmetryInterface;
import org.jmol.java.BS;
import org.jmol.modelset.Atom;
import org.jmol.modelset.Bond;
import org.jmol.modelset.BondSet;
import org.jmol.modelset.Chain;
import org.jmol.modelset.Group;
import org.jmol.modelset.LabelToken;
import org.jmol.modelset.Model;
import org.jmol.modelset.ModelSet;
import org.jmol.script.SV;
import org.jmol.script.T;
import org.jmol.util.BSUtil;
import org.jmol.util.C;
import org.jmol.util.Elements;
import org.jmol.util.Escape;
import org.jmol.util.JmolEdge;
import org.jmol.util.JmolMolecule;
import org.jmol.util.JmolNode;
import org.jmol.util.Logger;
import org.jmol.util.Quaternion;
import org.jmol.util.Txt;
import org.jmol.viewer.Viewer;

public class PropertyManager
implements JmolPropertyManager {
    Viewer viewer;
    private Map<String, Integer> map = new Hashtable<String, Integer>();
    private static final String atomExpression = "<atom selection>";
    private static final String[] propertyTypes = new String[]{"appletInfo", "", "", "fileName", "", "", "fileHeader", "", "", "fileContents", "<pathname>", "", "fileContents", "", "", "animationInfo", "", "", "modelInfo", "<atom selection>", "{*}", "ligandInfo", "<atom selection>", "{*}", "shapeInfo", "", "", "measurementInfo", "", "", "centerInfo", "", "", "orientationInfo", "", "", "transformInfo", "", "", "atomList", "<atom selection>", "(visible)", "atomInfo", "<atom selection>", "(visible)", "bondInfo", "<atom selection>", "(visible)", "chainInfo", "<atom selection>", "(visible)", "polymerInfo", "<atom selection>", "(visible)", "moleculeInfo", "<atom selection>", "(visible)", "stateInfo", "<state type>", "all", "extractModel", "<atom selection>", "(visible)", "jmolStatus", "statusNameList", "", "jmolViewer", "", "", "messageQueue", "", "", "auxiliaryInfo", "<atom selection>", "{*}", "boundBoxInfo", "", "", "dataInfo", "<data type>", "types", "image", "<width=www,height=hhh>", "", "evaluate", "<expression>", "", "menu", "<type>", "current", "minimizationInfo", "", "", "pointGroupInfo", "<atom selection>", "(visible)", "fileInfo", "<type>", "", "errorMessage", "", "", "mouseInfo", "", "", "isosurfaceInfo", "", "", "isosurfaceData", "", "", "consoleText", "", "", "JSpecView", "<key>", "", "scriptQueueInfo", "", "", "nmrInfo", "<elementSymbol> or 'all' or 'shifts'", "all"};
    private static final int PROP_APPLET_INFO = 0;
    private static final int PROP_FILENAME = 1;
    private static final int PROP_FILEHEADER = 2;
    private static final int PROP_FILECONTENTS_PATH = 3;
    private static final int PROP_FILECONTENTS = 4;
    private static final int PROP_ANIMATION_INFO = 5;
    private static final int PROP_MODEL_INFO = 6;
    private static final int PROP_LIGAND_INFO = 7;
    private static final int PROP_SHAPE_INFO = 8;
    private static final int PROP_MEASUREMENT_INFO = 9;
    private static final int PROP_CENTER_INFO = 10;
    private static final int PROP_ORIENTATION_INFO = 11;
    private static final int PROP_TRANSFORM_INFO = 12;
    private static final int PROP_ATOM_LIST = 13;
    private static final int PROP_ATOM_INFO = 14;
    private static final int PROP_BOND_INFO = 15;
    private static final int PROP_CHAIN_INFO = 16;
    private static final int PROP_POLYMER_INFO = 17;
    private static final int PROP_MOLECULE_INFO = 18;
    private static final int PROP_STATE_INFO = 19;
    private static final int PROP_EXTRACT_MODEL = 20;
    private static final int PROP_JMOL_STATUS = 21;
    private static final int PROP_JMOL_VIEWER = 22;
    private static final int PROP_MESSAGE_QUEUE = 23;
    private static final int PROP_AUXILIARY_INFO = 24;
    private static final int PROP_BOUNDBOX_INFO = 25;
    private static final int PROP_DATA_INFO = 26;
    private static final int PROP_IMAGE = 27;
    private static final int PROP_EVALUATE = 28;
    private static final int PROP_MENU = 29;
    private static final int PROP_MINIMIZATION_INFO = 30;
    private static final int PROP_POINTGROUP_INFO = 31;
    private static final int PROP_FILE_INFO = 32;
    private static final int PROP_ERROR_MESSAGE = 33;
    private static final int PROP_MOUSE_INFO = 34;
    private static final int PROP_ISOSURFACE_INFO = 35;
    private static final int PROP_ISOSURFACE_DATA = 36;
    private static final int PROP_CONSOLE_TEXT = 37;
    private static final int PROP_JSPECVIEW = 38;
    private static final int PROP_SCRIPT_QUEUE_INFO = 39;
    private static final int PROP_NMR_INFO = 40;
    private static final int PROP_COUNT = 41;
    private static final String[] readableTypes = new String[]{"", "stateinfo", "extractmodel", "filecontents", "fileheader", "image", "menu", "minimizationInfo"};

    @Override
    public void setViewer(Viewer viewer) {
        this.viewer = viewer;
        int n = 0;
        for (int i = 0; i < propertyTypes.length; i += 3) {
            this.map.put(propertyTypes[i].toLowerCase(), n++);
        }
    }

    @Override
    public int getPropertyNumber(String string) {
        Integer n = this.map.get(string == null ? "" : string.toLowerCase());
        return n == null ? -1 : n;
    }

    @Override
    public String getDefaultPropertyParam(int n) {
        return n < 0 ? "" : propertyTypes[n * 3 + 2];
    }

    @Override
    public boolean checkPropertyParameter(String string) {
        int n = this.getPropertyNumber(string);
        String string2 = PropertyManager.getParamType(n);
        return string2.length() > 0 && string2 != atomExpression;
    }

    @Override
    public Object getProperty(String string, String string2, Object object) {
        if (propertyTypes.length != 123) {
            Logger.warn("propertyTypes is not the right length: " + propertyTypes.length + " != " + 123);
        }
        Object object2 = string2.indexOf(".") >= 0 || string2.indexOf("[") >= 0 ? this.getModelProperty(string2, object) : this.getPropertyAsObject(string2, object, string);
        if (string == null) {
            return object2;
        }
        boolean bl = string.equalsIgnoreCase("readable");
        if (bl) {
            String string3 = string = PropertyManager.isReadableAsString(string2) ? "String" : "JSON";
        }
        if (string.equalsIgnoreCase("String")) {
            return object2 == null ? "" : object2.toString();
        }
        if (bl) {
            return Escape.toReadable(string2, object2);
        }
        if (string.equalsIgnoreCase("JSON")) {
            return "{" + PT.toJSON(string2, object2) + "}";
        }
        return object2;
    }

    private Object getModelProperty(String string, Object object) {
        string = string.replace(']', ' ').replace('[', ' ').replace('.', ' ');
        string = PT.simpleReplace(string, "  ", " ");
        String[] stringArray = PT.split(PT.trim(string, " "), " ");
        SV[] sVArray = new SV[stringArray.length];
        string = stringArray[0];
        for (int i = 1; i < stringArray.length; ++i) {
            int n = PT.parseInt(stringArray[i]);
            sVArray[i] = n != Integer.MIN_VALUE ? SV.newScriptVariableInt(n) : SV.newVariable(4, stringArray[i]);
        }
        return this.extractProperty(this.getProperty(null, string, object), sVArray, 1);
    }

    @Override
    public Object extractProperty(Object object, SV[] sVArray, int n) {
        if (n >= sVArray.length) {
            return object;
        }
        SV sV = sVArray[n++];
        switch (sV.tok) {
            case 2: {
                int n2 = sV.asInt() - 1;
                if (object instanceof List) {
                    List list = (List)object;
                    if (n2 < 0) {
                        n2 += list.size();
                    }
                    if (n2 >= 0 && n2 < list.size()) {
                        return this.extractProperty(list.get(n2), sVArray, n);
                    }
                    return "";
                }
                if (object instanceof M3) {
                    M3 m3 = (M3)object;
                    float[][] fArrayArray = new float[][]{{m3.m00, m3.m01, m3.m02}, {m3.m10, m3.m11, m3.m12}, {m3.m20, m3.m21, m3.m22}};
                    if (n2 < 0) {
                        n2 += 3;
                    }
                    if (n2 >= 0 && n2 < 3) {
                        return this.extractProperty(fArrayArray, sVArray, --n);
                    }
                    return "";
                }
                if (PT.isAI(object)) {
                    int[] nArray = (int[])object;
                    if (n2 < 0) {
                        n2 += nArray.length;
                    }
                    if (n2 >= 0 && n2 < nArray.length) {
                        return nArray[n2];
                    }
                    return "";
                }
                if (PT.isAD(object)) {
                    double[] dArray = (double[])object;
                    if (n2 < 0) {
                        n2 += dArray.length;
                    }
                    if (n2 >= 0 && n2 < dArray.length) {
                        return dArray[n2];
                    }
                    return "";
                }
                if (PT.isAF(object)) {
                    float[] fArray = (float[])object;
                    if (n2 < 0) {
                        n2 += fArray.length;
                    }
                    if (n2 >= 0 && n2 < fArray.length) {
                        return Float.valueOf(fArray[n2]);
                    }
                    return "";
                }
                if (PT.isAII(object)) {
                    int[][] nArray = (int[][])object;
                    if (n2 < 0) {
                        n2 += nArray.length;
                    }
                    if (n2 >= 0 && n2 < nArray.length) {
                        return this.extractProperty(nArray[n2], sVArray, n);
                    }
                    return "";
                }
                if (PT.isAFF(object)) {
                    float[][] fArray = (float[][])object;
                    if (n2 < 0) {
                        n2 += fArray.length;
                    }
                    if (n2 >= 0 && n2 < fArray.length) {
                        return this.extractProperty(fArray[n2], sVArray, n);
                    }
                    return "";
                }
                if (PT.isAS(object)) {
                    String[] stringArray = (String[])object;
                    if (n2 < 0) {
                        n2 += stringArray.length;
                    }
                    if (n2 >= 0 && n2 < stringArray.length) {
                        return stringArray[n2];
                    }
                    return "";
                }
                if (!(object instanceof Object[])) break;
                Object[] objectArray = (Object[])object;
                if (n2 < 0) {
                    n2 += objectArray.length;
                }
                if (n2 >= 0 && n2 < objectArray.length) {
                    return objectArray[n2];
                }
                return "";
            }
            case 4: {
                String string = sV.asString();
                if (object instanceof Map) {
                    Map map = (Map)object;
                    if (string.equalsIgnoreCase("keys")) {
                        List<String> list = new List<String>();
                        for (String string2 : map.keySet()) {
                            list.addLast(string2);
                        }
                        return this.extractProperty(list, sVArray, n);
                    }
                    if (!map.containsKey(string)) {
                        for (String string3 : map.keySet()) {
                            if (!string3.equalsIgnoreCase(string)) continue;
                            string = string3;
                            break;
                        }
                    }
                    if (map.containsKey(string)) {
                        return this.extractProperty(map.get(string), sVArray, n);
                    }
                    return "";
                }
                if (!(object instanceof List)) break;
                List list = (List)object;
                List<Object> list2 = new List<Object>();
                --n;
                for (int i = 0; i < list.size(); ++i) {
                    Object e = list.get(i);
                    if (!(e instanceof Map)) continue;
                    list2.addLast(this.extractProperty(e, sVArray, n));
                }
                return list2;
            }
        }
        return object;
    }

    private static String getPropertyName(int n) {
        return n < 0 ? "" : propertyTypes[n * 3];
    }

    private static String getParamType(int n) {
        return n < 0 ? "" : propertyTypes[n * 3 + 1];
    }

    private static boolean isReadableAsString(String string) {
        int n = readableTypes.length;
        while (--n >= 0) {
            if (!string.equalsIgnoreCase(readableTypes[n])) continue;
            return true;
        }
        return false;
    }

    private Object getPropertyAsObject(String string, Object object, String string2) {
        if (string.equals("tokenList")) {
            return T.getTokensLike((String)object);
        }
        int n = this.getPropertyNumber(string);
        boolean bl = object != null && object.toString().length() > 0;
        Object object2 = bl ? object : this.getDefaultPropertyParam(n);
        switch (n) {
            case 0: {
                return this.viewer.getAppletInfo();
            }
            case 5: {
                return this.viewer.getAnimationInfo();
            }
            case 13: {
                return this.viewer.getAtomBitSetVector(object2);
            }
            case 14: {
                return this.getAllAtomInfo(this.viewer.getAtomBitSet(object2));
            }
            case 24: {
                return this.viewer.getAuxiliaryInfo(object2);
            }
            case 15: {
                return this.getAllBondInfo(object2);
            }
            case 25: {
                return this.viewer.getBoundBoxInfo();
            }
            case 10: {
                return this.viewer.getRotationCenter();
            }
            case 16: {
                return this.getAllChainInfo(this.viewer.getAtomBitSet(object2));
            }
            case 37: {
                return this.viewer.getProperty("DATA_API", "consoleText", null);
            }
            case 26: {
                return this.viewer.getData(object2.toString());
            }
            case 33: {
                return this.viewer.getErrorMessageUn();
            }
            case 28: {
                return this.viewer.evaluateExpression(object2.toString());
            }
            case 20: {
                return this.viewer.getModelExtract(object2, true, false, "MOL");
            }
            case 32: {
                return PropertyManager.getFileInfo(this.viewer.getFileData(), object2.toString());
            }
            case 1: {
                return this.viewer.getFullPathName();
            }
            case 2: {
                return this.viewer.getFileHeader();
            }
            case 3: 
            case 4: {
                if (bl) {
                    return this.viewer.getFileAsString(object2.toString());
                }
                return this.viewer.getCurrentFileAsString();
            }
            case 27: {
                String string3 = object2.toString().toLowerCase();
                int n2 = -1;
                int n3 = -1;
                int n4 = string3.indexOf("height=");
                if (n4 >= 0) {
                    n2 = PT.parseInt(string3.substring(n4 + 7));
                }
                if ((n4 = string3.indexOf("width=")) >= 0) {
                    n3 = PT.parseInt(string3.substring(n4 + 6));
                }
                if (n3 < 0 && n2 < 0) {
                    n3 = -1;
                    n2 = -1;
                } else if (n3 < 0) {
                    n3 = n2;
                } else {
                    n2 = n3;
                }
                if (string3.indexOf("g64") >= 0 || string3.indexOf("base64") >= 0) {
                    string2 = "string";
                }
                String string4 = "JPG";
                if (string3.indexOf("type=") >= 0) {
                    string4 = PT.getTokens(PT.replaceAllCharacter(string3.substring(string3.indexOf("type=") + 5), ";,", ' '))[0];
                }
                String[] stringArray = new String[1];
                byte[] byArray = this.viewer.getImageAsBytes(string4.toUpperCase(), n3, n2, -1, stringArray);
                return stringArray[0] != null ? stringArray[0] : (string2 == null ? (Object)byArray : Base64.getBase64(byArray).toString());
            }
            case 35: {
                return this.viewer.getShapeProperty(24, "getInfo");
            }
            case 36: {
                return this.viewer.getShapeProperty(24, "getData");
            }
            case 40: {
                return this.viewer.getNMRCalculation().getInfo(object2.toString());
            }
            case 21: {
                return this.viewer.getStatusChanged(object2.toString());
            }
            case 22: {
                return this.viewer;
            }
            case 38: {
                return this.viewer.getJspecViewProperties(object2);
            }
            case 7: {
                return this.getLigandInfo(this.viewer.getAtomBitSet(object2));
            }
            case 9: {
                return this.viewer.getMeasurementInfo();
            }
            case 29: {
                return this.viewer.getMenu(object2.toString());
            }
            case 23: {
                return this.viewer.getMessageQueue();
            }
            case 30: {
                return this.viewer.getMinimizationInfo();
            }
            case 6: {
                return this.getModelInfo(this.viewer.getAtomBitSet(object2));
            }
            case 18: {
                return this.getMoleculeInfo(this.viewer.getAtomBitSet(object2));
            }
            case 34: {
                return this.viewer.getMouseInfo();
            }
            case 11: {
                return this.viewer.getOrientationInfo();
            }
            case 31: {
                return this.viewer.getPointGroupInfo(object2);
            }
            case 17: {
                return this.getAllPolymerInfo(this.viewer.getAtomBitSet(object2));
            }
            case 39: {
                return this.viewer.getScriptQueueInfo();
            }
            case 8: {
                return this.viewer.getShapeInfo();
            }
            case 19: {
                return this.viewer.getStateInfo3(object2.toString(), 0, 0);
            }
            case 12: {
                return this.viewer.getMatrixRotate();
            }
        }
        Object[] objectArray = new String[41];
        for (int i = 0; i < 41; ++i) {
            String string5 = PropertyManager.getParamType(i);
            String string6 = this.getDefaultPropertyParam(i);
            String string7 = PropertyManager.getPropertyName(i);
            objectArray[i] = string7.charAt(0) == 'X' ? "" : string7 + (string5 != "" ? " " + PropertyManager.getParamType(i) + (string6 != "" ? " #default: " + this.getDefaultPropertyParam(i) : "") : "");
        }
        Arrays.sort(objectArray);
        SB sB = new SB();
        sB.append("getProperty ERROR\n").append(string).append("?\nOptions include:\n");
        for (int i = 0; i < 41; ++i) {
            if (((String)objectArray[i]).length() <= 0) continue;
            sB.append("\n getProperty ").append((String)objectArray[i]);
        }
        return sB.toString();
    }

    static Object getFileInfo(Object object, String string) {
        boolean bl;
        Hashtable<String, String> hashtable = new Hashtable<String, String>();
        if (object == null) {
            return hashtable;
        }
        boolean bl2 = bl = string != null && string.length() > 0;
        if (object instanceof Map) {
            return bl ? ((Map)object).get(string) : object;
        }
        String[] stringArray = PT.split((String)object, "\n");
        if (stringArray.length == 0 || stringArray[0].length() < 6 || stringArray[0].charAt(6) != ' ' || !stringArray[0].substring(0, 6).equals(stringArray[0].substring(0, 6).toUpperCase())) {
            hashtable.put("fileHeader", (String)object);
            return hashtable;
        }
        String string2 = "";
        SB sB = new SB();
        if (bl) {
            string = string.toUpperCase();
        }
        String string3 = "";
        for (int i = 0; i < stringArray.length; ++i) {
            String string4 = stringArray[i];
            if (string4.length() < 12) continue;
            string3 = string4.substring(0, 6).trim();
            String string5 = string4.substring(7, 10).trim();
            if (string3.equals("REMARK")) {
                string3 = string3 + string5;
            }
            if (!string3.equals(string2)) {
                if (bl && string2.equals(string)) {
                    return sB.toString();
                }
                if (!bl) {
                    hashtable.put(string2, sB.toString());
                    sB = new SB();
                }
                string2 = string3;
            }
            if (bl && !string3.equals(string)) continue;
            sB.append(string4).appendC('\n');
        }
        if (!bl) {
            hashtable.put(string2, sB.toString());
        }
        if (bl) {
            return string3.equals(string) ? sB.toString() : "";
        }
        return hashtable;
    }

    public List<Map<String, Object>> getMoleculeInfo(Object object) {
        BS bS = this.viewer.getAtomBitSet(object);
        JmolMolecule[] jmolMoleculeArray = this.viewer.modelSet.getMolecules();
        List<Map<String, Object>> list = new List<Map<String, Object>>();
        BS bS2 = new BS();
        for (int i = 0; i < jmolMoleculeArray.length; ++i) {
            bS2 = BSUtil.copy(bS);
            JmolMolecule jmolMolecule = jmolMoleculeArray[i];
            bS2.and(jmolMolecule.atomList);
            if (bS2.length() <= 0) continue;
            Hashtable<String, Object> hashtable = new Hashtable<String, Object>();
            hashtable.put("mf", jmolMolecule.getMolecularFormula(false));
            hashtable.put("number", jmolMolecule.moleculeIndex + 1);
            hashtable.put("modelNumber", this.viewer.modelSet.getModelNumberDotted(jmolMolecule.modelIndex));
            hashtable.put("numberInModel", jmolMolecule.indexInModel + 1);
            hashtable.put("nAtoms", jmolMolecule.atomCount);
            hashtable.put("nElements", jmolMolecule.nElements);
            list.addLast((Map<String, Object>)hashtable);
        }
        return list;
    }

    @Override
    public Map<String, Object> getModelInfo(Object object) {
        BS bS = this.viewer.getModelBitSet(this.viewer.getAtomBitSet(object), false);
        ModelSet modelSet = this.viewer.getModelSet();
        Hashtable<String, Object> hashtable = new Hashtable<String, Object>();
        hashtable.put("modelSetName", modelSet.modelSetName);
        hashtable.put("modelCount", modelSet.modelCount);
        hashtable.put("isTainted", modelSet.tainted != null);
        hashtable.put("canSkipLoad", modelSet.canSkipLoad);
        hashtable.put("modelSetHasVibrationVectors", modelSet.modelSetHasVibrationVectors());
        if (modelSet.modelSetProperties != null) {
            hashtable.put("modelSetProperties", modelSet.modelSetProperties);
        }
        hashtable.put("modelCountSelected", BSUtil.cardinalityOf(bS));
        hashtable.put("modelsSelected", bS);
        List list = new List();
        modelSet.getMolecules();
        int n = bS.nextSetBit(0);
        while (n >= 0) {
            Float f;
            Hashtable<String, Object> hashtable2 = new Hashtable<String, Object>();
            hashtable2.put("_ipt", n);
            hashtable2.put("num", modelSet.getModelNumber(n));
            hashtable2.put("file_model", modelSet.getModelNumberDotted(n));
            hashtable2.put("name", modelSet.getModelName(n));
            String string = modelSet.getModelTitle(n);
            if (string != null) {
                hashtable2.put("title", string);
            }
            if ((string = modelSet.getModelFileName(n)) != null) {
                hashtable2.put("file", string);
            }
            if ((string = (String)modelSet.getModelAuxiliaryInfoValue(n, "modelID")) != null) {
                hashtable2.put("id", string);
            }
            hashtable2.put("vibrationVectors", this.viewer.modelHasVibrationVectors(n));
            Model model = modelSet.models[n];
            hashtable2.put("atomCount", model.atomCount);
            hashtable2.put("bondCount", model.getBondCount());
            hashtable2.put("groupCount", model.getGroupCount());
            hashtable2.put("moleculeCount", model.moleculeCount);
            hashtable2.put("polymerCount", model.getBioPolymerCount());
            hashtable2.put("chainCount", modelSet.getChainCountInModel(n, true));
            if (model.properties != null) {
                hashtable2.put("modelProperties", model.properties);
            }
            if ((f = (Float)modelSet.getModelAuxiliaryInfoValue(n, "Energy")) != null) {
                hashtable2.put("energy", f);
            }
            hashtable2.put("atomCount", model.atomCount);
            list.addLast(hashtable2);
            n = bS.nextSetBit(n + 1);
        }
        hashtable.put("models", list);
        return hashtable;
    }

    @Override
    public Map<String, Object> getLigandInfo(Object object) {
        BS bS = this.viewer.getAtomBitSet(object);
        BS bS2 = this.viewer.getAtomBitSet("solvent");
        Hashtable<String, Object> hashtable = new Hashtable<String, Object>();
        List list = new List();
        hashtable.put("ligands", list);
        ModelSet modelSet = this.viewer.modelSet;
        BS bS3 = BSUtil.copyInvert(bS, modelSet.atomCount);
        bS3.or(bS2);
        JmolNode[] jmolNodeArray = modelSet.atoms;
        int n = bS.nextSetBit(0);
        while (n >= 0) {
            if (jmolNodeArray[n].isProtein() || jmolNodeArray[n].isNucleic()) {
                bS3.set(n);
            }
            n = bS.nextSetBit(n + 1);
        }
        BS[] bSArray = new BS[modelSet.modelCount];
        int n2 = modelSet.modelCount;
        while (--n2 >= 0) {
            bSArray[n2] = this.viewer.getModelUndeletedAtomsBitSet(n2);
            bSArray[n2].andNot(bS3);
        }
        JmolMolecule[] jmolMoleculeArray = JmolMolecule.getMolecules(jmolNodeArray, bSArray, null, bS3);
        for (int i = 0; i < jmolMoleculeArray.length; ++i) {
            BS bS4 = jmolMoleculeArray[i].atomList;
            Hashtable<String, String> hashtable2 = new Hashtable<String, String>();
            list.addLast(hashtable2);
            hashtable2.put("atoms", Escape.eBS(bS4));
            String string = "";
            String string2 = "";
            Group group = null;
            int n3 = 0;
            String string3 = null;
            String string4 = "";
            String string5 = "";
            int n4 = Integer.MAX_VALUE;
            int n5 = Integer.MAX_VALUE;
            int n6 = bS4.nextSetBit(0);
            while (n6 >= 0) {
                JmolNode jmolNode = jmolNodeArray[n6];
                if (group != ((Atom)jmolNode).group) {
                    group = ((Atom)jmolNode).group;
                    int n7 = ((Atom)jmolNode).getResno();
                    int n8 = ((Atom)jmolNode).getChainID();
                    if (n4 != n7 - 1) {
                        if (string4.length() != 0 && n4 != n5) {
                            string4 = string4 + "-" + n4;
                        }
                        n8 = -1;
                        n5 = n7;
                    }
                    string5 = "/" + modelSet.getModelNumberDotted(((Atom)jmolNode).modelIndex);
                    if (n3 != 0 && n8 != n3) {
                        string4 = string4 + ":" + string3 + string5;
                    }
                    if (n8 == -1) {
                        string4 = string4 + " " + n7;
                    }
                    n4 = n7;
                    n3 = ((Atom)jmolNode).getChainID();
                    string3 = ((Atom)jmolNode).getChainIDStr();
                    string = string + string2 + ((Atom)jmolNode).getGroup3(false);
                    string2 = "-";
                }
                n6 = bS4.nextSetBit(n6 + 1);
            }
            string4 = string4 + (n5 == n4 ? "" : "-" + n4) + (n3 == 0 ? "" : ":" + string3) + string5;
            hashtable2.put("groupNames", string);
            hashtable2.put("residueList", string4.substring(1));
        }
        return hashtable;
    }

    @Override
    public Object getSymmetryInfo(BS bS, String string, int n, P3 p3, P3 p32, String string2, int n2) {
        int n3;
        int n4 = -1;
        if (bS == null) {
            n4 = this.viewer.getCurrentModelIndex();
            if (n4 < 0) {
                return "";
            }
            bS = this.viewer.getModelUndeletedAtomsBitSet(n4);
        }
        if ((n3 = bS.nextSetBit(0)) < 0) {
            return "";
        }
        n4 = this.viewer.modelSet.atoms[n3].modelIndex;
        SymmetryInterface symmetryInterface = this.viewer.modelSet.models[n4].biosymmetry;
        if (symmetryInterface == null) {
            symmetryInterface = this.viewer.modelSet.getUnitCell(n4);
        }
        if (symmetryInterface == null) {
            return "";
        }
        return symmetryInterface.getSymmetryInfo(this.viewer.modelSet, n4, n3, symmetryInterface, string, n, p3, p32, string2, n2);
    }

    @Override
    public String getModelExtract(BS bS, boolean bl, boolean bl2, String string) {
        Quaternion quaternion;
        int n;
        int n2;
        Cloneable cloneable;
        Object object;
        boolean bl3 = string.equalsIgnoreCase("V3000");
        boolean bl4 = string.equalsIgnoreCase("SDF");
        boolean bl5 = string.equalsIgnoreCase("XYZVIB");
        boolean bl6 = string.equalsIgnoreCase("JSON") || string.equalsIgnoreCase("CD");
        SB sB = new SB();
        ModelSet modelSet = this.viewer.modelSet;
        if (!bl5 && !bl6) {
            sB.append(bl2 ? "Jmol Model Kit" : this.viewer.getFullPathName().replace('\\', '/'));
            object = Viewer.getJmolVersion();
            sB.append("\n__Jmol-").append(((String)object).substring(0, 2));
            cloneable = Calendar.getInstance();
            int n3 = ((Calendar)cloneable).get(2);
            n2 = ((Calendar)cloneable).get(5);
            n = ((Calendar)cloneable).get(1);
            int n4 = ((Calendar)cloneable).get(11);
            int n5 = ((Calendar)cloneable).get(12);
            Txt.rightJustify(sB, "_00", "" + (1 + n3));
            Txt.rightJustify(sB, "00", "" + n2);
            sB.append(("" + n).substring(2, 4));
            Txt.rightJustify(sB, "00", "" + n4);
            Txt.rightJustify(sB, "00", "" + n5);
            sB.append("3D 1   1.00000     0.00000     0");
            sB.append("\nJmol version ").append(Viewer.getJmolVersion()).append(" EXTRACT: ").append(Escape.eBS(bS)).append("\n");
        }
        object = BSUtil.copy(bS);
        Atom[] atomArray = modelSet.atoms;
        n2 = bS.nextSetBit(0);
        while (n2 >= 0) {
            if (bl && atomArray[n2].isDeleted()) {
                ((BS)object).clear(n2);
            }
            n2 = bS.nextSetBit(n2 + 1);
        }
        BS bS2 = PropertyManager.getCovalentBondsForAtoms(modelSet.bonds, modelSet.bondCount, (BS)object);
        if (!bl5 && ((BS)object).cardinality() == 0) {
            return "";
        }
        n = 1;
        Quaternion quaternion2 = quaternion = bl ? this.viewer.getRotationQuaternion() : null;
        if (bl4) {
            String string2 = sB.toString();
            sB = new SB();
            cloneable = this.viewer.getModelBitSet((BS)object, true);
            int n6 = ((BS)cloneable).nextSetBit(0);
            while (n6 >= 0) {
                sB.append(string2);
                BS bS3 = BSUtil.copy((BS)object);
                bS3.and(modelSet.getModelAtomBitSetIncludingDeleted(n6, false));
                bS2 = PropertyManager.getCovalentBondsForAtoms(modelSet.bonds, modelSet.bondCount, bS3);
                boolean bl7 = this.addMolFile(sB, bS3, bS2, false, false, quaternion);
                n = bl7 ? 1 : 0;
                if (bl7) {
                    sB.append("$$$$\n");
                    n6 = ((BS)cloneable).nextSetBit(n6 + 1);
                    continue;
                }
                break;
            }
        } else if (bl5) {
            LabelToken[] labelTokenArray = LabelToken.compile(this.viewer, "%-2e %10.5x %10.5y %10.5z %10.5vx %10.5vy %10.5vz\n", '\u0000', null);
            cloneable = LabelToken.compile(this.viewer, "%-2e %10.5x %10.5y %10.5z\n", '\u0000', null);
            BS bS4 = this.viewer.getModelBitSet((BS)object, true);
            int n7 = bS4.nextSetBit(0);
            while (n7 >= 0) {
                BS bS5 = BSUtil.copy((BS)object);
                bS5.and(modelSet.getModelAtomBitSetIncludingDeleted(n7, false));
                if (bS5.cardinality() != 0) {
                    sB.appendI(bS5.cardinality()).appendC('\n');
                    Properties properties = modelSet.models[n7].properties;
                    sB.append("Model[" + (n7 + 1) + "]: ");
                    if (modelSet.frameTitles[n7] != null && modelSet.frameTitles[n7].length() > 0) {
                        sB.append(modelSet.frameTitles[n7].replace('\n', ' '));
                    } else if (properties == null) {
                        sB.append("Jmol " + Viewer.getJmolVersion());
                    } else {
                        SB sB2 = new SB();
                        Enumeration<?> enumeration = properties.propertyNames();
                        String string3 = null;
                        while (enumeration.hasMoreElements()) {
                            String string4 = (String)enumeration.nextElement();
                            if (string4.equals(".PATH")) {
                                string3 = properties.getProperty(string4);
                                continue;
                            }
                            sB2.append(";").append(string4).append("=").append(properties.getProperty(string4));
                        }
                        if (string3 != null) {
                            sB2.append(";PATH=").append(string3);
                        }
                        string3 = sB2.substring(sB2.length() > 0 ? 1 : 0);
                        sB.append(string3.replace('\n', ' '));
                    }
                    sB.appendC('\n');
                    int n8 = bS5.nextSetBit(0);
                    while (n8 >= 0) {
                        sB.append(LabelToken.formatLabelAtomArray(this.viewer, atomArray[n8], (LabelToken[])(modelSet.getVibration(n8, false) == null ? cloneable : labelTokenArray), '\u0000', null));
                        n8 = bS5.nextSetBit(n8 + 1);
                    }
                }
                n7 = bS4.nextSetBit(n7 + 1);
            }
        } else {
            n = this.addMolFile(sB, (BS)object, bS2, bl3, bl6, quaternion) ? 1 : 0;
        }
        return n != 0 ? sB.toString() : "ERROR: Too many atoms or bonds -- use V3000 format.";
    }

    private boolean addMolFile(SB sB, BS bS, BS bS2, boolean bl, boolean bl2, Quaternion quaternion) {
        float[] fArray;
        int n = bS.cardinality();
        int n2 = bS2.cardinality();
        if (!(bl || bl2 || n <= 999 && n2 <= 999)) {
            return false;
        }
        ModelSet modelSet = this.viewer.modelSet;
        int[] nArray = new int[modelSet.atomCount];
        P3 p3 = new P3();
        if (bl) {
            sB.append("  0  0  0  0  0  0            999 V3000");
        } else if (bl2) {
            sB.append("{\"mol\":{\"createdBy\":\"Jmol " + Viewer.getJmolVersion() + "\",\"a\":[");
        } else {
            Txt.rightJustify(sB, "   ", "" + n);
            Txt.rightJustify(sB, "   ", "" + n2);
            sB.append("  0  0  0  0              1 V2000");
        }
        if (!bl2) {
            sB.append("\n");
        }
        if (bl) {
            sB.append("M  V30 BEGIN CTAB\nM  V30 COUNTS ").appendI(n).append(" ").appendI(n2).append(" 0 0 0\n").append("M  V30 BEGIN ATOM\n");
        }
        P3 p32 = new P3();
        int n3 = bS.nextSetBit(0);
        int n4 = 0;
        while (n3 >= 0) {
            nArray[n3] = ++n4;
            this.getAtomRecordMOL(modelSet, sB, nArray[n3], modelSet.atoms[n3], quaternion, p3, p32, bl, bl2);
            n3 = bS.nextSetBit(n3 + 1);
        }
        if (bl) {
            sB.append("M  V30 END ATOM\nM  V30 BEGIN BOND\n");
        } else if (bl2) {
            sB.append("],\"b\":[");
        }
        n3 = bS2.nextSetBit(0);
        n4 = 0;
        while (n3 >= 0) {
            this.getBondRecordMOL(sB, ++n4, modelSet.bonds[n3], nArray, bl, bl2);
            n3 = bS2.nextSetBit(n3 + 1);
        }
        if (bl) {
            sB.append("M  V30 END BOND\nM  V30 END CTAB\n");
        }
        if (bl2) {
            sB.append("]}}");
        } else {
            sB.append("M  END\n");
        }
        if (!bl2 && !bl && (fArray = modelSet.getPartialCharges()) != null) {
            sB.append("> <JMOL_PARTIAL_CHARGES>\n").appendI(n).appendC('\n');
            n4 = bS.nextSetBit(0);
            int n5 = 0;
            while (n4 >= 0) {
                sB.appendI(++n5).append(" ").appendF(fArray[n4]).appendC('\n');
                n4 = bS.nextSetBit(n4 + 1);
            }
        }
        return true;
    }

    private static BS getCovalentBondsForAtoms(Bond[] bondArray, int n, BS bS) {
        BS bS2 = new BS();
        for (int i = 0; i < n; ++i) {
            Bond bond = bondArray[i];
            if (!bS.get(bond.atom1.index) || !bS.get(bond.atom2.index) || !bond.isCovalent()) continue;
            bS2.set(i);
        }
        return bS2;
    }

    private void getAtomRecordMOL(ModelSet modelSet, SB sB, int n, Atom atom, Quaternion quaternion, P3 p3, P3 p32, boolean bl, boolean bl2) {
        if (modelSet.models[atom.modelIndex].isTrajectory) {
            atom.setFractionalCoordPt(p32, ((P3[])modelSet.trajectorySteps.get(atom.modelIndex))[atom.index - modelSet.models[atom.modelIndex].firstAtomIndex], true);
        } else {
            p3.setT(atom);
        }
        if (quaternion != null) {
            quaternion.transformP2(p3, p3);
        }
        int n2 = atom.getElementNumber();
        String string = atom.isDeleted() ? "Xx" : Elements.elementSymbolFromNumber(n2);
        int n3 = atom.getIsotopeNumber();
        int n4 = atom.getFormalCharge();
        if (bl) {
            sB.append("M  V30 ").appendI(n).append(" ").append(string).append(" ").appendF(p3.x).append(" ").appendF(p3.y).append(" ").appendF(p3.z).append(" 0");
            if (n4 != 0) {
                sB.append(" CHG=").appendI(n4);
            }
            if (n3 != 0) {
                sB.append(" MASS=").appendI(n3);
            }
            sB.append("\n");
        } else if (bl2) {
            if (n != 1) {
                sB.append(",");
            }
            sB.append("{");
            if (atom.getElementNumber() != 6) {
                sB.append("\"l\":\"").append(atom.getElementSymbol()).append("\",");
            }
            if (n4 != 0) {
                sB.append("\"c\":").appendI(n4).append(",");
            }
            if (n3 != 0 && n3 != Elements.getNaturalIsotope(n2)) {
                sB.append("\"m\":").appendI(n3).append(",");
            }
            sB.append("\"x\":").appendF(atom.x).append(",\"y\":").appendF(atom.y).append(",\"z\":").appendF(atom.z).append("}");
        } else {
            sB.append(Txt.sprintf("%10.5p%10.5p%10.5p", "p", new Object[]{p3}));
            sB.append(" ").append(string);
            if (string.length() == 1) {
                sB.append(" ");
            }
            if (n3 > 0) {
                n3 -= Elements.getNaturalIsotope(atom.getElementNumber());
            }
            sB.append(" ");
            Txt.rightJustify(sB, "  ", "" + n3);
            Txt.rightJustify(sB, "   ", "" + (n4 == 0 ? 0 : 4 - n4));
            sB.append("  0  0  0  0\n");
        }
    }

    private void getBondRecordMOL(SB sB, int n, Bond bond, int[] nArray, boolean bl, boolean bl2) {
        int n2 = nArray[bond.atom1.index];
        int n3 = nArray[bond.atom2.index];
        int n4 = bond.getValence();
        if (n4 > 3) {
            n4 = 1;
        }
        switch (bond.order & 0xFFFDFFFF) {
            case 515: {
                n4 = bl2 ? -3 : 4;
                break;
            }
            case 66: {
                n4 = bl2 ? -3 : 5;
                break;
            }
            case 513: {
                n4 = bl2 ? 1 : 6;
                break;
            }
            case 514: {
                n4 = bl2 ? 2 : 7;
                break;
            }
            case 33: {
                int n5 = n4 = bl2 ? -1 : 8;
            }
        }
        if (bl) {
            sB.append("M  V30 ").appendI(n).append(" ").appendI(n4).append(" ").appendI(n2).append(" ").appendI(n3).appendC('\n');
        } else if (bl2) {
            if (n != 1) {
                sB.append(",");
            }
            sB.append("{\"b\":").appendI(n2 - 1).append(",\"e\":").appendI(n3 - 1);
            if (n4 != 1) {
                sB.append(",\"o\":");
                if (n4 < 0) {
                    sB.appendF((float)(-n4) / 2.0f);
                } else {
                    sB.appendI(n4);
                }
            }
            sB.append("}");
        } else {
            Txt.rightJustify(sB, "   ", "" + n2);
            Txt.rightJustify(sB, "   ", "" + n3);
            sB.append("  ").appendI(n4).append("  0  0  0\n");
        }
    }

    @Override
    public String getChimeInfo(int n, BS bS) {
        switch (n) {
            case 1073741982: {
                break;
            }
            case 1073741864: {
                return this.getBasePairInfo(bS);
            }
            default: {
                return this.getChimeInfoA(this.viewer.modelSet.atoms, n, bS);
            }
        }
        SB sB = new SB();
        this.viewer.modelSet.models[0].getChimeInfo(sB, 0);
        return sB.appendC('\n').toString().substring(1);
    }

    /*
     * Unable to fully structure code
     * Enabled aggressive block sorting
     */
    private String getChimeInfoA(Atom[] var1_1, int var2_2, BS var3_3) {
        var4_4 = new SB();
        var4_4.append("\n");
        var5_5 = "";
        var6_6 = null;
        var7_7 = null;
        var8_8 = -1;
        var9_9 = 0;
        if (var3_3 != null) {
            var10_10 = var3_3.nextSetBit(0);
            block10: while (var10_10 >= 0) {
                var11_11 = var1_1[var10_10];
                switch (var2_2) {
                    case 1114638363: {
                        var5_5 = var11_11.getInfo();
                        ** break;
                    }
                    case 0x44100001: {
                        var5_5 = "" + var11_11.getAtomNumber();
                        ** break;
                    }
                    case 1087373318: {
                        var5_5 = var11_11.getGroup3(false);
                        ** break;
                    }
                    case 1073742120: 
                    case 0x40D00004: 
                    case 1087373320: {
                        var12_12 = var11_11.getChainID();
                        v0 = var5_5 = var12_12 == 0 ? " " : var11_11.getChainIDStr();
                        if (var12_12 > 255) {
                            var5_5 = Escape.eS(var5_5);
                        }
                        switch (var2_2) {
                            case 1073742120: {
                                var5_5 = "[" + var11_11.getGroup3(false) + "]" + var11_11.getSeqcodeString() + ":" + var5_5;
                                ** break;
                            }
                            case 1087373320: {
                                if (var11_11.getModelIndex() != var8_8) {
                                    var4_4.appendC('\n');
                                    var9_9 = 0;
                                    var8_8 = var11_11.getModelIndex();
                                    var4_4.append("Model " + var11_11.getModelNumber());
                                    var7_7 = null;
                                    var6_6 = null;
                                }
                                if (var11_11.getChain() != var6_6) {
                                    var4_4.appendC('\n');
                                    var9_9 = 0;
                                    var6_6 = var11_11.getChain();
                                    var4_4.append("Chain " + var5_5 + ":\n");
                                    var7_7 = null;
                                }
                                if ((var13_13 = var11_11.getGroup()) == var7_7) break;
                                if (var9_9++ % 5 == 0 && var9_9 > 1) {
                                    var4_4.appendC('\n');
                                }
                                Txt.leftJustify(var4_4, "          ", "[" + var11_11.getGroup3(false) + "]" + var11_11.getResno() + " ");
                                var7_7 = var13_13;
                                break;
                            }
lbl57:
                            // 2 sources

                            default: lbl-1000:
                            // 4 sources

                            {
                                if (var4_4.indexOf("\n" + var5_5 + "\n") >= 0) break;
                                var4_4.append(var5_5).appendC('\n');
                            }
                        }
                        var10_10 = var3_3.nextSetBit(var10_10 + 1);
                        continue block10;
                    }
                    default: {
                        return "";
                    }
                }
            }
        }
        if (var2_2 == 1087373320) {
            var4_4.appendC('\n');
        }
        return var4_4.toString().substring(1);
    }

    @Override
    public String getModelFileInfo(BS bS) {
        ModelSet modelSet = this.viewer.modelSet;
        SB sB = new SB();
        for (int i = 0; i < modelSet.modelCount; ++i) {
            if (bS != null && !bS.get(i)) continue;
            String string = "[\"" + modelSet.getModelNumberDotted(i) + "\"] = ";
            sB.append("\n\nfile").append(string).append(Escape.eS(modelSet.getModelFileName(i)));
            String string2 = (String)modelSet.getModelAuxiliaryInfoValue(i, "modelID");
            if (string2 != null) {
                sB.append("\nid").append(string).append(Escape.eS(string2));
            }
            sB.append("\ntitle").append(string).append(Escape.eS(modelSet.getModelTitle(i)));
            sB.append("\nname").append(string).append(Escape.eS(modelSet.getModelName(i)));
            sB.append("\ntype").append(string).append(Escape.eS(modelSet.getModelFileType(i)));
        }
        return sB.toString();
    }

    public List<Map<String, Object>> getAllAtomInfo(BS bS) {
        List<Map<String, Object>> list = new List<Map<String, Object>>();
        int n = bS.nextSetBit(0);
        while (n >= 0) {
            list.addLast(this.getAtomInfoLong(n));
            n = bS.nextSetBit(n + 1);
        }
        return list;
    }

    private Map<String, Object> getAtomInfoLong(int n) {
        ModelSet modelSet = this.viewer.modelSet;
        Atom atom = modelSet.atoms[n];
        Hashtable<String, Object> hashtable = new Hashtable<String, Object>();
        this.viewer.getAtomIdentityInfo(n, hashtable);
        hashtable.put("element", modelSet.getElementName(n));
        hashtable.put("elemno", modelSet.getElementNumber(n));
        hashtable.put("x", Float.valueOf(atom.x));
        hashtable.put("y", Float.valueOf(atom.y));
        hashtable.put("z", Float.valueOf(atom.z));
        hashtable.put("coord", P3.newP(atom));
        if (modelSet.vibrations != null && modelSet.vibrations[n] != null) {
            hashtable.put("vibVector", V3.newV(modelSet.vibrations[n]));
        }
        hashtable.put("bondCount", atom.getCovalentBondCount());
        hashtable.put("radius", Float.valueOf((float)((double)atom.getRasMolRadius() / 120.0)));
        hashtable.put("model", atom.getModelNumberForLabel());
        hashtable.put("shape", Atom.atomPropertyString(this.viewer, atom, 1087373323));
        hashtable.put("visible", atom.isVisible(0));
        hashtable.put("clickabilityFlags", atom.clickabilityFlags);
        hashtable.put("visibilityFlags", atom.shapeVisibilityFlags);
        hashtable.put("spacefill", Float.valueOf(atom.getRadius()));
        String string = Escape.escapeColor(this.viewer.getColorArgbOrGray(atom.colixAtom));
        if (string != null) {
            hashtable.put("color", string);
        }
        hashtable.put("colix", atom.colixAtom);
        boolean bl = atom.isTranslucent();
        if (bl) {
            hashtable.put("translucent", bl);
        }
        hashtable.put("formalCharge", atom.getFormalCharge());
        hashtable.put("partialCharge", Float.valueOf(atom.getPartialCharge()));
        float f = (float)atom.getSurfaceDistance100() / 100.0f;
        if (f >= 0.0f) {
            hashtable.put("surfaceDistance", Float.valueOf(f));
        }
        if (modelSet.models[atom.modelIndex].isBioModel) {
            hashtable.put("resname", atom.getGroup3(false));
            char c = atom.getInsertionCode();
            int n2 = atom.getResno();
            if (n2 > 0) {
                hashtable.put("resno", n2);
            }
            if (c != '\u0000') {
                hashtable.put("insertionCode", "" + c);
            }
            hashtable.put("name", modelSet.getAtomName(n));
            hashtable.put("chain", atom.getChainIDStr());
            hashtable.put("atomID", atom.atomID);
            hashtable.put("groupID", atom.getGroupID());
            if (atom.altloc != '\u0000') {
                hashtable.put("altLocation", "" + atom.altloc);
            }
            hashtable.put("structure", atom.getProteinStructureType().getId());
            hashtable.put("polymerLength", atom.getPolymerLength());
            hashtable.put("occupancy", atom.getOccupancy100());
            int n3 = atom.getBfactor100();
            hashtable.put("temp", n3 / 100);
        }
        return hashtable;
    }

    public List<Map<String, Object>> getAllBondInfo(Object object) {
        List<Map<String, Object>> list;
        block5: {
            Bond[] bondArray;
            int n;
            block6: {
                block4: {
                    list = new List<Map<String, Object>>();
                    ModelSet modelSet = this.viewer.modelSet;
                    n = modelSet.bondCount;
                    bondArray = modelSet.bonds;
                    if (object instanceof String) {
                        object = this.viewer.getAtomBitSet(object);
                    }
                    if (!(object instanceof BS[])) break block4;
                    BS bS = ((BS[])object)[0];
                    BS bS2 = ((BS[])object)[1];
                    for (int i = 0; i < n; ++i) {
                        int n2 = bondArray[i].atom1.index;
                        int n3 = bondArray[i].atom2.index;
                        if ((!bS.get(n2) || !bS2.get(n3)) && (!bS2.get(n2) || !bS.get(n3))) continue;
                        list.addLast(this.getBondInfo(i));
                    }
                    break block5;
                }
                if (!(object instanceof BondSet)) break block6;
                BS bS = (BS)object;
                int n4 = bS.nextSetBit(0);
                while (n4 >= 0 && n4 < n) {
                    list.addLast(this.getBondInfo(n4));
                    n4 = bS.nextSetBit(n4 + 1);
                }
                break block5;
            }
            if (!(object instanceof BS)) break block5;
            BS bS = (BS)object;
            int n5 = bS.cardinality() == 1 ? bS.nextSetBit(0) : -1;
            for (int i = 0; i < n; ++i) {
                if (!(n5 >= 0 ? bondArray[i].atom1.index == n5 || bondArray[i].atom2.index == n5 : bS.get(bondArray[i].atom1.index) && bS.get(bondArray[i].atom2.index))) continue;
                list.addLast(this.getBondInfo(i));
            }
        }
        return list;
    }

    private Map<String, Object> getBondInfo(int n) {
        Bond bond = this.viewer.modelSet.bonds[n];
        Atom atom = bond.atom1;
        Atom atom2 = bond.atom2;
        Hashtable<String, Object> hashtable = new Hashtable<String, Object>();
        hashtable.put("_bpt", n);
        Hashtable<String, Object> hashtable2 = new Hashtable<String, Object>();
        this.viewer.getAtomIdentityInfo(atom.index, hashtable2);
        Hashtable<String, Object> hashtable3 = new Hashtable<String, Object>();
        this.viewer.getAtomIdentityInfo(atom2.index, hashtable3);
        hashtable.put("atom1", hashtable2);
        hashtable.put("atom2", hashtable3);
        hashtable.put("order", Float.valueOf(PT.fVal(JmolEdge.getBondOrderNumberFromOrder(bond.order))));
        hashtable.put("type", JmolEdge.getBondOrderNameFromOrder(bond.order));
        hashtable.put("radius", Float.valueOf((float)((double)bond.mad / 2000.0)));
        hashtable.put("length_Ang", Float.valueOf(atom.distance(atom2)));
        hashtable.put("visible", bond.shapeVisibilityFlags != 0);
        String string = Escape.escapeColor(this.viewer.getColorArgbOrGray(bond.colix));
        if (string != null) {
            hashtable.put("color", string);
        }
        hashtable.put("colix", Integer.valueOf(bond.colix));
        if (C.isColixTranslucent(bond.colix)) {
            hashtable.put("translucent", Boolean.TRUE);
        }
        return hashtable;
    }

    public Map<String, List<Map<String, Object>>> getAllChainInfo(BS bS) {
        Hashtable<String, List<Map<String, Object>>> hashtable = new Hashtable<String, List<Map<String, Object>>>();
        List list = new List();
        int n = this.viewer.modelSet.modelCount;
        for (int i = 0; i < n; ++i) {
            Hashtable<String, Serializable> hashtable2 = new Hashtable<String, Serializable>();
            List<Map<String, List<Map<String, Object>>>> list2 = this.getChainInfo(i, bS);
            if (list2.size() <= 0) continue;
            hashtable2.put("modelIndex", Integer.valueOf(i));
            hashtable2.put("chains", list2);
            list.addLast(hashtable2);
        }
        hashtable.put("models", list);
        return hashtable;
    }

    private List<Map<String, List<Map<String, Object>>>> getChainInfo(int n, BS bS) {
        Model model = this.viewer.modelSet.models[n];
        int n2 = model.getChainCount(true);
        List<Map<String, List<Map<String, Object>>>> list = new List<Map<String, List<Map<String, Object>>>>();
        for (int i = 0; i < n2; ++i) {
            Chain chain = model.getChainAt(i);
            List<Map<String, Object>> list2 = new List<Map<String, Object>>();
            int n3 = chain.getGroupCount();
            Hashtable<String, List<Map<String, Object>>> hashtable = new Hashtable<String, List<Map<String, Object>>>();
            for (int j = 0; j < n3; ++j) {
                Group group = chain.getGroup(j);
                if (!bS.get(group.firstAtomIndex)) continue;
                list2.addLast(group.getGroupInfo(j));
            }
            if (list2.isEmpty()) continue;
            hashtable.put("residues", list2);
            list.addLast((Map<String, List<Map<String, Object>>>)hashtable);
        }
        return list;
    }

    public Map<String, List<Map<String, Object>>> getAllPolymerInfo(BS bS) {
        Hashtable<String, List<Map<String, Object>>> hashtable = new Hashtable<String, List<Map<String, Object>>>();
        List<Map<String, Object>> list = new List<Map<String, Object>>();
        int n = this.viewer.modelSet.modelCount;
        Model[] modelArray = this.viewer.modelSet.models;
        for (int i = 0; i < n; ++i) {
            if (!modelArray[i].isBioModel) continue;
            modelArray[i].getAllPolymerInfo(bS, hashtable, list);
        }
        hashtable.put("models", list);
        return hashtable;
    }

    private String getBasePairInfo(BS bS) {
        SB sB = new SB();
        List<Bond> list = new List<Bond>();
        this.viewer.modelSet.calcRasmolHydrogenBonds(bS, bS, list, true, 1, false, null);
        int n = list.size();
        while (--n >= 0) {
            Bond bond = (Bond)list.get(n);
            PropertyManager.getAtomResidueInfo(sB, bond.atom1);
            sB.append(" - ");
            PropertyManager.getAtomResidueInfo(sB, bond.atom2);
            sB.append("\n");
        }
        return sB.toString();
    }

    private static void getAtomResidueInfo(SB sB, Atom atom) {
        sB.append("[").append(atom.getGroup3(false)).append("]").append(atom.getSeqcodeString()).append(":");
        int n = atom.getChainID();
        sB.append(n == 0 ? " " : atom.getChainIDStr());
    }
}

