/*
 * Decompiled with CFR 0.152.
 */
package org.jmol.adapter.readers.simple;

import javajs.util.PT;
import org.jmol.adapter.smarter.Atom;
import org.jmol.adapter.smarter.AtomSetCollectionReader;
import org.jmol.adapter.smarter.Bond;

public class JmeReader
extends AtomSetCollectionReader {
    public void initializeReader() throws Exception {
        this.atomSetCollection.setCollectionName("JME");
        this.atomSetCollection.newAtomSet();
        this.line = this.readLine().replace('\t', ' ');
        this.checkCurrentLineForScript();
        this.addJmolScript("jmeString='" + this.line + "'");
        int n = this.parseInt();
        int n2 = this.parseInt();
        this.readAtoms(n);
        this.readBonds(n2);
        this.set2D();
        this.continuing = false;
    }

    private void readAtoms(int n) throws Exception {
        for (int i = 0; i < n; ++i) {
            String string;
            String string2 = this.parseToken();
            Atom atom = this.atomSetCollection.addNewAtom();
            this.setAtomCoordXYZ(atom, this.parseFloat(), this.parseFloat(), 0.0f);
            int n2 = string2.indexOf(58);
            String string3 = string = n2 > 0 ? string2.substring(0, n2) : string2;
            if (string.indexOf("+") >= 0) {
                string = PT.trim((String)string, (String)"+");
                atom.formalCharge = 1;
            } else if (string.indexOf("-") >= 0) {
                string = PT.trim((String)string, (String)"-");
                atom.formalCharge = -1;
            }
            atom.elementSymbol = string;
        }
    }

    private void readBonds(int n) throws Exception {
        block5: for (int i = 0; i < n; ++i) {
            int n2 = this.parseInt() - 1;
            int n3 = this.parseInt() - 1;
            int n4 = this.parseInt();
            switch (n4) {
                default: {
                    continue block5;
                }
                case 1: 
                case 2: 
                case 3: {
                    break;
                }
                case -1: {
                    n4 = 1025;
                    break;
                }
                case -2: {
                    n4 = 1041;
                }
            }
            this.atomSetCollection.addBond(new Bond(n2, n3, n4));
        }
    }
}

