/*
 * Decompiled with CFR 0.152.
 */
package org.jmol.adapter.readers.simple;

import javajs.util.P3;
import javajs.util.T3;
import org.jmol.adapter.readers.simple.ZMatrixReader;
import org.jmol.adapter.smarter.Atom;
import org.jmol.api.JmolAdapter;

public class MopacArchiveReader
extends ZMatrixReader {
    String energyWithUnits;

    protected void initializeReader() {
        this.atomSetCollection.newAtomSet();
        if (!this.checkFilterKey("NOCENTER")) {
            this.doCentralize = true;
        }
    }

    @Override
    protected boolean checkLine() throws Exception {
        if (this.line.indexOf("=") == 34) {
            return this.getValue();
        }
        if (this.line.indexOf("FINAL GEOMETRY OBTAINED") >= 0) {
            return this.readCoordinates();
        }
        return true;
    }

    private boolean getValue() {
        if (this.line.substring(0, 10).trim().length() != 0) {
            return true;
        }
        String string = this.line.substring(0, 34).trim().replace(' ', '_');
        String string2 = this.line.substring(35).trim();
        this.atomSetCollection.setAtomSetAuxiliaryInfo(string, (Object)string2);
        if (this.line.indexOf("TOTAL ENERGY") >= 0) {
            String[] stringArray = this.getTokens();
            this.energyWithUnits = " (" + stringArray[3] + " " + stringArray[4] + ")";
            this.atomSetCollection.setAtomSetEnergy(stringArray[3], this.parseFloatStr(stringArray[3]));
        }
        return true;
    }

    private boolean readCoordinates() throws Exception {
        this.readLine();
        this.line = this.readLine().trim();
        this.atomSetCollection.setAtomSetName(this.line + (this.energyWithUnits == null ? "" : this.energyWithUnits));
        this.readLine();
        Atom atom = null;
        String string = null;
        this.setFractionalCoordinates(false);
        while (this.readLine() != null && this.line.length() >= 50) {
            atom = new Atom();
            this.vAtoms.addLast((Object)atom);
            atom.x = this.parseFloatRange(this.line, 5, 18);
            atom.y = this.parseFloatRange(this.line, 21, 34);
            atom.z = this.parseFloatRange(this.line, 37, 50);
            if (this.line.length() > 58 && this.line.charAt(58) != ' ') {
                switch (this.atomCount) {
                    case 0: {
                        break;
                    }
                    case 1: {
                        atom.sub((T3)this.vAtoms.get(0));
                        break;
                    }
                    case 2: {
                        this.setAtom(atom, 0, 1, 0, atom.x, atom.y, Float.MAX_VALUE);
                        break;
                    }
                    default: {
                        this.setAtom(atom, this.parseIntRange(this.line, 54, 59) - 1, this.parseIntRange(this.line, 60, 65) - 1, this.parseIntRange(this.line, 66, 71) - 1, atom.x, atom.y, atom.z);
                    }
                }
            }
            atom.elementSymbol = string = this.line.substring(1, 3).trim();
            if (string.equals("Tv")) continue;
            ++this.atomCount;
            if (this.line.length() >= 84) {
                atom.partialCharge = this.parseFloatRange(this.line, 76, 84);
            }
            if (JmolAdapter.getElementNumber((String)string) != 0) {
                this.atomSetCollection.addAtom(atom);
            }
            this.setAtomCoord(atom);
        }
        if (string.equals("Tv")) {
            int n;
            int n2;
            this.setSpaceGroupName("P1");
            for (int i = n2 = this.vAtoms.size() - this.atomCount; i < 3; ++i) {
                this.vAtoms.addLast((Object)new Atom());
            }
            float[] fArray = new float[9];
            for (n = 0; n < 3; ++n) {
                int n3 = n * 3;
                atom = (Atom)this.vAtoms.get(this.atomCount + n);
                if (!Float.isNaN(atom.x)) {
                    fArray[n3] = atom.x;
                    fArray[n3 + 1] = atom.y;
                    fArray[n3 + 2] = atom.z;
                }
                this.addPrimitiveLatticeVector(n, fArray, n3);
            }
            n = this.atomCount;
            while (--n >= 0) {
                this.setAtomCoord((Atom)this.vAtoms.get(n));
            }
            P3 p3 = P3.new3((float)-3.4028235E38f, (float)-3.4028235E38f, (float)-3.4028235E38f);
            P3 p32 = P3.new3((float)Float.MAX_VALUE, (float)Float.MAX_VALUE, (float)Float.MAX_VALUE);
            if (this.doCentralize) {
                int n4 = this.atomCount;
                while (--n4 >= 0) {
                    atom = (Atom)this.vAtoms.get(n4);
                    p3.x = Math.max(p3.x, atom.x);
                    p3.y = Math.max(p3.y, atom.y);
                    p3.z = Math.max(p3.z, atom.z);
                    p32.x = Math.min(p32.x, atom.x);
                    p32.y = Math.min(p32.y, atom.y);
                    p32.z = Math.min(p32.z, atom.z);
                }
                P3 p33 = new P3();
                switch (n2) {
                    case 3: {
                        p33.x = 0.5f;
                    }
                    case 2: {
                        p33.y = 0.5f;
                    }
                    case 1: {
                        p33.z = 0.5f;
                    }
                }
                p33.scaleAdd2(-0.5f, (T3)p32, (T3)p33);
                p33.scaleAdd2(-0.5f, (T3)p3, (T3)p33);
                int n5 = this.atomCount;
                while (--n5 >= 0) {
                    ((Atom)this.vAtoms.get(n5)).add((T3)p33);
                }
            }
            this.doCentralize = false;
        }
        return true;
    }
}

