/*
 * Decompiled with CFR 0.152.
 */
package org.jmol.modelset;

import java.util.Hashtable;
import java.util.Map;
import javajs.util.PT;
import javajs.util.SB;
import javajs.util.T3;
import org.jmol.modelset.Atom;
import org.jmol.modelset.Bond;
import org.jmol.modelset.Measurement;
import org.jmol.script.T;
import org.jmol.viewer.Viewer;

public class LabelToken {
    private String text;
    private String key;
    private Object data;
    private int tok;
    private int pt = -1;
    private char ch1 = '\u0000';
    private int width;
    private int precision = Integer.MAX_VALUE;
    private boolean alignLeft;
    private boolean zeroPad;
    private boolean intAsFloat;
    private static final String labelTokenParams = "AaBbCcDEefGgIiLlMmNnoPpQqRrSsTtUuVvWXxYyZz%%%gqW";
    private static final int[] labelTokenIds = new int[]{1087373315, 1087375362, 1087375361, 1112541199, 1632634891, 0x40D00004, 1095761923, 1087373322, 1087375365, 1112539145, 1095761933, 103, 1112541195, 1095763969, 1095761938, 1095763978, 1095766030, 1087373319, 1095761936, 1087373318, 1089470478, 1112541196, 1112539146, 81, 1129318401, 1095761939, 114, 1095761940, 0x40D00004, 1112539150, 1112541199, 1087373321, 1112539151, 1649412120, 1146095631, 87, 1112541188, 1112541185, 1112541189, 1112541186, 1112541190, 1112541187, 1115297793, 1113200642, 1113198595, 1113198596, 1113198597, 1113200646, 1113200647, 1113200649, 1113200650, 1113200652, 1650071565, 1113200654, 1112539137, 1112539138, 1095761922, 1095761924, 1766856708, 1095761932, 1112539140, 1229984263, 1288701960, 1826248715, 1112539143, 1095761935, 1112539141, 1112539144, 1095761937, 1716520985, 1666189314, 1114638363, 1087373323, 1087373320, 1113200651, 1641025539, 1238369286, 1095761941, 1087373324, 1087375373, 1112539152, 1112539153, 1112539154, 1112539155, 1095763990, 1649410049, 1112541202, 1112541203, 1112541204, 1313866247, 1146093582, 1146095627, 1146095626, 1146095629, 1112541191, 1112541192, 1112541193, 1114638362, 1112539147, 1112539148, 1112539149, 1146095628, 1112539142, 1112539139, 1095761927};
    public static final String STANDARD_LABEL = "%[identify]";
    private static final String twoCharLabelTokenParams = "fuv";
    private static final int[] twoCharLabelTokenIds = new int[]{1112541188, 1112541189, 1112541190, 1112539153, 1112539154, 1112539155, 1112541202, 1112541203, 1112541204};

    private LabelToken set(String string, int n) {
        this.text = string;
        this.pt = n;
        return this;
    }

    private static boolean isLabelPropertyTok(int n) {
        int n2 = labelTokenIds.length;
        while (--n2 >= 0) {
            if (labelTokenIds[n2] != n) continue;
            return true;
        }
        return false;
    }

    public static LabelToken[] compile(Viewer viewer, String string, char c, Map<String, Object> map) {
        int n;
        if (string == null || string.length() == 0) {
            return null;
        }
        if (string.indexOf("%") < 0 || string.length() < 2) {
            return new LabelToken[]{new LabelToken().set(string, -1)};
        }
        int n2 = 0;
        int n3 = -1;
        int n4 = string.length();
        while (++n3 < n4 && (n3 = string.indexOf(37, n3)) >= 0) {
            ++n2;
        }
        LabelToken[] labelTokenArray = new LabelToken[n2 * 2 + 1];
        int n5 = 0;
        n3 = 0;
        while ((n = string.indexOf(37, n3)) >= 0) {
            if (n3 != n) {
                labelTokenArray[n5++] = new LabelToken().set(string.substring(n3, n), -1);
            }
            int n6 = n5++;
            LabelToken labelToken = new LabelToken().set(null, n);
            labelTokenArray[n6] = labelToken;
            LabelToken labelToken2 = labelToken;
            viewer.autoCalculate(labelToken2.tok);
            n3 = LabelToken.setToken(viewer, string, labelToken2, n4, c, map);
        }
        if (n3 < n4) {
            labelTokenArray[n5++] = new LabelToken().set(string.substring(n3), -1);
        }
        return labelTokenArray;
    }

    public static String formatLabel(Viewer viewer, Atom atom, String string) {
        if (string == null || string.length() == 0) {
            return null;
        }
        LabelToken[] labelTokenArray = LabelToken.compile(viewer, string, '\u0000', null);
        return LabelToken.formatLabelAtomArray(viewer, atom, labelTokenArray, '\u0000', null);
    }

    public static String formatLabelAtomArray(Viewer viewer, Atom atom, LabelToken[] labelTokenArray, char c, int[] nArray) {
        SB sB;
        if (atom == null) {
            return null;
        }
        SB sB2 = sB = c > '0' ? null : new SB();
        if (labelTokenArray != null) {
            LabelToken labelToken;
            for (int i = 0; i < labelTokenArray.length && (labelToken = labelTokenArray[i]) != null; ++i) {
                if (c > '0' && labelToken.ch1 != c) continue;
                if (labelToken.tok <= 0 || labelToken.key != null) {
                    if (sB == null) continue;
                    sB.append(labelToken.text);
                    if (labelToken.ch1 == '\u0000') continue;
                    sB.appendC(labelToken.ch1);
                    continue;
                }
                LabelToken.appendAtomTokenValue(viewer, atom, labelToken, sB, nArray);
            }
        }
        return sB == null ? null : sB.toString().intern();
    }

    public static Map<String, Object> getBondLabelValues() {
        Hashtable<String, Object> hashtable = new Hashtable<String, Object>();
        hashtable.put("#", "");
        hashtable.put("ORDER", "");
        hashtable.put("TYPE", "");
        hashtable.put("LENGTH", Float.valueOf(0.0f));
        hashtable.put("ENERGY", Float.valueOf(0.0f));
        return hashtable;
    }

    public static String formatLabelBond(Viewer viewer, Bond bond, LabelToken[] labelTokenArray, Map<String, Object> map, int[] nArray) {
        map.put("#", "" + (bond.index + 1));
        map.put("ORDER", "" + bond.getOrderNumberAsString());
        map.put("TYPE", bond.getOrderName());
        map.put("LENGTH", Float.valueOf(bond.atom1.distance(bond.atom2)));
        map.put("ENERGY", Float.valueOf(bond.getEnergy()));
        LabelToken.setValues(labelTokenArray, map);
        LabelToken.formatLabelAtomArray(viewer, bond.atom1, labelTokenArray, '1', nArray);
        LabelToken.formatLabelAtomArray(viewer, bond.atom2, labelTokenArray, '2', nArray);
        return LabelToken.getLabel(labelTokenArray);
    }

    public static String formatLabelMeasure(Viewer viewer, Measurement measurement, String string, float f, String string2) {
        Hashtable<String, Object> hashtable = new Hashtable<String, Object>();
        hashtable.put("#", "" + (measurement.index + 1));
        hashtable.put("VALUE", Float.valueOf(f));
        hashtable.put("UNITS", string2);
        LabelToken[] labelTokenArray = LabelToken.compile(viewer, string, '\u0001', hashtable);
        if (labelTokenArray == null) {
            return "";
        }
        LabelToken.setValues(labelTokenArray, hashtable);
        Atom[] atomArray = measurement.modelSet.atoms;
        int[] nArray = measurement.getCountPlusIndices();
        for (int i = nArray[0]; i >= 1; --i) {
            if (nArray[i] < 0) continue;
            LabelToken.formatLabelAtomArray(viewer, atomArray[nArray[i]], labelTokenArray, (char)(48 + i), null);
        }
        string = LabelToken.getLabel(labelTokenArray);
        return string == null ? "" : string;
    }

    public static void setValues(LabelToken[] labelTokenArray, Map<String, Object> map) {
        LabelToken labelToken;
        for (int i = 0; i < labelTokenArray.length && (labelToken = labelTokenArray[i]) != null; ++i) {
            if (labelToken.key == null) continue;
            Object object = map.get(labelToken.key);
            labelToken.text = object instanceof Float ? labelToken.format(((Float)object).floatValue(), null, null) : labelToken.format(Float.NaN, (String)object, null);
        }
    }

    public static String getLabel(LabelToken[] labelTokenArray) {
        LabelToken labelToken;
        SB sB = new SB();
        for (int i = 0; i < labelTokenArray.length && (labelToken = labelTokenArray[i]) != null; ++i) {
            sB.append(labelToken.text);
        }
        return sB.toString();
    }

    private static int setToken(Viewer viewer, String string, LabelToken labelToken, int n, int n2, Map<String, Object> map) {
        char c;
        int n3 = labelToken.pt + 1;
        if (n3 >= n) {
            return n3;
        }
        if (string.charAt(n3) == '-') {
            labelToken.alignLeft = true;
            ++n3;
        }
        if (n3 < n && string.charAt(n3) == '0') {
            labelToken.zeroPad = true;
            ++n3;
        }
        while (n3 < n && Character.isDigit(c = string.charAt(n3))) {
            labelToken.width = 10 * labelToken.width + (c - 48);
            ++n3;
        }
        labelToken.precision = Integer.MAX_VALUE;
        boolean bl = false;
        if (n3 < n && string.charAt(n3) == '.') {
            if (++n3 < n && (c = string.charAt(n3)) == '-') {
                bl = true;
                ++n3;
            }
            if (n3 < n && Character.isDigit(c = string.charAt(n3))) {
                labelToken.precision = c - 48;
                if (bl) {
                    labelToken.precision = -1 - labelToken.precision;
                }
                ++n3;
            }
        }
        if (n3 < n && map != null) {
            for (String string2 : map.keySet()) {
                if (string.indexOf(string2) != n3) continue;
                labelToken.key = string2;
                return n3 + labelToken.key.length();
            }
        }
        if (n3 < n) {
            c = string.charAt(n3++);
            switch (c) {
                case '%': {
                    labelToken.text = "%";
                    return n3;
                }
                case '[': {
                    String string2;
                    int n4 = string.indexOf(93, n3);
                    if (n4 < n3) {
                        n3 = n;
                        break;
                    }
                    string2 = string.substring(n3, n4).toLowerCase();
                    if (string2.startsWith("property_")) {
                        labelToken.text = string2;
                        labelToken.tok = 135270407;
                        labelToken.data = viewer.getDataFloat(labelToken.text);
                    } else {
                        T t = T.getTokenFromName(string2);
                        if (t != null && LabelToken.isLabelPropertyTok(t.tok)) {
                            labelToken.tok = t.tok;
                        }
                    }
                    n3 = n4 + 1;
                    break;
                }
                case '{': {
                    int n5 = string.indexOf(125, n3);
                    if (n5 < n3) {
                        n3 = n;
                        break;
                    }
                    labelToken.text = string.substring(n3, n5);
                    labelToken.data = viewer.getDataFloat(labelToken.text);
                    if (labelToken.data == null) {
                        labelToken.data = viewer.getData(labelToken.text);
                        if (labelToken.data instanceof Object[]) {
                            labelToken.data = ((Object[])labelToken.data)[1];
                            if (labelToken.data instanceof String) {
                                labelToken.data = PT.split((String)labelToken.data, "\n");
                            }
                            if (!PT.isAS(labelToken.data)) {
                                labelToken.data = null;
                            }
                        }
                        labelToken.tok = labelToken.data == null ? 4 : 135266306;
                    } else {
                        labelToken.tok = 135270407;
                    }
                    n3 = n5 + 1;
                    break;
                }
                default: {
                    int n6;
                    int n7;
                    if (n3 < n && (n7 = twoCharLabelTokenParams.indexOf(c)) >= 0 && (n6 = "xyz".indexOf(string.charAt(n3))) >= 0) {
                        labelToken.tok = twoCharLabelTokenIds[n7 * 3 + n6];
                        ++n3;
                        break;
                    }
                    n7 = labelTokenParams.indexOf(c);
                    if (n7 < 0) break;
                    labelToken.tok = labelTokenIds[n7];
                }
            }
        }
        labelToken.text = string.substring(labelToken.pt, n3);
        if (n3 < n && n2 != 0 && Character.isDigit(c = string.charAt(n3))) {
            ++n3;
            labelToken.ch1 = c;
            if (c != n2 && n2 != 1) {
                labelToken.tok = 0;
            }
        }
        return n3;
    }

    private static void appendAtomTokenValue(Viewer viewer, Atom atom, LabelToken labelToken, SB sB, int[] nArray) {
        String string = null;
        float f = Float.NaN;
        T3 t3 = null;
        try {
            block1 : switch (labelToken.tok) {
                case 1095761923: {
                    string = "" + (nArray == null ? atom.index : nArray[atom.index]);
                    break;
                }
                case 1766856708: {
                    t3 = Atom.atomPropertyTuple(atom, labelToken.tok);
                    break;
                }
                case 135270407: {
                    if (labelToken.data != null) {
                        f = ((float[])labelToken.data)[atom.index];
                    }
                    break;
                }
                case 135266306: {
                    if (labelToken.data != null) {
                        String[] stringArray = (String[])labelToken.data;
                        string = atom.index < stringArray.length ? stringArray[atom.index] : "";
                    }
                    break;
                }
                case 1632634891: {
                    int n = atom.getFormalCharge();
                    if (n > 0) {
                        string = "" + n + "+";
                        break;
                    }
                    if (n < 0) {
                        string = "" + -n + "-";
                        break;
                    }
                    string = "";
                    break;
                }
                case 103: {
                    string = "" + atom.getSelectedGroupIndexWithinChain();
                    break;
                }
                case 1095766030: {
                    string = atom.getModelNumberForLabel();
                    break;
                }
                case 1129318401: {
                    string = "" + Atom.atomPropertyInt(atom, labelToken.tok);
                    break;
                }
                case 81: {
                    f = (float)atom.getOccupancy100() / 100.0f;
                    break;
                }
                case 1666189314: {
                    f = Atom.atomPropertyFloat(viewer, atom, labelToken.tok);
                    break;
                }
                case 114: {
                    string = atom.getSeqcodeString();
                    break;
                }
                case 1087373324: {
                    string = atom.getStructureId();
                    break;
                }
                case 1095761941: {
                    int n = atom.getStrucNo();
                    string = n <= 0 ? "" : "" + n;
                    break;
                }
                case 1112539150: {
                    f = atom.getGroupParameter(1112539150);
                    if (Float.isNaN(f)) {
                        string = "null";
                    }
                    break;
                }
                case 4: {
                    string = viewer.getModelAtomProperty(atom, labelToken.text.substring(2, labelToken.text.length() - 1));
                    break;
                }
                case 1238369286: 
                case 1641025539: {
                    string = Atom.atomPropertyString(viewer, atom, labelToken.tok);
                    break;
                }
                case 87: {
                    string = atom.getIdentityXYZ(false);
                    break;
                }
                default: {
                    switch (labelToken.tok & 0x43D00000) {
                        case 1095761920: {
                            if (labelToken.intAsFloat) {
                                f = Atom.atomPropertyInt(atom, labelToken.tok);
                                break block1;
                            }
                            string = "" + Atom.atomPropertyInt(atom, labelToken.tok);
                            break block1;
                        }
                        case 1112539136: {
                            f = Atom.atomPropertyFloat(viewer, atom, labelToken.tok);
                            break block1;
                        }
                        case 0x40D00000: {
                            string = Atom.atomPropertyString(viewer, atom, labelToken.tok);
                            break block1;
                        }
                        case 0x40500000: {
                            t3 = Atom.atomPropertyTuple(atom, labelToken.tok);
                            break block1;
                        }
                    }
                    break;
                }
            }
        }
        catch (IndexOutOfBoundsException indexOutOfBoundsException) {
            f = Float.NaN;
            string = null;
            t3 = null;
        }
        string = labelToken.format(f, string, t3);
        if (sB == null) {
            labelToken.text = string;
        } else {
            sB.append(string);
        }
    }

    private String format(float f, String string, T3 t3) {
        if (!Float.isNaN(f)) {
            return PT.formatF(f, this.width, this.precision, this.alignLeft, this.zeroPad);
        }
        if (string != null) {
            return PT.formatS(string, this.width, this.precision, this.alignLeft, this.zeroPad);
        }
        if (t3 != null) {
            if (this.width == 0 && this.precision == Integer.MAX_VALUE) {
                this.width = 6;
                this.precision = 2;
            }
            return PT.formatF(t3.x, this.width, this.precision, false, false) + PT.formatF(t3.y, this.width, this.precision, false, false) + PT.formatF(t3.z, this.width, this.precision, false, false);
        }
        return this.text;
    }
}

