/*
 * Decompiled with CFR 0.152.
 */
package org.jmol.shape;

import javajs.util.P3;
import javajs.util.SB;
import javajs.util.V3;
import org.jmol.api.SymmetryInterface;
import org.jmol.constant.EnumAxesMode;
import org.jmol.java.BS;
import org.jmol.shape.FontLineShape;
import org.jmol.util.Escape;
import org.jmol.viewer.JC;

public class Axes
extends FontLineShape {
    public P3 axisXY = new P3();
    public float scale;
    private P3 fixedOrigin;
    final P3 originPoint = new P3();
    final P3[] axisPoints = new P3[6];
    static final P3 pt0 = new P3();
    public String[] labels;
    final P3 ptTemp;
    private static final float MIN_AXIS_LEN = 1.5f;
    V3 corner;

    public Axes() {
        int n = 6;
        while (--n >= 0) {
            this.axisPoints[n] = new P3();
        }
        this.ptTemp = new P3();
        this.corner = new V3();
    }

    public P3 getOriginPoint(boolean bl) {
        return bl ? pt0 : this.originPoint;
    }

    public P3 getAxisPoint(int n, boolean bl) {
        if (!bl && this.axisXY.z == 0.0f) {
            return this.axisPoints[n];
        }
        this.ptTemp.setT(this.axisPoints[n]);
        this.ptTemp.sub(this.originPoint);
        this.ptTemp.scale(0.5f);
        return this.ptTemp;
    }

    @Override
    public void setProperty(String string, Object object, BS bS) {
        if ("position" == string) {
            this.axisXY = (P3)object;
            return;
        }
        if ("origin" == string) {
            if (object == null) {
                this.fixedOrigin = null;
            } else {
                if (this.fixedOrigin == null) {
                    this.fixedOrigin = new P3();
                }
                this.fixedOrigin.setT((P3)object);
            }
            this.initShape();
            return;
        }
        if ("labels" == string) {
            this.labels = (String[])object;
            return;
        }
        if ("labelsOn" == string) {
            this.labels = null;
            return;
        }
        if ("labelsOff" == string) {
            this.labels = new String[]{"", "", ""};
            return;
        }
        this.setPropFLS(string, object);
    }

    @Override
    public void initShape() {
        super.initShape();
        this.myType = "axes";
        this.font3d = this.gdata.getFont3D(14.0f);
        EnumAxesMode enumAxesMode = this.viewer.getAxesMode();
        if (this.fixedOrigin == null) {
            this.originPoint.set(0.0f, 0.0f, 0.0f);
        } else {
            this.originPoint.setT(this.fixedOrigin);
        }
        if (enumAxesMode == EnumAxesMode.UNITCELL && this.modelSet.unitCells != null) {
            SymmetryInterface symmetryInterface = this.viewer.getCurrentUnitCell();
            if (symmetryInterface != null) {
                P3[] p3Array = symmetryInterface.getUnitCellVertices();
                P3 p3 = symmetryInterface.getCartesianOffset();
                if (this.fixedOrigin == null) {
                    this.originPoint.setT(p3);
                    this.originPoint.add(p3Array[0]);
                } else {
                    p3 = this.fixedOrigin;
                }
                this.scale = this.viewer.getFloat(0x22000002) / 2.0f;
                this.axisPoints[0].scaleAdd2(this.scale, p3Array[4], p3);
                this.axisPoints[1].scaleAdd2(this.scale, p3Array[2], p3);
                this.axisPoints[2].scaleAdd2(this.scale, p3Array[1], p3);
                return;
            }
        } else if (enumAxesMode == EnumAxesMode.BOUNDBOX && this.fixedOrigin == null) {
            this.originPoint.setT(this.viewer.getBoundBoxCenter());
        }
        this.setScale(this.viewer.getFloat(0x22000002) / 2.0f);
    }

    @Override
    public Object getProperty(String string, int n) {
        if (string == "axisPoints") {
            return this.axisPoints;
        }
        if (string == "origin") {
            return this.fixedOrigin;
        }
        if (string == "axesTypeXY") {
            return this.axisXY.z == 0.0f ? Boolean.FALSE : Boolean.TRUE;
        }
        return null;
    }

    void setScale(float f) {
        this.scale = f;
        this.corner.setT(this.viewer.getBoundBoxCornerVector());
        int n = 6;
        while (--n >= 0) {
            P3 p3 = this.axisPoints[n];
            p3.setT(JC.unitAxisVectors[n]);
            if (this.corner.x < 1.5f) {
                this.corner.x = 1.5f;
            }
            if (this.corner.y < 1.5f) {
                this.corner.y = 1.5f;
            }
            if (this.corner.z < 1.5f) {
                this.corner.z = 1.5f;
            }
            if (this.axisXY.z == 0.0f) {
                p3.x *= this.corner.x * f;
                p3.y *= this.corner.y * f;
                p3.z *= this.corner.z * f;
            }
            p3.add(this.originPoint);
        }
    }

    @Override
    public String getShapeState() {
        SB sB = new SB();
        sB.append("  axes scale ").appendF(this.viewer.getFloat(0x22000002)).append(";\n");
        if (this.fixedOrigin != null) {
            sB.append("  axes center ").append(Escape.eP(this.fixedOrigin)).append(";\n");
        }
        if (this.axisXY.z != 0.0f) {
            sB.append("  axes position [").appendI((int)this.axisXY.x).append(" ").appendI((int)this.axisXY.y).append(" ").append(this.axisXY.z < 0.0f ? " %" : "").append("];\n");
        }
        if (this.labels != null) {
            sB.append("  axes labels ");
            for (int i = 0; i < this.labels.length; ++i) {
                if (this.labels[i] == null) continue;
                sB.append(Escape.eS(this.labels[i])).append(" ");
            }
            sB.append(";\n");
        }
        return super.getShapeState() + sB;
    }
}

