/*
 * Decompiled with CFR 0.152.
 */
package org.jmol.thread;

import org.jmol.thread.JmolThread;
import org.jmol.util.Logger;
import org.jmol.viewer.AnimationManager;
import org.jmol.viewer.Viewer;

public class ModulationThread
extends JmolThread {
    private int modT;
    private int modT2;
    private AnimationManager animationManager;

    @Override
    public int setManager(Object object, Viewer viewer, Object object2) {
        int[] nArray = (int[])object2;
        this.modT = nArray[0];
        this.modT2 = nArray[1];
        this.animationManager = (AnimationManager)object;
        this.setViewer(viewer, "ModulationThread");
        viewer.startHoverWatcher(false);
        return 0;
    }

    @Override
    public void interrupt() {
        if (this.stopped) {
            return;
        }
        this.stopped = true;
        if (Logger.debugging) {
            Logger.debug("animation thread interrupted!");
        }
        this.animationManager.modulationPlay = false;
        super.interrupt();
    }

    @Override
    protected void run1(int n) throws InterruptedException {
        while (true) {
            switch (n) {
                case -1: {
                    if (Logger.debugging) {
                        Logger.debug("modulation thread running");
                    }
                    this.viewer.requestRepaintAndWait("modulationThread");
                    this.viewer.startHoverWatcher(false);
                    n = 0;
                    break;
                }
                case 0: {
                    if (this.checkInterrupted() || !this.animationManager.modulationPlay || this.modT > this.modT2) {
                        n = -2;
                        break;
                    }
                    n = 1;
                    break;
                }
                case 1: {
                    this.viewer.setModulation(true, new int[]{this.modT++}, Integer.MAX_VALUE, true);
                    n = 2;
                    break;
                }
                case 2: {
                    this.targetTime += (long)((int)(1000.0f / this.animationManager.modulationFps));
                    n = 3;
                    break;
                }
                case 3: {
                    while (this.animationManager.modulationPlay && !this.checkInterrupted() && !this.viewer.getRefreshing()) {
                        if (this.runSleep(10, 3)) continue;
                        return;
                    }
                    this.viewer.refresh(1, "modulationThread");
                    this.sleepTime = (int)(this.targetTime - (System.currentTimeMillis() - this.startTime));
                    if (!this.runSleep(this.sleepTime, 0)) {
                        return;
                    }
                    n = 0;
                    break;
                }
                case -2: {
                    if (Logger.debugging) {
                        Logger.debug("modulation thread exiting");
                    }
                    this.animationManager.stopModulationThread();
                    return;
                }
            }
        }
    }
}

