/*
 * Decompiled with CFR 0.152.
 */
package org.jmol.thread;

import javajs.util.A4;
import javajs.util.M3;
import javajs.util.P3;
import javajs.util.V3;
import org.jmol.thread.JmolThread;
import org.jmol.viewer.TransformManager;
import org.jmol.viewer.Viewer;

public class MoveToThread
extends JmolThread {
    private TransformManager transformManager;
    private final V3 aaStepCenter = new V3();
    private final V3 aaStepNavCenter = new V3();
    private final A4 aaStep = new A4();
    private final A4 aaTotal = new A4();
    private final M3 matrixStart = new M3();
    private final M3 matrixStartInv = new M3();
    private M3 matrixStep = new M3();
    private final M3 matrixEnd = new M3();
    private P3 center;
    private P3 navCenter;
    private P3 ptMoveToCenter;
    private Slider zoom;
    private Slider xTrans;
    private Slider yTrans;
    private Slider xNav;
    private Slider yNav;
    private Slider navDepth;
    private Slider cameraDepth;
    private Slider cameraX;
    private Slider cameraY;
    private Slider rotationRadius;
    private Slider pixelScale;
    private int totalSteps;
    private int fps;
    private long frameTimeMillis;
    private int iStep;
    private boolean doEndMove;
    private float floatSecondsTotal;
    private float fStep;

    @Override
    public int setManager(Object object, Viewer viewer, Object object2) {
        Object[] objectArray = (Object[])object2;
        this.setViewer(viewer, "MoveToThread");
        this.transformManager = (TransformManager)object;
        this.center = (P3)objectArray[0];
        this.matrixEnd.setM((M3)objectArray[1]);
        float[] fArray = (float[])objectArray[3];
        this.ptMoveToCenter = this.center == null ? this.transformManager.fixedRotationCenter : this.center;
        this.floatSecondsTotal = fArray[0];
        this.zoom = this.newSlider(this.transformManager.zoomPercent, fArray[1]);
        this.xTrans = this.newSlider(this.transformManager.getTranslationXPercent(), fArray[2]);
        this.yTrans = this.newSlider(this.transformManager.getTranslationYPercent(), fArray[3]);
        this.rotationRadius = this.newSlider(this.transformManager.modelRadius, this.center == null || Float.isNaN(fArray[4]) ? this.transformManager.modelRadius : (fArray[4] <= 0.0f ? viewer.calcRotationRadius(this.center) : fArray[4]));
        this.pixelScale = this.newSlider(this.transformManager.scaleDefaultPixelsPerAngstrom, fArray[5]);
        if (fArray[6] != 0.0f) {
            this.navCenter = (P3)objectArray[2];
            this.navDepth = this.newSlider(this.transformManager.getNavigationDepthPercent(), fArray[6]);
            this.xNav = this.newSlider(this.transformManager.getNavigationOffsetPercent('X'), fArray[7]);
            this.yNav = this.newSlider(this.transformManager.getNavigationOffsetPercent('Y'), fArray[8]);
        }
        this.cameraDepth = this.newSlider(this.transformManager.getCameraDepth(), fArray[9]);
        this.cameraX = this.newSlider(this.transformManager.camera.x, fArray[10]);
        this.cameraY = this.newSlider(this.transformManager.camera.y, fArray[11]);
        this.transformManager.getRotation(this.matrixStart);
        this.matrixStartInv.invertM(this.matrixStart);
        this.matrixStep.mul2(this.matrixEnd, this.matrixStartInv);
        this.aaTotal.setM(this.matrixStep);
        this.fps = 30;
        this.totalSteps = (int)(this.floatSecondsTotal * (float)this.fps);
        this.frameTimeMillis = 1000 / this.fps;
        this.targetTime = System.currentTimeMillis();
        this.aaStepCenter.setT(this.ptMoveToCenter);
        this.aaStepCenter.sub(this.transformManager.fixedRotationCenter);
        this.aaStepCenter.scale(1.0f / (float)this.totalSteps);
        if (this.navCenter != null && this.transformManager.mode == 1) {
            this.aaStepNavCenter.setT(this.navCenter);
            this.aaStepNavCenter.sub(this.transformManager.navigationCenter);
            this.aaStepNavCenter.scale(1.0f / (float)this.totalSteps);
        }
        return this.totalSteps;
    }

    private Slider newSlider(float f, float f2) {
        return Float.isNaN(f2) || f2 == Float.MAX_VALUE ? null : new Slider(f, f2);
    }

    @Override
    protected void run1(int n) throws InterruptedException {
        while (true) {
            switch (n) {
                case -1: {
                    if (this.totalSteps > 0) {
                        this.viewer.setInMotion(true);
                    }
                    n = 0;
                    break;
                }
                case 0: {
                    boolean bl;
                    if (this.stopped || ++this.iStep >= this.totalSteps) {
                        n = -2;
                        break;
                    }
                    this.doStepTransform();
                    this.doEndMove = true;
                    this.targetTime += this.frameTimeMillis;
                    this.currentTime = System.currentTimeMillis();
                    boolean bl2 = bl = this.currentTime < this.targetTime;
                    if (!bl && this.isJS) {
                        this.targetTime = this.currentTime;
                        bl = true;
                    }
                    if (bl) {
                        this.viewer.requestRepaintAndWait("movetoThread");
                    }
                    if (this.transformManager.motion == null || !this.isJS && this.eval != null && !this.viewer.isScriptExecuting()) {
                        this.stopped = true;
                        break;
                    }
                    this.currentTime = System.currentTimeMillis();
                    int n2 = (int)(this.targetTime - this.currentTime);
                    if (!this.runSleep(n2, 0)) {
                        return;
                    }
                    n = 0;
                    break;
                }
                case -2: {
                    if (this.totalSteps <= 0 || this.doEndMove && !this.stopped) {
                        this.doFinalTransform();
                    }
                    if (this.totalSteps > 0) {
                        this.viewer.setInMotion(false);
                    }
                    this.viewer.moveUpdate(this.floatSecondsTotal);
                    if (this.transformManager.motion != null && !this.stopped) {
                        this.transformManager.motion = null;
                        this.viewer.finalizeTransformParameters();
                    }
                    this.resumeEval();
                    return;
                }
            }
        }
    }

    private void doStepTransform() {
        if (!Float.isNaN(this.matrixEnd.m00)) {
            this.transformManager.getRotation(this.matrixStart);
            this.matrixStartInv.invertM(this.matrixStart);
            this.matrixStep.mul2(this.matrixEnd, this.matrixStartInv);
            this.aaTotal.setM(this.matrixStep);
            this.aaStep.setAA(this.aaTotal);
            this.aaStep.angle /= (float)(this.totalSteps - this.iStep);
            if (this.aaStep.angle == 0.0f) {
                this.matrixStep.setIdentity();
            } else {
                this.matrixStep.setAA(this.aaStep);
            }
            this.matrixStep.mul(this.matrixStart);
        }
        this.fStep = (float)this.iStep / ((float)this.totalSteps - 1.0f);
        if (this.center != null) {
            this.transformManager.fixedRotationCenter.add(this.aaStepCenter);
        }
        if (this.navCenter != null && this.transformManager.mode == 1) {
            P3 p3 = P3.newP(this.transformManager.navigationCenter);
            p3.add(this.aaStepNavCenter);
            this.transformManager.setNavigatePt(p3);
        }
        this.setValues(this.matrixStep, null, null);
    }

    private void doFinalTransform() {
        this.fStep = -1.0f;
        this.setValues(this.matrixEnd, this.center, this.navCenter);
    }

    private void setValues(M3 m3, P3 p3, P3 p32) {
        this.transformManager.setAll(p3, m3, p32, this.getVal(this.zoom), this.getVal(this.xTrans), this.getVal(this.yTrans), this.getVal(this.rotationRadius), this.getVal(this.pixelScale), this.getVal(this.navDepth), this.getVal(this.xNav), this.getVal(this.yNav), this.getVal(this.cameraDepth), this.getVal(this.cameraX), this.getVal(this.cameraY));
    }

    private float getVal(Slider slider) {
        return slider == null ? Float.NaN : slider.getVal(this.fStep);
    }

    @Override
    public void interrupt() {
        this.doEndMove = false;
        super.interrupt();
    }

    private class Slider {
        float start;
        float delta;
        float value;

        Slider(float f, float f2) {
            this.start = f;
            this.value = f2;
            this.delta = f2 - f;
        }

        float getVal(float f) {
            return f < 0.0f ? this.value : this.start + f * this.delta;
        }
    }
}

