/*
 * Decompiled with CFR 0.152.
 */
package org.jmol.thread;

import java.util.Map;
import javajs.util.SB;
import org.jmol.thread.JmolThread;
import org.jmol.viewer.Viewer;

public class TimeoutThread
extends JmolThread {
    public String script;
    private int status;
    private boolean triggered = true;
    private Map<String, Object> timeouts;

    public TimeoutThread(Viewer viewer, String string, int n, String string2) {
        this.setViewer(viewer, string);
        this.name = string;
        this.set(n, string2);
    }

    private void set(int n, String string) {
        this.sleepTime = n;
        if (string != null) {
            this.script = string;
        }
    }

    @Override
    public String toString() {
        return "timeout name=" + this.name + " executions=" + this.status + " mSec=" + this.sleepTime + " secRemaining=" + (float)(this.targetTime - System.currentTimeMillis()) / 1000.0f + " script=" + this.script;
    }

    @Override
    protected void run1(int n) throws InterruptedException {
        while (true) {
            switch (n) {
                case -1: {
                    if (!this.isJS) {
                        Thread.currentThread().setPriority(1);
                    }
                    this.timeouts = this.viewer.getTimeouts();
                    this.targetTime = System.currentTimeMillis() + (long)Math.abs(this.sleepTime);
                    n = 0;
                    break;
                }
                case 0: {
                    if (this.checkInterrupted() || this.script == null || this.script.length() == 0) {
                        return;
                    }
                    if (!this.runSleep(26, 1)) {
                        return;
                    }
                    n = 1;
                    break;
                }
                case 1: {
                    n = System.currentTimeMillis() < this.targetTime ? 0 : 2;
                    break;
                }
                case 2: {
                    boolean bl;
                    this.currentTime = System.currentTimeMillis();
                    if (this.timeouts.get(this.name) == null) {
                        return;
                    }
                    ++this.status;
                    boolean bl2 = bl = this.sleepTime < 0;
                    if (bl) {
                        this.targetTime = System.currentTimeMillis() + (long)Math.abs(this.sleepTime);
                    } else {
                        this.timeouts.remove(this.name);
                    }
                    if (this.triggered) {
                        this.triggered = false;
                        if (this.name.equals("_SET_IN_MOTION_")) {
                            this.viewer.checkInMotion(2);
                        } else {
                            this.viewer.evalStringQuiet(bl ? this.script + ";\ntimeout ID \"" + this.name + "\";" : this.script);
                        }
                    }
                    n = bl ? 0 : -2;
                    break;
                }
                case -2: {
                    this.timeouts.remove(this.name);
                    return;
                }
            }
        }
    }

    public static void clear(Map<String, Object> map) {
        for (Object object : map.values()) {
            TimeoutThread timeoutThread = (TimeoutThread)object;
            if (timeoutThread.script.equals("exitJmol")) continue;
            timeoutThread.interrupt();
        }
        map.clear();
    }

    public static void setTimeout(Viewer viewer, Map<String, Object> map, String string, int n, String string2) {
        TimeoutThread timeoutThread = (TimeoutThread)map.get(string);
        if (n == 0) {
            if (timeoutThread != null) {
                timeoutThread.interrupt();
                map.remove(string);
            }
            return;
        }
        if (timeoutThread != null) {
            timeoutThread.set(n, string2);
            return;
        }
        timeoutThread = new TimeoutThread(viewer, string, n, string2);
        map.put(string, timeoutThread);
        timeoutThread.start();
    }

    public static void trigger(Map<String, Object> map, String string) {
        TimeoutThread timeoutThread = (TimeoutThread)map.get(string);
        if (timeoutThread != null) {
            timeoutThread.triggered = timeoutThread.sleepTime < 0;
        }
    }

    public static String showTimeout(Map<String, Object> map, String string) {
        SB sB = new SB();
        if (map != null) {
            for (Object object : map.values()) {
                TimeoutThread timeoutThread = (TimeoutThread)object;
                if (string != null && !timeoutThread.name.equalsIgnoreCase(string)) continue;
                sB.append(timeoutThread.toString()).append("\n");
            }
        }
        return sB.length() > 0 ? sB.toString() : "<no timeouts set>";
    }
}

