/*
 * Decompiled with CFR 0.152.
 */
package org.jmol.util;

import javajs.util.P3;
import org.jmol.util.Escape;
import org.jmol.util.Logger;
import org.jmol.util.ModulationSet;

public class Modulation {
    private static final double TWOPI = Math.PI * 2;
    private P3 qCoefs;
    private double a1;
    private double a2;
    private double center;
    private double left;
    private double right;
    private char axis;
    private final int type;
    private String utens;
    public static final int TYPE_DISP_FOURIER = 0;
    public static final int TYPE_DISP_SAWTOOTH = 1;
    public static final int TYPE_OCC_FOURIER = 2;
    public static final int TYPE_OCC_CRENEL = 3;
    public static final int TYPE_U_FOURIER = 4;

    public Modulation(char c, int n, P3 p3, String string, P3 p32) {
        if (Logger.debuggingHigh) {
            Logger.debug("MOD create " + Escape.eP(p32) + " axis=" + c + " type=" + n + " params=" + p3 + " utens=" + string);
        }
        this.axis = c;
        this.type = n;
        this.utens = string;
        this.qCoefs = p32;
        switch (n) {
            case 0: 
            case 2: 
            case 4: {
                this.a1 = p3.x;
                this.a2 = p3.y;
                break;
            }
            case 1: 
            case 3: {
                this.center = p3.x;
                float f = p3.y;
                if (f > 1.0f) {
                    f = 1.0f;
                }
                this.left = this.center - (double)(f / 2.0f);
                this.right = this.center + (double)(f / 2.0f);
                if (this.left < 0.0) {
                    this.left += 1.0;
                }
                if (this.right > 1.0) {
                    this.right -= 1.0;
                }
                if (this.left >= this.right && this.left - this.right < (double)0.01f) {
                    this.left = this.right + (double)0.01f;
                }
                this.a1 = 2.0f * p3.z / p3.y;
            }
        }
    }

    void apply(ModulationSet modulationSet, double d) {
        double d2 = (double)this.qCoefs.dot(modulationSet.x456) + (double)this.qCoefs.x * d;
        double d3 = 0.0;
        switch (this.type) {
            case 0: 
            case 2: 
            case 4: {
                double d4 = Math.PI * 2 * d2;
                if (this.a1 != 0.0) {
                    d3 += this.a1 * Math.cos(d4);
                }
                if (this.a2 != 0.0) {
                    d3 += this.a2 * Math.sin(d4);
                }
                if (!Logger.debuggingHigh) break;
                Logger.debug("MOD " + modulationSet.id + " " + Escape.eP(this.qCoefs) + " axis=" + this.axis + " v=" + d3 + " ccos,csin=" + this.a1 + "," + this.a2 + " / theta=" + d4);
                break;
            }
            case 3: {
                d2 -= Math.floor(d2);
                modulationSet.vOcc = this.range(d2) ? 1 : 0;
                modulationSet.vOcc0 = Float.NaN;
                return;
            }
            case 1: {
                d2 -= Math.floor(d2);
                if (!this.range(d2)) {
                    return;
                }
                if (this.left > this.right) {
                    if (d2 < this.left && this.left < this.center) {
                        d2 += 1.0;
                    } else if (d2 > this.right && this.right > this.center) {
                        d2 -= 1.0;
                    }
                }
                d3 = this.a1 * (d2 - this.center);
            }
        }
        switch (this.axis) {
            case 'x': {
                modulationSet.x = (float)((double)modulationSet.x + d3);
                break;
            }
            case 'y': {
                modulationSet.y = (float)((double)modulationSet.y + d3);
                break;
            }
            case 'z': {
                modulationSet.z = (float)((double)modulationSet.z + d3);
                break;
            }
            case 'U': {
                modulationSet.addUTens(this.utens, (float)d3);
                break;
            }
            default: {
                if (Float.isNaN(modulationSet.vOcc)) {
                    modulationSet.vOcc = 0.0f;
                }
                modulationSet.vOcc += (float)d3;
            }
        }
    }

    private boolean range(double d) {
        return this.left < this.right ? this.left <= d && d <= this.right : this.left <= d || d <= this.right;
    }
}

