/*
 * Decompiled with CFR 0.152.
 */
package org.jmol.util;

import java.util.Hashtable;
import java.util.Map;
import javajs.util.List;
import javajs.util.M3;
import javajs.util.M4;
import javajs.util.P3;
import javajs.util.V3;
import org.jmol.api.JmolModulationSet;
import org.jmol.util.Escape;
import org.jmol.util.Logger;
import org.jmol.util.Modulation;
import org.jmol.util.Vibration;

public class ModulationSet
extends Vibration
implements JmolModulationSet {
    public float vOcc = Float.NaN;
    public Map<String, Float> htUij;
    public float vOcc0;
    String id;
    V3 x456;
    private V3 prevSetting;
    private List<Modulation> mods;
    private M3 gammaE;
    private int t = Integer.MAX_VALUE;
    private double[] qlen;
    private int modDim;
    private boolean enabled = false;

    @Override
    public boolean isEnabled() {
        return this.enabled;
    }

    public ModulationSet(String string, P3 p3, int n, List<Modulation> list, M3 m3, M4 m4, M4 m42, double[] dArray) {
        this.id = string;
        this.modDim = n;
        this.mods = list;
        this.gammaE = m3;
        M3 m32 = new M3();
        m4.getRotationScale(m32);
        V3 v3 = new V3();
        m4.get(v3);
        m32.invert();
        this.x456 = V3.newV(p3);
        m42.transform(this.x456);
        this.x456.sub(v3);
        m32.transform(this.x456);
        if (Logger.debuggingHigh) {
            Logger.debug("MODSET create r=" + Escape.eP(p3) + " si=" + Escape.eP(v3) + " ginv=" + m32.toString().replace('\n', ' ') + " x4=" + this.x456.x);
        }
        this.qlen = dArray;
    }

    public void calculate() {
        this.z = 0.0f;
        this.y = 0.0f;
        this.x = 0.0f;
        this.htUij = null;
        this.vOcc = Float.NaN;
        double d = this.t == Integer.MAX_VALUE ? 0.0 : this.qlen[0] * (double)this.t;
        int n = this.mods.size();
        while (--n >= 0) {
            ((Modulation)this.mods.get(n)).apply(this, d);
        }
        this.gammaE.transform(this);
    }

    public void addUTens(String string, float f) {
        if (this.htUij == null) {
            this.htUij = new Hashtable<String, Float>();
        }
        Float f2 = this.htUij.get(string);
        if (Logger.debuggingHigh) {
            Logger.debug("MODSET " + this.id + " utens=" + string + " f=" + f2 + " v=" + f);
        }
        if (f2 != null) {
            f += f2.floatValue();
        }
        this.htUij.put(string, Float.valueOf(f));
    }

    @Override
    public int setModT(boolean bl, int n) {
        if (n == Integer.MAX_VALUE) {
            if (this.enabled == bl) {
                return 0;
            }
            this.enabled = bl;
            this.scale(-1.0f);
            return this.enabled ? 2 : 1;
        }
        if (this.modDim > 1 || n == this.t) {
            return 4;
        }
        if (this.prevSetting == null) {
            this.prevSetting = new V3();
        }
        this.prevSetting.setT(this);
        this.t = n;
        this.calculate();
        this.enabled = false;
        return 3;
    }

    @Override
    public String getState() {
        return "modulation " + (!this.enabled ? "OFF" : (this.t == Integer.MAX_VALUE ? "ON" : "" + this.t));
    }

    @Override
    public V3 getPrevSetting() {
        return this.prevSetting;
    }
}

